var ct = null;
var portRes = null;
var tunnelIndex = 0xFFFFFFFF;
var win = getParentWindow();

var neid = win.neid;
var nmUser = win.nmUser;

var obj = getNeProperty(self);
var slotId = obj.slotid;
var portId = obj.port;
var snkIPAddr = obj.snkipaddr;

function init()
{
    initTable();
    initButton();
}

function initTable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["property"], RESOURCE["value"]);
    
    var atom = new Atom("select");
    atom.addOption("GRE Tunnel", 1);
    atom.addOption("IP Tunnel", 2);
    atom.element.onchange = changeBoundType;
    ct.addAttrRow("boundtype", RESOURCE["boundtype"], atom);
    
    atom = new Atom("text");
    atom.element.style.width = "87%";
    atom.element.disabled = true;
    atom.setValue("/");
    ct.addAttrRow("tunnel", "Tunnel", atom);
    var btn = document.createElement("input");
    btn.setAttribute("type", "button");
    btn.setAttribute("id", "selectbtn");
    btn.setAttribute("width", "13%");
    btn.onclick = openDialog;
    atom.element.parentNode.appendChild(btn);
    
    $("tbdiv").appendChild(ct.getTable());
}

function initButton()
{
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
}

function changeBoundType()
{
    ct.getAtom("tunnel").setValue("/");
}

function openDialog()
{
    var boundType = ct.getAtom("boundtype").getValue();
    xshowModalDialog("tunnelselect.html?boundType=" + boundType, RESOURCE["tunnelres"], 480, 400, "../../../../../images/");
}

function doBind()
{
    var cell = null;
    var tunnel = ct.getAtom("tunnel").getValue();
    var indexes = win.st.getSelectedRows();
    for (var i = 0, m = indexes.length; i < m; i++) 
    {
        cell = win.st.getCell(indexes[i], "tunnelindex");
        win.st.setCellValue(cell, "tunnelindex", tunnelIndex);
        win.st.getCellShow(indexes[i], "tunnelindex").element.innerHTML = tunnel;
        cell.element.modify = true;
        cell.element.parentNode.modify = true;
        cell.element.style.backgroundColor = "#d0f946";
    }
    win.$("applybtn").disabled = !win.btnRightArr.applybtn.right;
    xcloseDialog();
}
