var winurlobj = getNeProperty(self);
var st = new SortTable();
var btnRightArr = new Object();
var winobj = getNeProperty(top);

function init()
{
    st.head.setAttribute("id", "htmlTablebfdTHead");
    st.body.setAttribute("id", "htmlTablebfdTBody");
    st.setImage("../../../../../images/"); 
    createTableHead(st, window.tableconf[0]);
    st.setOnCellEditHandler(valueChanged);		
    st.element.oncontextmenu = popupMenuHandler;
    st.setBodyHeight(getTableHeight(document.getElementById("table"),st)+"px");
	$("table").appendChild(st.getTable());
    initButton();
    initRight();
	
    if(btnRightArr.querybtn.right)
    {
        doQuery();
    }
}

window.onresize = function()
{    
	st.setBodyHeight(getTableHeight(document.getElementById("table"),st)+"px");
}

function initButton()
{
	$("querybtn").value = RESOURCE["querybutton"];
	$("applybtn").value = RESOURCE["applybutton"];
	$("applybtn").disabled = true;
}

function initRight()
{
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_QUERY_BFD);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_MODIFY_BFD);
    
    getRightInfo(winobj, btnRightArr);
}

function tabSelectHandler()
{
	if (btnRightArr.querybtn.right) 
	{
		doQuery();
	}
}

function valueChanged()
{
	$("applybtn").disabled = false;
}

function addParam(row, param)
{
	row.appendChild(param);
}

function doQuery()
{
	var xmlstr = createQueryXML();
	if (null == xmlstr)
	{
		return;
	}
	st.clearTableData();
	$("querybtn").disabled = true;
	$("applybtn").disabled = true;
	loadXMLdoc("../../../../../neExlorerServlet?sfid=" + "1008", "POST",
			true, handleBackQuery, null, "inputdata=" + xmlstr);	
}

function createQueryXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	addParam(row, newParam("neid", winurlobj["neid"]));
	addParam(row, newParam("qx", "NSCMD_PTN_ATM_GET_SEGEND"));
	addParam(row, newParam("atmindex", 0));
	addParam(row, newParam("connectionid", 0));
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function handleBackQuery(doc)
{
	var dinterface = EncapsulateData(doc);
	showErrorDialog(dinterface);
	$("querybtn").disabled = false;
	if (dinterface.getSErrorCode() != 0)
	{
		return;
	}
	createTableBody(st, window.tableconf[0], dinterface, RESOURCE);
}

function doApply()
{
	var xmlstr = createApplyXML();
	if (null == xmlstr)
	{
		return;
	}
	$("applybtn").disabled = true;
	loadXMLdoc("../../../../../neExlorerServlet?sfid=" + "1001", "POST",
			true, handleBackApply, null, "inputdata=" + xmlstr);
}

function createApplyXML()
{
    var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");	

	for ( var rowindex = 0, rowlen = st.getDataRowLength(); rowindex < rowlen; rowindex++)
	{
		if (!st.getModify(rowindex))
		{
			continue;
		}
		var row = new tagElement("row-params");
		param = new tagElement("param");
		param.setAttribute("name", "atmindex");
		param.setAttribute("value", st.getCellStoreValue(rowindex, "atmindex",
				"atmindex"));
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "connectionid");
		param.setAttribute("value", st.getCellStoreValue(rowindex, "connectionid",
				"connectionid"));
		row.appendChild(param);
		
		param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", winurlobj["neid"]);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "direction");
		param.setAttribute("value", st.getCellStoreValue(rowindex, "direction",
				"direction"));
		row.appendChild(param);

		if (st.getCellModify(rowindex, "segmentattri"))
		{
			param = new tagElement("param");
			param.setAttribute("name", "segmentattri");
			param.setAttribute("value", st.getCellStoreValue(rowindex, "segmentattri", "segmentattri"));
			row.appendChild(param);
		}
		bussiness.appendChild(row);
	}
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function handleBackApply(doc)
{
	var dinterface = EncapsulateData(doc);
	if (dinterface.getSErrorCode() != 0)
	{
		$("applybtn").disabled = false;
		showErrorDialog(dinterface);
		return;
	}	
	refreshTableState(st, window.tableconf[0], dinterface);
}

function showErrorDialog(data)
{
    var errArr = [];
    openErrPage("../../../../../page/", data.getError(), errArr); 
}
