var winurlobj = getNeProperty(self);
var st = new SortTable();
var btnRightArr = new Object();
var winobj = getNeProperty(top);
var nelist = [];
var selectRow = [];

function init()
{
    st.head.setAttribute("id", "htmlTablebfdTHead");
    st.body.setAttribute("id", "htmlTablebfdTBody");
    st.setImage("../../../../../images/");
    createTableHead(st, window.tableconf[0]);
	
    st.element.oncontextmenu = popupMenuHandler;    
    st.setBodyHeight(getTableHeight(document.getElementById("table"), st) + "px");
	$("table").appendChild(st.getTable());
	st.setOnRowSelectHandler(rowSelectHandler);
    initButton();
    initRight();
}

function rowSelectHandler()
{
	var selectedRowCount = st.getSelectedRowCount();
	if (selectedRowCount > 0) 
    {
        $("testbtn").disabled = false;
    }
    else 
    {
        $("testbtn").disabled = true;
    }
}

window.onresize = function()
{    
	st.setBodyHeight(getTableHeight(document.getElementById("table"),st)+"px");
}

function initButton()
{
    $("testbtn").value = RESOURCE["testbutton"];
	$("testbtn").disabled = true;
}

function initRight()
{
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_QUERY_BFD);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_MODIFY_BFD);
    
    getRightInfo(winobj, btnRightArr);
}

function tabSelectHandler()
{
    doQuery();
}

function doQuery()
{
	$("testbtn").disabled = true;
	st.clearTableData();
    var xmlstr = createQueryXML();
    if (null == xmlstr) 
    {
        return;
    }
    loadXMLdoc("../../../../../neExlorerServlet?sfid=" + "1008", "POST", true, handleBackQuery, null, "inputdata=" + xmlstr);
}

function createQueryXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    addParam(row, newParam("neid", winurlobj["neid"]));
    addParam(row, newParam("qx", ""));
    addParam(row, newParam("atmindex", 0));
    addParam(row, newParam("connectionid", 0));
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackQuery(doc)
{
	var dinterface = EncapsulateData(doc);
	
	showErrorDialog(dinterface);
	if (dinterface.getSErrorCode() != 0) 
	{
		return;
	}
	createTableBody(st, window.tableconf[0], dinterface, RESOURCE);
	var length = dinterface.getDataRowLength();	
	for (var i = 0; i < length; i++) 
	{
		var cell = st.getCell(i, "ne");
		st.setCellValue(cell, "ne", winobj["neid"]);
		st.getCellShow(i, "ne").element.innerHTML = winobj["neName"];
	}    
    if (length != 0) 
    {
        var element = st.getCellElement(0, "ne").editElement;
        element.removeAllOptions();
        if(dinterface.rows[0].ne != null)
        {
	        var length = dinterface.rows[0].ne.options.length;
	        for (var j = 0; j < length; j++) 
	        {
	            var neString = dinterface.rows[0].ne.options[j];
	            var dot = neString.lastIndexOf(".");
	            var neName = neString.substring(0, dot);
	            var neid = neString.substring(dot + 1, neString.length);
	            element.addOption(neName, neid);
	        }
        }
        else
        {
        	
            element.addOption(winobj["neName"], winobj["neid"]);
        }
    }
}		

function doTest()
{
	selectRow = st.getSelectedRows();
	if(selectRow.length == 0)
	{
		return;
	}
	$("testbtn").disabled = true;
	for (var i = 0; i < selectRow.length; i++) 
	{		
    	var cell = st.getCell(selectRow[i], "result");
    	st.getCellShow(selectRow[i], "result").element.innerHTML = "";
	
		var xmlstr = createQueryllidXML(selectRow[i]);
		if (null == xmlstr) 
		{
			return;
		}
		loadXMLdoc("../../../../../neExlorerServlet?sfid=" + "1006", "POST", true, handleBackQueryllid, selectRow[i], "inputdata=" + xmlstr);
	}
}

function createQueryllidXML(rowindex)
{	
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");    
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", st.getCellStoreValue(rowindex, "ne", "ne"));
    row.appendChild(param);
    bussiness.appendChild(row);    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackQueryllid(doc, rowindex)
{
	var xmlstr = createTestXML(doc, rowindex);
	if (null == xmlstr) 
    {
        return;
    }
    loadXMLdoc("../../../../../neExlorerServlet?sfid=" + "1007", "POST", true, handleBackTest, rowindex, "inputdata=" + xmlstr);
}

function createTestXML(doc, rowindex)
{
    var dinterface = EncapsulateData(doc);
    showErrorDialog(dinterface);
    if (dinterface.getSErrorCode() != 0) 
    {
        $("testbtn").disabled = false;
        return;
    }
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");      
    var row = new tagElement("row-params");
	
    param = new tagElement("param");
    param.setAttribute("name", "atmindex");
    param.setAttribute("value", st.getCellStoreValue(rowindex, "atmindex", "atmindex"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "connectionid");
    param.setAttribute("value", st.getCellStoreValue(rowindex, "connectionid", "connectionid"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "direction");
    param.setAttribute("value", st.getCellStoreValue(rowindex, "direction", "direction"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "segmentattri");
    param.setAttribute("value", st.getCellStoreValue(rowindex, "segmentattri", "segmentattri"));
    row.appendChild(param);
    
    var ccode = dinterface.getDataRowParam(0, "countrycode");
    var netcode = dinterface.getDataRowParam(0, "netcode");
    var necode = dinterface.getDataRowParam(0, "necode");
    llid = ccode + netcode + necode + "1";
    param = new tagElement("param");
    param.setAttribute("name", "llid");
    param.setAttribute("value", llid);
	
    row.appendChild(param);    
    bussiness.appendChild(row);    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackTest(doc, rowindex)
{
    $("testbtn").disabled = false;
    var dinterface = EncapsulateData(doc);    
    if (dinterface.getSErrorCode() != 0) 
    {
        var info = dinterface.errObj.rowErrors[0].error.info + RESOURCE["errorcode"] + dinterface.errObj.rowErrors[0].error.code;
        st.getCellShow(rowindex, "result").element.innerHTML = info;        
    }
    else 
    {    
        st.getCellShow(rowindex, "result").element.innerHTML = RESOURCE["succeed"];        
    }
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
}
