var winurlobj = getNeProperty(self);
var st = new SortTable();
var btnRightArr = new Object();
var winobj = getNeProperty(top);

function init()
{
	st = new SortTable();
    st.head.setAttribute("id", "htmlTablebfdTHead");
    st.body.setAttribute("id", "htmlTablebfdTBody");
    st.setImage("../../../../../images/"); 
    st.setBodyHeight("400px");
	tc = window.tableconf[0];
    createTableHead(st, tc);
    st.setOnCellEditHandler(valueChanged);
    st.element.oncontextmenu = popupMenuHandler;
    document.getElementById("table").appendChild(st.getTable());
    st.setBodyHeight(getTableHeight(document.getElementById("table"),st)+"px");    
    initButton();
    initRight();
}

window.onresize = function()
{    
	st.setBodyHeight(getTableHeight(document.getElementById("table"),st)+"px");
}

function initButton()
{
	$("querybtn").value = RESOURCE["querybutton"];
	$("applybtn").value = RESOURCE["applybutton"];
	$("applybtn").disabled = true;
}

function initRight()
{
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_QUERY_BFD);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_MODIFY_BFD);
    
    getRightInfo(winobj, btnRightArr);
}

function valueChanged()
{
	$("applybtn").disabled = false;
}

function tabSelectHandler()
{
	if (btnRightArr.querybtn.right) 
	{
		doQuery();
	}
}

function doQuery()
{
	st.clearTableData();
	var xmlstr = createQueryXML();
	if (null == xmlstr)
	{
		return;
	}
	$("querybtn").disabled = true;
	$("applybtn").disabled = true;
	loadXMLdoc("../../../../../neExlorerServlet?sfid=" + "1006", "POST",
			true, handleBackQuery, null, "inputdata=" + xmlstr);
}

function createQueryXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	addParam(row, newParam("neid", winurlobj["neid"]));
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function handleBackQuery(doc)
{
	var dinterface = EncapsulateData(doc);
	showErrorDialog(dinterface);
	$("querybtn").disabled = false;
	if (dinterface.getSErrorCode() != 0)
	{
		return;
	}
	createTableBody(st, window.tableconf[0], dinterface, RESOURCE);
	addSpaceAll();
	addCellEvent();
}

function addCellEvent()
{
    var cell = null;
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        var countrycodeElement = st.getCellElement(i, "countrycode").editElement.element;
		if (isIE) 
		{
			countrycodeElement.onkeydown = function()
			{
				var showvalue = countrycodeElement.value;
				var index = showvalue.indexOf("]");	
				if(digitalTag_getPos(countrycodeElement) > 5 + index ||
					digitalTag_getPos(countrycodeElement) <= index) 
				{
					return false;
				}				
				hexTextKeyDownCheck(countrycodeElement);
			}
		}
		else
		{	            
            countrycodeElement.onkeypress = function()
            {
				var showvalue = countrycodeElement.value;
				var index = showvalue.indexOf("]");	
				if(digitalTag_getPos(countrycodeElement) > 5 + index ||
					digitalTag_getPos(countrycodeElement) <= index) 
				{
					return false;
				}				
                hexTextKeyPressCheck(countrycodeElement);
            }			
		}
		
        var netcodeElement = st.getCellElement(i, "netcode").editElement.element;
		if (isIE) 
		{
			netcodeElement.onkeydown = function()
			{
				var showvalue = netcodeElement.value;
				var index = showvalue.indexOf("]");	
				if(digitalTag_getPos(netcodeElement) > 5 + index ||
					digitalTag_getPos(netcodeElement) <= index) 
				{
					return false;
				}				
				hexTextKeyDownCheck(netcodeElement);
			}
		}
		else
		{	            
            netcodeElement.onkeypress = function()
            {
				var showvalue = netcodeElement.value;
				var index = showvalue.indexOf("]");	
				if(digitalTag_getPos(netcodeElement) > 5 + index ||
					digitalTag_getPos(netcodeElement) <= index) 
				{
					return false;
				}				
                hexTextKeyPressCheck(netcodeElement);
            }			
		}		
		
        var necodeElement = st.getCellElement(i, "necode").editElement.element;
		if (isIE) 
		{
			necodeElement.onkeydown = function()
			{
				var showvalue = necodeElement.value;
				var index = showvalue.indexOf("]");	
				if(digitalTag_getPos(necodeElement) > 32 + index ||
					digitalTag_getPos(necodeElement) <= index) 
				{
					return false;
				}				
				hexTextKeyDownCheck(necodeElement);
			}
		}
		else
		{	            
            necodeElement.onkeypress = function()
            {
				var showvalue = necodeElement.value;
				var index = showvalue.indexOf("]");	
				if(digitalTag_getPos(necodeElement) > 32 + index ||
					digitalTag_getPos(necodeElement) <= index) 
				{
					return false;
				}				
                hexTextKeyPressCheck(necodeElement);
            }			
		}		
    }
}

/**
 *                ,      
 */
function addSpaceAll()
{
	var storeValue = null;
	var J0Mode = null;
	var showValue = null;
	var cell = null;
	var temp = null;
	
	for(var i = 0, len = st.getDataRowLength(); i < len; i++)
	{
		showValue = st.getCellShow(i,"countrycode");
		if(("-" != showValue.getValue())&&("/" != showValue.getValue()))
		{
			storeValue = st.getCellStoreValue(i,"countrycode","countrycode");
			showValue = RESOURCE["twobyte"] + addSpace(storeValue);
			st.getCellShow(i,"countrycode").setValue(showValue);
		}
		showValue = st.getCellShow(i,"netcode");
		if(("-" != showValue.getValue())&&("/" != showValue.getValue()))
		{
			storeValue = st.getCellStoreValue(i,"netcode","netcode");
			showValue = RESOURCE["twobyte"] + addSpace(storeValue);
			st.getCellShow(i,"netcode").setValue(showValue);
		}		
		showValue = st.getCellShow(i,"necode");
		if(("-" != showValue.getValue())&&("/" != showValue.getValue()))
		{
			storeValue = st.getCellStoreValue(i,"necode","necode");
			showValue = RESOURCE["elevenbyte"] + addSpace(storeValue);
			st.getCellShow(i,"necode").setValue(showValue);
		}
	}
}

/**
 *     
 */
function addSpace(value)
{
	var temp = "";
	for(var i = 0,len = value.length;i<len;i++)
	{
		temp += value.substring(i,i+2);
		
		if(i<value.length-1)
		{
			temp += " ";
		}
		i++;
	}
	return temp;
}

function doApply()
{
	var xmlstr = createApplyXML();
	if (null == xmlstr)
	{
		return;
	}
	$("applybtn").disabled = true;
	loadXMLdoc("../../../../../neExlorerServlet?sfid=" + "1005", "POST",
			true, handleBackApply, null, "inputdata=" + xmlstr);
}

function createApplyXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");	

    for (var rowindex = 0, rowlen = st.getDataRowLength(); rowindex < rowlen; rowindex++) 
    {
        if (!st.getModify(rowindex)) 
        {
            continue;
        }
		var row = new tagElement("row-params");
		param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", winurlobj["neid"]);
		row.appendChild(param);
		
        param = new tagElement("param");
        param.setAttribute("name", "countrycode");
		var codevalue = st.getCellStoreValue(rowindex, "countrycode", "countrycode");
		if (st.getCellModify(rowindex, "countrycode")) 
		{
			var index = codevalue.indexOf("]");
			codevalue = codevalue.substring(index + 1, codevalue.length);
			codevalue = removeSpace(codevalue);
		}
		param.setAttribute("value", codevalue);		
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "netcode");
		codevalue = st.getCellStoreValue(rowindex, "netcode", "netcode");
		if (st.getCellModify(rowindex, "netcode")) 
		{
			var index = codevalue.indexOf("]");
			codevalue = codevalue.substring(index + 1, codevalue.length);
			codevalue = removeSpace(codevalue);
		}
		param.setAttribute("value", codevalue);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "necode");
		codevalue = st.getCellStoreValue(rowindex, "necode", "necode");
		if (st.getCellModify(rowindex, "necode")) 
		{
			var index = codevalue.indexOf("]");
			codevalue = codevalue.substring(index + 1, codevalue.length);
			codevalue = removeSpace(codevalue);
		}
		param.setAttribute("value", codevalue);		
        row.appendChild(param);
        
        bussiness.appendChild(row);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *     
 * @param {Object} value
 */
function removeSpace(value)
{
	var regExp = /\s/g;
	return value.replace(regExp, '');	
}

function handleBackApply(doc)
{
	var dinterface = EncapsulateData(doc);
	if (dinterface.getSErrorCode() != 0)
	{
		$("applybtn").disabled = false;
		showErrorDialog(dinterface);
		return;
	}	
	refreshTableState(st, window.tableconf[0], dinterface);
}

function showErrorDialog(data)
{
    var errArr = [];
    openErrPage("../../../../../page/", data.getError(), errArr); 
}


