var winurlobj = getNeProperty(self);
var st = new SortTable();
var btnRightArr = new Object();
var winobj = getNeProperty(top);

function init()
{
	st = new SortTable();
    st.head.setAttribute("id", "htmlTablebfdTHead");
    st.body.setAttribute("id", "htmlTablebfdTBody");
    st.setImage("../../../../../images/"); 
    st.setBodyHeight("400px");
    createTableHead(st, window.tableconf[0]);
    st.setOnCellEditHandler(valueChanged);
    st.element.oncontextmenu = popupMenuHandler;
    document.getElementById("table").appendChild(st.getTable());
    st.setBodyHeight(getTableHeight(document.getElementById("table"),st)+"px");
    initButton();
    initRight();
}

window.onresize = function()
{    
	st.setBodyHeight(getTableHeight(document.getElementById("table"),st)+"px");
}

function tabSelectHandler()
{
	if (btnRightArr.querybtn.right) 
	{
		doQuery();
	}
}

function initButton()
{
	$("querybtn").value = RESOURCE["querybutton"];
	$("applybtn").value = RESOURCE["applybutton"];
	$("applybtn").disabled = true;
}

function initRight()
{
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_QUERY_BFD);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_MODIFY_BFD);
    
    getRightInfo(winobj, btnRightArr);
}

function valueChanged()
{
	$("applybtn").disabled = false;
}

function doQuery()
{
	st.clearTableData();
	var xmlstr = createQueryXML();
	if (null == xmlstr)
	{
		return;
	}
	$("querybtn").disabled = true;
	$("applybtn").disabled = true;
	loadXMLdoc("../../../../../neExlorerServlet?sfid=" + "1008", "POST",
			true, handleBackQuery, null, "inputdata=" + xmlstr);
}

function createQueryXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	addParam(row, newParam("neid", winurlobj["neid"]));
	addParam(row, newParam("qx", "NSCMD_PTN_ATM_GET_CC"));
	addParam(row, newParam("atmindex", 0));
	addParam(row, newParam("connectionid", 0));
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function handleBackQuery(doc)
{
	var dinterface = EncapsulateData(doc);
	showErrorDialog(dinterface);
	$("querybtn").disabled = false;
	if (dinterface.getSErrorCode() != 0)
	{
		return;
	}
	createTableBody(st, window.tableconf[0], dinterface, RESOURCE);	
	tagCosTableHandler();
}

function tagCosTableHandler()
{
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        st.getCellEdit(i, "ccActivate").element.onchange = handleActivateFlagChange;
		if (st.getCellStoreValue(i, "segment", "segmentattri") == INVALID) 
		{
			st.setCellIsEdit(st.getCellElement(i, "segment"), 0);
		}
    }
}

function handleActivateFlagChange()
{
	var rowindex = this.parentNode.parentNode.rowIndex;
	var colary = new Array("segment");
	if (this.value == DEACTIVATE)
	{
		st.setCellIsEdit(st.getCellElement(rowindex, "segment"), 0);
		st.getCellShow(rowindex, "segment").element.innerHTML = "-";
	}
	else
	{
		st.setCellIsEdit(st.getCellElement(rowindex, "segment"), 1);
		st.getCellShow(rowindex, "segment").element.innerHTML = RESOURCE[segmentattri[1]];
		st.setCellValue(st.getCell(rowindex, "segment"), "segmentattri", 1);		
	}
}

function doApply()
{
	var xmlstr = createApplyXML();
	if (null == xmlstr)
	{
		return;
	}

	$("applybtn").disabled = true;
	loadXMLdoc("../../../../../neExlorerServlet?sfid=" + "1003", "POST",
			true, handleBackApply, null, "inputdata=" + xmlstr);
}

function createApplyXML()
{
    var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");	

	for ( var rowindex = 0, rowlen = st.getDataRowLength(); rowindex < rowlen; rowindex++)
	{
		if (!st.getModify(rowindex))
		{
			continue;
		}
		var row = new tagElement("row-params");
		param = new tagElement("param");
		param.setAttribute("name", "atmindex");
		param.setAttribute("value", st.getCellStoreValue(rowindex, "atmindex",
				"atmindex"));
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "useautoid");
		param.setAttribute("value", 0);
		row.appendChild(param);
		
		param = new tagElement("param");
		param.setAttribute("name", "useautoid1");
		param.setAttribute("value", 0);
		row.appendChild(param);
				
		param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", winurlobj["neid"]);
		row.appendChild(param);
		
		param = new tagElement("param");
		param.setAttribute("name", "connectionid");
		param.setAttribute("value", st.getCellStoreValue(rowindex, "connectionid",
				"connectionid"));
		row.appendChild(param);		

		param = new tagElement("param");
		param.setAttribute("name", "direction");
		param.setAttribute("value", st.getCellStoreValue(rowindex, "direction",
				"direction"));
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "segmentattri");
		param.setAttribute("value", st.getCellStoreValue(rowindex, "segment", "segmentattri"));
		row.appendChild(param);		

		param = new tagElement("param");
		param.setAttribute("name", "activateflag");
		param.setAttribute("value", st.getCellStoreValue(rowindex, "ccActivate", "activateflag"));
		row.appendChild(param);
		
		bussiness.appendChild(row);
	}
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function handleBackApply(doc)
{
	var dinterface = EncapsulateData(doc);
	if (dinterface.getSErrorCode() != 0)
	{
		$("applybtn").disabled = false;
		showErrorDialog(dinterface);
		return;
	}
	refreshTableState(st, window.tableconf[0], dinterface);
}

function showErrorDialog(data)
{
    var errArr = [];
    openErrPage("../../../../../page/", data.getError(), errArr); 
}


function setOptionValue(param)
{
	var showtext = param[0];
	var txtvalue = param[1];
	var elem = param[2];
	var colid = elem.colid;

	var rows = elem.parent.getSelectedRows();
	for ( var i = 0; i < rows.length; i++)
	{
		var cell = elem.parent.getCell(rows[i], colid);
		if (cell.element.isEdit == 0)
		{
			continue;
		}
		elem.parent.setCellValue(cell, getColKey(colid), txtvalue);

		var showElement = cell.element.showElement;
		cell.element.modify = true;
		cell.element.parentNode.modify = true;
		cell.element.style.backgroundColor = "#d0f946";
		handleCellEdit(cell.element, TABLE_CONSTANT.AFTEREDIT);
		if (showElement.type == 'span' || showElement.type == 'text')
		{
			showElement.element.innerText = showtext;
		}
		else if (showElement.type == 'select')
		{
			var options = showElement.element.options;
			for ( var j = 0; j < options.length; j++)
			{
				if (options[j].value == txtvalue)
				{
					showElement.element.selectedIndex = j;
					break;
				}
			}
		}
		if (cell.element.editElement.element.onchange)
		{
			cell.element.editElement.element.style.display = "none";
			cell.element.appendChild(cell.element.editElement.element);
			hideMenu();
			cell.element.editElement.element.value = txtvalue;
			cell.element.editElement.element.onchange();
			cell.element.editElement.element.style.display = "";
			cell.element.removeChild(cell.element.lastChild);
		}
	}
}

function getColKey(colid)
{
    var colIndex = window.tableconf[0].getIndexByid(colid);
    var keys = window.tableconf[0].getColKeyArray(colIndex);
    return keys[0].name;
}
