
/**
 * 
 * <!--     TRANSU2000V1R7C00-3881-->
 * <!--    :OP201204190004:TDR5    PW         VCCV        -WEBLCT-->
 * <!--NSCMD_PTN_MPLS_PW_SET_CW_VCCV        NSCMD_PTN_MPLS_PW_SET_CW NSCMD_PTN_MPLS_PW_SET_VCCV        -->
 * 
 */
function initAdvancedTable()
{
    act = new CTable2();
    if (protecttype == NO_PROTECT)
    {
    	act.addHead(RESOURCE["attribute"], RESOURCE["value"], RESOURCE["value"]);
    }
    else
    {
    	act.addHead(RESOURCE["attribute"], RESOURCE["forwardpw"], RESOURCE["backwardpw"]);
    }
    
    $("advance").appendChild(act.getTable());
    
    var atom1 = new Atom("select");
    atom1.addOption(RESOURCE["nouse"], 1);
    atom1.addOption(RESOURCE["mustuse"], 3);
    atom1.element.options.selectedIndex = 1;
    
    var atom2 = new Atom("select");
    atom2.addOption(RESOURCE["nouse"], 1);
    atom2.addOption(RESOURCE["mustuse"], 3);
    atom2.element.options.selectedIndex = 1;
    
    atom2.element.disabled = true;
    act.addAttrRow("controlword", RESOURCE["controlword"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.addOption("None", "0");
    atom1.addOption("CW","1");
    atom1.addOption("Alert Label","2");
    atom1.element.options.selectedIndex = 1;
    atom2 = new Atom("select");
    atom2.addOption("None", "0");
    atom2.addOption("CW","1");
    atom2.addOption("Alert Label","2");
    atom2.element.options.selectedIndex = 1;
    atom2.element.disabled = true;
    act.addAttrRow("controlchanneltype", RESOURCE["controlchanneltype"], atom1, atom2);
     atom1.element.onchange = function()
    {
    	var controlchanneltype = act.getAtom("controlchanneltype", 1).element;
    	controlchanneltype.selectedIndex = this.value;
    }
    
    atom1 = new Atom("select");
    atom1.addOption("None", "0");
    atom1.addOption("Ping", "1");
    atom1.element.options.selectedIndex = 1;
    atom1.element.onchange = function()
    {
    	var vccvmode = act.getAtom("vccvmode", 1).element;
    	vccvmode.selectedIndex = (this.value == 0)?0:1;
    }
    atom2 = new Atom("select");
    atom2.addOption("None", "0");
    atom2.addOption("Ping", "1");
    atom2.element.options.selectedIndex = 1;
    atom2.element.disabled = true;
    act.addAttrRow("vccvmode", RESOURCE["vccvmode"], atom1, atom2);
    
    atom1 = new Atom("text");
    atom1.setValue("10");
    textCheckWithStepLen(atom1.element, "1", "31", "1");
    atom1.element.onchange = function()
    {
    	act.getAtom("count", 1).setValue(this.value);
    	if (this.value == 1) 
        {
            act.getAtom("time", 0).setValue("0");
            act.getAtom("time", 0).element.disabled = true;
            act.getAtom("time", 1).setValue("0");
        }
        else 
        {
            act.getAtom("time", 0).setValue("1000");
            act.getAtom("time", 0).element.disabled = false;
            act.getAtom("time", 1).setValue("1000");
        }
    	
    }
    atom2 = new Atom("text");
    atom2.setValue("10");
    atom2.element.disabled = true;
    act.addAttrRow("count", RESOURCE["count"], atom1, atom2);
    
    atom1 = new Atom("text");
    atom1.setValue("1000");
    textCheckWithStepLen(atom1.element, "100", "50000", "100");
    atom1.element.onchange = function()
    {
    	act.getAtom("time", 1).setValue(this.value);
    }
    atom2 = new Atom("text");
    atom2.setValue("1000");
    atom2.element.disabled = true;
    act.addAttrRow("time", RESOURCE["time"], atom1, atom2);
    
    var crlword = act.getAtom("controlword",0);
    crlword.element.onchange = function()
    {
    	var value = this.value;
    	var channeltype = act.getAtom("controlchanneltype",0);
    	channeltype.removeAllOptions();
    	if(value == "1")
    	{
    		channeltype.addOption("None", "0");
    		channeltype.addOption("Alert Label", "2");
    	}
    	else
    	{
    		channeltype.addOption("None", "0");
    		channeltype.addOption("CW", "1");
    		channeltype.addOption("Alert Label", "2");
    	}
    }
}

function initData()
{
    if (protecttype == NO_PROTECT)
    {
	loadXMLdoc("../../../conf/atm_u2kv1r3c00/create/qosdata.xml", "GET", false, initQosTableData);
    }
    else
    {
	loadXMLdoc("../../../conf/atm_u2kv1r3c00/create/protect_qosdata.xml", "GET", false, initQosTableData);
    }
}

function constructPWQOSRow()
{
	win.qosAttr.workPWIngress_BW = qostable.getCellStoreValue(QOS_INFO_TABLE_BANDWIDTHLIMIT_INDEX, QOS_INFO_TABLE_WORKPWINGRESS_COL, QOS_INFO_TABLE_WORKPWINGRESS_COL);
	win.qosAttr.workPWIngress_CIR = qostable.getCellStoreValue(QOS_INFO_TABLE_CIR_INDEX, QOS_INFO_TABLE_WORKPWINGRESS_COL, QOS_INFO_TABLE_WORKPWINGRESS_COL);
	win.qosAttr.workPWIngress_CBS = qostable.getCellStoreValue(QOS_INFO_TABLE_CBS_INDEX, QOS_INFO_TABLE_WORKPWINGRESS_COL, QOS_INFO_TABLE_WORKPWINGRESS_COL);
	win.qosAttr.workPWIngress_PIR = qostable.getCellStoreValue(QOS_INFO_TABLE_PIR_INDEX, QOS_INFO_TABLE_WORKPWINGRESS_COL, QOS_INFO_TABLE_WORKPWINGRESS_COL);
	win.qosAttr.workPWIngress_PBS = qostable.getCellStoreValue(QOS_INFO_TABLE_PBS_INDEX, QOS_INFO_TABLE_WORKPWINGRESS_COL, QOS_INFO_TABLE_WORKPWINGRESS_COL);
	win.qosAttr.workPWIngress_EXP = qostable.getCellStoreValue(QOS_INFO_TABLE_EXP_INDEX, QOS_INFO_TABLE_WORKPWINGRESS_COL, QOS_INFO_TABLE_WORKPWINGRESS_COL); //  PW INGRESS 
	if (protecttype != NO_PROTECT)
	{
		win.qosAttr.protectPWIngress_BW = qostable.getCellStoreValue(QOS_INFO_TABLE_BANDWIDTHLIMIT_INDEX, QOS_INFO_TABLE_PROTECTPWINGRESS_COL, QOS_INFO_TABLE_PROTECTPWINGRESS_COL);
		win.qosAttr.protectPWIngress_CIR = qostable.getCellStoreValue(QOS_INFO_TABLE_CIR_INDEX, QOS_INFO_TABLE_PROTECTPWINGRESS_COL, QOS_INFO_TABLE_PROTECTPWINGRESS_COL);
		win.qosAttr.protectPWIngress_CBS = qostable.getCellStoreValue(QOS_INFO_TABLE_CBS_INDEX, QOS_INFO_TABLE_PROTECTPWINGRESS_COL, QOS_INFO_TABLE_PROTECTPWINGRESS_COL);
		win.qosAttr.protectPWIngress_PIR = qostable.getCellStoreValue(QOS_INFO_TABLE_PIR_INDEX, QOS_INFO_TABLE_PROTECTPWINGRESS_COL, QOS_INFO_TABLE_PROTECTPWINGRESS_COL);
		win.qosAttr.protectPWIngress_PBS = qostable.getCellStoreValue(QOS_INFO_TABLE_PBS_INDEX, QOS_INFO_TABLE_PROTECTPWINGRESS_COL, QOS_INFO_TABLE_PROTECTPWINGRESS_COL);
		win.qosAttr.protectPWIngress_EXP = qostable.getCellStoreValue(QOS_INFO_TABLE_EXP_INDEX, QOS_INFO_TABLE_PROTECTPWINGRESS_COL, QOS_INFO_TABLE_PROTECTPWINGRESS_COL); //  PW INGRESS 
	}
}
