var winurlobj = getNeProperty(top);
var basicattriTable;
var qosTable;
var advanceattriTable;

var UNIUNI = 1;
var INVALID_LABEL_VALUE_1 = 0;//   label 
var INVALID_LABEL_VALUE_2 = 4294967295;//   label 
var INVALID_IP = 0;//  IP  
var INVALID_VALUE = "-";//      
var INVALID_QOS_VALUE = 4294967295;//   cir  
var INVALID = "-";

var currPWserviceType = 4;//                PW     (    ETH )
var selecttable = "basicattriLabel";

var tunneltype = [];
tunneltype["0"] = "MPLS";
tunneltype["NSCMD_CFG_MPLS_GET_TUNNEL"] = "MPLS";
tunneltype["1"] = "IP";
tunneltype["2"] = "GRE";

var enableState = new Object();
enableState[0] = "enableState_0";
enableState[1] = "enableState_1";

var ENABLED = 1;
var DISABLED = 0;

var TABLE_RES_MAP = [];//                    
TABLE_RES_MAP["ETH"] = "advancedattr_eth_table";//    
TABLE_RES_MAP["CES"] = "advancedattr_ces_table";//CES  
TABLE_RES_MAP["ATM"] = "advancedattr_atm_table";//ATM  
var basicdata = new DataInterface();
var qosdata = new DataInterface();
var advancedata = new DataInterface();
var basicflag = false;
var qosflag = false;
var advanceflag = false;
var curAtmIndex;

function initPage()
{
    initBasicattriTable();
    initQosTable();
    initAdvanceattriTable();
    initButton();
}

function initButton()
{
    $("querybtn").value = RESOURCE["querybutton"];
    $("applybtn").value = RESOURCE["applybutton"];
    $("applybtn").disabled = true;
}

function tabSelectHandler()
{
	swicthTab("basicattriLabel");
	doQuery();
}

function swicthTab(divStr)
{
    document.getElementById(divStr).className = "tabSelect";
    if (divStr == "basicattriLabel") 
    {
        selecttable = "basicattriLabel";
        $("qosLabel").className = "tabUnselect";
        $("advanceattriLabel").className = "tabUnselect";
        $("qostable").style.display = "none";
        $("advanceattritable").style.display = "none";
        $("basicattritable").style.display = "inline";
        if (!basicflag) 
        {
            createTableBody(basicattriTable, window.tableconf[0], basicdata, RESOURCE);
            basicflag = true;
        }
        else 
        {
            adjustTableLayout(basicattriTable, window.tableconf[0]);
        }
    }
    else if (divStr == "qosLabel") 
    {
        selecttable = "qosLabel";
        $("advanceattriLabel").className = "tabUnselect";
        $("basicattriLabel").className = "tabUnselect";
        $("qostable").style.display = "inline";
        $("advanceattritable").style.display = "none";
        $("basicattritable").style.display = "none";
        if (!qosflag) 
        {
            createTableBody(qosTable, window.tableconf[1], qosdata, RESOURCE);
            qosflag = true;
        }
        else 
        {
            adjustTableLayout(qosTable, window.tableconf[1]);
        }
    }
    else if (divStr == "advanceattriLabel") 
    {
        selecttable = "advanceattriLabel";
        $("qosLabel").className = "tabUnselect";
        $("basicattriLabel").className = "tabUnselect";
        $("qostable").style.display = "none";
        $("advanceattritable").style.display = "inline";
        $("basicattritable").style.display = "none";
        if (!advanceflag) 
        {
            advanceattriTable.clearTableData();
            createTableBody(advanceattriTable, window.tableconf[2], advancedata, RESOURCE);
            advanceflag = true;
            for (var i = 0, m = advanceattriTable.getDataRowLength(); i < m; i++) 
            {
                textCheckWithStepLen(advanceattriTable.getCell(i, "maxcount").element.editElement.element, "1", "31", "1");
                textCheckWithStepLen(advanceattriTable.getCell(i, "maxtime").element.editElement.element, "100", "50000", "100");
                if (advanceattriTable.getCellStoreValue(i, "maxcount", "maxcount") == 1) 
                {
                    advanceattriTable.setCellIsEdit(advanceattriTable.getCell(i, "maxtime"), 0);
                }
            }
        }
        else 
        {
            adjustTableLayout(advanceattriTable, window.tableconf[2]);
        }
    }
    if (parent.selectAtmType == UNIUNI) 
    {
        basicattriTable.clearTableData();
        qosTable.clearTableData();
        advanceattriTable.clearTableData();
    }
}

function initBasicattriTable()
{
    basicattriTable = new SortTable();
    basicattriTable.head.setAttribute("id", "htmlTable_STHead_resport");
    basicattriTable.body.setAttribute("id", "htmlTable_STBody_resport");
    basicattriTable.setImage("../../../../../images/");
    createTableHead(basicattriTable, window.tableconf[0]);
    basicattriTable.setBodyHeight(getComponetHeight($("basicattritable"), 80) + 20 + "px");
    $("basicattritable").appendChild(basicattriTable.getTable());
    $("basicattritable").oncontextmenu = popupMenuHandler_PW;
}

function initQosTable()
{
    qosTable = new SortTable();
    qosTable.head.setAttribute("id", "htmlTable_STHead_resport");
    qosTable.body.setAttribute("id", "htmlTable_STBody_resport");
    qosTable.setImage("../../../../../images/");
    createTableHead(qosTable, window.tableconf[1]);
    qosTable.setBodyHeight(getComponetHeight($("qosTable"), 80) + 20 + "px");
    $("qosTable").appendChild(qosTable.getTable());
    qosTable.setOnCellEditHandler(qosCellEditHandler);
}

function initAdvanceattriTable()
{
    advanceattriTable = new SortTable();
    advanceattriTable.head.setAttribute("id", "htmlTable_STHead_resport");
    advanceattriTable.body.setAttribute("id", "htmlTable_STBody_resport");
    advanceattriTable.setImage("../../../../../images/");
    createTableHead(advanceattriTable, window.tableconf[2]);
    advanceattriTable.setBodyHeight(getComponetHeight($("advanceattriTable"), 80) + 20 + "px");
    $("advanceattriTable").appendChild(advanceattriTable.getTable());
    advanceattriTable.setOnCellEditHandler(advanceCellEditHandler);
}

function cellEditHandler(param)
{
    $("applybtn").disabled = false;
}

function advanceCellEditHandler(param)
{
	$("applybtn").disabled = false;
	if (param.colid == "maxcount")
	{
		var cell = advanceattriTable.getCell(param.rowindex, "maxtime");
		if (parseInt(param.value) == 1)
		{
			advanceattriTable.setCellIsEdit(cell, 0);
            advanceattriTable.setCellValue(cell, "maxtime", 0);
            cell.element.showElement.element.innerHTML = 0;
		}
		else if (!advanceattriTable.getCellIsEdit(cell))
		{
			advanceattriTable.setCellIsEdit(cell, 1);
           	advanceattriTable.setCellValue(cell, "maxtime", 1000);
            cell.element.showElement.element.innerHTML = 1000;
		}
	}
}

function qosCellEditHandler(param)
{
    $("applybtn").disabled = false;
    var cell;
    var rowindex = param.rowindex;
    if (param.colid == "bandwidthLimit")
    {
    	if (qosTable.getCellStoreValue(rowindex, "bandwidthLimit", "bandwidthLimit") == DISABLED) //    
    	{
    		cell = qosTable.getCell(rowindex, "cir");
    		cellHandler(qosTable, cell, "cir", false, INVALID_VALUE);
    		cell = qosTable.getCell(rowindex, "cbs");
    		cellHandler(qosTable, cell, "cbs", false, INVALID_VALUE);
    		cell = qosTable.getCell(rowindex, "pir");
    		cellHandler(qosTable, cell, "pir", false, INVALID_VALUE);
    		cell = qosTable.getCell(rowindex, "pbs");
    		cellHandler(qosTable, cell, "pbs", false, INVALID_VALUE);
    	}
    	else
    	{
    		cell = qosTable.getCell(rowindex, "cir");
    		if (!advanceattriTable.getCellIsEdit(cell))
    		{
    			cellHandler(qosTable, cell, "cir", true, 64);
    		
    			cell = qosTable.getCell(rowindex, "cbs");
    			cellHandler(qosTable, cell, "cbs", true, "");
    		
    			cell = qosTable.getCell(rowindex, "pir");
    			cellHandler(qosTable, cell, "pir", true, 64);
    		
    			cell = qosTable.getCell(rowindex, "pbs");
    			cellHandler(qosTable, cell, "pbs", true, "");
    		}
    		
    	}
    }
}

function cellHandler(table, cell, key, isEdit, value)
{
	cell.element.showElement.element.innerHTML = value;
	table.setCellIsEdit(cell, isEdit);
	table.setCellValue(cell, key ,value);
}

function doQuery()
{
    parent.Tab.getTabWindow(6).disableNewBtn();
    if (parent.selectAtmIndex == 0) 
    {
        return;
    }
    if (parent.selectAtmType == UNIUNI) 
    {
        basicattriTable.clearTableData();
        qosTable.clearTableData();
        advanceattriTable.clearTableData();
        return;
    }
    doQueryByIndex(parent.pwIndex);
}

function doQueryByIndex(pwIndex)
{
    curAtmIndex = parent.selectAtmIndex;
    queryBasic(pwIndex);
}

/**
 *       
 * @param {Object} pwIndex
 */
function queryBasic(pwIndex)
{
    var xmlstr = createQueryPWIndexXML(pwIndex);
    if (null == xmlstr) 
    {
        return;
    }
    $("querybtn").disabled = true;
    $("applybtn").disabled = true;
    basicattriTable.clearTableData();
    loadXMLdoc("../../../../../neExlorerServlet?sfid=" + TE_IPPTN_QUERY_PW, "POST", true, handleBackQueryBasic, null, "inputdata=" + xmlstr);
}

function createQueryPWIndexXML(pwIndex)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    for (var i = 0; i < pwIndex.length; i++)
    {
    	var row = new tagElement("row-params");
    	addParam(row, newParam("neid", winurlobj["neid"]));
   	    addParam(row, newParam("pwIndex", pwIndex[i]));
   	    bussiness.appendChild(row);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackQueryBasic(doc)
{
    var dinterface = EncapsulateData(doc);
    showErrorDialog(dinterface);
    if (dinterface.getSErrorCode() != 0) 
    {
        $("querybtn").disabled = false;
        return;
    }
    basicattriTable.clearTableData();
    if (window.parent.isContainAtm(curAtmIndex)) 
    {
        createTableBody(basicattriTable, window.tableconf[0], dinterface, RESOURCE);
    }
    if (basicattriTable.getDataRowLength() == 0) 
    {
        return;
    }
    var pwID = [];
    for (var i = 0, len = dinterface.getDataRowLength(); i < len; i++) 
    {
        basicattriTable.getCellShow(i, "autopolic").element.innerHTML = INVALID_VALUE;
        pwID[i] = basicattriTable.getCellStoreValue(i, "pwID", "pwID");
        if (i == 0)
        {
        	basicattriTable.getCellShow(i, "workstatus").element.innerHTML = RESOURCE["WORK"];
        }
        if (i == 1)
        {
        	basicattriTable.getCellShow(i, "workstatus").element.innerHTML = RESOURCE["PROTECT"];
        }
        
    }
    basicdata = dinterface;
    
    queryQos(parent.pwIndex, pwID);
    queryAdvance(parent.pwIndex);
}

function queryQos(pwIndex, pwID)
{
    var xmlstr = createQueryQosXML(pwIndex);
    if (null == xmlstr) 
    {
        return;
    }
    qosTable.clearTableData();
    loadXMLdoc("../../../../../neExlorerServlet?sfid=" + TE_IPPTN_GET_PW_QOS, "POST", true, handleBackQueryQos, pwID, "inputdata=" + xmlstr);
}

function createQueryQosXML(pwIndex)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    for (var i = 0; i < pwIndex.length; i++)
    {
    	var row = new tagElement("row-params");
    	addParam(row, newParam("neid", winurlobj["neid"]));
    	addParam(row, newParam("pwIndex", pwIndex[i]));
    	bussiness.appendChild(row);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackQueryQos(doc, pwID)
{
    var dinterface = EncapsulateData(doc);
    showErrorDialog(dinterface);
    if (dinterface.getSErrorCode() != 0) 
    {
        $("querybtn").disabled = false;
        return;
    }
    processData(dinterface, pwID);
    qosTable.clearTableData();
    if (window.parent.isContainAtm(curAtmIndex)) 
	{
		createTableBody(qosTable, window.tableconf[1], dinterface, RESOURCE);
		for (var i = 0, len = dinterface.getDataRowLength(); i < len; i++) 
		{
			var direction = qosTable.getCellStoreValue(i, "direction", "direction");
			var cell;
			if (dinterface.getDataRowParam(i, "cir") == INVALID_QOS_VALUE) //       
			{
				if (direction == 2) //Egress   exp         
				{
					cell = qosTable.getCell(i, "exp");
					cellHandler(qosTable, cell, "exp", false, INVALID_VALUE);
					cell = qosTable.getCell(i, "bandwidthLimit");
					cellHandler(qosTable, cell, "bandwidthLimit", false, INVALID_VALUE);
				}
				else //Ingress   exp         
				{
					cell = qosTable.getCell(i, "bandwidthLimit");
					qosTable.getCellShow(i, "bandwidthLimit").element.innerHTML = RESOURCE["enableState_0"];
					qosTable.setCellValue(cell, "bandwidthLimit", DISABLED);
					cell = qosTable.getCell(i, "exp");
					cellHandler(qosTable, cell, "exp", false, INVALID_VALUE);
				}
				cell = qosTable.getCell(i, "cir");
				cellHandler(qosTable, cell, "cir", false, INVALID_VALUE);
				cell = qosTable.getCell(i, "cbs");
				cellHandler(qosTable, cell, "cbs", false, INVALID_VALUE);
				cell = qosTable.getCell(i, "pir");
				cellHandler(qosTable, cell, "pir", false, INVALID_VALUE);
				cell = qosTable.getCell(i, "pbs");
				cellHandler(qosTable, cell, "pbs", false, INVALID_VALUE);
			}
			else
			{
				cell = qosTable.getCell(i, "bandwidthLimit");
				qosTable.getCellShow(i, "bandwidthLimit").element.innerHTML = RESOURCE["enableState_1"];
				qosTable.setCellValue(cell, "bandwidthLimit", ENABLED);
			}
		}
		
		for (var j = 0, len1 = qosTable.getDataRowLength(); j < len1; j++)
		{
		    textCheckWithStepLen(qosTable.getCellEdit(j, "cir").element, 0, 1000000, 64);
		    textCheckWithStepLen(qosTable.getCellEdit(j, "pir").element, 0, 1000000, 64);
		}
		
	}
}

/**
 *              
 * @param data        
 * @return  
 */
function processData(data, pwID)
{
    for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
    {
        if (null != data.getDataRowParam(i, "direction")) 
        {
        	var pwID = data.getDataRowParam(i, "pwID");
        	if (i == 0)
        	{
        		data.getDataRow(1)["pwID"].value = pwID;
        	}
        	if (i == 2)
        	{
        		data.getDataRow(3)["pwID"].value = pwID;
        	}
        	
            data.rows[i]["bandwidthLimit"].value = RESOURCE["enableState_0"];
        }
    }
}

function queryAdvance(pwIndex)
{
    var xmlstr = createQueryAdvanceXML(pwIndex);
    if (null == xmlstr) 
    {
        return;
    }
    advanceattriTable.clearTableData();
    loadXMLdoc("../../../../../neExlorerServlet?sfid=" + TE_IPPTN_GET_PW, "POST", true, handleBackQueryAdvance, null, "inputdata=" + xmlstr);
}

function createQueryAdvanceXML(pwIndex)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    for (var i = 0; i < pwIndex.length; i++)
    {
    	var rowparams = new tagElement("row-params");
    
    	rowparams.appendChild(createTagElement("neid", winurlobj["neid"]));
    	rowparams.appendChild(createTagElement("pwIndex", pwIndex[i]));
    	rowparams.appendChild(createTagElement("pwdomain", "ATM"));//pw       
    	rowparams.appendChild(createTagElement("isLogFlag", "0"));//     
    	bussiness.appendChild(rowparams);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function createTagElement(name, value)
{
    var elem = new tagElement("param");
    elem.setAttribute("name", name);
    elem.setAttribute("value", value);
    return elem;
}


function handleBackQueryAdvance(doc)
{
    $("querybtn").disabled = false;
    var dinterface = EncapsulateData(doc);
    showErrorDialog(dinterface);
    if (dinterface.getSErrorCode() != 0) 
    {
        return;
    }
    advanceattriTable.clearTableData();
    if (window.parent.isContainAtm(curAtmIndex)) 
	{
		createTableBody(advanceattriTable, window.tableconf[2], dinterface, RESOURCE);
		advancedata = dinterface;
		for(var i = 0,len = advanceattriTable.getDataRowLength();i<len;i++)
		{
		 	var cell = advanceattriTable.getCell(i, "maxtime");
        	if (advanceattriTable.getCellStoreValue(i, "maxcount", "maxcount") == 1) 
            {
            	advanceattriTable.setCellIsEdit(cell, 0);
            	advanceattriTable.setCellValue(cell, "maxtime", 0);
            	cell.element.showElement.element.innerHTML = 0;
      	    }
		}
	}
	
    if (parent.protecttype == NO_PROTECT)
    {
    	parent.Tab.getTabWindow(6).enableNewBtn();
    }
}

/**
 *     
 */
function refreshAdvanceTable()
{
    var serviceType = basicattriTable.getCellStoreValue(0, "serviceType", "serviceType");
    if (serType2Domain[currPWserviceType] != serType2Domain[serviceType]) 
    {
        currPWserviceType = serviceType;
        window.tableconf.pop();
        loadXMLdoc("../../conf/atm_u2kv1r3c00/" + TABLE_RES_MAP[serType2Domain[serviceType]] + "_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable, null);
        var nodes = document.getElementById("advanceattriTable");
        for (var i = nodes.childNodes.length - 1; i >= 0; i--) 
        {
            nodes.removeChild(nodes.childNodes[i]);
        }
        initAdvanceattriTable();
    }
}

function doApply()
{
    if (selecttable == "qosLabel") 
    {
        doApplyQos();
    }
    else if (selecttable == "advanceattriLabel") 
    {
        doApplyAdvance();
    }
}

function checkCBSDataValid(){	
	var tmpst = qosTable;
    for (var rowindex = 0, rowlen = tmpst.getDataRowLength(); rowindex < rowlen; rowindex++) {


            var cbsValue = tmpst.getCellShow(rowindex, "cbs").element.innerText;
            if (cbsValue==""||cbsValue==null) {
            
                return false;
            }           
    }
    return true;
}

function checkPBSDataValid(){	
	var tmpst = qosTable;
    for (var rowindex = 0, rowlen = tmpst.getDataRowLength(); rowindex < rowlen; rowindex++) {

            var pbsValue = tmpst.getCellShow(rowindex, "pbs").element.innerText;
            if (pbsValue==""||pbsValue==null) {
            
                return false;
            }           
    }
    return true;
}

function doApplyQos()
{
	if (!checkCBSDataValid()) {
		alert(RESOURCE["errcbs"]);
        return;
    }
	
	if (!checkPBSDataValid()) {
		alert(RESOURCE["errpbs"]);
        return;
    }
	
    var xmlstr = createApplyQosXML();
    if (null == xmlstr) 
    {
        return;
    }
    $("applybtn").disabled = true;
    loadXMLdoc("../../../../../neExlorerServlet?sfid=" + TE_IPPTN_SET_PW_QOS, "POST", true, handleBackApplyQos, null, "inputdata=" + xmlstr);
}

function createApplyQosXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    for (var rowindex = 0, rowlen = qosTable.getDataRowLength(); rowindex < rowlen; rowindex++) 
    {
        if (!qosTable.getModify(rowindex)) 
        {
            continue;
        }
        var row = new tagElement("row-params");
        
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", winurlobj["neid"]);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "pwIndex");
        param.setAttribute("value", qosTable.getCellStoreValue(rowindex, "pwIndex", "pwIndex"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "direction");
        param.setAttribute("value", qosTable.getCellStoreValue(rowindex, "direction", "direction"));
        row.appendChild(param);
        
        if (qosTable.getCellModify(rowindex, "bandwidthLimit"))
        {
        	param = new tagElement("param");
       		param.setAttribute("name", "bwEnabled"); //    
        	param.setAttribute("value", qosTable.getCellStoreValue(rowindex, "bandwidthLimit", "bandwidthLimit"));
        	row.appendChild(param);
        }
        
        if (qosTable.getCellStoreValue(rowindex, "bandwidthLimit", "bandwidthLimit") == ENABLED)
        {
        	param = new tagElement("param");
        	param.setAttribute("name", "cir");
       		param.setAttribute("value", qosTable.getCellStoreValue(rowindex, "cir", "cir"));
            row.appendChild(param);
        
        	param = new tagElement("param");
        	param.setAttribute("name", "cbs");
        	param.setAttribute("value", qosTable.getCellStoreValue(rowindex, "cbs", "cbs"));
        	row.appendChild(param);
        
        	param = new tagElement("param");
        	param.setAttribute("name", "pir");
        	param.setAttribute("value", qosTable.getCellStoreValue(rowindex, "pir", "pir"));
        	row.appendChild(param);
        
        	param = new tagElement("param");
        	param.setAttribute("name", "pbs");
        	param.setAttribute("value", qosTable.getCellStoreValue(rowindex, "pbs", "pbs"));
        	row.appendChild(param);
        }
        
        if (qosTable.getCellModify(rowindex, "exp"))
        {
        	param = new tagElement("param");
        	param.setAttribute("name", "exp");
        	param.setAttribute("value", qosTable.getCellStoreValue(rowindex, "exp", "exp"));
        	row.appendChild(param);
        }
        bussiness.appendChild(row);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackApplyQos(doc)
{
    $("applybtn").disabled = true;
    var dinterface = EncapsulateData(doc);
    if (dinterface.getSErrorCode() != 0) 
    {
        $("applybtn").disabled = false;
        showErrorDialog(dinterface);
        return;
    }
    refreshTableState(qosTable, window.tableconf[1], dinterface);
    qosdata = dinterface;
}

function doApplyAdvance()
{
    var xmlstr = createApplyAdvanceXML();
    if (null == xmlstr) 
    {
        return;
    }
    $("applybtn").disabled = false;
    loadXMLdoc("../../../../../neExlorerServlet?sfid=" + "1015", "POST", true, handleBackApplyAdvance, null, "inputdata=" + xmlstr);
}

function createApplyAdvanceXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var rowindex = 0, rowlen = advanceattriTable.getDataRowLength(); rowindex < rowlen; rowindex++) 
    {
        if (!advanceattriTable.getModify(rowindex)) 
        {
            continue;
        }
        var row = new tagElement("row-params");
        
        param = new tagElement("param");
        param.setAttribute("name", "pwIndex");
        param.setAttribute("value", advanceattriTable.getCellStoreValue(rowindex, "pwIndex", "pwIndex"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", winurlobj["neid"]);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "maxcount");
        param.setAttribute("value", advanceattriTable.getCellStoreValue(rowindex, "maxcount", "maxcount"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "maxtime");
        param.setAttribute("value", advanceattriTable.getCellStoreValue(rowindex, "maxtime", "maxtime"));
        row.appendChild(param);
        
        bussiness.appendChild(row);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackApplyAdvance(doc)
{
    var dinterface = EncapsulateData(doc);
    if (dinterface.getSErrorCode() != 0) 
    {
        $("applybtn").disabled = false;
        showErrorDialog(dinterface);
        return;
    }
    $("applybtn").disabled = true;
    refreshTableState(advanceattriTable, window.tableconf[2], dinterface);
}

function showErrorDialog(data)
{
    var errArr = [];
    openErrPage("../../../../../page/", data.getError(), errArr);
}

/**
 *   IP  
 * @param {Object} param
 */
function convertIP(param)
{
    if (param == INVALID_IP) 
    {
        return INVALID_VALUE;
    }
    
    return convertNumToIpaddr(param);
}

/**
 *               0 0xFFFFFFFF      - 
 * @param {Object} param
 */
function convertLabel(param)
{
    if (param == INVALID_LABEL_VALUE_1 || param == INVALID_LABEL_VALUE_2) 
    {
        return INVALID_VALUE;
    }
    return param;
}

/**
 *   cir pir           0xFFFFFFFF      - 
 * @param {Object} param
 */
function convertQoS(param)
{
    if (param == INVALID_QOS_VALUE) 
    {
        return "None";
    }
    return param;
}


/**
 *       
 * @param {Object} evt
 */
function popupMenuHandler_PW(evt)
{
    if (!evt) 
    {
        evt = window.event;
    }
    var elem = (evt.target) ? evt.target : evt.srcElement;
    if (elem != null && elem.blur) 
    {
        elem.blur();
    }
    
    while (elem != null) 
    {
        if (elem.tagName == 'TD') 
        {
            break;
        }
        else 
        {
            elem = elem.parentNode;
        }
    }
    
    if (elem == null || elem.tagName != 'TD' || null == elem.parent) 
    {
        return;
    }
    
    var rowid = elem.parentNode.rowIndex;
    var rows = elem.parent.getSelectedRows();
    var colid = elem.colid;
    if (rows.contains(rowid)) 
    {
        createTablePopupMenu_PW(rows, evt);
    }
}

/**
 *     
 * @param {Object} rows
 * @param {Object} evt
 */
function createTablePopupMenu_PW(rows, evt)
{
    removejsDOMmenu();
    var enableMenu = false;//      
    var disableMenu = false;//      
    for (var i = 0; i < rows.length; i++) 
    {
        var enableState = basicattriTable.getCellStoreValue(rows[i], "enableState", "enableState");
        if (enableState == ENABLED) 
        {
            disableMenu = true;//                   
        }
        else 
        {
            enableMenu = true;
        }
    }

    if( winurlobj.neType == "76" || winurlobj.neType == "77" || winurlobj.neType == "83" )
    {
    	var versionArray = winurlobj.neversion.split(".");
    	if( versionArray[2] >= "03" && versionArray[3] >= "30" )
    	{
    		disableMenu = false;		
    	}
    }

    var cursorMenu1 = new jsDOMenu(150);
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["enableState_1"], "", doSetEnabledStat, ENABLED, enableMenu));
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["enableState_0"], "", doSetEnabledStat, DISABLED, disableMenu));
    setPopUpMenu(cursorMenu1);
    showMenu(evt);
}

/**
 *          xml
 * @param {Object} enableState
 */
function createSetEnabledXML(enableState)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var rows = basicattriTable.getSelectedRows();
    for (var i = 0; i < rows.length; i++) 
    {
        var row = new tagElement("row-params");
        row.appendChild(createTagElement("neid", winurlobj["neid"]));
        var pwIndex = basicattriTable.getCellCurrentValue(rows[i], "pwIndex", "pwIndex");
        row.appendChild(createTagElement("pwIndex", pwIndex));
        
        var rowEnableState = basicattriTable.getCellCurrentValue(rows[i], "enableState", "enableState");
        if (rowEnableState != enableState) 
        {
            row.appendChild(createTagElement("enableState", enableState));
        }
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *   PW    
 * @param {Object} enableState
 */
function doSetEnabledStat(enableState)
{
    removejsDOMmenu();
    var rows = basicattriTable.getSelectedRows();
    var xml = createSetEnabledXML(enableState, rows);
    var param = [];
    param[0] = rows;
    param[1] = enableState;
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_NF_PTN_PWTRIAL_ENABLE;
    loadXMLdoc(url, "POST", true, setEnabledCallBack, param, "inputdata=" + xml);
}

function setEnabledCallBack(doc, param)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    var rows = param[0];
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var pwIndex = data.getBErrParam(i, "pwIndex");
        for (var j = indexes.length - 1; j >= 0; j--) 
        {
            var tempIndex = basicattriTable.getCellCurrentValue(rows[j], "pwIndex", "pwIndex");
            if (pwIndex == tempIndex) 
            {
                rows.splice(j, 1);
                break;
            }
        }
    }
    for (var k = rows.length - 1; k >= 0; k--) 
    {
        var enableStateCell = basicattriTable.getCell(rows[k], "enableState");
        basicattriTable.setCellValue(enableStateCell, "enableState", param[1]);
        var cellShow = basicattriTable.getCellShow(rows[k], "enableState");
        cellShow.element.innerHTML = RESOURCE["enableState_" + param[1]];
    }
}

/**
 *   Tunnel      
 * @param {Object} rows
 */
function doReplaceTunnel(rows)
{
}
