var tab = null;

var win = getParentWindow();
var neid = win.neid;

var pwct = null;
var qostable = null;
var qostabletc = null;
var pwProtectCT = null;
var pairPwProtectCT = null;
var act = null;
var pwoamct = null;

var tabSelectFlg = getNeProperty(self).tabSelectFlg;

var tunnelTypes = [];

tunnelTypes[TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL] = "NSCMD_CFG_MPLS_GET_TUNNEL";
tunnelTypes[TECMDCODE_PTN_GRETUNNEL_QUERY] = "NSCMD_CFG_GRE_TNL_GET_TUNNEL";
tunnelTypes[TECMDCODE_PTN_IPTUNNEL_QUERY] = "NSCMD_CFG_IP_TNL_GET_TUNNEL";

var LOAD_TYPE_PW = 1; //     PW
var WORK_STATE = 0; //     PW
var PROTECT_STATE =1; //     PW

var NO_PROTECT = 0;
var PW_APS = 1;
var PROTECT_PAIRS = 2;

var protecttype;
if (tabSelectFlg == "pwAPS")
{
	protecttype = PW_APS;
}
else
{
	protecttype = PROTECT_PAIRS;
}

var workState = [];
workState[0] = "WORK";
workState[1] = "PROTECT";

var pwEXP = new Object();
pwEXP["0"] = "exp_0";
pwEXP["1"] = "exp_1";
pwEXP["2"] = "exp_2";
pwEXP["3"] = "exp_3";
pwEXP["4"] = "exp_4";
pwEXP["5"] = "exp_5";
pwEXP["6"] = "exp_6";
pwEXP["7"] = "exp_7";
pwEXP["255"] = "exp_none";

var pwAttr;
var qosAttr;
function init()
{
	pwAttr = win.parent.getPWTable();
    initGeneralTable();
    initQOSTable();
    initAdvancedTable();
    initPWProtectTable();
    initPairPWProtectTable();
    initPWOAMTable();
    initUI();
    initTabs();
    initData(); //   QOSTABLE    
    addQoSCellListener();
}
function initData()
{
	if (protecttype == NO_PROTECT)
	{
		loadXMLdoc("../../conf/atm_u2kv1r3c00/create/qosdata.xml", "GET", false, initQosTableData);
	}
	else
	{
		loadXMLdoc("../../conf/atm_u2kv1r3c00/create/protect_qosdata.xml", "GET", false, initQosTableData);
	}
}

function initQosTableData(doc)
{
	var data = EncapsulateData(doc);
    createTableBody(qostable, qostabletc, EncapsulateData(doc), RESOURCE);
    if(qostable.getDataRowLength() == 0)
	{
		return;
	}
    for(var i = 0, size = qostable.getDataRowLength(); i < size; i++)
    {
        var attrId = qostable.getCellStoreValue(i, QOS_INFO_TABLE_ATTR_COL, QOS_INFO_TABLE_ATTR_COL);
        qostable.getCellShow(i, QOS_INFO_TABLE_ATTR_COL).element.innerHTML = RESOURCE[attrId]; //     
        var cell;
        var cellValue;
    	for(var j = 1, colLength = qostable.getColumnCount(); j < colLength; j++)//  0            
    	{
    		var colid = qostabletc.getColId(j);
    		if (i == QOS_INFO_TABLE_POLICY_INDEX)
    	    {
    	    	cell = qostable.getCell(i, "workPWIngress");
    	    	qostable.setCellIsEdit(cell, false);
    	    	qostable.getCellShow(i, colid).element.innerHTML = "-";
    	    	cell = qostable.getCell(i, "protectPWIngress");
    	    	qostable.setCellIsEdit(cell, false);
    	    	qostable.getCellShow(i, colid).element.innerHTML = "-";
    	    }
    	    if (colid == QOS_INFO_TABLE_WORKPWINGRESS_COL) //  PW 
    	    {
    	    	cell = qostable.getCell(i, "workPWIngress");
    	    	if (i == QOS_INFO_TABLE_BANDWIDTHLIMIT_INDEX)
    	    	{
    	    		cellValue = pwAttr.pwQosTable.getCellStoreValue(0, "bandwidthLimit", "bandwidthLimit");
    	    		qostable.setCellValue(cell, "workPWIngress", cellValue);
    	    		qostable.setCellIsEdit(cell, false);
    	    		qostable.getCellShow(i, colid).element.innerHTML = RESOURCE["bandwidthLimit_" + cellValue];
    	    	}
    	    	if (i == QOS_INFO_TABLE_CIR_INDEX)
    	    	{
    	    		cellValue = pwAttr.pwQosTable.getCellStoreValue(0, "cir", "cir");
    	    		qostable.setCellValue(cell, "workPWIngress", cellValue);
    	    		qostable.setCellIsEdit(cell, false);
    	    		qostable.getCellShow(i, colid).element.innerHTML = cellValue;
    	    	}
    	    	if (i == QOS_INFO_TABLE_CBS_INDEX)
    	    	{
    	    		cellValue = pwAttr.pwQosTable.getCellStoreValue(0, "cbs", "cbs");
    	    		qostable.setCellValue(cell, "workPWIngress", cellValue);
    	    		qostable.setCellIsEdit(cell, false);
    	    		qostable.getCellShow(i, colid).element.innerHTML = cellValue;
    	    	}
    	    	if (i == QOS_INFO_TABLE_PIR_INDEX)
    	    	{
    	    		cellValue = pwAttr.pwQosTable.getCellStoreValue(0, "pir", "pir");
    	    		qostable.setCellValue(cell, "workPWIngress", cellValue);
    	    		qostable.setCellIsEdit(cell, false);
    	    		qostable.getCellShow(i, colid).element.innerHTML = cellValue;
    	    	}
    	    	if (i == QOS_INFO_TABLE_PBS_INDEX)
    	    	{
    	    		cellValue = pwAttr.pwQosTable.getCellStoreValue(0, "pbs", "pbs");
    	    		qostable.setCellValue(cell, "workPWIngress", cellValue);
    	    		qostable.setCellIsEdit(cell, false);
    	    		qostable.getCellShow(i, colid).element.innerHTML = cellValue;
    	    	}
    	    	if (i == QOS_INFO_TABLE_EXP_INDEX)
    	    	{
    	    		cellValue = pwAttr.pwQosTable.getCellStoreValue(0, "exp", "exp");
    	    		qostable.setCellValue(cell, "workPWIngress", cellValue);
    	    		qostable.setCellIsEdit(cell, false);
    	    		qostable.getCellShow(i, colid).element.innerHTML = RESOURCE["exp_" + cellValue];;
    	    	}
    	    	
    	    }
    	    if (colid == QOS_INFO_TABLE_PROTECTPWINGRESS_COL)
    	    {
    	    	cell = qostable.getCell(i, "protectPWIngress"); //  PW
    	    	if (i == QOS_INFO_TABLE_BANDWIDTHLIMIT_INDEX || i == QOS_INFO_TABLE_EXP_INDEX)
    	    	{
    	    		cellValue = qostable.getCellStoreValue(i, colid, colid);
    	    		qostable.setCellValue(cell, "protectPWIngress", cellValue);
    	    		qostable.setCellIsEdit(cell, true);
    	    		qostable.getCellShow(i, colid).element.innerHTML = RESOURCE[attrId + "_" + cellValue];
    	    	}
    	    }
    		cellValue = qostable.getCellStoreValue(i, colid, colid);
    		if(cellValue == "-")
    		{
    			setCellEidtable(qostable, i, colid, CELL_DISABLED);
    		}
    	}
    }
}


function embedTabSelectHandler(id)
{

	if(id == "tab2div")
	{
		adjustTableLayout(qostable,qostabletc);
	}
	else if (id == "tab6div") 
   {
       if(pwoamct.getAtom("relsrid",0).getValue()=="" || pwoamct.getAtom("relsrid",0).getValue()==null)
       {
       	pwoamct.getAtom("relsrid",0).setValue(pwct.getAtom("oppsitelsrid",0).getValue());
       }
       
       if(pwoamct.getAtom("relsrid",1).getValue()=="" || pwoamct.getAtom("relsrid",1).getValue()==null)
       {
       	pwoamct.getAtom("relsrid",1).setValue(pwct.getAtom("oppsitelsrid",1).getValue());
       }
       
        if(pwoamct.getAtom("sendpwid",0).getValue()=="" || pwoamct.getAtom("sendpwid",0).getValue()==null)
       {
       	pwoamct.getAtom("sendpwid",0).setValue(pwct.getAtom("pwid",0).getValue());
       }
       
       if(pwoamct.getAtom("sendpwid",1).getValue()=="" || pwoamct.getAtom("sendpwid",1).getValue()==null)
       {
       	pwoamct.getAtom("sendpwid",1).setValue(pwct.getAtom("pwid",1).getValue());
       }
       
   }
}

function initPWOAMTable()
{
	pwoamct = new CTable2();
	pwoamct.element.id = "pwoamct";
	pwoamct.addHead(RESOURCE["property"], RESOURCE["WORK_PW"], RESOURCE["PROTECT_PW"]);
	$("pwoam").appendChild(pwoamct.getTable());
	
	var atom1 = new Atom("select");
	atom1.addOption(RESOURCE["enableState_0"], 0);
	atom1.addOption(RESOURCE["enableState_1"], 1);
	atom1.element.options.selectedIndex = 1;
	atom1.element.disabled = true;
	var atom2 = new Atom("select");
	atom2.addOption(RESOURCE["enableState_0"], 0);
	atom2.addOption(RESOURCE["enableState_1"], 1);
	atom2.element.options.selectedIndex = 1;
	atom2.element.disabled = true;
	pwoamct.addAttrRow("enablestate", RESOURCE["OAM_STATE"], atom1, atom2);
	
	atom1 = new Atom("select");
	atom1.addOption(RESOURCE["detectionMode_1"], 0); //   
	atom1.addOption(RESOURCE["detectionMode_2"], 1);  //  
	atom1.element.options.selectedIndex = 0;
	atom2 = new Atom("select");
	atom2.addOption(RESOURCE["detectionMode_1"], 0);
	atom2.addOption(RESOURCE["detectionMode_2"], 1);
	atom2.element.options.selectedIndex = 0;
	pwoamct.addAttrRow("detectstyle", RESOURCE["DETECT_STYLE"], atom1, atom2);
	
	atom1 = new Atom("select");
	atom1.addOption(RESOURCE["detectType_1"], 0); //CV
	atom1.addOption(RESOURCE["detectType_2"], 1);  //FFD
	atom1.element.options.selectedIndex = 0;
	atom1.element.onchange = function()
	{
		var temp = pwoamct.getAtom("detecttime", 0);
		if (this.value == 0) //FFD
		{
			temp.element.options.length = 0;
			temp.addOption("1000", "1000");
			temp.element.disabled = true;
		}
		else
		{
			temp.element.options.length = 0;
			temp.addOption("3.3", "3.3");
			temp.addOption("10", "10");
			temp.addOption("20", "20");
			temp.addOption("50", "50");
			temp.addOption("100", "100");
			temp.addOption("200", "200");
			temp.addOption("500", "500");
			temp.element.options.selectedIndex = 3;
			temp.element.disabled = false;
		}
	};
	atom2 = new Atom("select");
	atom2.addOption(RESOURCE["detectType_1"], 0);
	atom2.addOption(RESOURCE["detectType_2"], 1); 
	atom2.element.options.selectedIndex = 0;
	atom2.element.onchange = function()
	{
		var temp = pwoamct.getAtom("detecttime", 1);
		if (this.value == 0) //FFD
		{
			temp.element.options.length = 0;
			temp.addOption("1000", "1000");
			temp.element.disabled = true;
		}
		else
		{
			temp.element.options.length = 0;
			temp.addOption("3.3", "3.3");
			temp.addOption("10", "10");
			temp.addOption("20", "20");
			temp.addOption("50", "50");
			temp.addOption("100", "100");
			temp.addOption("200", "200");
			temp.addOption("500", "500");
			temp.element.options.selectedIndex = 3;
			temp.element.disabled = false;
		}
	};
	pwoamct.addAttrRow("detecttype", RESOURCE["DETECT_TYPE"], atom1, atom2);
	
	
	atom1 = new Atom("select");
	atom1.addOption("1000", "1000");
	atom1.element.disabled = true;
	atom2 = new Atom("select");
	atom2.addOption("1000", "1000");
	atom2.element.disabled = true;
	pwoamct.addAttrRow("detecttime", RESOURCE["DETECT_TIME"], atom1, atom2); //      
	
	atom1 = new Atom("text");
	validateIp(atom1.element);
	atom2 = new Atom("text");
	validateIp(atom2.element);
	pwoamct.addAttrRow("relsrid", RESOURCE["RECEIVE_LSRID"], atom1, atom2);
	
	atom1 = new Atom("text");
	checkText(atom1.element, "1", "4294967295");
	atom2 = new Atom("text");
	checkText(atom2.element, "1", "4294967295");
	pwoamct.addAttrRow("sendpwid", RESOURCE["SEND_PWID"], atom1, atom2);
	
	setDisplay(pwoamct,"33%", "");
}

function initPWProtectTable()
{
    pwProtectCT = new CTable();
    pwProtectCT.element.id = "pwProtectCT";
    pwProtectCT.addHead(RESOURCE["property"], RESOURCE["value"]);
    
    var atom = new Atom("select");
    atom.addOption("PW APS", "1");
    atom.element.disabled=true;
	pwProtectCT.addAttrRow("protecttype", RESOURCE["PROTECT_TYPE"], atom);
   
    
    atom = new Atom("text");
    checkText(atom.element, "1", "32");
    pwProtectCT.addAttrRow("protectid", RESOURCE["PROTECT_ID"], atom);
    
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.addOption(RESOURCE["enabled"], "1");
    atom.addOption(RESOURCE["disabled"], "0");
    pwProtectCT.addAttrRow("isenable", RESOURCE["ISENABLE"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.addOption("1:1", "1");
    atom.element.disabled = true;
    pwProtectCT.addAttrRow("protype", RESOURCE["PROTECT_MODE"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.addOption(RESOURCE["SWTICH_MODE2"], "1");
    atom.addOption(RESOURCE["SWTICH_MODE1"], "0");
    atom.element.disabled = true;
    pwProtectCT.addAttrRow("swtichmode", RESOURCE["SWTICH_MODE"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.addOption(RESOURCE["revertive"], "1");
    atom.addOption(RESOURCE["NO_RECOVERY_MODE"], "0");
    atom.element.onchange = function()
    {
    	 var recoverytime = pwProtectCT.getAtom("recoverytime");
    	 if(pwProtectCT.getAtom("recoverymode").getValue() == "1")
    	 {
    	 	   recoverytime.element.disabled = false;
    	 	   recoverytime.element.value = "1";
    	 }else
    	 {
    	 	   recoverytime.element.disabled = true;
    	 	   recoverytime.element.value = "-";
    	 }
    }
    pwProtectCT.addAttrRow("recoverymode", RESOURCE["RECOVERY_MODE"], atom);
    
    atom = new Atom("text");
    atom.element.value = 1;
    checkText(atom.element, "1", "12");
    pwProtectCT.addAttrRow("recoverytime", RESOURCE["RECOVERY_TIME"], atom);
    
    atom = new Atom("text");
    atom.element.value = 0;
    checkText(atom.element, "0", "100");
    pwProtectCT.addAttrRow("swtichtime", RESOURCE["DELAY_TIME"], atom);
    
    $("pwprotecttb").appendChild(pwProtectCT.getTable());
    
}
function initPairPWProtectTable()
{
	pairPwProtectCT = new CTable();
    pairPwProtectCT.element.id = "pairPwProtectCT";
    pairPwProtectCT.addHead(RESOURCE["property"], RESOURCE["value"]);
    
    var atom = new Atom("select");
    atom.addOption(RESOURCE["PROTECT_PAIRS"], "2");
    atom.element.disabled=true;
	pairPwProtectCT.addAttrRow("protecttype", RESOURCE["PROTECT_TYPE"], atom);
    
    atom = new Atom("span");
    pairPwProtectCT.addAttrRow("protectidspan", RESOURCE["PROTECT_ID"], atom);
    
    var elem = document.createElement("input");
    elem.type = "text";
    elem.id = "protectidforpair";
    elem.disabled = true;
    checkText(elem, "1", "32");
    elem.style.width = "79%";
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "button";
    elem.id = "protectidBtn";
    elem.value = "...";
    elem.style.width = "20%";
    elem.onclick = function()
	{
		xshowModalDialog("../ethservice/eline_u2kv1r3c00/selectaps.html", RESOURCE["resourceselected"], 720, 400, "../../../../../images/");
	};
    atom.element.parentNode.appendChild(elem); 
 
    $("pairpwprotecttb").appendChild(pairPwProtectCT.getTable());
}

function initGeneralTable()
{
    pwct = new CTable2();
    pwct.element.id = "pwct";
    pwct.addHead(RESOURCE["property"], RESOURCE["WORK_PW"], RESOURCE["PROTECT_PW"]);
    
    $("general").appendChild(pwct.getTable());
    
    var atom1 = new Atom("text");
    checkText(atom1.element, "1", "4294967295");
    atom1.element.disabled = true;
    atom1.setValue(pwAttr.basicattriTable.getCellStoreValue(0, "pwID", "pwID"));
    var atom2 = new Atom("text");
    checkText(atom2.element, "1", "4294967295");
    pwct.addAttrRow("pwid", RESOURCE["pwid"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.element.style.width = "100%";
    atom1.addOption(RESOURCE["static"], "1");
    atom1.element.disabled = true;
    atom1.element.name = "0";
    atom2 = new Atom("select");
    atom2.element.style.width = "100%";
    atom2.addOption(RESOURCE["static"], "1");
    atom2.element.name = "1";
    pwct.addAttrRow("pwsignaltype", RESOURCE["pwsignaltype"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.element.style.width = "100%";
    var serviceType = pwAttr.basicattriTable.getCellStoreValue(0, "serviceType", "serviceType");
    atom1.addOption(RESOURCE["serviceType_" + serviceType], serviceType);
    atom1.element.disabled = true;
    
    atom2 = new Atom("select");
    atom2.element.style.width = "100%";
    atom2.addOption(RESOURCE["serviceType_" + serviceType], serviceType);
    atom2.element.disabled = true;
    pwct.addAttrRow("pwtype", RESOURCE["pwtype"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.element.style.width = "100%";
    atom1.element.disabled = true;
    atom1.addOption(RESOURCE["bidirectional"], "1");
    atom2 = new Atom("select");
    atom2.element.style.width = "100%";
    atom2.addOption(RESOURCE["bidirectional"], "1");
    atom2.element.disabled = true;
    pwct.addAttrRow("direction", RESOURCE["direction"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.addOption("MPLS", 1);
    atom1.element.name = "0";
    atom1.element.disabled = true;
    atom2 = new Atom("select");
    atom2.addOption("MPLS", 1);
    atom2.element.name = "1";
    atom2.element.disabled = true;
    pwct.addAttrRow("pwencaptype", RESOURCE["pwencaptype"], atom1, atom2);
    
    atom1 = new Atom("text");
    atom1.element.disabled = true;
    atom1.setValue(pwAttr.basicattriTable.getCellStoreValue(0, "pwIngressLabel", "pwIngressLabel"));
    atom2 = new Atom("text");
    checkText(atom2.element, "16", "1048575");
    pwct.addAttrRow("pwinlabel", RESOURCE["pwinlabel"], atom1, atom2);
    
    atom1 = new Atom("text");
    atom1.setValue(pwAttr.basicattriTable.getCellStoreValue(0, "pwEgressLabel", "pwEgressLabel"));
    atom1.element.disabled = true;
    checkText(atom1.element, "16", "1048575");
    atom2 = new Atom("text");
    checkText(atom2.element, "16", "1048575");
    pwct.addAttrRow("pwoutlabel", RESOURCE["pwoutlabel"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.addOption("MPLS", TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL);
    atom2 = new Atom("select");
    atom2.addOption("MPLS", TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL);
    pwct.addAttrRow("tunneltype", RESOURCE["tunneltype"], atom1, atom2);
    
    atom1 = new Atom("span");
    atom2 = new Atom("span");
    pwct.addAttrRow("tunnel", "Ingress Tunnel", atom1, atom2);
    createTunnelAtom(atom1, 0);
    createTunnelAtom(atom2, 1);
    
    atom1 = new Atom("span");
    atom2 = new Atom("span");
    pwct.addAttrRow("tunnel_egress", "Egress Tunnel", atom1, atom2);
    createTunnelAtom(atom1, 2);
    createTunnelAtom(atom2, 3);
    
    atom1 = new Atom("text");
    atom1.element.disabled = true;
    atom1.setValue(pwAttr.basicattriTable.getCellShow(0, "oppositeLsrID").getValue());
    atom2 = new Atom("text");
    atom2.element.disabled = true;
    pwct.addAttrRow("oppsitelsrid", RESOURCE["oppsitelsrid"], atom1, atom2);
}

function initQOSTable()
{
	qostable = new SortTable();
	qostable.head.setAttribute("id", "htmlTablebfdTHead");
	qostable.body.setAttribute("id", "htmlTablebfdTBody");
	qostable.setImage("../../../../../images/");
    qostabletc = window.tableconf[1];
    createTableHead(qostable, qostabletc);
    qostable.setBodyHeight("200px");
    $("qos").appendChild(qostable.getTable());
    
}


function createTunnelAtom(atom1, atomName)
{
    var elem = document.createElement("input");
    elem.type = "radio";
    elem.id = "newtunnel" + atomName;
    if (atomName == 0 || atomName == 2)
    {
    	elem.disabled = true;
    }
    elem.onclick = function()
    {
        $("hadtunnel" + atomName).checked = false;
        this.checked = true;
    }
    atom1.element.parentNode.appendChild(elem);
    elem.checked = true;
    
    elem = document.createElement("span");
    
    elem.innerHTML = RESOURCE["newbtn"];
    atom1.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "radio";
    elem.id = "hadtunnel" + atomName;
    if (atomName == 0 || atomName == 2)
    {
    	elem.disabled = true;
    }
    elem.onclick = function()
    {
        $("newtunnel" + atomName).checked = false;
        this.checked = true;
    }
    atom1.element.parentNode.appendChild(elem);
    
    elem = document.createElement("span");
    elem.innerHTML = RESOURCE["useexist"];
    atom1.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "text";
    elem.id = "selectedtunnel" + atomName;
    elem.disabled = true;
    elem.style.width = "48%";
    if (atomName == 0)
    {
    	elem.value = pwAttr.basicattriTable.getCellShow(0, "tunnelid").getValue();
    }
    if (atomName == 2)
    {
    	elem.value = pwAttr.basicattriTable.getCellShow(0, "tunnelid_e").getValue();
    }
    atom1.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "hidden";
    elem.id = "tunnelindex" + atomName;
    atom1.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "hidden";
    elem.id = "ingressid" + atomName;
    atom1.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "hidden";
    elem.id = "egressid" + atomName;
    atom1.element.parentNode.appendChild(elem); 
    
    elem = document.createElement("input");
    if (atomName == 0 || atomName == 2)
    {
    	elem.disabled = true;
    }
    elem.type = "button";
    elem.value = "...";
    elem.className="autowidthbutton";
    elem.name = atomName;
    elem.onclick = doSelectTunnel;
    atom1.element.parentNode.appendChild(elem);
}

function doSelectTunnel()
{
	var buttonIndex =  this.name;
  	var tunnelIndex = (buttonIndex > 1) ? buttonIndex - 2 : buttonIndex; // 2 3    0 1  tunnel  
    var tunnelType = pwct.getAtom("tunneltype", tunnelIndex).getValue();
    var nodetype = -1;
    if (buttonIndex == 0 || buttonIndex == 1)//buttonInde:0,1  Ingress
    {
    	nodetype = NODE_TYPE_INGRESS;
    }
    else
    {	
    	nodetype = NODE_TYPE_EGRESS;
    }
    if ($("hadtunnel" + buttonIndex).checked) 
    {
        xshowModalDialog("../ethservice/eline_u2kv1r3c00/selecttunnel.html?tunnelType=" + tunnelType + "&nodetype=" + nodetype + "&buttonIndex=" + buttonIndex, RESOURCE["resourceselected"], 580, 250, "../../../../../../images/");
    }
    else 
    {
        if (tunnelType == TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL) 
        {
            xshowModalDialog("../ethservice/eline_u2kv1r3c00/createmplsnodetypetunnel.html?tunnelType=" + tunnelType + "&nodetype=" + nodetype + "&buttonIndex=" + buttonIndex, RESOURCE["resourceselected"], 580, 620, "../../../../../../images/");
        }
        else 
        {
            xshowModalDialog("../ethcommon/createipgretunnel.html?tunnelType=" + tunnelType, RESOURCE["resourceselected"], 580, 450, "../../../../../../images/");
        }
    }
}

function initAdvancedTable()
{
    act = new CTable2();
    act.addHead(RESOURCE["attribute"], RESOURCE["WORK_PW"], RESOURCE["PROTECT_PW"]);
    $("advance").appendChild(act.getTable());
    
    var controlWord = pwAttr.advanceattriTable.getCellStoreValue(0, "controlWord", "controlWord");
    var atom1 = new Atom("select");
    if (controlWord == "1")
    {
        atom1.addOption(RESOURCE["nouse"], 1);
    }
    else
    {
        atom1.addOption(RESOURCE["mustuse"], 3);
    }
    atom1.element.disabled = true;
    var atom2 = new Atom("select");
    if (controlWord == "1")
    {
        atom2.addOption(RESOURCE["nouse"], 1);
    }
    else
    {
        atom2.addOption(RESOURCE["mustuse"], 3);
    }
    atom2.element.disabled = true;
    act.addAttrRow("controlword", RESOURCE["controlword"], atom1, atom2);
    
    var controlWord = pwAttr.advanceattriTable.getCellStoreValue(0, "ctrlChanType", "ctrlChanType");
    atom1 = new Atom("select");
    if (controlWord == "0")
    {
        atom1.addOption("None", "0");
    }
    else if (controlWord == "1")
    {
        atom1.addOption("CW","1");
    }
    else
    {
        atom1.addOption("Alert Label","2");
    }
    atom1.element.disabled = true;
    atom2 = new Atom("select");
    if (controlWord == "0")
    {
        atom2.addOption("None", "0");
    }
    else if (controlWord == "1")
    {
        atom2.addOption("CW","1");
    }
    else
    {
        atom2.addOption("Alert Label","2");
    }
    atom2.element.disabled = true;
    act.addAttrRow("controlchanneltype", RESOURCE["controlchanneltype"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.element.disabled = true;
    var vccvmode = pwAttr.advanceattriTable.getCellStoreValue(0, "vccv", "vccv");
    if (vccvmode == "0")
    {
    	atom1.addOption("None", "0");
    }
    else
    {
    	atom1.addOption("Ping", "1");
    }
    
    atom2 = new Atom("select");
    atom2.element.disabled = true;
    if (vccvmode == "0")
    {
    	atom2.addOption("None", "0");
    }
    else
    {
    	atom2.addOption("Ping", "1");
    }
    act.addAttrRow("vccvmode", RESOURCE["vccvmode"], atom1, atom2);
    
    atom1 = new Atom("text");
    var maxcount = pwAttr.advanceattriTable.getCellStoreValue(0, "maxcount", "maxcount");
    atom1.setValue(maxcount);
    atom1.element.disabled = true;
    atom2 = new Atom("text");
    atom2.setValue(maxcount);
    atom2.element.disabled = true;
    act.addAttrRow("count", RESOURCE["count"], atom1, atom2);
    
    atom1 = new Atom("text");
    var maxtime = pwAttr.advanceattriTable.getCellStoreValue(0, "maxtime", "maxtime");
    atom1.element.disabled = true;
    atom1.setValue(maxtime);
    atom2 = new Atom("text");
    atom2.setValue(maxtime);
    atom2.element.disabled = true;
    act.addAttrRow("time", RESOURCE["time"], atom1, atom2);
    
}

function initUI()
{
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
}

function initTabs()
{
    tab = new EmbedTabs();
    tab.addEmbedTab("tab1div", RESOURCE["generalattr"], $("tab1div")); //    
    tab.addEmbedTab("tab2div", RESOURCE["qos"], $("tab2div")); //QOS  
    tab.addEmbedTab("tab3div", RESOURCE["advancedattr"], $("tab3div"));  //    
    tab.addEmbedTab("tab4div", RESOURCE["PW_PROTECT_GROUP"], $("tab4div")); //PW   
    tab.addEmbedTab("tab5div", RESOURCE["PW_PROTECT_GROUP"], $("tab5div")); //PW     
    tab.addEmbedTab("tab6div", RESOURCE["PW_OAM"], $("tab6div")); //PW_OAM
    setSelectedEmbedTab("tab1div");
    if (tabSelectFlg == "pwAPS")
    {
    	setDisplay(pwct, "33%", "");
        setDisplay(act, "33%", "");
        tabHeadList["tab4div"].style.display = "";
        tabHeadList["tab5div"].style.display = "none";
        tabHeadList["tab6div"].style.display = "";
    }
    else
    {
    	setDisplay(pwct,"33%", "");
        setDisplay(act,"33%", "");
	    tabHeadList["tab4div"].style.display = "none";
        tabHeadList["tab5div"].style.display = "";
        tabHeadList["tab6div"].style.display = "none";
    }
    
    $("embedtab").appendChild(tab.getEmbedTabs());
}

/**
 *   
 */
function validate(index)
{
    var msgArr = new Array();
    var pwID = pwct.getAtom("pwid", index).getValue();
    if (typeof(pwID) == "undefined" || pwID == "") 
    {
        msgArr[msgArr.length] = RESOURCE["pwid"] + RESOURCE["rangemsg"] + "1~4294967295";
    }
    var labelRange = "16~1048575";
    var label = pwct.getAtom("pwinlabel", index).getValue();
    if (label != "-" && label == "") 
    {
        msgArr[msgArr.length] = RESOURCE["pwinlabel"] + RESOURCE["rangemsg"] + labelRange;
    }
    label = pwct.getAtom("pwoutlabel", index).getValue();
    if (label != "-" && label == "") 
    {
        msgArr[msgArr.length] = RESOURCE["pwoutlabel"] + RESOURCE["rangemsg"] + labelRange;
    }
    var ingresstunnel = $("selectedtunnel" + index).value; //  Ingress Tunnel
    var egresstunnel = $("selectedtunnel" + (index + 2)).value; //  Egress Tunnel
    if (ingresstunnel == "" || egresstunnel == "") 
    {
        msgArr[msgArr.length] = RESOURCE["inputtunnel"];
    }
    if (index == 1)//     ID
    {
    	var protectId = "undefined";
    	var tstpwid1,tstpwid2;
    	var lsrid1,lsrid2;
    	if (protecttype == PW_APS)
  	    {
  	    	protectId = pwProtectCT.getAtom("protectid").getValue();
  	    	/**
  	    	 * DTS2011062705795 
  	    	 *   PW APS TAB   PWAPS         PW OAM        
  	    	 *                 LSRID     PWID          
  	    	 *      PW OAM TAB                  
  	    	 *                                    
  	    	 */
  	    	tstpwid1 = pwoamct.getAtom("sendpwid", 0).getValue();
  	    	if (tstpwid1 == "" && pwct.getAtom("pwid",0).getValue() != "")
  	    	{
  	    	    tstpwid1 = pwct.getAtom("pwid",0).getValue();
  	    	    pwoamct.getAtom("sendpwid",0).setValue(tstpwid1);
  	    	}
  	    	
  			tstpwid2 = pwoamct.getAtom("sendpwid", 1).getValue();
  			if (tstpwid2 == "" && pwct.getAtom("pwid",1).getValue() != "")
  	    	{
  	    	    tstpwid2 = pwct.getAtom("pwid",1).getValue();
  	    	    pwoamct.getAtom("sendpwid",1).setValue(tstpwid2);
  	    	}
  			
  			lsrid1 = pwoamct.getAtom("relsrid", 0).getValue();
  			if (lsrid1 == "" && pwct.getAtom("oppsitelsrid",0).getValue() != "")
  	    	{
  	    	    lsrid1 = pwct.getAtom("oppsitelsrid",0).getValue();
  	    	    pwoamct.getAtom("relsrid",0).setValue(lsrid1);
  	    	}
  			
  			lsrid2 = pwoamct.getAtom("relsrid", 1).getValue();
  			if (lsrid2 == "" && pwct.getAtom("oppsitelsrid",1).getValue() != "")
  	    	{
  	    	    lsrid2 = pwct.getAtom("oppsitelsrid",1).getValue();
  	    	    pwoamct.getAtom("relsrid",1).setValue(lsrid2);
  	    	}
  			
  	    }
  	    else if(protecttype == PROTECT_PAIRS)
		{
			protectId = $("protectidforpair").value;
		}
		if (typeof(protectId) == "undefined" || protectId == "") 
		{
            msgArr[msgArr.length] = RESOURCE["PROTECT_ID"] + RESOURCE["rangemsg"] + "1~32";
        }
        if (protecttype == PW_APS)
        {
        	if((!lsrid1 || !lsrid2))
        	{
            	msgArr[msgArr.length] = RESOURCE["inputlsridtobereceived"];
       	    }
        
        	if((!tstpwid1 || !tstpwid2))
       	    {
            	msgArr[msgArr.length] = RESOURCE["SEND_PWID"] + RESOURCE["rangemsg"] + "1~4294967295";
        	}
        }
    }
    /*
    var v = pwct.getAtom("oppsitelsrid").getValue();
    var arr = v.split(".");
    var fIp = parseInt(arr[0]);
    var tIp = parseInt(arr[3]);
    if (isNaN(fIp) || isNaN(tIp) || fIp == 0 || fIp == 127 || (fIp >= 224 && fIp <= 255) || tIp == 0 || tIp == 255) 
    {
        msgArr[msgArr.length] = RESOURCE["oppsitelsrid"] + RESOURCE["inputmsg"] + "0.*.*.*,127.*.*.*,*.*.*.0,*.*.*.255,224.0.0.0~255.255.255.255";
    }
    */
    if (msgArr.length > 0) 
    {
        var msg = RESOURCE["errormsg"];
        for (var i = 0, m = msgArr.length; i < m; i++) 
        {
            msg += "\n(" + (i + 1) + ")" + msgArr[i];
        }
        alert(msg);
        return false;
    }
    return true;
}

function doOK()
{
	if (!validate(0) || !validate(1)) 
    {
    	return null;
  	}
	
    var xml = createPWXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_MSTPPLUS_PW_CREATE_PROTECTGROUP_ATM + "&nmUser=" + win.winurlobj["nmUser"];
    loadXMLdoc(url, "POST", false, createCallBack, null, "inputdata=" + xml);
    
}

function createCallBack(doc)
{
	var data = EncapsulateData(doc);
	if (data.getSErrorCode() != 0) 
    {
        showErrorDialog(data);
        return;
    }
    var parentst = win.parent.st;
    var selectRow = parentst.getSelectedRows();
    var cell;
    cell = parentst.getCell(selectRow, "apsID");
    parentst.setCellValue(cell, "apsID", data.getDataRowParam(0, "apsid"));
    
    cell = parentst.getCell(selectRow, "pwIndex");
    parentst.setCellValue(cell, "pwIndex", data.getDataRowParam(0, "workpw"));
    
    cell = parentst.getCell(selectRow, "protectpwIndex");
    parentst.setCellValue(cell, "protectpwIndex", data.getDataRowParam(0, "protectpw"));
    
    cell = parentst.getCell(selectRow, "protecttype");
    parentst.setCellValue(cell, "protecttype", protecttype);
    
    win.parent.apsid = data.getDataRowParam(0, "apsid");
    win.parent.pwIndex[0]= data.getDataRowParam(0, "workpw");
    win.parent.pwIndex[1] = data.getDataRowParam(0, "protectpw");
    win.parent.protecttype = protecttype;
    
    xcloseDialog();
    win.$("newbtn").disabled = true; //      
    if (tabSelectFlg == "pwAPS")
    {
    	win.doQueryPWAPS();//    
    }
    else
    {
    	win.doQueryPWAPSPairs();//    
    }
}

function createPWXML()
{
	var di = new inputxml("datainterface");
 	var business = new tagElement("bussiness-params");
    if (tabSelectFlg == "pwAPS")//       PW_OAM  PW   PW OAM  
	{
		constructWorkPW(business); //  PW   PWOAM  
		constructPwRow(business, protecttype); //    PW
		constructProtectGroupRow(business);
	}
	else
	{
		constructPwRow(business, protecttype); //    PW
		constructPairProtectGroupRow(business);
	}
	di.getRoot().appendChild(business);
	return di.toString();
}
function constructWorkPW(business)
{
	var rowParams = new tagElement("row-params");
	rowParams.appendChild(createTagElement("neid", neid));
	
	rowParams.appendChild(createTagElement("workState", WORK_STATE));
	
	rowParams.appendChild(createTagElement("pwIndex", win.parent.pwIndex[0])); //  pwIndex
    rowParams.appendChild(createTagElement("enablestate", 1)); //    
    rowParams.appendChild(createTagElement("checkMode", pwoamct.getAtom("detectstyle", 0).getValue())); //    
    rowParams.appendChild(createTagElement("pagcketType", pwoamct.getAtom("detecttype", 0).getValue())); //      
    rowParams.appendChild(createTagElement("checkPeriod", pwoamct.getAtom("detecttime", 0).getValue())); //      
    rowParams.appendChild(createTagElement("lsrId", convertIPStrToLong(pwoamct.getAtom("relsrid", 0).getValue()))); //  LSRID
    rowParams.appendChild(createTagElement("sendpwId", pwoamct.getAtom("sendpwid", 0).getValue())); //  PWID
    
    business.appendChild(rowParams);
}
function constructPwRow(business, protecttype)
{
    var rowParams = new tagElement("row-params");
    rowParams.appendChild(createTagElement("neid", neid));
    rowParams.appendChild(createTagElement("vnniId", 1));
    rowParams.appendChild(createTagElement("workpw", win.parent.pwIndex[0])); //  pwIndex,            
    rowParams.appendChild(createTagElement("workState", PROTECT_STATE)); //PW           
    rowParams.appendChild(createTagElement("protecttype", protecttype)); //    
    rowParams.appendChild(createTagElement("pwID", pwct.getAtom("pwid",1).getValue()));
    rowParams.appendChild(createTagElement("pwIndex", 0));
    rowParams.appendChild(createTagElement("enableState", 1));
    rowParams.appendChild(createTagElement("pwSignalType", pwct.getAtom("pwsignaltype",1).getValue()));
    rowParams.appendChild(createTagElement("pwType", pwct.getAtom("pwtype",1).getValue()));
    rowParams.appendChild(createTagElement("serviceType", pwct.getAtom("pwtype", 1).getValue()));
    rowParams.appendChild(createTagElement("direction", pwct.getAtom("direction",1).getValue()));
    
    /*----------- PW        ------------*/
    rowParams.appendChild(createTagElement("pwEncapsType", pwct.getAtom("pwencaptype",1).getValue()));
    rowParams.appendChild(createTagElement("pwIngressLabel", pwct.getAtom("pwinlabel",1).getValue()));
    rowParams.appendChild(createTagElement("pwEgressLabel", pwct.getAtom("pwoutlabel",1).getValue()));
    
    rowParams.appendChild(createTagElement("oppositeLsrID", convertIPStrToLong(pwct.getAtom("oppsitelsrid",1).getValue())));
    rowParams.appendChild(createTagElement("tunneltype", tunnelTypes[pwct.getAtom("tunneltype",1).getValue()]));
    var tunnelIndex = $("tunnelindex1").value;
    var tunnelIndexHex = tenToHex(tunnelIndex);
    for (var i = tunnelIndexHex.length; i < 8; i++) 
    {
        tunnelIndexHex = "0" + tunnelIndexHex;
    }
    rowParams.appendChild(createTagElement("tunnelIndexes", tunnelIndexHex)); //tunnelIndexes:PW  Ingress  
    
    var ingresstunnelid = $("ingressid1").value; //    Ingress Tunnel  TunnelID           
    rowParams.appendChild(createTagElement("ingresstunnelid", ingresstunnelid));
    
    var tunnelid = $("tunnelindex3").value;
    var ingressid = $("ingressid3").value;
    var egressid = $("egressid3").value;
    rowParams.appendChild(createTagElement("ingressid", ingressid)); //ingressid,egressid,tunnelid:PW  Egress  
    rowParams.appendChild(createTagElement("egressid", egressid)); 
    rowParams.appendChild(createTagElement("tunnelid", tunnelid));
      
    rowParams.appendChild(createTagElement("controlWord", act.getAtom("controlword", 1).getValue()));
    rowParams.appendChild(createTagElement("ctrlChanType", act.getAtom("controlchanneltype", 1).getValue()));
    rowParams.appendChild(createTagElement("vccv", act.getAtom("vccvmode", 1).getValue()));
    rowParams.appendChild(createTagElement("tunnelpolicy", "-"));
    rowParams.appendChild(createTagElement("localWorkingStat", 0));
    rowParams.appendChild(createTagElement("remoteWorkingStat", 0));
    rowParams.appendChild(createTagElement("compWorkingStat", 0));
    rowParams.appendChild(createTagElement("maxcount", act.getAtom("count", 1).getValue()));
    rowParams.appendChild(createTagElement("maxtime", act.getAtom("time", 1).getValue()));
    
    if (protecttype == PW_APS)
    {
    	rowParams.appendChild(createTagElement("enablestate", 1)); //    
   	    rowParams.appendChild(createTagElement("checkMode", pwoamct.getAtom("detectstyle", 1).getValue())); //    
        rowParams.appendChild(createTagElement("pagcketType", pwoamct.getAtom("detecttype", 1).getValue())); //      
        rowParams.appendChild(createTagElement("checkPeriod", pwoamct.getAtom("detecttime", 1).getValue())); //      
        rowParams.appendChild(createTagElement("lsrId", convertIPStrToLong(pwoamct.getAtom("relsrid", 1).getValue()))); //  LSRID
        rowParams.appendChild(createTagElement("sendpwId", pwoamct.getAtom("sendpwid", 1).getValue())); //  PWID
    }
    
    rowParams.appendChild(createTagElement("idirection", INGRESS)); //  
    var protectPWIngress_BW = qostable.getCellStoreValue(QOS_INFO_TABLE_BANDWIDTHLIMIT_INDEX, QOS_INFO_TABLE_PROTECTPWINGRESS_COL, QOS_INFO_TABLE_PROTECTPWINGRESS_COL);
    rowParams.appendChild(createTagElement("bwEnabled", protectPWIngress_BW));
	var protectPWIngress_CIR = qostable.getCellStoreValue(QOS_INFO_TABLE_CIR_INDEX, QOS_INFO_TABLE_PROTECTPWINGRESS_COL, QOS_INFO_TABLE_PROTECTPWINGRESS_COL);
	rowParams.appendChild(createTagElement("cir", protectPWIngress_CIR));
	var protectPWIngress_CBS = qostable.getCellStoreValue(QOS_INFO_TABLE_CBS_INDEX, QOS_INFO_TABLE_PROTECTPWINGRESS_COL, QOS_INFO_TABLE_PROTECTPWINGRESS_COL);
	rowParams.appendChild(createTagElement("cbs", protectPWIngress_CBS));
	var protectPWIngress_PIR = qostable.getCellStoreValue(QOS_INFO_TABLE_PIR_INDEX, QOS_INFO_TABLE_PROTECTPWINGRESS_COL, QOS_INFO_TABLE_PROTECTPWINGRESS_COL);
	rowParams.appendChild(createTagElement("pir", protectPWIngress_PIR));
	var protectPWIngress_PBS = qostable.getCellStoreValue(QOS_INFO_TABLE_PBS_INDEX, QOS_INFO_TABLE_PROTECTPWINGRESS_COL, QOS_INFO_TABLE_PROTECTPWINGRESS_COL);
	rowParams.appendChild(createTagElement("pbs", protectPWIngress_PBS));
	var protectPWIngress_EXP = qostable.getCellStoreValue(QOS_INFO_TABLE_EXP_INDEX, QOS_INFO_TABLE_PROTECTPWINGRESS_COL, QOS_INFO_TABLE_PROTECTPWINGRESS_COL);
	rowParams.appendChild(createTagElement("exp", protectPWIngress_EXP));
    
    
	business.appendChild(rowParams);
}

function constructProtectGroupRow(business)
{
	var rowParams = new tagElement("row-params");
	rowParams.appendChild(createTagElement("neid", neid));
	rowParams.appendChild(createTagElement("autoassign", 0));
    rowParams.appendChild(createTagElement("apsid", pwProtectCT.getAtom("protectid").getValue())); //   ID
    rowParams.appendChild(createTagElement("tunneltype", 1));
    rowParams.appendChild(createTagElement("protype", pwProtectCT.getAtom("protype").getValue())); //    APS    
    rowParams.appendChild(createTagElement("isenable", pwProtectCT.getAtom("isenable").getValue()));  //    
    rowParams.appendChild(createTagElement("switchmode", pwProtectCT.getAtom("swtichmode").getValue()));  //    
    rowParams.appendChild(createTagElement("rvtmode", pwProtectCT.getAtom("swtichmode").getValue()));  //    
    var recoverytime = pwProtectCT.getAtom("recoverytime").getValue();
    if(recoverytime == "-")
    {
        recoverytime = 1;
    }
    rowParams.appendChild(createTagElement("wtrtime", recoverytime)); //      
    rowParams.appendChild(createTagElement("delaytime", pwProtectCT.getAtom("swtichtime").getValue()));  //    
    rowParams.appendChild(createTagElement("groupid", 0xFFFF));
    
    business.appendChild(rowParams);
    
}
function constructPairProtectGroupRow(business)
{
	var rowParams = new tagElement("row-params");
	rowParams.appendChild(createTagElement("neid", neid));
	rowParams.appendChild(createTagElement("autoassign", 0));
	rowParams.appendChild(createTagElement("apsid", $("protectidforpair").value));
    rowParams.appendChild(createTagElement("protype", pairPwProtectCT.getAtom("protecttype").getValue()));
	business.appendChild(rowParams);
	
}


function CTable2()
{
    this.element = document.createElement("table");
    this.element.appendChild(document.createElement("thead"));
    this.element.appendChild(document.createElement("tbody"));
    this.element.firstChild.appendChild(document.createElement("tr"));
    
    this.attrName = new Object();
    this.attrArray = new Object();
    this.element.className = "attrTable";
    this.addHead = function(head1, head2, head3)
    {
        var th = document.createElement("td");
        span = document.createElement("span");
        span.appendChild(document.createTextNode(head1));
        th.appendChild(span);
        this.element.firstChild.firstChild.appendChild(th);
        th = document.createElement("td");
        span = document.createElement("span");
        span.appendChild(document.createTextNode(head2));
        th.appendChild(span);
        this.element.firstChild.firstChild.appendChild(th);
        th = document.createElement("td");
        span = document.createElement("span");
        span.appendChild(document.createTextNode(head3));
        th.appendChild(span);
        this.element.firstChild.firstChild.appendChild(th);
    }
    
    this.addAttrRow = function(attrid, attrname, atom1, atom2, text)
    {
        tr = document.createElement("tr");
        td = document.createElement("td");
        span = document.createElement("span");
        span.appendChild(document.createTextNode(attrname));
        td.appendChild(span);
        tr.appendChild(td);
        
        td = document.createElement("td");
        td.appendChild(atom1.element);
        if (text != null) {
            span = document.createElement("span");
            span.appendChild(document.createTextNode(text));
            td.appendChild(span);
        }
        tr.appendChild(td);
        
        td = document.createElement("td");
        td.appendChild(atom2.element);
        if (text != null) {
            span = document.createElement("span");
            span.appendChild(document.createTextNode(text));
            td.appendChild(span);
        }
        tr.appendChild(td);
        this.element.childNodes[1].appendChild(tr);
        var atomArr = new Object();
        atomArr[0] = atom1;
        atomArr[1] = atom2;
        this.attrArray[attrid] = atomArr;
        this.attrName[attrid] = attrname;
    }
    
    this.getAttrName = function(attrid){
        return this.attrName[attrid];
    }
    
    this.getAttrValue = function(attrid, index){
        return this.attrArray[attrid][index].getValue();
    }
    
    this.setAttrValue = function(attrid, index, value){
        if (this.attrArray[attrid][index]) {
            this.attrArray[attrid][index].setValue(value);
        }
    }
    
    this.getAtom = function(attrid, index){
        if (this.attrArray[attrid][index]) {
            return this.attrArray[attrid][index];
        }
        
    }
    this.getTable = function(){
        return this.element;
    }
}

function setDisplay(table, width, display)
{
    table.element.childNodes[0].childNodes[0].childNodes[0].style.width = width;
    table.element.childNodes[0].childNodes[0].childNodes[1].style.width = width;
    table.element.childNodes[0].childNodes[0].childNodes[2].style.display = display;
    
    
    var childNodes = table.element.childNodes[1].childNodes;
    for (var i = 0, m = childNodes.length; i < m; i++) {
        childNodes[i].childNodes[0].style.width = width;
        childNodes[i].childNodes[1].style.width = width;
        childNodes[i].childNodes[2].style.display = display;
    }
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
}
