var tab = null;

var win = getParentWindow();
var neid = win.neid;
var nmUser = win.nmUser;

var pwct = null;
var qostable = null;
var qostabletc = null;
var pwProtectCT = null;
var pairPwProtectCT = null;
var act = null;
var pwoamct = null;

var connectionType = null;
var protecttype = null;

var tunnelTypes = [];

tunnelTypes[TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL] = "NSCMD_CFG_MPLS_GET_TUNNEL";
tunnelTypes[TECMDCODE_PTN_GRETUNNEL_QUERY] = "NSCMD_CFG_GRE_TNL_GET_TUNNEL";
tunnelTypes[TECMDCODE_PTN_IPTUNNEL_QUERY] = "NSCMD_CFG_IP_TNL_GET_TUNNEL";


var workState = [];
workState[0] = "WORK";
workState[1] = "PROTECT";

var pwEXP = new Object();
pwEXP["0"] = "exp_0";
pwEXP["1"] = "exp_1";
pwEXP["2"] = "exp_2";
pwEXP["3"] = "exp_3";
pwEXP["4"] = "exp_4";
pwEXP["5"] = "exp_5";
pwEXP["6"] = "exp_6";
pwEXP["7"] = "exp_7";
pwEXP["255"] = "exp_none";

var QOS_INFO_TABLE_BANDWIDTHLIMIT_INDEX = 0;//"    "  
var QOS_INFO_TABLE_POLICY_INDEX = 1;//"  "  
var QOS_INFO_TABLE_CIR_INDEX = 2;//"     (kbit/s)"  
var QOS_INFO_TABLE_CBS_INDEX = 3;//"        (byte)"  
var QOS_INFO_TABLE_PIR_INDEX = 4;//"    (kbit/s)"  
var QOS_INFO_TABLE_PBS_INDEX = 5;//"          (byte)"  
var QOS_INFO_TABLE_EXP_INDEX = 6;//"EXP"  
var QOS_INFO_TABLE_LSPMODE_INDEX = 7;//"LSP  "  
var QOS_INFO_TABLE_ATTR_COL = "qosAtrr";//"  " ID
var QOS_INFO_TABLE_WORKPWINGRESS_COL = "workPWIngress";//"  PW Ingress " ID
var QOS_INFO_TABLE_WORKPWEGRESS_COL = "workPWEgress";//"  PW Egress " ID
var QOS_INFO_TABLE_PROTECTPWINGRESS_COL = "protectPWIngress";//"  PW Ingress " ID
var QOS_INFO_TABLE_PROTECTPWEGRESS_COL = "protectPWEgress";//"  PW Egress " ID

var CELL_DISABLED = "0";//        
var CELL_ENABLED = "1";//       

var BANDWIDTH_LIMIT_DISABLED = "0";//      
var BANDWIDTH_LIMIT_ENABLED = "1";//      


function init()
{
    connectionType = win.parent.ct.getAtom("connectiontype").getValue();
    protecttype = parseInt(win.parent.ct.getAtom("protecttype").getValue()); 
    initGeneralTable();
    initQOSTable();
    initAdvancedTable();
    initPWProtectTable();
    initPairPWProtectTable();
    initPWOAMTable();
    initUI();
    initTabs();
    initData(); //   QOSTABLE    
    addQoSCellListener();
}
function initData()
{
	/*
	var root = document.createElement("datainterface");
	var firstlevel = document.createElement("business-params");
	var secondlevel = document.createElement("row-params");
	var thirdlevel = document.createElement("param");
	thirdlevel.setAttribute("name", "qosAtrr");
	thirdlevel.setAttribute("value", "EXP");
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = document.createElement("param");
	thirdlevel.setAttribute("name", "workPWIngress");
	thirdlevel.setAttribute("value", win.qosAttr.workPWIngress);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = document.createElement("param");
	thirdlevel.setAttribute("name", "workPWEgress");
	thirdlevel.setAttribute("value", "-");
	secondlevel.appendChild(thirdlevel);
	
	if (protecttype != NO_PROTECT)
	{
		thirdlevel = document.createElement("param");
		thirdlevel.setAttribute("name", "protectPWIngress");
		thirdlevel.setAttribute("value", win.qosAttr.protectPWIngress);
		secondlevel.appendChild(thirdlevel);
	
		thirdlevel = document.createElement("param");
		thirdlevel.setAttribute("name", "protectPWEgress");
		thirdlevel.setAttribute("value", "-");
		secondlevel.appendChild(thirdlevel);
	}
	firstlevel.appendChild(secondlevel);
	root.appendChild(firstlevel);
	createTableBody(qostable, qostabletc, EncapsulateData(root), RESOURCE);
	*/
	if (protecttype == NO_PROTECT)
	{
		loadXMLdoc("../../../conf/atm_u2kv1r3c00/create/qosdata.xml", "GET", false, initQosTableData);
	}
	else
	{
		loadXMLdoc("../../../conf/atm_u2kv1r3c00/create/protect_qosdata.xml", "GET", false, initQosTableData);
	}
	
}

function initQosTableData(doc)
{
	var data = EncapsulateData(doc);
    createTableBody(qostable, qostabletc, EncapsulateData(doc), RESOURCE);
    if(qostable.getDataRowLength() == 0)
	{
		return;
	}
    
    for(var i = 0, size = qostable.getDataRowLength(); i < size; i++)
    {
        var attrId = qostable.getCellStoreValue(i, QOS_INFO_TABLE_ATTR_COL, QOS_INFO_TABLE_ATTR_COL);
        qostable.getCellShow(i, QOS_INFO_TABLE_ATTR_COL).element.innerHTML = RESOURCE[attrId]; //     
    	for(var j = 1, colLength = qostable.getColumnCount(); j < colLength; j++)//  0            
    	{
    	    var colid = qostabletc.getColId(j);
    		var cellValue = qostable.getCellStoreValue(i, colid, colid);
    		if(cellValue == "-")
    		{
    			setCellEidtable(qostable, i, colid, CELL_DISABLED);
    		}
    		else if(cellValue != null && cellValue != "")
    		{
    			setCellEidtable(qostable, i, colid, CELL_ENABLED);
    			if ( i == QOS_INFO_TABLE_BANDWIDTHLIMIT_INDEX)
    			{
    				qostable.getCellShow(i, colid).element.innerHTML = RESOURCE[attrId + "_" + cellValue];
    			}
    			else if (i == QOS_INFO_TABLE_EXP_INDEX)
    			{
    				qostable.getCellShow(i, colid).element.innerHTML = RESOURCE[attrId + "_" + cellValue];
    				setCellEidtable(qostable, i, colid, CELL_DISABLED);
    			}
    		}
    	}
    }
    
}

function addQoSCellListener()
{
	for(var i = 0, size = qostable.getDataRowLength(); i < size; i++)
    {
        qostable.getCell(i, QOS_INFO_TABLE_WORKPWINGRESS_COL).element.ondblclick = qosTableCellondbclick;
        qostable.getCell(i, QOS_INFO_TABLE_WORKPWEGRESS_COL).element.ondblclick = qosTableCellondbclick;
        if (protecttype != NO_PROTECT)
        {
        	qostable.getCell(i, QOS_INFO_TABLE_PROTECTPWINGRESS_COL).element.ondblclick = qosTableCellondbclick;
        	qostable.getCell(i, QOS_INFO_TABLE_PROTECTPWEGRESS_COL).element.ondblclick = qosTableCellondbclick;
        }
        
    }
}

/**
 *          QoS        
 * @return
 */
function qosTableCellondbclick()
{
    if(this.isEdit == CELL_DISABLED)
    {
        return;//            
    }
    
    var rowid = this.parentNode.rowIndex;
    if(qostable.element.datarows[rowid].element.style.display == "none")
    {
        return;//           
    }
    
    this.style.backgroundColor = "#d0f946";
    if(isIE)
    {
        this.onselectstart = null;
    }
    else
    {
        this.style.MozUserSelect = "text";
    }
    this.modify = true;
    this.parentNode.modify = true;
    this.showElement.element.style.display = "none"; 
    var colid = this.colid;
    var atom = null;
    switch(rowid)
    {
        case QOS_INFO_TABLE_BANDWIDTHLIMIT_INDEX://     
            atom = createSelectAtom(qostable, this);
            atom.addOption(RESOURCE["bandwidthLimit_0"],"0");
            atom.addOption(RESOURCE["bandwidthLimit_1"],"1");
            atom.element.onchange = function()
            {
                bandwidthLimitChange(this);
            }
            break;
		case QOS_INFO_TABLE_CIR_INDEX: //CIR
		case QOS_INFO_TABLE_PIR_INDEX: //PIR
			atom = createTextAtom(qostable, this);
            textCheckWithStepLen(atom.element, 0, 1000000, 64);
            break;
		case QOS_INFO_TABLE_CBS_INDEX:
		case QOS_INFO_TABLE_PBS_INDEX:
			atom = createTextAtom(qostable, this);
            textCheck(atom.element, 0, 4294967295);
            break;
        case QOS_INFO_TABLE_EXP_INDEX:// EXP
            atom = createSelectAtom(qostable, this);
            atom.addOption(RESOURCE["exp_" + 255], 255);
            for(var i = 0; i < 8; i++)
            {
                atom.addOption(RESOURCE["exp_" + i], i);
            }
            break;
        case QOS_INFO_TABLE_LSPMODE_INDEX:// LSP  
            atom = createSelectAtom(qostable, this);
            atom.addOption(RESOURCE["lspmode_1"],"1");
            atom.addOption(RESOURCE["lspmode_2"],"2");
            break;
        default:
            break;
    }
    
    if(atom == null)
    {
        return;
    }
    
    var cellOldValue = this.storeValue[this.colid];
    if(cellOldValue)//                       
    {
        atom.setValue(cellOldValue);
    }

    atom.element.onclick=stopEventPropagation;
    atom.element.onmousedown=atomOnMouseDownHandle;
    atom.element.ondblclick=stopEventPropagation;
    
    this.appendChild(atom.element);
    atom.element.focus();
}

/**
 * QoS                  
 * @return
 */
function bandwidthLimitChange(atom)
{
    var colid = atom.parentNode.colid;
    var cell;
    if(atom.value == BANDWIDTH_LIMIT_DISABLED)
    {
        setCellEidtable(qostable, QOS_INFO_TABLE_CIR_INDEX, colid, CELL_DISABLED);//     (kbit/s)
        setCellEidtable(qostable, QOS_INFO_TABLE_CBS_INDEX, colid, CELL_DISABLED);//(kbit/s)
        setCellEidtable(qostable, QOS_INFO_TABLE_PIR_INDEX, colid, CELL_DISABLED);//    (kbit/s)
        setCellEidtable(qostable, QOS_INFO_TABLE_PBS_INDEX, colid, CELL_DISABLED);//     (kbit/s)
        qostable.getCellShow(QOS_INFO_TABLE_CIR_INDEX, colid).element.innerHTML = "-";
        qostable.getCellShow(QOS_INFO_TABLE_CBS_INDEX, colid).element.innerHTML = "-";
        qostable.getCellShow(QOS_INFO_TABLE_PIR_INDEX, colid).element.innerHTML = "-";
        qostable.getCellShow(QOS_INFO_TABLE_PBS_INDEX, colid).element.innerHTML = "-";
        cell = qostable.getCell(QOS_INFO_TABLE_CBS_INDEX, colid);
        qostable.setCellValue(cell, colid, "-");
        cell = qostable.getCell(QOS_INFO_TABLE_PBS_INDEX, colid);
        qostable.setCellValue(cell, colid, "-");
    }
    else
    {
        setCellEidtable(qostable, QOS_INFO_TABLE_CIR_INDEX, colid, CELL_ENABLED);//     (kbit/s)
        setCellEidtable(qostable, QOS_INFO_TABLE_CBS_INDEX, colid, CELL_ENABLED);//(kbit/s)
        setCellEidtable(qostable, QOS_INFO_TABLE_PIR_INDEX, colid, CELL_ENABLED);//    (kbit/s)
        setCellEidtable(qostable, QOS_INFO_TABLE_PBS_INDEX, colid, CELL_ENABLED);
        qostable.getCellShow(QOS_INFO_TABLE_CIR_INDEX, colid).element.innerHTML = "64";
        qostable.getCellShow(QOS_INFO_TABLE_CBS_INDEX, colid).element.innerHTML = "";
        qostable.getCellShow(QOS_INFO_TABLE_PIR_INDEX, colid).element.innerHTML = "64";
        qostable.getCellShow(QOS_INFO_TABLE_PBS_INDEX, colid).element.innerHTML = "";
        cell = qostable.getCell(QOS_INFO_TABLE_CIR_INDEX, colid);
        qostable.setCellValue(cell, colid, 64);
        cell = qostable.getCell(QOS_INFO_TABLE_CBS_INDEX, colid);
        qostable.setCellValue(cell, colid, "");
        cell = qostable.getCell(QOS_INFO_TABLE_PIR_INDEX, colid);
        qostable.setCellValue(cell, colid, 64);
        cell = qostable.getCell(QOS_INFO_TABLE_PBS_INDEX, colid);
        qostable.setCellValue(cell, colid, "");
    }
    addQoSCellListener();//           
}

/**
 *   select         
 * @param cell
 * @return
 */
function createSelectAtom(st, cell)
{
    var atom = st.createAtom("select");
    cell.editElement.type = "select";
    atom.element.onblur= cellonblur;
    return atom;
}

/**
 *   text         
 * @param cell
 * @return
 */
function createTextAtom(st, cell)
{
    var atom = st.createAtom("text");
    cell.editElement.type = "text";
    atom.element.onblur= cellonblur;
    return atom;
}

/**
 *       
 * @param value
 * @return
 */
function attrConvert(value)
{
	var attrRes = RESOURCE[value];
	if(attrRes == null)
	{
		return value;
	}
	return attrRes;
}

function embedTabSelectHandler(id)
{
	if(id == "tab2div")
	{
		adjustTableLayout(qostable,qostabletc);
	}
	else if (id == "tab6div") 
   {
       if(pwoamct.getAtom("relsrid",0).getValue()=="" || pwoamct.getAtom("relsrid",0).getValue()==null)
       {
       	pwoamct.getAtom("relsrid",0).setValue(pwct.getAtom("oppsitelsrid",0).getValue());
       }
       
       if(pwoamct.getAtom("relsrid",1).getValue()=="" || pwoamct.getAtom("relsrid",1).getValue()==null)
       {
       	pwoamct.getAtom("relsrid",1).setValue(pwct.getAtom("oppsitelsrid",1).getValue());
       }
       
        if(pwoamct.getAtom("sendpwid",0).getValue()=="" || pwoamct.getAtom("sendpwid",0).getValue()==null)
       {
       	pwoamct.getAtom("sendpwid",0).setValue(pwct.getAtom("pwid",0).getValue());
       }
       
       if(pwoamct.getAtom("sendpwid",1).getValue()=="" || pwoamct.getAtom("sendpwid",1).getValue()==null)
       {
       	pwoamct.getAtom("sendpwid",1).setValue(pwct.getAtom("pwid",1).getValue());
       }
       
   }
}

function initPWOAMTable()
{
	pwoamct = new CTable2();
	pwoamct.element.id = "pwoamct";
	pwoamct.addHead(RESOURCE["property"], RESOURCE["WORK_PW"], RESOURCE["PROTECT_PW"]);
	$("pwoam").appendChild(pwoamct.getTable());
	
	var atom1 = new Atom("select");
	atom1.addOption(RESOURCE["enableState_0"], 0);
	atom1.addOption(RESOURCE["enableState_1"], 1);
	atom1.element.options.selectedIndex = 1;
	atom1.element.disabled = true;
	var atom2 = new Atom("select");
	atom2.addOption(RESOURCE["enableState_0"], 0);
	atom2.addOption(RESOURCE["enableState_1"], 1);
	atom2.element.options.selectedIndex = 1;
	atom2.element.disabled = true;
	pwoamct.addAttrRow("enablestate", RESOURCE["OAM_STATE"], atom1, atom2);
	
	atom1 = new Atom("select");
	atom1.addOption(RESOURCE["detectionMode_1"], 0); //   
	atom1.addOption(RESOURCE["detectionMode_2"], 1);  //  
	atom1.element.options.selectedIndex = 0;
	atom2 = new Atom("select");
	atom2.addOption(RESOURCE["detectionMode_1"], 0);
	atom2.addOption(RESOURCE["detectionMode_2"], 1);
	atom2.element.options.selectedIndex = 0;
	pwoamct.addAttrRow("detectstyle", RESOURCE["DETECT_STYLE"], atom1, atom2);
	
	atom1 = new Atom("select");
	atom1.addOption(RESOURCE["detectType_1"], 0); //CV
	atom1.addOption(RESOURCE["detectType_2"], 1);  //FFD
	atom1.element.options.selectedIndex = 0;
	atom1.element.onchange = function()
	{
		var temp = pwoamct.getAtom("detecttime", 0);
		if (this.value == 0) //FFD
		{
			temp.element.options.length = 0;
			temp.addOption("1000", "1000");
			temp.element.disabled = true;
		}
		else
		{
			temp.element.options.length = 0;
			temp.addOption("3.3", "3.3");
			temp.addOption("10", "10");
			temp.addOption("20", "20");
			temp.addOption("50", "50");
			temp.addOption("100", "100");
			temp.addOption("200", "200");
			temp.addOption("500", "500");
			temp.element.options.selectedIndex = 3;
			temp.element.disabled = false;
		}
	};
	atom2 = new Atom("select");
	atom2.addOption(RESOURCE["detectType_1"], 0);
	atom2.addOption(RESOURCE["detectType_2"], 1); 
	atom2.element.options.selectedIndex = 0;
	atom2.element.onchange = function()
	{
		var temp = pwoamct.getAtom("detecttime", 1);
		if (this.value == 0) //FFD
		{
			temp.element.options.length = 0;
			temp.addOption("1000", "1000");
			temp.element.disabled = true;
		}
		else
		{
			temp.element.options.length = 0;
			temp.addOption("3.3", "3.3");
			temp.addOption("10", "10");
			temp.addOption("20", "20");
			temp.addOption("50", "50");
			temp.addOption("100", "100");
			temp.addOption("200", "200");
			temp.addOption("500", "500");
			temp.element.options.selectedIndex = 3;
			temp.element.disabled = false;
		}
	};
	pwoamct.addAttrRow("detecttype", RESOURCE["DETECT_TYPE"], atom1, atom2);
	
	
	atom1 = new Atom("select");
	atom1.addOption("1000", "1000");
	atom1.element.disabled = true;
	atom2 = new Atom("select");
	atom2.addOption("1000", "1000");
	atom2.element.disabled = true;
	pwoamct.addAttrRow("detecttime", RESOURCE["DETECT_TIME"], atom1, atom2); //      
	
	atom1 = new Atom("text");
	validateIp(atom1.element);
	atom2 = new Atom("text");
	validateIp(atom2.element);
	pwoamct.addAttrRow("relsrid", RESOURCE["RECEIVE_LSRID"], atom1, atom2);
	
	atom1 = new Atom("text");
	checkText(atom1.element, "1", "4294967295");
	atom2 = new Atom("text");
	checkText(atom2.element, "1", "4294967295");
	pwoamct.addAttrRow("sendpwid", RESOURCE["SEND_PWID"], atom1, atom2);
	
	setDisplay(pwoamct,"33%", "");
}

function initPWProtectTable()
{
    pwProtectCT = new CTable();
    pwProtectCT.element.id = "pwProtectCT";
    pwProtectCT.addHead(RESOURCE["property"], RESOURCE["value"]);
    
    var atom = new Atom("select");
    atom.addOption("PW APS", "1");
    atom.element.disabled=true;
	pwProtectCT.addAttrRow("protecttype", RESOURCE["PROTECT_TYPE"], atom);
   
    
    atom = new Atom("text");
    checkText(atom.element, "1", "32");
    pwProtectCT.addAttrRow("protectid", RESOURCE["PROTECT_ID"], atom);
    
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.addOption(RESOURCE["enabled"], "1");
    atom.addOption(RESOURCE["disabled"], "0");
    pwProtectCT.addAttrRow("isenable", RESOURCE["ISENABLE"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.addOption("1:1", "1");
    atom.element.disabled = true;
    pwProtectCT.addAttrRow("protype", RESOURCE["PROTECT_MODE"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.addOption(RESOURCE["SWTICH_MODE2"], "1");
    atom.addOption(RESOURCE["SWTICH_MODE1"], "0");
    atom.element.disabled = true;
    pwProtectCT.addAttrRow("swtichmode", RESOURCE["SWTICH_MODE"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.addOption(RESOURCE["revertive"], "1");
    atom.addOption(RESOURCE["NO_RECOVERY_MODE"], "0");
    atom.element.onchange = function()
    {
    	 var recoverytime = pwProtectCT.getAtom("recoverytime");
    	 if(pwProtectCT.getAtom("recoverymode").getValue() == "1")
    	 {
    	 	   recoverytime.element.disabled = false;
    	 	   recoverytime.element.value = "1";
    	 }else
    	 {
    	 	   recoverytime.element.disabled = true;
    	 	   recoverytime.element.value = "-";
    	 }
    }
    pwProtectCT.addAttrRow("recoverymode", RESOURCE["RECOVERY_MODE"], atom);
    
    atom = new Atom("text");
    atom.element.value = 1;
    checkText(atom.element, "1", "12");
    pwProtectCT.addAttrRow("recoverytime", RESOURCE["RECOVERY_TIME"], atom);
    
    atom = new Atom("text");
    atom.element.value = 0;
    checkText(atom.element, "0", "100");
    pwProtectCT.addAttrRow("swtichtime", RESOURCE["DELAY_TIME"], atom);
    
    $("pwprotecttb").appendChild(pwProtectCT.getTable());
    
}
function initPairPWProtectTable()
{
	pairPwProtectCT = new CTable();
    pairPwProtectCT.element.id = "pairPwProtectCT";
    pairPwProtectCT.addHead(RESOURCE["property"], RESOURCE["value"]);
    
    var atom = new Atom("select");
    atom.addOption(RESOURCE["PROTECT_PAIRS"], "1");
    atom.element.disabled=true;
	pairPwProtectCT.addAttrRow("protecttype", RESOURCE["PROTECT_TYPE"], atom);
    
    atom = new Atom("span");
    pairPwProtectCT.addAttrRow("protectidspan", RESOURCE["PROTECT_ID"], atom);
    
    var elem = document.createElement("input");
    elem.type = "text";
    elem.id = "protectidforpair";
    elem.disabled = true;
    checkText(elem, "1", "32");
    elem.style.width = "79%";
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "button";
    elem.id = "protectidBtn";
    elem.value = "...";
    elem.style.width = "20%";
    elem.onclick = function()
	{
		xshowModalDialog("../../ethservice/eline_u2kv1r3c00/selectaps.html", RESOURCE["resourceselected"], 720, 400, "../../../../../../images/");
	};
    atom.element.parentNode.appendChild(elem); 
 
    $("pairpwprotecttb").appendChild(pairPwProtectCT.getTable());
}

function initGeneralTable()
{
    pwct = new CTable2();
    pwct.element.id = "pwct";
    pwct.addHead(RESOURCE["property"], RESOURCE["WORK_PW"], RESOURCE["PROTECT_PW"]);
    
    $("general").appendChild(pwct.getTable());
    
    var atom1 = new Atom("text");
    checkText(atom1.element, "1", "4294967295");
    if (win.pwID != 0) 
    {
        atom1.setValue(win.pwID);//         pwID
    }
    var atom2 = new Atom("text");
    checkText(atom2.element, "1", "4294967295");
    pwct.addAttrRow("pwid", RESOURCE["pwid"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.element.style.width = "100%";
    atom1.addOption(RESOURCE["static"], "1");
    atom1.element.name = "0";
    atom2 = new Atom("select");
    atom2.element.style.width = "100%";
    atom2.addOption(RESOURCE["static"], "1");
    atom2.element.name = "1";
    pwct.addAttrRow("pwsignaltype", RESOURCE["pwsignaltype"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.element.style.width = "100%";
    if (connectionType == CONNTYPE_PVC) 
    {
        atom1.addOption(RESOURCE["serviceType_9"], "9");
        atom1.addOption(RESOURCE["serviceType_12"], "12");
    }
    else if (connectionType == CONNTYPE_transparent) 
    {
        atom1.addOption(RESOURCE["transparent"], "3");
    }
    else 
    {
        atom1.addOption(RESOURCE["serviceType_10"], "10");
        atom1.addOption(RESOURCE["serviceType_13"], "13");
    }
    atom1.element.onchange = function()
    {
    	var pwtype = pwct.getAtom("pwtype", 1).element; //    
        if (this.value == 12 || this.value == 13) 
        {
        	pwtype.selectedIndex = 1;
            act.getAtom("controlword", 0).element.disabled = true;
            act.getAtom("controlword", 0).setValue(3); //       
            act.getAtom("controlword", 1).element.disabled = true;
            act.getAtom("controlword", 1).setValue(3); //       
        }
        else 
        {
        	pwtype.selectedIndex = 1;
            act.getAtom("controlword", 0).element.disabled = false;
            act.getAtom("controlword", 0).setValue(1);
            act.getAtom("controlword", 1).element.disabled = false;
            act.getAtom("controlword", 1).setValue(1);
            pwtype.selectedIndex = 0;
        }
    }
    
    atom2 = new Atom("select");
    atom2.element.style.width = "100%";
    if (connectionType == CONNTYPE_PVC) 
    {
        atom2.addOption(RESOURCE["serviceType_9"], "9");
        atom2.addOption(RESOURCE["serviceType_12"], "12");
    }
     else if (connectionType == CONNTYPE_transparent) 
    {
        atom2.addOption(RESOURCE["transparent"], "3");
    }
    else 
    {
        atom2.addOption(RESOURCE["serviceType_10"], "10");
        atom2.addOption(RESOURCE["serviceType_13"], "13");
    }
    atom2.element.disabled = true;
    pwct.addAttrRow("pwtype", RESOURCE["pwtype"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.element.style.width = "100%";
    atom1.addOption(RESOURCE["bidirectional"], "1");
    atom2 = new Atom("select");
    atom2.element.style.width = "100%";
    atom2.addOption(RESOURCE["bidirectional"], "1");
    atom2.element.disabled = true;
    pwct.addAttrRow("direction", RESOURCE["direction"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.addOption("MPLS", 1);
    atom1.element.name = "0";
    atom1.element.disabled = true;
    atom2 = new Atom("select");
    atom2.addOption("MPLS", 1);
    atom2.element.name = "1";
    atom2.element.disabled = true;
    pwct.addAttrRow("pwencaptype", RESOURCE["pwencaptype"], atom1, atom2);
    
    atom1 = new Atom("text");
    checkText(atom1.element, "16", "1048575");
    atom2 = new Atom("text");
    checkText(atom2.element, "16", "1048575");
    pwct.addAttrRow("pwinlabel", RESOURCE["pwinlabel"], atom1, atom2);
    
    atom1 = new Atom("text");
    checkText(atom1.element, "16", "1048575");
    atom2 = new Atom("text");
    checkText(atom2.element, "16", "1048575");
    pwct.addAttrRow("pwoutlabel", RESOURCE["pwoutlabel"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.addOption("MPLS", TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL);
    atom2 = new Atom("select");
    atom2.addOption("MPLS", TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL);
    pwct.addAttrRow("tunneltype", RESOURCE["tunneltype"], atom1, atom2);
    
    atom1 = new Atom("span");
    atom2 = new Atom("span");
    pwct.addAttrRow("tunnel", "Ingress Tunnel", atom1, atom2);
    createTunnelAtom(atom1, 0);
    createTunnelAtom(atom2, 1);
    
    atom1 = new Atom("span");
    atom2 = new Atom("span");
    pwct.addAttrRow("tunnel_egress", "Egress Tunnel", atom1, atom2);
    createTunnelAtom(atom1, 2);
    createTunnelAtom(atom2, 3);
    
    atom1 = new Atom("text");
    atom1.element.disabled = true;
    atom2 = new Atom("text");
    atom2.element.disabled = true;
    pwct.addAttrRow("oppsitelsrid", RESOURCE["oppsitelsrid"], atom1, atom2);
}

function initQOSTable()
{
	qostable = new SortTable();
	qostable.head.setAttribute("id", "htmlTablebfdTHead");
	qostable.body.setAttribute("id", "htmlTablebfdTBody");
	qostable.setImage("../../../../../../images/");
	if (protecttype == NO_PROTECT)
	{
		qostabletc = window.tableconf[0];
	}
    else
    {
    	qostabletc = window.tableconf[1];
    }
    createTableHead(qostable, qostabletc);
    qostable.setBodyHeight("200px");
    $("qos").appendChild(qostable.getTable());
    
}


function createTunnelAtom(atom1, atomName)
{
    var elem = document.createElement("input");
    elem.type = "radio";
    elem.id = "newtunnel" + atomName;
    elem.onclick = function()
    {
        $("hadtunnel" + atomName).checked = false;
        this.checked = true;
    }
    atom1.element.parentNode.appendChild(elem);
    elem.checked = true;
    
    elem = document.createElement("span");
    elem.innerHTML = RESOURCE["newbtn"];
    atom1.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "radio";
    elem.id = "hadtunnel" + atomName;
    elem.onclick = function()
    {
        $("newtunnel" + atomName).checked = false;
        this.checked = true;
    }
    atom1.element.parentNode.appendChild(elem);
    
    elem = document.createElement("span");
    elem.innerHTML = RESOURCE["useexist"];
    atom1.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "text";
    elem.id = "selectedtunnel" + atomName;
    elem.disabled = true;
    elem.style.width = "48%";
    atom1.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "hidden";
    elem.id = "tunnelindex" + atomName;
    atom1.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "hidden";
    elem.id = "ingressid" + atomName;
    atom1.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "hidden";
    elem.id = "egressid" + atomName;
    atom1.element.parentNode.appendChild(elem); 
    
    elem = document.createElement("input");
    elem.type = "button";
    elem.value = "...";
    elem.className="autowidthbutton";
    elem.name = atomName;
    elem.onclick = doSelectTunnel;
    atom1.element.parentNode.appendChild(elem);
}

function doSelectTunnel()
{
	var buttonIndex =  this.name;
  	var tunnelIndex = (buttonIndex > 1) ? buttonIndex - 2 : buttonIndex; // 2 3    0 1  tunnel  
    var tunnelType = pwct.getAtom("tunneltype", tunnelIndex).getValue();
    var nodetype = -1;
    if (buttonIndex == 0 || buttonIndex == 1)//buttonInde:0,1  Ingress
    {
    	nodetype = NODE_TYPE_INGRESS;
    }
    else
    {	
    	nodetype = NODE_TYPE_EGRESS;
    }
    if ($("hadtunnel" + buttonIndex).checked) 
    {
        xshowModalDialog("../../ethservice/eline_u2kv1r3c00/selecttunnel.html?tunnelType=" + tunnelType + "&nodetype=" + nodetype + "&buttonIndex=" + buttonIndex, RESOURCE["resourceselected"], 580, 250, "../../../../../../images/");
    }
    else 
    {
        if (tunnelType == TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL) 
        {
            xshowModalDialog("../../ethservice/eline_u2kv1r3c00/createmplsnodetypetunnel.html?tunnelType=" + tunnelType + "&nodetype=" + nodetype + "&buttonIndex=" + buttonIndex, RESOURCE["resourceselected"], 580, 620, "../../../../../../images/");
        }
        else 
        {
            xshowModalDialog("../../ethcommon/createipgretunnel.html?tunnelType=" + tunnelType, RESOURCE["resourceselected"], 580, 450, "../../../../../../images/");
        }
    }
}

function initAdvancedTable()
{
    act = new CTable2();
    if (protecttype == NO_PROTECT)
    {
    	act.addHead(RESOURCE["attribute"], RESOURCE["value"], RESOURCE["value"]);
    }
    else
    {
    	act.addHead(RESOURCE["attribute"], RESOURCE["forwardpw"], RESOURCE["backwardpw"]);
    }
    
    $("advance").appendChild(act.getTable());
    
    var atom1 = new Atom("select");
    atom1.addOption(RESOURCE["mustuse"], 3);
    atom1.addOption(RESOURCE["nouse"], 1);
     atom1.element.onchange = function()
    {
    	var controlword = act.getAtom("controlword", 1).element;
    	controlword.selectedIndex = (this.value == 3)?0:1;
    }
    
    var atom2 = new Atom("select");
    atom2.addOption(RESOURCE["mustuse"], 3);
    atom2.addOption(RESOURCE["nouse"], 1);
    
    atom2.element.disabled = true;
    act.addAttrRow("controlword", RESOURCE["controlword"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.addOption("None", "0");
    atom1.addOption("CW","1");
    atom1.addOption("Alert Label","2");
    atom1.element.options.selectedIndex = 1;
    atom2 = new Atom("select");
    atom2.addOption("None", "0");
    atom2.addOption("CW","1");
    atom2.addOption("Alert Label","2");
    atom2.element.options.selectedIndex = 1;
    atom2.element.disabled = true;
    act.addAttrRow("controlchanneltype", RESOURCE["controlchanneltype"], atom1, atom2);
     atom1.element.onchange = function()
    {
    	var controlchanneltype = act.getAtom("controlchanneltype", 1).element;
    	controlchanneltype.selectedIndex = this.value;
    }
    
    atom1 = new Atom("select");
    atom1.addOption("None", "0");
    atom1.addOption("Ping", "1");
    atom1.element.options.selectedIndex = 1;
    atom1.element.onchange = function()
    {
    	var vccvmode = act.getAtom("vccvmode", 1).element;
    	vccvmode.selectedIndex = (this.value == 0)?0:1;
    }
    atom2 = new Atom("select");
    atom2.addOption("None", "0");
    atom2.addOption("Ping", "1");
    atom2.element.options.selectedIndex = 1;
    atom2.element.disabled = true;
    act.addAttrRow("vccvmode", RESOURCE["vccvmode"], atom1, atom2);
    
    atom1 = new Atom("text");
    atom1.setValue("10");
    textCheckWithStepLen(atom1.element, "1", "31", "1");
    atom1.element.onchange = function()
    {
    	act.getAtom("count", 1).setValue(this.value);
    	if (this.value == 1) 
        {
            act.getAtom("time", 0).setValue("0");
            act.getAtom("time", 0).element.disabled = true;
            act.getAtom("time", 1).setValue("0");
        }
        else 
        {
            act.getAtom("time", 0).setValue("1000");
            act.getAtom("time", 0).element.disabled = false;
            act.getAtom("time", 1).setValue("1000");
        }
    	
    }
    atom2 = new Atom("text");
    atom2.setValue("10");
    atom2.element.disabled = true;
    act.addAttrRow("count", RESOURCE["count"], atom1, atom2);
    
    atom1 = new Atom("text");
    atom1.setValue("1000");
    textCheckWithStepLen(atom1.element, "100", "50000", "100");
    atom1.element.onchange = function()
    {
    	act.getAtom("time", 1).setValue(this.value);
    }
    atom2 = new Atom("text");
    atom2.setValue("1000");
    atom2.element.disabled = true;
    act.addAttrRow("time", RESOURCE["time"], atom1, atom2);
    
}

function initUI()
{
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
}

function initTabs()
{
    tab = new EmbedTabs();
    tab.addEmbedTab("tab1div", RESOURCE["generalattr"], $("tab1div")); //    
    tab.addEmbedTab("tab2div", RESOURCE["qos"], $("tab2div")); //QOS  
    tab.addEmbedTab("tab3div", RESOURCE["advancedattr"], $("tab3div"));  //    
    tab.addEmbedTab("tab4div", RESOURCE["PW_PROTECT_GROUP"], $("tab4div")); //PW   
    tab.addEmbedTab("tab5div", RESOURCE["PW_PROTECT_GROUP"], $("tab5div")); //PW     
    tab.addEmbedTab("tab6div", RESOURCE["PW_OAM"], $("tab6div")); //PW_OAM
    setSelectedEmbedTab("tab1div");
    switch (protecttype) 
    {
        case NO_PROTECT:
            setDisplay(pwct,"50%", "none");
            setDisplay(act, "50%", "none");
            tabHeadList["tab4div"].style.display = "none";
            tabHeadList["tab5div"].style.display = "none";
            tabHeadList["tab6div"].style.display = "none";
            break;
            
        case PW_APS:
            setDisplay(pwct, "33%", "");
            setDisplay(act, "33%", "");
            tabHeadList["tab4div"].style.display = "";
            tabHeadList["tab5div"].style.display = "none";
            tabHeadList["tab6div"].style.display = "";
            break;
            
        case PROTECT_PAIRS:
            setDisplay(pwct,"33%", "");
            setDisplay(act,"33%", "");
			tabHeadList["tab4div"].style.display = "none";
            tabHeadList["tab5div"].style.display = "";
            tabHeadList["tab6div"].style.display = "none";
            break;
            
        default:
            break;
    }
    
    $("embedtab").appendChild(tab.getEmbedTabs());
}

function changePwSignaltype(type)
{
    if (type == 2) 
    {
        pwct.getAtom("pwinlabel").element.disabled = true;
        pwct.getAtom("pwoutlabel").element.disabled = true;
        pwct.getAtom("pwinlabel").setValue("-");
        pwct.getAtom("pwoutlabel").setValue("-");
    }
    else 
    {
        pwct.getAtom("pwinlabel").element.disabled = false;
        pwct.getAtom("pwoutlabel").element.disabled = false;
        pwct.getAtom("pwinlabel").setValue("");
        pwct.getAtom("pwoutlabel").setValue("");
    }
}

/**
 *   
 */
function validate(index)
{
    var msgArr = new Array();
    var pwID = pwct.getAtom("pwid", index).getValue();
    if (typeof(pwID) == "undefined" || pwID == "") 
    {
        msgArr[msgArr.length] = RESOURCE["pwid"] + RESOURCE["rangemsg"] + "1~4294967295";
    }
    var labelRange = "16~1048575";
    var label = pwct.getAtom("pwinlabel", index).getValue();
    if (label != "-" && label == "") 
    {
        msgArr[msgArr.length] = RESOURCE["pwinlabel"] + RESOURCE["rangemsg"] + labelRange;
    }
    label = pwct.getAtom("pwoutlabel", index).getValue();
    if (label != "-" && label == "") 
    {
        msgArr[msgArr.length] = RESOURCE["pwoutlabel"] + RESOURCE["rangemsg"] + labelRange;
    }
    var ingresstunnel = $("selectedtunnel" + index).value; //  Ingress Tunnel
    var egresstunnel = $("selectedtunnel" + (index + 2)).value; //  Egress Tunnel
    if (ingresstunnel == "" || egresstunnel == "") 
    {
        msgArr[msgArr.length] = RESOURCE["inputtunnel"];
    }
    
    var cbs = qostable.getCellStoreValue(QOS_INFO_TABLE_CBS_INDEX, QOS_INFO_TABLE_WORKPWINGRESS_COL, QOS_INFO_TABLE_WORKPWINGRESS_COL);
    
    if(cbs == "" || cbs == null )
    {
    	 msgArr[msgArr.length] = RESOURCE["errcbs"];
    }
	
	var pbs = qostable.getCellStoreValue(QOS_INFO_TABLE_PBS_INDEX, QOS_INFO_TABLE_WORKPWINGRESS_COL, QOS_INFO_TABLE_WORKPWINGRESS_COL);
    
    if(pbs == "" || pbs == null )
    {
    	 msgArr[msgArr.length] = RESOURCE["errpbs"];
    }
    
    if (index == 1)//     ID
    {
    	var protectId = "undefined";
    	var tstpwid1,tstpwid2;
    	var lsrid1,lsrid2;
    	if (protecttype == PW_APS)
  	    {
  	    	protectId = pwProtectCT.getAtom("protectid").getValue();
  	    	/**
  	    	 * DTS2011062705795 
  	    	 *   PW APS TAB   PWAPS         PW OAM        
  	    	 *                 LSRID     PWID          
  	    	 *      PW OAM TAB                  
  	    	 *                                    
  	    	 */
  	    	tstpwid1 = pwoamct.getAtom("sendpwid", 0).getValue();
  	    	if (tstpwid1 == "" && pwct.getAtom("pwid",0).getValue() != "")
  	    	{
  	    	    tstpwid1 = pwct.getAtom("pwid",0).getValue();
  	    	    pwoamct.getAtom("sendpwid",0).setValue(tstpwid1);
  	    	}
  	    	
  			tstpwid2 = pwoamct.getAtom("sendpwid", 1).getValue();
  			if (tstpwid2 == "" && pwct.getAtom("pwid",1).getValue() != "")
  	    	{
  	    	    tstpwid2 = pwct.getAtom("pwid",1).getValue();
  	    	    pwoamct.getAtom("sendpwid",1).setValue(tstpwid2);
  	    	}
  	    	
  			lsrid1 = pwoamct.getAtom("relsrid", 0).getValue();
  			if (lsrid1 == "" && pwct.getAtom("oppsitelsrid",0).getValue() != "")
  	    	{
  	    	    lsrid1 = pwct.getAtom("oppsitelsrid",0).getValue();
  	    	    pwoamct.getAtom("relsrid",0).setValue(lsrid1);
  	    	}
  	    	
  			lsrid2 = pwoamct.getAtom("relsrid", 1).getValue();
  			if (lsrid2 == "" && pwct.getAtom("oppsitelsrid",1).getValue() != "")
  	    	{
  	    	    lsrid2 = pwct.getAtom("oppsitelsrid",1).getValue();
  	    	    pwoamct.getAtom("relsrid",1).setValue(lsrid2);
  	    	}
  	    }
  	    else if(protecttype == PROTECT_PAIRS)
		{
			protectId = $("protectidforpair").value;
		}
		if (typeof(protectId) == "undefined" || protectId == "") 
		{
            msgArr[msgArr.length] = RESOURCE["PROTECT_ID"] + RESOURCE["rangemsg"] + "1~32";
        }
        if (protecttype == PW_APS)
        {
        	if((!lsrid1 || !lsrid2))
        	{
            	msgArr[msgArr.length] = RESOURCE["inputlsridtobereceived"];
       	    }
        
        	if((!tstpwid1 || !tstpwid2))
       	    {
            	msgArr[msgArr.length] = RESOURCE["SEND_PWID"] + RESOURCE["rangemsg"] + "1~4294967295";
        	}
        }
    }
    /*
    var v = pwct.getAtom("oppsitelsrid").getValue();
    var arr = v.split(".");
    var fIp = parseInt(arr[0]);
    var tIp = parseInt(arr[3]);
    if (isNaN(fIp) || isNaN(tIp) || fIp == 0 || fIp == 127 || (fIp >= 224 && fIp <= 255) || tIp == 0 || tIp == 255) 
    {
        msgArr[msgArr.length] = RESOURCE["oppsitelsrid"] + RESOURCE["inputmsg"] + "0.*.*.*,127.*.*.*,*.*.*.0,*.*.*.255,224.0.0.0~255.255.255.255";
    }
    */
    if (msgArr.length > 0) 
    {
        var msg = RESOURCE["errormsg"];
        for (var i = 0, m = msgArr.length; i < m; i++) 
        {
            msg += "\n(" + (i + 1) + ")" + msgArr[i];
        }
        alert(msg);
        return false;
    }
    return true;
}

function doOK()
{
	if (protecttype == NO_PROTECT)
	{
		if (!validate(0))
		{
			return null;
		}
	}
	else
	{
		if (!validate(0) || !validate(1)) 
    	{
            return null;
  	    }
	}
    var di = document.createElement("datainterface");
 	var bparams = document.createElement("bussiness-params");
 	var rowParams = constructPwRowParam(0); //  PW
    win.addRow(pwct.getAtom("pwid", 0).getValue());
    constructAdvanceAttrRow(); //              
    constructPWQOSRow(); //  QOS  
    if (protecttype == NO_PROTECT)
    {
    	bparams.appendChild(rowParams);
   		di.appendChild(bparams);
    }
    else if (protecttype == PW_APS)//       PW_OAM  PW   PW OAM  
	{
		bparams.appendChild(rowParams);
		rowParams = constructPwRowParam(1); //    PW
		bparams.appendChild(rowParams);
		di.appendChild(bparams);
		constructPWOAMRow(); //  PWOAM  
		constructProtectGroupRow(); //       
	}
	else
	{
		bparams.appendChild(rowParams);
		rowParams = constructPwRowParam(1); //    PW
		bparams.appendChild(rowParams);
		di.appendChild(bparams);
		constructPairProtectGroupRow(); //       
	}
    createTableBody(win.cfgPwst, win.cfgPwtc, EncapsulateData(di), RESOURCE);//      PW   PW      
    
    win.addCellListener();
    win.$("delpwbtn").disabled = false;
    win.$("newbtn").disabled = true;
    
    win.cfgPwst.setRowSelect(0);
    if (win.pwID != pwct.getAtom("pwid", 0).getValue()) 
    {
        win.parent.refreshPWID(pwct.getAtom("pwid", 0).getValue());
    }
    xcloseDialog();
}
function constructPWQOSRow()
{
	win.qosAttr.workPWIngress_BW = qostable.getCellStoreValue(QOS_INFO_TABLE_BANDWIDTHLIMIT_INDEX, QOS_INFO_TABLE_WORKPWINGRESS_COL, QOS_INFO_TABLE_WORKPWINGRESS_COL);
	win.qosAttr.workPWIngress_CIR = qostable.getCellStoreValue(QOS_INFO_TABLE_CIR_INDEX, QOS_INFO_TABLE_WORKPWINGRESS_COL, QOS_INFO_TABLE_WORKPWINGRESS_COL);
	win.qosAttr.workPWIngress_CBS = qostable.getCellStoreValue(QOS_INFO_TABLE_CBS_INDEX, QOS_INFO_TABLE_WORKPWINGRESS_COL, QOS_INFO_TABLE_WORKPWINGRESS_COL);
	win.qosAttr.workPWIngress_PIR = qostable.getCellStoreValue(QOS_INFO_TABLE_PIR_INDEX, QOS_INFO_TABLE_WORKPWINGRESS_COL, QOS_INFO_TABLE_WORKPWINGRESS_COL);
	win.qosAttr.workPWIngress_PBS = qostable.getCellStoreValue(QOS_INFO_TABLE_PBS_INDEX, QOS_INFO_TABLE_WORKPWINGRESS_COL, QOS_INFO_TABLE_WORKPWINGRESS_COL);
	win.qosAttr.workPWIngress_EXP = qostable.getCellStoreValue(QOS_INFO_TABLE_EXP_INDEX, QOS_INFO_TABLE_WORKPWINGRESS_COL, QOS_INFO_TABLE_WORKPWINGRESS_COL); //  PW INGRESS 
	if (protecttype != NO_PROTECT)
	{
		win.qosAttr.protectPWIngress_BW = qostable.getCellStoreValue(QOS_INFO_TABLE_BANDWIDTHLIMIT_INDEX, QOS_INFO_TABLE_PROTECTPWINGRESS_COL, QOS_INFO_TABLE_PROTECTPWINGRESS_COL);
		win.qosAttr.protectPWIngress_CIR = qostable.getCellStoreValue(QOS_INFO_TABLE_CIR_INDEX, QOS_INFO_TABLE_PROTECTPWINGRESS_COL, QOS_INFO_TABLE_PROTECTPWINGRESS_COL);
		win.qosAttr.protectPWIngress_CBS = qostable.getCellStoreValue(QOS_INFO_TABLE_CBS_INDEX, QOS_INFO_TABLE_PROTECTPWINGRESS_COL, QOS_INFO_TABLE_PROTECTPWINGRESS_COL);
		win.qosAttr.protectPWIngress_PIR = qostable.getCellStoreValue(QOS_INFO_TABLE_PIR_INDEX, QOS_INFO_TABLE_PROTECTPWINGRESS_COL, QOS_INFO_TABLE_PROTECTPWINGRESS_COL);
		win.qosAttr.protectPWIngress_PBS = qostable.getCellStoreValue(QOS_INFO_TABLE_PBS_INDEX, QOS_INFO_TABLE_PROTECTPWINGRESS_COL, QOS_INFO_TABLE_PROTECTPWINGRESS_COL);
		win.qosAttr.protectPWIngress_EXP = qostable.getCellStoreValue(QOS_INFO_TABLE_EXP_INDEX, QOS_INFO_TABLE_PROTECTPWINGRESS_COL, QOS_INFO_TABLE_PROTECTPWINGRESS_COL); //  PW INGRESS 
	}
}
function constructAdvanceAttrRow()
{
	win.pwAdvanceAttr.controlword = act.getAtom("controlword", 0).getValue(); //   
	win.pwAdvanceAttr.controlchanneltype = act.getAtom("controlchanneltype", 0).getValue(); //      
	win.pwAdvanceAttr.vccvmode = act.getAtom("vccvmode", 0).getValue(); //vccv    
	win.pwAdvanceAttr.count = act.getAtom("count", 0).getValue(); //      
	win.pwAdvanceAttr.time = act.getAtom("time", 0).getValue(); //      
}
function constructPWOAMRow()
{
	win.pwoamAttr.work_detectstyle = pwoamct.getAtom("detectstyle", 0).getValue(); //    
	win.pwoamAttr.work_detecttype = pwoamct.getAtom("detecttype", 0).getValue(); //    
	win.pwoamAttr.work_detecttime = pwoamct.getAtom("detecttime", 0).getValue(); //      
	win.pwoamAttr.work_relsrid = convertIPStrToLong(pwoamct.getAtom("relsrid", 0).getValue()); //  LSRID
	win.pwoamAttr.work_sendpwid = pwoamct.getAtom("sendpwid", 0).getValue(); //  PWID

	win.pwoamAttr.protect_detectstyle = pwoamct.getAtom("detectstyle", 1).getValue(); //    
	win.pwoamAttr.protect_detecttype = pwoamct.getAtom("detecttype", 1).getValue(); //    
	win.pwoamAttr.protect_detecttime = pwoamct.getAtom("detecttime", 1).getValue(); //      
	win.pwoamAttr.protect_relsrid = convertIPStrToLong(pwoamct.getAtom("relsrid", 1).getValue()); //  LSRID
	win.pwoamAttr.protect_sendpwid = pwoamct.getAtom("sendpwid", 1).getValue(); //  PWID
}
function constructPwRowParam(index)
{
    var rowParams = document.createElement("row-params");
    rowParams.appendChild(createParamElement("vnniId", 1));
    
    rowParams.appendChild(createParamElement("pwID", pwct.getAtom("pwid",index).getValue()));
    rowParams.appendChild(createParamElement("pwIndex", 0));
    rowParams.appendChild(createParamElement("enableState", 1));
    rowParams.appendChild(createParamElement("pwSignalType", pwct.getAtom("pwsignaltype",index).getValue()));
    rowParams.appendChild(createParamElement("serviceType", pwct.getAtom("pwtype", index).getValue()));
    rowParams.appendChild(createParamElement("direction", pwct.getAtom("direction",index).getValue()));
    
    rowParams.appendChild(createParamElement("workState", index));
   
    /*----------- PW        ------------*/
    rowParams.appendChild(createParamElement("pwEncapsType", pwct.getAtom("pwencaptype",index).getValue()));
    rowParams.appendChild(createParamElement("pwIngressLabel", pwct.getAtom("pwinlabel",index).getValue()));
    rowParams.appendChild(createParamElement("pwEgressLabel", pwct.getAtom("pwoutlabel",index).getValue()));
    
    rowParams.appendChild(createParamElement("oppositeLsrID", convertIPStrToLong(pwct.getAtom("oppsitelsrid",index).getValue())));
    rowParams.appendChild(createParamElement("tunneltype", tunnelTypes[pwct.getAtom("tunneltype",index).getValue()]));
    var tunnelIndex = $("tunnelindex"+index).value;
    rowParams.appendChild(createParamElement("tunnelindex", tunnelIndex)); //tunnelIndexes:PW  Ingress  
    
    var ingresstunnelid = $("ingressid" + index).value; //    Ingress Tunnel  TunnelID           
    rowParams.appendChild(createParamElement("ingresstunnelid", ingresstunnelid));
    
    var tunnelid = $("tunnelindex" + (index + 2)).value;
    var ingressid = $("ingressid" + (index+2)).value;
    var egressid = $("egressid" + (index+2)).value;
    rowParams.appendChild(createParamElement("ingressid", ingressid)); //ingressid,egressid,tunnelid:PW  Egress  
    rowParams.appendChild(createParamElement("egressid", egressid)); 
    rowParams.appendChild(createParamElement("tunnelid", tunnelid));
      
    rowParams.appendChild(createParamElement("controlWord", act.getAtom("controlword", index).getValue()));
    rowParams.appendChild(createParamElement("ctrlChanType", act.getAtom("controlchanneltype", index).getValue()));
    rowParams.appendChild(createParamElement("vccv", act.getAtom("vccvmode", index).getValue()));
    rowParams.appendChild(createParamElement("tunnelpolicy", "-"));
    rowParams.appendChild(createParamElement("localWorkingStat", 0));
    rowParams.appendChild(createParamElement("remoteWorkingStat", 0));
    rowParams.appendChild(createParamElement("compWorkingStat", 0));
    rowParams.appendChild(createParamElement("maxcount", act.getAtom("count", index).getValue()));
    rowParams.appendChild(createParamElement("maxtime", act.getAtom("time", index).getValue()));
	return rowParams;
}

function constructProtectGroupRow()
{
    win.protectAttr.apsid = pwProtectCT.getAtom("protectid").getValue();
    win.protectAttr.protype = pwProtectCT.getAtom("protype").getValue();
    win.protectAttr.isenable = pwProtectCT.getAtom("isenable").getValue();
    win.protectAttr.switchmode = pwProtectCT.getAtom("swtichmode").getValue();
    win.protectAttr.rvtmode = pwProtectCT.getAtom("recoverymode").getValue();
    
    if(pwProtectCT.getAtom("recoverytime").getValue() == "-")
    {
        win.protectAttr.recoverytime = 1;
    }
    else
    {
    	win.protectAttr.recoverytime = pwProtectCT.getAtom("recoverytime").getValue();
    }
    win.protectAttr.delaytime = pwProtectCT.getAtom("swtichtime").getValue();
    
}
function constructPairProtectGroupRow()
{
    win.protectAttr.apsid = $("protectidforpair").value;
    win.protectAttr.protype = pairPwProtectCT.getAtom("protecttype").getValue();
}


function CTable2()
{
    this.element = document.createElement("table");
    this.element.appendChild(document.createElement("thead"));
    this.element.appendChild(document.createElement("tbody"));
    this.element.firstChild.appendChild(document.createElement("tr"));
    
    this.attrName = new Object();
    this.attrArray = new Object();
    this.element.className = "attrTable";
    this.addHead = function(head1, head2, head3)
    {
        var th = document.createElement("td");
        span = document.createElement("span");
        span.appendChild(document.createTextNode(head1));
        th.appendChild(span);
        this.element.firstChild.firstChild.appendChild(th);
        th = document.createElement("td");
        span = document.createElement("span");
        span.appendChild(document.createTextNode(head2));
        th.appendChild(span);
        this.element.firstChild.firstChild.appendChild(th);
        th = document.createElement("td");
        span = document.createElement("span");
        span.appendChild(document.createTextNode(head3));
        th.appendChild(span);
        this.element.firstChild.firstChild.appendChild(th);
    }
    
    this.addAttrRow = function(attrid, attrname, atom1, atom2, text)
    {
        tr = document.createElement("tr");
        td = document.createElement("td");
        span = document.createElement("span");
        span.appendChild(document.createTextNode(attrname));
        td.appendChild(span);
        tr.appendChild(td);
        
        td = document.createElement("td");
        td.appendChild(atom1.element);
        if (text != null) {
            span = document.createElement("span");
            span.appendChild(document.createTextNode(text));
            td.appendChild(span);
        }
        tr.appendChild(td);
        
        td = document.createElement("td");
        td.appendChild(atom2.element);
        if (text != null) {
            span = document.createElement("span");
            span.appendChild(document.createTextNode(text));
            td.appendChild(span);
        }
        tr.appendChild(td);
        this.element.childNodes[1].appendChild(tr);
        var atomArr = new Object();
        atomArr[0] = atom1;
        atomArr[1] = atom2;
        this.attrArray[attrid] = atomArr;
        this.attrName[attrid] = attrname;
    }
    
    this.getAttrName = function(attrid){
        return this.attrName[attrid];
    }
    
    this.getAttrValue = function(attrid, index){
        return this.attrArray[attrid][index].getValue();
    }
    
    this.setAttrValue = function(attrid, index, value){
        if (this.attrArray[attrid][index]) {
            this.attrArray[attrid][index].setValue(value);
        }
    }
    
    this.getAtom = function(attrid, index){
        if (this.attrArray[attrid][index]) {
            return this.attrArray[attrid][index];
        }
        
    }
    this.getTable = function(){
        return this.element;
    }
}

function setDisplay(table, width, display)
{
    table.element.childNodes[0].childNodes[0].childNodes[0].style.width = width;
    table.element.childNodes[0].childNodes[0].childNodes[1].style.width = width;
    table.element.childNodes[0].childNodes[0].childNodes[2].style.display = display;
    
    
    var childNodes = table.element.childNodes[1].childNodes;
    for (var i = 0, m = childNodes.length; i < m; i++) {
        childNodes[i].childNodes[0].style.width = width;
        childNodes[i].childNodes[1].style.width = width;
        childNodes[i].childNodes[2].style.display = display;
    }
}

/**
 *           
 * @param row
 * @param colid
 * @param isEdit
 * @return
 */
function setCellEidtable(st, row, colid, isEdit)
{
	var cell = st.getCell(row, colid);
	st.setCellIsEdit(cell , isEdit);
	if(isEdit == CELL_DISABLED)
	{
		cell.element.style.cursor = "default";
	}
	else
	{
		cell.element.style.cursor = "hand";
	}
	
}



