var winurlobj = getParentWindow().winurlobj;
var cfgPwst = new SortTable();
var neid = winurlobj.neid;
var nmUser = winurlobj.nmUser;
var pwID = 0;
var expValue = 255;
var cfgPwtc;
var tType = [];
tType["NSCMD_CFG_MPLS_GET_TUNNEL"] = TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL;
tType["NSCMD_CFG_GRE_TNL_GET_TUNNEL"] = TECMDCODE_PTN_GRETUNNEL_QUERY;
tType["NSCMD_CFG_IP_TNL_GET_TUNNEL"] = TECMDCODE_PTN_IPTUNNEL_QUERY;

var WORK_STATE = "0"; //    
var PROTECT_STATE = "1";  //    

var protectAttr = new Object();
protectAttr.apsid = 0; //   ID
protectAttr.protype = 0; //    
protectAttr.isenable; //    
protectAttr.switchmode; //    
protectAttr.rvtmode; //    
protectAttr.recoverytime; //      
protectAttr.delaytime; //    

var pwAdvanceAttr = new Object();
pwAdvanceAttr.controlword = 1; //   
pwAdvanceAttr.controlchanneltype = 0; //      
pwAdvanceAttr.vccvmode = 1; //vccv    
pwAdvanceAttr.count = 10; //      
pwAdvanceAttr.time = 1000; //      

var qosAttr = new Object();
qosAttr.workPWIngress_BW = 0; //    /  
qosAttr.workPWIngress_CIR = 1
qosAttr.workPWIngress_CBS = 1;
qosAttr.workPWIngress_PIR = 1;
qosAttr.workPWIngress_PBS = 1;
qosAttr.workPWIngress_EXP = 255; //  PW INGRESS 

qosAttr.protectPWIngress_BW = 0;
qosAttr.protectPWIngress_CIR = 1
qosAttr.protectPWIngress_CBS = 1;
qosAttr.protectPWIngress_PIR = 1;
qosAttr.protectPWIngress_PBS = 1;
qosAttr.protectPWIngress_EXP = 255; //  PW INGRESS 

var pwoamAttr = new Object();
pwoamAttr.work_enablestate = 0; //    
pwoamAttr.work_detectstyle = 0; //    
pwoamAttr.work_detecttype = 0; //    
pwoamAttr.work_detecttime = 1000; //      
pwoamAttr.work_relsrid = ""; //  LSRID
pwoamAttr.work_sendpwid = 0; //  PWID

pwoamAttr.protect_enablestate = 0; //    
pwoamAttr.protect_detectstyle = 0; //    
pwoamAttr.protect_detecttype = 0; //    
pwoamAttr.protect_detecttime = 1000; //      
pwoamAttr.protect_relsrid = ""; //  LSRID
pwoamAttr.protect_sendpwid = 0; //  PWID

function initCfgPwTable()
{
    cfgPwst.head.setAttribute("id", "htmlTablebfdTHead");
    cfgPwst.body.setAttribute("id", "htmlTablebfdTBody");
    cfgPwst.setImage("../../../../../../images/");
    cfgPwst.isUsedForSelectList = true;
    cfgPwtc = window.tableconf[2];
    createTableHead(cfgPwst, cfgPwtc);
    cfgPwst.setOnCellEditHandler(cellEditHandler);
    cfgPwst.setSingleChoiceFlg(true);
    var height = getTableHeight(document.getElementById("cfgpwattr"), cfgPwst) / 4;
    cfgPwst.setBodyHeight(height + "px");
    $("cfgpwattr").appendChild(cfgPwst.getTable());
    createTableBody(cfgPwst, cfgPwtc, new DataInterface(), RESOURCE);
}

function doPwCreate()
{
    var serviceType = parent.ct.getAtom("servicedirection").getValue();
    if (serviceType == UNIUNI) 
    {
        alert(RESOURCE["prompt_notsupportpw"]);
        return;
    }
    pwID = parent.pwID;
    if (SYSTEMCONF.getLanguage() == "en") 
    {
        xshowModalDialog("createpw.html", RESOURCE["createpw"], 680, 450, "../../../../../../images/");
        
    }
    else 
    {
        xshowModalDialog("createpw.html", RESOURCE["createpw"], 660, 450, "../../../../../../images/");
    }
}

function createPW()
{
    if (cfgPwst.getDataRowLength() == 0) 
    {
        return;
    }
    var xmlstr = createCreatePWXML();
    if (null == xmlstr) 
    {
        return;
    }
    loadXMLdoc("../../../../../../neExlorerServlet?sfid=" + "1027", "POST", true, handleBackCreatePW, null, "inputdata=" + xmlstr);
}

function addCellListener()
{
    if (cfgPwst.getDataRowLength() == 0)
    {
        return;
    }
    var type = cfgPwst.getCellStoreValue(0, "tunneltype", "tunneltype");
    var cell;
    for (var i = 0; i < cfgPwst.getDataRowLength(); i++)
    {
    	cell = cfgPwst.getCellEdit(i, "pwID");
    	textCheck(cell.element, "1", "4294967295");
    	
    	cell = cfgPwst.getCell(i, "tunnelid"); //Egress Tunnel     
    	cell.element.ondblclick = function()
    	{
    		if (SYSTEMCONF.getLanguage() == "en") 
        	{
                xshowModalDialog("selecttunnel.html?tunnelType=" + tType[type] +  "&nodetype=" + NODE_TYPE_EGRESS, RESOURCE["resourceselected"], 580, 250, "../../../../../../images/");
       	    }
        	else 
       	    {
                xshowModalDialog("selecttunnel.html?tunnelType=" + tType[type] + "&nodetype=" + NODE_TYPE_EGRESS, RESOURCE["resourceselected"], 580, 200, "../../../../../../images/");
       	    }
    	}
    	cell = cfgPwst.getCell(i, "ingresstunnelid"); //Ingress Tunnel     
    	cell.element.ondblclick = function()
    	{
    		if (SYSTEMCONF.getLanguage() == "en") 
        	{
                xshowModalDialog("selecttunnel.html?tunnelType=" + tType[type] +  "&nodetype=" + NODE_TYPE_INGRESS, RESOURCE["resourceselected"], 580, 250, "../../../../../../images/");
       	    }
        	else 
       	    {
                xshowModalDialog("selecttunnel.html?tunnelType=" + tType[type] + "&nodetype=" + NODE_TYPE_INGRESS, RESOURCE["resourceselected"], 580, 200, "../../../../../../images/");
       	    }
    	}
    }
}

function cellEditHandler(param)
{
    var rowIndex = param.rowindex;
    var minLabel = 16;
    var maxLabel = 1048575;
    var pwEncapType = parseInt(cfgPwst.getCellStoreValue(rowIndex, "pwEncapsType", "pwEncapsType"));
    if (pwEncapType == 2) 
    {
        minLabel = 49153;
        maxLabel = 50176;
    }
    
    if (param.colid == "pwIngressLabel" && param.stage == TABLE_CONSTANT.BEFOREEDIT) 
    {
        var cell = cfgPwst.getCellEdit(rowIndex, "pwIngressLabel");
        textCheck(cell.element, minLabel, maxLabel);
    }
    
    if (param.colid == "pwEgressLabel" && param.stage == TABLE_CONSTANT.BEFOREEDIT) 
    {
        var cell = cfgPwst.getCellEdit(rowIndex, "pwEgressLabel");
        textCheck(cell.element, minLabel, maxLabel);
    }
    
    if (param.colid == "pwID") 
    {
    	var workState = cfgPwst.getCellStoreValue(rowIndex, "workState", "workState");
    	if (parseInt(workState) == 0)
    	{
    		var pwID = cfgPwst.getCellStoreValue(rowIndex, "pwID", "pwID");
        	parent.refreshPWID(pwID);
    	}
    }
}

function handleBackCreatePW(doc)
{
    parent.$("okbtn").disabled = false;
    parent.$("applybtn").disabled = false;
    var dinterface = EncapsulateData(doc);
    showErrorDialog(dinterface);
    if (dinterface.getSErrorCode() == 0) 
    {
        var row = dinterface.getDataRow(0);
        var pwIndex = row.pwIndex.value;
        parent.doCreateATM(pwIndex);
    }
}

function createCreatePWXML(business)
{
	var protecttype = parseInt(parent.ct.getAtom("protecttype").getValue());
    var rowparams = new tagElement("row-params");
    if (protecttype == NO_PROTECT)
    {
    	rowparams = constructPwRow("1", 0xffffffff, 0xffffffff, 0, 0, WORK_STATE); //  PW
    	business.appendChild(rowparams);
    }
	
	if (protecttype == PW_APS)
	{
		var workState = 0;
		workState = cfgPwst.getCellStoreValue(0, "workState", "workState");//     
		if (workState == WORK_STATE)
		{
			rowparams = constructPwRow("1", 0xffffffff, 0xffffffff, 0, 0, WORK_STATE); //  PW
		}
		else
		{
			rowparams = constructPwRow("1", 0xffffffff, 0xffffffff, 0, 1, WORK_STATE); //  PW
		}
		business.appendChild(rowparams);
		workState = cfgPwst.getCellStoreValue(1, "workState", "workState");
		if (workState == PROTECT_STATE)
		{
			rowparams = constructPwRow("1", 0xffffffff, 0xffffffff, 0, 1, PROTECT_STATE); //  PW
		}
		else
		{
			rowparams = constructPwRow("1", 0xffffffff, 0xffffffff, 0, 0, PROTECT_STATE); //  PW
		}
				
		business.appendChild(rowparams);
        rowparams = constructProtectGroupRow(protecttype); //   
        business.appendChild(rowparams);
	}
	else if (protecttype == PROTECT_PAIRS)
	{
		var workState = 0;
		workState = cfgPwst.getCellStoreValue(0, "workState", "workState");//     
		if (workState == WORK_STATE)
		{
			rowparams = constructPwRow("1", 0xffffffff, 0xffffffff, 0, 0, WORK_STATE); //  PW
		}
		else
		{
			rowparams = constructPwRow("1", 0xffffffff, 0xffffffff, 0, 1, WORK_STATE); //  PW
		}
		business.appendChild(rowparams);
		workState = cfgPwst.getCellStoreValue(1, "workState", "workState");
		if (workState == PROTECT_STATE)
		{
			rowparams = constructPwRow("1", 0xffffffff, 0xffffffff, 0, 1, PROTECT_STATE); //  PW
		}
		else
		{
			rowparams = constructPwRow("1", 0xffffffff, 0xffffffff, 0, 0, PROTECT_STATE); //  PW
		}
				
		business.appendChild(rowparams);
        rowparams = constructPairProtectGroupRow(protecttype); //     
        business.appendChild(rowparams);
	}	
}
function constructPwRow(carrierType,carrierID1,carrierID2,carrierID3,index, workState)
{
	var protecttype = parseInt(parent.ct.getAtom("protecttype").getValue());
    var rowparams = new tagElement("row-params");
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("vnniID", 1));
    rowparams.appendChild(createTagElement("protecttype", protecttype));
    rowparams.appendChild(createTagElement("carrierType", carrierType));
    rowparams.appendChild(createTagElement("carrierID1", carrierID1));
    rowparams.appendChild(createTagElement("carrierID2", carrierID2));
    rowparams.appendChild(createTagElement("carrierID3", carrierID3));
    
    rowparams.appendChild(createTagElement("pwSignalType", cfgPwst.getCellStoreValue(index, "pwSignalType", "pwSignalType")));
    rowparams.appendChild(createTagElement("pwType", cfgPwst.getCellStoreValue(index, "serviceType", "serviceType")));
    
    rowparams.appendChild(createTagElement("pwID", cfgPwst.getCellStoreValue(index, "pwID", "pwID")));
    rowparams.appendChild(createTagElement("enableState", cfgPwst.getCellStoreValue(index, "enableState", "enableState")));
    rowparams.appendChild(createTagElement("direction", cfgPwst.getCellStoreValue(index, "direction", "direction")));
    rowparams.appendChild(createTagElement("pwIngressLabel", cfgPwst.getCellStoreValue(index, "pwIngressLabel", "pwIngressLabel")));
    rowparams.appendChild(createTagElement("pwEgressLabel", cfgPwst.getCellStoreValue(index, "pwEgressLabel", "pwEgressLabel")));
    rowparams.appendChild(createTagElement("oppositeLsrID", cfgPwst.getCellStoreValue(index, "oppositeLsrID", "oppositeLsrID")));
    var tunnelIndexHex = tenToHex(cfgPwst.getCellStoreValue(index, "tunnelindex", "tunnelindex"));
    for (var i = tunnelIndexHex.length; i < 8; i++) 
    {
        tunnelIndexHex = "0" + tunnelIndexHex;
    }
    rowparams.appendChild(createTagElement("tunnelIndexes", tunnelIndexHex));
    rowparams.appendChild(createTagElement("pwEncapsType", cfgPwst.getCellStoreValue(index, "pwEncapsType", "pwEncapsType")));
    rowparams.appendChild(createTagElement("ingressid", cfgPwst.getCellStoreValue(index, "ingressid", "ingressid")));
    rowparams.appendChild(createTagElement("egressid", cfgPwst.getCellStoreValue(index, "egressid", "egressid")));
    rowparams.appendChild(createTagElement("tunnelid", cfgPwst.getCellStoreValue(index, "tunnelid", "tunnelid")));
    
    rowparams.appendChild(createTagElement("controlWord", pwAdvanceAttr.controlword));  //   
    rowparams.appendChild(createTagElement("ctrlChanType", pwAdvanceAttr.controlchanneltype));  //      
    rowparams.appendChild(createTagElement("vccv", pwAdvanceAttr.vccvmode));  //vccv    
    rowparams.appendChild(createTagElement("maxcount", pwAdvanceAttr.count));  //      
    rowparams.appendChild(createTagElement("maxtime", pwAdvanceAttr.time));  //      
    
    if (workState == WORK_STATE)
    {	
    	rowparams.appendChild(createTagElement("idirection", INGRESS));
    	rowparams.appendChild(createTagElement("bwEnabled", qosAttr.workPWIngress_BW)); 
    	if (qosAttr.workPWIngress_BW == 1)//  
    	{
    		rowparams.appendChild(createTagElement("cir", qosAttr.workPWIngress_CIR)); 
    		rowparams.appendChild(createTagElement("cbs", qosAttr.workPWIngress_CBS)); 
    		rowparams.appendChild(createTagElement("pir", qosAttr.workPWIngress_PIR));
    		rowparams.appendChild(createTagElement("pbs", qosAttr.workPWIngress_PBS));
    	}
    	rowparams.appendChild(createTagElement("exp", qosAttr.workPWIngress_EXP)); //  PW EXP 
        if (protecttype == PW_APS)
        {
        	rowparams.appendChild(createTagElement("enablestate", 1)); //    
       	    rowparams.appendChild(createTagElement("checkMode", pwoamAttr.work_detectstyle)); //    
            rowparams.appendChild(createTagElement("pagcketType", pwoamAttr.work_detecttype)); //      
            rowparams.appendChild(createTagElement("checkPeriod", pwoamAttr.work_detecttime)); //      
            rowparams.appendChild(createTagElement("lsrId", pwoamAttr.work_relsrid)); //  LSRID
            rowparams.appendChild(createTagElement("sendpwId", pwoamAttr.work_sendpwid)); //  PWID
        }
    }
    else
    {
    	rowparams.appendChild(createTagElement("idirection", INGRESS)); //  
    	rowparams.appendChild(createTagElement("bwEnabled", qosAttr.protectPWIngress_BW)); 
    	if (qosAttr.protectPWIngress_BW == 1)//  
    	{
    		rowparams.appendChild(createTagElement("cir", qosAttr.protectPWIngress_CIR)); 
    		rowparams.appendChild(createTagElement("cbs", qosAttr.protectPWIngress_CBS)); 
    		rowparams.appendChild(createTagElement("pir", qosAttr.protectPWIngress_PIR));
    		rowparams.appendChild(createTagElement("pbs", qosAttr.protectPWIngress_PBS));
    	}
    	rowparams.appendChild(createTagElement("exp", qosAttr.protectPWIngress_EXP)); //  PW EXP 
    	if (protecttype == PW_APS)
        {
        	rowparams.appendChild(createTagElement("enablestate", 1)); //    
       	    rowparams.appendChild(createTagElement("checkMode", pwoamAttr.protect_detectstyle)); //    
            rowparams.appendChild(createTagElement("pagcketType", pwoamAttr.protect_detecttype)); //      
            rowparams.appendChild(createTagElement("checkPeriod", pwoamAttr.protect_detecttime)); //      
            rowparams.appendChild(createTagElement("lsrId", pwoamAttr.protect_relsrid)); //  LSRID
            rowparams.appendChild(createTagElement("sendpwId", pwoamAttr.protect_sendpwid)); //  PWID
        }
    	
    }
	return rowparams;
}

function constructProtectGroupRow()
{
	var protecttype = parseInt(parent.ct.getAtom("protecttype").getValue());
    var rowparams = new tagElement("row-params");
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("autoassign", 0));
    rowparams.appendChild(createTagElement("apsid", protectAttr.apsid)); //   ID
    rowparams.appendChild(createTagElement("tunneltype", 1));
    rowparams.appendChild(createTagElement("protype", protecttype)); //    APS    
    rowparams.appendChild(createTagElement("isenable", protectAttr.isenable));  //    
    rowparams.appendChild(createTagElement("switchmode", protectAttr.switchmode));  //    
    rowparams.appendChild(createTagElement("rvtmode", protectAttr.rvtmode));  //    
    rowparams.appendChild(createTagElement("wtrtime", protectAttr.recoverytime)); //      
    rowparams.appendChild(createTagElement("delaytime", protectAttr.delaytime));  //    
    rowparams.appendChild(createTagElement("groupid", 0xFFFF));
    
    return rowparams;
}
function constructPairProtectGroupRow(protecttype)
{
	var protecttype = parseInt(parent.ct.getAtom("protecttype").getValue());
    var rowparams = new tagElement("row-params");
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("autoassign", 0));
    rowparams.appendChild(createTagElement("apsid", protectAttr.apsid));
    rowparams.appendChild(createTagElement("protype", protecttype));
    return rowparams;
}

function showErrorDialog(data)
{
    var errArr = [];
    openErrPage("../../../../../../page/", data.getError(), errArr);
}

function doCfgQos()
{
    if (SYSTEMCONF.getLanguage() == "en") 
    {
    
        xshowModalDialog("cfgqos.html", RESOURCE["cfgqos"], 700, 200, "../../../../../../images/");
    }
    else 
    {
    	xshowModalDialog("cfgqos.html", RESOURCE["cfgqos"], 700, 215, "../../../../../../images/");
    }
}

function doPwDelete()
{
    if (cfgPwst.getDataRowLength() == 0) 
    {
        return;
    }
    cfgPwst.clearTableData();
    if (parent.connectionst.getDataRowLength() == 0)
    {
    	parent.pwID = 0;
    }
    $("newbtn").disabled = false;
    $("delpwbtn").disabled = true;
}

function initCfgPwButton()
{
    $("newbtn").value = RESOURCE["newbutton"];
    $("delpwbtn").value = RESOURCE["deletebutton"];
    $("delpwbtn").disabled = true;
}

function setTunnel(tunnelIndex, tunnel, sinkNode)
{
    var cell = cfgPwst.getCell(0, "tunnelindex");
    cfgPwst.setCellValue(cell, "tunnelindex", tunnelIndex);
    
    var cell = cfgPwst.getCell(0, "tunnelid");
    cfgPwst.setCellValue(cell, "tunnelid", tunnel);
    cfgPwst.getCellShow(0, "tunnelid").setValue(tunnel);
    
    var cell = cfgPwst.getCell(0, "oppositeLsrID");
    cfgPwst.setCellValue(cell, "oppositeLsrID", convertIPStrToLong(sinkNode));
    cfgPwst.getCellShow(0, "oppositeLsrID").setValue(sinkNode);
}
