var winurlobj = getNeProperty(top);
var basicattriTable;
var qosTable;
var advanceattriTable;

var UNIUNI = 1;
var INVALID_LABEL_VALUE_1 = 0;//   label 
var INVALID_LABEL_VALUE_2 = 4294967295;//   label 
var INVALID_IP = 0;//  IP  
var INVALID_VALUE = "-";//      
var INVALID_QOS_VALUE = 4294967295;//   cir  
var INVALID = "-";

var currPWserviceType = 4;//                PW     (    ETH )
var selecttable = "basicattriLabel";

var TABLE_RES_MAP = [];//                    
TABLE_RES_MAP["ETH"] = "advancedattr_eth_table";//    
TABLE_RES_MAP["CES"] = "advancedattr_ces_table";//CES  
TABLE_RES_MAP["ATM"] = "advancedattr_atm_table";//ATM  
var basicdata = new DataInterface();
var qosdata = new DataInterface();
var advancedata = new DataInterface();
var basicflag = false;
var qosflag = false;
var advanceflag = false;
var curAtmIndex;

function initPage()
{
    initBasicattriTable();
    initQosTable();
    initAdvanceattriTable();
    initButton();
    swicthTab("basicattriLabel");
}

function initButton()
{
    $("querybtn").value = RESOURCE["querybutton"];
    $("applybtn").value = RESOURCE["applybutton"];
    $("applybtn").disabled = true;
}

function valueChanged()
{

    $("applybtn").disabled = false;
}

function swicthTab(divStr)
{
    document.getElementById(divStr).className = "tabSelect";
    if (divStr == "basicattriLabel") 
    {
        selecttable = "basicattriLabel";
        $("qosLabel").className = "tabUnselect";
        $("advanceattriLabel").className = "tabUnselect";
        $("qostable").style.display = "none";
        $("advanceattritable").style.display = "none";
        $("basicattritable").style.display = "inline";
        if (!basicflag) 
        {
            createTableBody(basicattriTable, window.tableconf[0], basicdata, RESOURCE);
            for (var i = 0, len = basicdata.getDataRowLength(); i < len; i++) 
            {
                basicattriTable.getCellShow(i, "autopolic").element.innerHTML = INVALID_VALUE;
                basicattriTable.getCellShow(i, "workstatus").element.innerHTML = INVALID_VALUE;
            }
            basicflag = true;
        }
        else 
        {
            adjustTableLayout(basicattriTable, window.tableconf[0]);
        }
    }
    else if (divStr == "qosLabel") 
    {
        selecttable = "qosLabel";
        $("advanceattriLabel").className = "tabUnselect";
        $("basicattriLabel").className = "tabUnselect";
        $("qostable").style.display = "inline";
        $("advanceattritable").style.display = "none";
        $("basicattritable").style.display = "none";
        if (!qosflag) 
        {
            createTableBody(qosTable, window.tableconf[1], qosdata, RESOURCE);
            qosflag = true;
        }
        else 
        {
            adjustTableLayout(qosTable, window.tableconf[1]);
        }
    }
    else if (divStr == "advanceattriLabel") 
    {
        selecttable = "advanceattriLabel";
        $("qosLabel").className = "tabUnselect";
        $("basicattriLabel").className = "tabUnselect";
        $("qostable").style.display = "none";
        $("advanceattritable").style.display = "inline";
        $("basicattritable").style.display = "none";
        if (!advanceflag) 
        {
            advanceattriTable.clearTableData();
            createTableBody(advanceattriTable, window.tableconf[2], advancedata, RESOURCE);
            for (var i = 0, m = advanceattriTable.getDataRowLength(); i < m; i++) 
            {
                if (advanceattriTable.getCellStoreValue(i, "maxcount", "maxcount") == 1) 
                {
                    advanceattriTable.setCellIsEdit(advanceattriTable.getCell(i, "maxtime"), 0);
                }
                textCheckWithStepLen(advanceattriTable.getCell(i, "maxcount").element.editElement.element, "1", "31", "1");
                textCheckWithStepLen(advanceattriTable.getCell(i, "maxtime").element.editElement.element, "100", "50000", "100");
            }
            advanceflag = true;
        }
        else 
        {
            adjustTableLayout(advanceattriTable, window.tableconf[2]);
        }
    }
}

function initBasicattriTable()
{
    basicattriTable = new SortTable();
    basicattriTable.head.setAttribute("id", "htmlTable_STHead_resport");
    basicattriTable.body.setAttribute("id", "htmlTable_STBody_resport");
    basicattriTable.setImage("../../../../../images/");
    createTableHead(basicattriTable, window.tableconf[0]);
    basicattriTable.setBodyHeight(getComponetHeight($("basicattritable"), 70) + "px");
    $("basicattritable").appendChild(basicattriTable.getTable());
}

function initQosTable()
{
    qosTable = new SortTable();
    qosTable.head.setAttribute("id", "htmlTable_STHead_resport");
    qosTable.body.setAttribute("id", "htmlTable_STBody_resport");
    qosTable.setImage("../../../../../images/");
    createTableHead(qosTable, window.tableconf[1]);
    qosTable.setBodyHeight(getComponetHeight($("qosTable"), 70) + "px");
    $("qosTable").appendChild(qosTable.getTable());
    qosTable.setOnCellEditHandler(valueChanged);
}

function initAdvanceattriTable()
{
    advanceattriTable = new SortTable();
    advanceattriTable.head.setAttribute("id", "htmlTable_STHead_resport");
    advanceattriTable.body.setAttribute("id", "htmlTable_STBody_resport");
    advanceattriTable.setImage("../../../../../images/");
    createTableHead(advanceattriTable, window.tableconf[2]);
    advanceattriTable.setBodyHeight(getComponetHeight($("advanceattriTable"), 70) + "px");
    $("advanceattriTable").appendChild(advanceattriTable.getTable());
    advanceattriTable.setOnCellEditHandler(cellEditHandler);
}

function cellEditHandler(param)
{
    $("applybtn").disabled = false;
}

function doQuery()
{
    if (parent.selectAtmIndex == 0) 
    {
        return;
    }
    if (parent.selectAtmType == UNIUNI) 
    {
        basicattriTable.clearTableData();
        qosTable.clearTableData();
        advanceattriTable.clearTableData();
        alert(RESOURCE["nopw"]);
        return;
    }
    doQueryByIndex(parent.selectAtmIndex);
}

function doQueryByIndex(atmIndex)
{
    if (parent.selectAtmType == UNIUNI) 
    {
        basicattriTable.clearTableData();
        qosTable.clearTableData();
        advanceattriTable.clearTableData();
        return;
    }
    curAtmIndex = atmIndex;
    queryBasic(atmIndex);
}

/**
 *       
 * @param {Object} atmIndex
 */
function queryBasic(atmIndex)
{
    qureyPWIndex(atmIndex);
}

/**
 *   PW Index
 * @param {Object} atmIndex
 */
function qureyPWIndex(atmIndex)
{
    var xmlstr = createQueryPWIndexXML(atmIndex);
    if (null == xmlstr) 
    {
        return;
    }
    $("querybtn").disabled = true;
    $("applybtn").disabled = true;
    basicattriTable.clearTableData();
    loadXMLdoc("../../../../../neExlorerServlet?sfid=" + "1014", "POST", true, handleBackQueryPWIndex, null, "inputdata=" + xmlstr);
}

function createQueryPWIndexXML(atmIndex)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    addParam(row, newParam("neid", winurlobj["neid"]));
    addParam(row, newParam("atmindex", atmIndex));
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackQueryPWIndex(doc)
{
    var dinterface = EncapsulateData(doc);
    showErrorDialog(dinterface);
    if (dinterface.getSErrorCode() != 0) 
    {
        $("querybtn").disabled = false;
        return;
    }
    var pwIndex = dinterface.rows[0].pwIndex.value;
    var xmlstr = createQueryBasicXML(pwIndex);
    loadXMLdoc("../../../../../neExlorerServlet?sfid=" + TE_IPPTN_QUERY_PW, "POST", true, handleBackQueryBasic, null, "inputdata=" + xmlstr);
}

function createQueryBasicXML(pwIndex)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    addParam(row, newParam("neid", winurlobj["neid"]));
    addParam(row, newParam("pwIndex", pwIndex));
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackQueryBasic(doc)
{
    var dinterface = EncapsulateData(doc);
    showErrorDialog(dinterface);
    if (dinterface.getSErrorCode() != 0) 
    {
        $("querybtn").disabled = false;
        return;
    }
    basicattriTable.clearTableData();
    if (window.parent.isContainAtm(curAtmIndex)) 
    {
        createTableBody(basicattriTable, window.tableconf[0], dinterface, RESOURCE);
    }
    if (basicattriTable.getDataRowLength() == 0) 
    {
        return;
    }
    for (var i = 0, len = dinterface.getDataRowLength(); i < len; i++) 
    {
        basicattriTable.getCellShow(i, "autopolic").element.innerHTML = INVALID_VALUE;
        basicattriTable.getCellShow(i, "workstatus").element.innerHTML = INVALID_VALUE;
    }
    basicdata = dinterface;
    var pwIndex = basicattriTable.getCellStoreValue(0, "pwIndex", "pwIndex");
    var pwID = basicattriTable.getCellStoreValue(0, "pwID", "pwID");
    queryQos(pwIndex, pwID);
    refreshAdvanceTable();
    queryAdvance(pwIndex);
}

function queryQos(pwIndex, pwID)
{
    var xmlstr = createQueryQosXML(pwIndex);
    if (null == xmlstr) 
    {
        return;
    }
    qosTable.clearTableData();
    loadXMLdoc("../../../../../neExlorerServlet?sfid=" + TE_IPPTN_GET_PW_QOS, "POST", true, handleBackQueryQos, pwID, "inputdata=" + xmlstr);
}

function createQueryQosXML(pwIndex)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    addParam(row, newParam("neid", winurlobj["neid"]));
    addParam(row, newParam("pwIndex", pwIndex));
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackQueryQos(doc, pwID)
{
    var dinterface = EncapsulateData(doc);
    showErrorDialog(dinterface);
    if (dinterface.getSErrorCode() != 0) 
    {
        $("querybtn").disabled = false;
        return;
    }
    processData(dinterface, pwID);
    qosTable.clearTableData();
    if (window.parent.isContainAtm(curAtmIndex)) 
	{
		createTableBody(qosTable, window.tableconf[1], dinterface, RESOURCE);
		for (var i = 0, len = dinterface.getDataRowLength(); i < len; i++) 
		{
			if (qosTable.getCellStoreValue(i, "direction", "direction") == 2) 
			{
				qosTable.getCellShow(i, "exp").element.innerHTML = INVALID_VALUE;
				var cell = qosTable.getCell(i, "exp");
				qosTable.setCellIsEdit(cell, false);
			}
		}
	}
}

/**
 *              
 * @param data        
 * @return  
 */
function processData(data, pwID)
{
    for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
    {
        if (null != data.getDataRowParam(i, "direction")) 
        {
            data.rows[i]["pwID"].value = pwID;
            data.rows[i]["bandwidthLimit"].value = RESOURCE["enableState_0"];
        }
    }
}

/**
 *              
 * @param data        
 * @return  
 */
function processData(data, pwID)
{
    for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
    {
        if (null != data.getDataRowParam(i, "direction")) 
        {
            data.rows[i]["pwID"].value = pwID;
            data.rows[i]["bandwidthLimit"].value = RESOURCE["enableState_0"];
        }
    }
}

function queryAdvance(pwIndex)
{
    var xmlstr = createQueryAdvanceXML(pwIndex);
    if (null == xmlstr) 
    {
        return;
    }
    advanceattriTable.clearTableData();
    loadXMLdoc("../../../../../neExlorerServlet?sfid=" + TE_IPPTN_GET_PW, "POST", true, handleBackQueryAdvance, null, "inputdata=" + xmlstr);
}

function createQueryAdvanceXML(pwIndex)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", winurlobj["neid"]));
    rowparams.appendChild(createTagElement("pwIndex", pwIndex));
    rowparams.appendChild(createTagElement("pwdomain", serType2Domain[currPWserviceType]));//pw       
    rowparams.appendChild(createTagElement("isLogFlag", "0"));//     
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function createTagElement(name, value)
{
    var elem = new tagElement("param");
    elem.setAttribute("name", name);
    elem.setAttribute("value", value);
    return elem;
}


function handleBackQueryAdvance(doc)
{
    $("querybtn").disabled = false;
    var dinterface = EncapsulateData(doc);
    showErrorDialog(dinterface);
    if (dinterface.getSErrorCode() != 0) 
    {
        return;
    }
    advanceattriTable.clearTableData();
    if (window.parent.isContainAtm(curAtmIndex)) 
	{
		createTableBody(advanceattriTable, window.tableconf[2], dinterface, RESOURCE);
		advancedata = dinterface;
	}
}

/**
 *     
 */
function refreshAdvanceTable()
{
    var serviceType = basicattriTable.getCellStoreValue(0, "serviceType", "serviceType");
    if (serType2Domain[currPWserviceType] != serType2Domain[serviceType]) 
    {
        currPWserviceType = serviceType;
        window.tableconf.pop();
        loadXMLdoc("../../conf/atm/" + TABLE_RES_MAP[serType2Domain[serviceType]] + "_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable, null);
        var nodes = document.getElementById("advanceattriTable");
        for (var i = nodes.childNodes.length - 1; i >= 0; i--) 
        {
            nodes.removeChild(nodes.childNodes[i]);
        }
        initAdvanceattriTable();
    }
}

function doApply()
{
    if (selecttable == "qosLabel") 
    {
        doApplyQos();
    }
    else if (selecttable == "advanceattriLabel") 
    {
        doApplyAdvance();
    }
}

function doApplyQos()
{
    var xmlstr = createApplyQosXML();
    if (null == xmlstr) 
    {
        return;
    }
    $("applybtn").disabled = true;
    loadXMLdoc("../../../../../neExlorerServlet?sfid=" + TE_IPPTN_SET_PW_QOS, "POST", true, handleBackApplyQos, null, "inputdata=" + xmlstr);
}

function createApplyQosXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    for (var rowindex = 0, rowlen = qosTable.getDataRowLength(); rowindex < rowlen; rowindex++) 
    {
        if (!qosTable.getModify(rowindex)) 
        {
            continue;
        }
        var row = new tagElement("row-params");
        
        param = new tagElement("param");
        param.setAttribute("name", "pwIndex");
        param.setAttribute("value", qosTable.getCellStoreValue(rowindex, "pwIndex", "pwIndex"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", winurlobj["neid"]);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "direction");
        param.setAttribute("value", qosTable.getCellStoreValue(rowindex, "direction", "direction"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "exp");
        param.setAttribute("value", qosTable.getCellStoreValue(rowindex, "exp", "exp"));
        row.appendChild(param);
        
        bussiness.appendChild(row);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackApplyQos(doc)
{
    $("applybtn").disabled = true;
    var dinterface = EncapsulateData(doc);
    if (dinterface.getSErrorCode() != 0) 
    {
        $("applybtn").disabled = false;
        showErrorDialog(dinterface);
        return;
    }
    refreshTableState(qosTable, window.tableconf[1], dinterface);
    qosdata = dinterface;
}

function doApplyAdvance()
{
    var xmlstr = createApplyAdvanceXML();
    if (null == xmlstr) 
    {
        return;
    }
    $("applybtn").disabled = false;
    loadXMLdoc("../../../../../neExlorerServlet?sfid=" + "1015", "POST", true, handleBackApplyAdvance, null, "inputdata=" + xmlstr);
}

function createApplyAdvanceXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var rowindex = 0, rowlen = advanceattriTable.getDataRowLength(); rowindex < rowlen; rowindex++) 
    {
        if (!advanceattriTable.getModify(rowindex)) 
        {
            continue;
        }
        var row = new tagElement("row-params");
        
        param = new tagElement("param");
        param.setAttribute("name", "pwIndex");
        param.setAttribute("value", advanceattriTable.getCellStoreValue(rowindex, "pwIndex", "pwIndex"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", winurlobj["neid"]);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "maxcount");
        param.setAttribute("value", advanceattriTable.getCellStoreValue(rowindex, "maxcount", "maxcount"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "maxtime");
        param.setAttribute("value", advanceattriTable.getCellStoreValue(rowindex, "maxtime", "maxtime"));
        row.appendChild(param);
        
        bussiness.appendChild(row);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackApplyAdvance(doc)
{
    var dinterface = EncapsulateData(doc);
    if (dinterface.getSErrorCode() != 0) 
    {
        $("applybtn").disabled = false;
        showErrorDialog(dinterface);
        return;
    }
    $("applybtn").disabled = true;
    refreshTableState(advanceattriTable, window.tableconf[2], dinterface);
}

function showErrorDialog(data)
{
    var errArr = [];
    openErrPage("../../../../../page/", data.getError(), errArr);
}

/**
 *   IP  
 * @param {Object} param
 */
function convertIP(param)
{
    if (param == INVALID_IP) 
    {
        return INVALID_VALUE;
    }
    
    return convertNumToIpaddr(param);
}

/**
 *               0 0xFFFFFFFF      - 
 * @param {Object} param
 */
function convertLabel(param)
{
    if (param == INVALID_LABEL_VALUE_1 || param == INVALID_LABEL_VALUE_2) 
    {
        return INVALID_VALUE;
    }
    return param;
}

/**
 *   cir pir           0xFFFFFFFF      - 
 * @param {Object} param
 */
function convertQoS(param)
{
    if (param == INVALID_QOS_VALUE) 
    {
        return INVALID_VALUE;
    }
    return param;
}

function textCheckWithStepLen(obj, min, max, stepLen)
{
    min += "";
    max += "";
    
    obj.style.imeMode = "disabled";
    
    obj.onpaste = function()
    {
        return false;
    }
    
    obj.onblur = function()
    {
        numCellOnBlurWithStepLen(obj, min, max, stepLen);
        var cell = advanceattriTable.getCell(0, "maxtime");
        if (this.value == 1) 
        {
            advanceattriTable.setCellIsEdit(cell, 0);
            advanceattriTable.setCellValue(cell, "maxtime", 0);
            cell.element.showElement.element.innerHTML = 0;
        }
        else 
        {
            advanceattriTable.setCellIsEdit(cell, 1);
            if (advanceattriTable.getCellStoreValue(0, "maxtime", "maxtime") == 0) 
            {
                advanceattriTable.setCellValue(cell, "maxtime", 1000);
                cell.element.showElement.element.innerHTML = 1000;
            }
        }
    }
    
    obj.onkeypress = function()
    {
        var evt= EventUtil.getEvent();
        return digitalCheckWithStepLen(obj, min, max, stepLen, null, evt);
    }
}
