var imaConfigBindTable = null;
var winurlobj = getNeProperty(parent);
var win = getParentWindow();
var neid = win.winurlobj["neid"];
var availboardList = new Object();

var IL_Optical_STM2 = 6402;
var IL_Optical_STM1 = 6401;
var E1 = "E1";
var FrationalE1 = "Fractional E1";
var VC12 = "VC12-xv";
var BIDIR;
var DOWNLINK;
var UPLINK;
var boundPathTableData;

var uinToSepar = false; // boundPathTableData       dinterSepar
var ifchange = false;//        
var hasCahce = new Object();
var dinterSepar; //    DataInterface  
var TRUNKNUM = 8192;
var FRANTRUNKNUM = 4096;
var FranE1Port = 6144;

var bindPathSucceed = false; //        
function init()
{
    BIDIR = RESOURCE["BIDIRECTIONAL"];
    DOWNLINK = RESOURCE["DOWNLINK"];
    UPLINK = RESOURCE["UPLINK"];
    initDialogInfo();
    initButton();
    initpathTable();
    sendQueryInfo();
    $("availboardselect").options[$("availboardselect").options.length] = new Option(win.trunkslotname, win.trunkSoltid);
    $("bindvctrunkselect").options[$("bindvctrunkselect").options.length] = new Option(win.trunkName, win.trunckId);
    availboardselectChanged();
    onVctrunckSelectChanged();
    
}

function initButton()
{
    $("okbutton").value = RESOURCE["okbutton"];
    $("cancelbutton").value = RESOURCE["cancelbutton"];
    $("applybutton").value = RESOURCE["applybutton"];
}

function sendQueryInfo()
{
    var xml = createGetAttributeXML();
    var URL = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_BOARDINFO_FROBOUND + "" + "&nmUser=" + win.winurlobj["nmUser"];
    loadXMLdoc(URL, "POST", false, doQueryCallBack, null, "inputdata=" + xml);
}

function sendAvailResource()
{
    var xml = createGetAvailResourceXML();
    
    var URL = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_IMAPORT_RESOURCE + "" + "&nmUser=" + win.winurlobj["nmUser"];
    
    loadXMLdoc(URL, "POST", false, doQueryAvailResourceCallBack, null, "inputdata=" + xml);
}

function createGetAvailResourceXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", $("availboardselect").value);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "level");
    param.setAttribute("value", $("levelselect").value);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "subslotid");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "port");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "porttype");
    param.setAttribute("value", "PORTTYPE_PTN_TU");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "opticalport");
    param.setAttribute("value", $("optinterfaceselect").value);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "trunkid");
    param.setAttribute("value", $("bindvctrunkselect").value);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *       timeslot  
 */
function buildTimeSlotSelectFromCache()
{
    if ($("levelselect").value == VC12) 
    {
        var slotid = $("availboardselect").value;
        var opticalid = $("optinterfaceselect").value;
        var highObjs = getChannelListFromCache(slotid, opticalid);
        if (highObjs != null) 
        {
            for (var i = 0; i < highObjs.length; i++) 
            {
                var highChannelID = highObjs[i].highChannelId;
                $("unusedresselect").options.add(new Option("VC4:" + highChannelID, highChannelID));
                for (var j = 0; j < highObjs[i].timeSlot.length; j++) 
                {
                    var timslotID = highObjs[i].timeSlot[j];
                    var option = new Option("VC12:" + timslotID, timslotID);
                    $("unusedpathselect")[$("unusedpathselect").options.length] = option;
                }
                sortSelector($("unusedpathselect"));
            }
        }
        else 
        {
            return false;
        }
        sortSelector($("unusedresselect"));
        return true;
    }
}

function doQueryAvailResourceCallBack(doc)
{
    var data = EncapsulateData(doc);
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        if ($("levelselect").value == E1 || $("levelselect").value == FrationalE1) 
        {
            for (var i = 0, len = data.getDataRowLength(); i < len; ++i) 
            {
                var isbound = data.rows[i]["isbound"].value;
                if (isbound != "true") 
                {
                    var optionres = new Option(data.rows[i]["availablePort"].value, data.rows[i]["availablePortID"].value);
                    $("unusedresselect").options.add(optionres);
                }
                addE1PortInfoToCache(data.rows[i]["availablePort"].value, data.rows[i]["availablePortID"].value, isbound);
                
            }
            setDefaultSelect();
            
        }
        else if ($("levelselect").value == VC12) 
        {
        
            var highChannelIDList = new Array();
            for (var i = 0, len = data.getDataRowLength(); i < len; ++i) 
            {
            
                var highChannelID = data.rows[i]["availablePortID"].value;
                if (!isListContainValue(highChannelIDList, highChannelID)) 
                {
                    $("unusedresselect").options.add(new Option("VC4:" + highChannelID, highChannelID));
                    highChannelIDList[highChannelIDList.length] = highChannelID;
                }
                var timeSlot = data.rows[i]["timeSlot"].value
                addVC12PortInfoToCache(highChannelID, timeSlot);
            }
            if ($("unusedresselect").options.length > 0)//         
            {
                $("unusedresselect").selectedIndex = 0;
            }
        }
        if (hasCahce[$("availboardselect").value] == null) 
        {
            hasCahce[$("availboardselect").value] = new Array();
        }
        var trunckList = hasCahce[$("availboardselect").value];
        if (!isListContainValue(trunckList, $("bindvctrunkselect").value)) 
        {
            trunckList[trunckList.length] = $("bindvctrunkselect").value;
        }
    }
    
}

function doQueryCallBack(doc)
{
    var data = EncapsulateData(doc);
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        for (var i = 0, len = data.getDataRowLength(); i < len; ++i) 
        {
            var slotid = data.rows[i]["slotid"].value;
            if (availboardList[slotid] != null) 
            {
                if (data.rows[i]["portName"] != null) 
                {
                    var portNameList = availboardList[slotid].portName;
                    if (portNameList == null) 
                    {
                        portNameList = new Array();
                    }
                    var portInfo = new Object();
                    portInfo.portName = data.rows[i]["portName"].value;
                    portInfo.portID = data.rows[i]["portID"].value;
                    portNameList[portNameList.length] = portInfo;
                }
                
            }
            else 
            {
                var board = new Object();
                board.boradName = data.rows[i]["boradName"].value;
                board.slotid = slotid;
                board.boardtype = data.rows[i]["boardtype"].value;
                if (data.rows[i]["portName"] != null) 
                {
                    board.portName = new Array();
                    var portInfo = new Object();
                    portInfo.portName = data.rows[i]["portName"].value;
                    portInfo.portID = data.rows[i]["portID"].value;
                    board.portName[board.portName.length] = portInfo;
                }
                
                availboardList[slotid] = board;
            }
        }
    }
    else 
    {
        showErrorDialog(data);
    }
}

function getTrunkNum(slotid)
{
    var trunkNum = 0;
    if (availboardList[slotid].portName != null) 
    {
        for (var i = 0; i < availboardList[slotid].portName.length; i++) 
        {
            var portInfo = availboardList[slotid].portName[i];
            if (portInfo.portID > TRUNKNUM) 
            {
                trunkNum++;
            }
        }
    }
    return trunkNum;
}

function availboardselectChanged()
{
    var slotid = $("availboardselect").value;
    var cpnam;
    for (var i = 0, len = $("availboardselect").options.length; i < len; i++) 
    {
        if ($("availboardselect").options[i].value == slotid) 
        {
            cpnam = $("availboardselect").options[i].text;
            break;
        }
    }
    if (availboardList[slotid] == null || availboardList[slotid].boardtype == null || availboardList[slotid].portName == null) 
    {
        $("bindvctrunkselect").length = 0;
    }
    else 
    {
        if (availboardList[slotid].boardtype == E1) 
        {
            $("levelselect").length = 0;
            $("levelselect").options[$("levelselect").options.length] = new Option(E1, E1);
            $("levelselect").options[$("levelselect").options.length] = new Option(FrationalE1, FrationalE1);
            $("optinterfaceselect").length = 0;
            $("optinterfaceselect").disabled = true;
        }
        else 
        {
            $("levelselect").length = 0;
            $("levelselect").options[$("levelselect").options.length] = new Option(VC12, VC12);
            $("levelselect").options[$("levelselect").options.length] = new Option(FrationalE1, FrationalE1);
            addOptinterfaceselect(slotid);
        }
        
    }
    onAvailResourceSelectChanged();
    sendQueryBindTrunck();
}

function addOptinterfaceselect(slotid)
{
    $("optinterfaceselect").length = 0;
    $("optinterfaceselect").disabled = false;
    
    for (var i = 0; i < availboardList[slotid].portName.length; i++) 
    {
        if (availboardList[slotid].portName[i].portID < FRANTRUNKNUM) 
        {
            $("optinterfaceselect")[$("optinterfaceselect").options.length] = new Option(availboardList[slotid].portName[i].portName, availboardList[slotid].portName[i].portID);
        }
    }
}

function isHasCahce()
{
    var trunckList = hasCahce[$("availboardselect").value];
    if (trunckList != null && (isListContainValue(trunckList, $("bindvctrunkselect").value))) 
    {
        return true;
    }
    return false;
    
}

function onAvailResourceSelectChanged()
{

    clearResourceSelect();
    freshOpticalPort();
    sendAvailResource();
    if ($("levelselect").value == E1 || $("levelselect").value == FrationalE1) 
    {
        $("unusedresselect").multiple = true;
    }
    else 
    {
        $("unusedresselect").multiple = false;
    }
    sendQueryBindTrunck();
    onResourceSelectChanged();
}

function clearResourceSelect()
{
    $("unusedresselect").length = 0;
    $("unusedpathselect").length = 0;
}

function freshOpticalPort()
{
    if ($("levelselect").value == VC12) 
    {
        var slotid = $("availboardselect").value;
        var cpnam;
        for (var i = 0, len = $("availboardselect").options.length; i < len; i++) 
        {
            if ($("availboardselect").options[i].value == slotid) 
            {
                cpnam = $("availboardselect").options[i].text;
                break;
            }
        }
        addOptinterfaceselect(slotid);
    }
    else 
    {
        $("optinterfaceselect").length = 0;
        $("optinterfaceselect").disabled = true;
    }
}

function initDialogInfo()
{
    document.getElementById("bindvctrunk").innerHTML = RESOURCE["bindvctrunk"];
    document.getElementById("configports").innerHTML = RESOURCE["configports"];
    document.getElementById("vclevel").innerHTML = RESOURCE["vclevel"];
    document.getElementById("canbindpath").innerHTML = RESOURCE["canbindpath"];
    document.getElementById("vcdirction").innerHTML = RESOURCE["vcdirction"];
    document.getElementById("optinterface").innerHTML = RESOURCE["optinterface"];
    document.getElementById("availresources").innerHTML = RESOURCE["availresources"];
    document.getElementById("availtimeslots").innerHTML = RESOURCE["availtimeslots"];
    document.getElementById("showrows").innerHTML = RESOURCE["showrows"];
    document.getElementById("usedbindpath").innerHTML = RESOURCE["usedbindpath"];
    if ($("levelselect").value == E1 || $("levelselect").value == FrationalE1) 
    {
        $("unusedresselect").multiple = true;
    }
    else 
    {
        $("unusedresselect").multiple = false;
    }
    
    $("levelselect").onchange = onAvailResourceSelectChanged;
    
    $("optinterfaceselect").onchange = onOptinterfaceSelectChanged;
    $("unusedresselect").onchange = onResourceSelectChanged;
    document.getElementById("showrowsbox").checked = true;
    document.getElementById("showrowsbox").onclick = function()
    {
        if (true == document.getElementById("showrowsbox").checked) 
        {
            showRowsUni();//      
        }
        else 
        {
            showRowsSepar();//         			
        }
    }
}

function onResourceSelectChanged()
{
    if ($("levelselect").value == VC12) 
    {
        var slotid = $("availboardselect").value;
        var optiPortID = $("optinterfaceselect").value;
        var highChannelID = $("unusedresselect").value;
        var timeSlotList = getTimeSlotFromCache(slotid, optiPortID, highChannelID);
        if (timeSlotList == null) 
        {
            return;
        }
        $("unusedpathselect").options.length = 0;
        for (var i = 0; i < timeSlotList.length; i++) 
        {
            var option = new Option("VC12:" + timeSlotList[i], timeSlotList[i]);
            $("unusedpathselect")[$("unusedpathselect").options.length] = option;
        }
        sortSelector($("unusedpathselect"));
        setDefaultSelect();
    }
    
}

function onOptinterfaceSelectChanged()
{
    clearResourceSelect();
    if (!isHasCahce()) 
    {
        sendAvailResource();
        onResourceSelectChanged();
    }
    else 
    {
        var isSucess = buildTimeSlotSelectFromCache();
        if (!isSucess) 
        {
            sendAvailResource();
            onResourceSelectChanged();
        }
    }
    setDefaultSelect();
}

function initpathTable()
{
    $("dirctionselect").disabled = true;
    $("availboardselect").disabled = true;
    $("bindvctrunkselect").disabled = true;
    $("dirctionselect").options[0] = new Option(RESOURCE["BIDIRECTIONAL"], RESOURCE["BIDIRECTIONAL"]);
    imaConfigBindTable = new SortTable();
    imaConfigBindTable.isUsedForSelectList = true;
    imaConfigBindTable.setImage("../../../../../../images/");
    
    createTableHead(imaConfigBindTable, window.tableconf[0]);
    $("pathtable").appendChild(imaConfigBindTable.getTable());
    imaConfigBindTable.setBodyHeight("460px");
}

function onVctrunckSelectChanged()
{
    
    hasCahce = new Object();
    onAvailResourceSelectChanged();
}

function sendQueryBindTrunck()
{
    var xml = createGetBindTrunckXML();
    var URL = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_ATM_GET_VCTRUNK_LIST + "" + "&nmUser=" + win.winurlobj["nmUser"];
    
    loadXMLdoc(URL, "POST", false, doGetBindTrunckCallBack, null, "inputdata=" + xml);
}

function createGetBindTrunckXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    
    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", $("availboardselect").value);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "level");
    param.setAttribute("value", $("levelselect").value);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "childslotid");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "trunckid");
    param.setAttribute("value", $("bindvctrunkselect").value);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doGetBindTrunckCallBack(doc)
{
    boundPathTableData = EncapsulateData(doc);
    
    if (boundPathTableData.getSErrorCode() == 0 || boundPathTableData.getSErrorCode() == 1) 
    {
        imaConfigBindTable.clearTableData();
        createTableBody(imaConfigBindTable, window.tableconf[0], boundPathTableData, RESOURCE);
    }
    else 
    {
        showErrorDialog(boundPathTableData);
    }
    
}

/**
 * select          
 * @param   
 * @return  
 */
function addVctrunkPaths()
{
    var vpVctrunk = getSelectOption(document.getElementById("bindvctrunkselect"));
    var vpLevel = getSelectOption(document.getElementById("levelselect"));
    var unilen
    if (null != boundPathTableData)//      
    {
        unilen = boundPathTableData.getDataRowLength();
    }
    else 
    {
        unilen = 0;
    }
    var selectPathOrPort;
    var vpSelectPath = document.getElementById("unusedpathselect");
    var unusedresselect = document.getElementById("unusedresselect");
    if (vpLevel == FrationalE1 || vpLevel == E1) 
    {
    
        if (-1 == unusedresselect.selectedIndex)//                  
        {
            return;
        }
        selectPathOrPort = unusedresselect;
    }
    else 
    {
        if (-1 == vpSelectPath.selectedIndex)//                  
        {
            return;
        }
        selectPathOrPort = vpSelectPath;
    }
    
    var beSelPathList = delSelectResourceRow();
    addToDinterUni(beSelPathList);
    document.getElementById("applybutton").disabled = false;
    refreshBoundTable();
    ifchange = true;
    setDefaultSelect();
    
}

function setDefaultSelect()
{
    if ($("unusedresselect").options.length > 0)//         
    {
        $("unusedresselect").selectedIndex = 0;
    }
    if ($("unusedpathselect").options.length > 0)//         
    {
        $("unusedpathselect").selectedIndex = 0;
    }
}

/**
 *                    
 */
function delSelectResourceRow()
{
    var beSelPathList = new Array();
    var vpSelectPath = document.getElementById("unusedpathselect");
    var unusedresselect = document.getElementById("unusedresselect");
    var vpLevel = getSelectOption(document.getElementById("levelselect"));
    if (vpLevel == VC12) 
    {
        var i = 0;
        while (i < vpSelectPath.length) 
        {
            if (vpSelectPath.options[i].selected) 
            {
                var slotid = $("availboardselect").value;
                var opticalid = $("optinterfaceselect").value;
                var highid = $("unusedresselect").value;
                beSelPathList[beSelPathList.length] = vpSelectPath.options[i].value//  options     
                delTimeSlotFromCache(slotid, opticalid, highid, vpSelectPath.options[i].value);
                vpSelectPath.options[i] = null;
                
            }
            else 
            {
                i++;
            }
        }
    }
    else 
    {
        var i = 0;
        while (i < unusedresselect.length) 
        {
            if (unusedresselect.options[i].selected) 
            {
                if (vpLevel == FrationalE1) 
                {
                    beSelPathList[beSelPathList.length] = unusedresselect.options[i].value - FranE1Port;
                }
                else 
                {
                    beSelPathList[beSelPathList.length] = unusedresselect.options[i].value//  options     
                }
                
                unusedresselect.options[i] = null;
            }
            else 
            {
                i++;
            }
        }
    }
    return beSelPathList;
}

/**
 * select  dinterUni     
 * @param   
 * @return  
 */
function addToDinterUni(beSelPathList)
{
    if (beSelPathList.length == 0) 
    {
        return;
    }
    var vpServerNo = getSelectOption(document.getElementById("unusedresselect"));
    var vpDirction = getSelectOption(document.getElementById("dirctionselect"));
    var vpVctrunk = getSelectOption(document.getElementById("bindvctrunkselect"));
    var vctrunck = getSelectorText(document.getElementById("bindvctrunkselect"), vpVctrunk);
    var optiPortid = $("optinterfaceselect").value;
    var unilen = boundPathTableData.getDataRowLength();
    if (boundPathTableData == null) 
    {
        boundPathTableData = new DataInterface();
    }
    if (unilen == 0) 
    {
        boundPathTableData.rows[0] = new Object();
        boundPathTableData.rows[0].vctrunck = new Object();
        boundPathTableData.rows[0].vctrunck.value = vctrunck;
        boundPathTableData.rows[0].level = new Object();
        boundPathTableData.rows[0].level.value = getSelectOption(document.getElementById("levelselect"));
        boundPathTableData.rows[0].direction = new Object();
        boundPathTableData.rows[0].direction.value = vpDirction;
        boundPathTableData.rows[0].boundpathnum = new Object();
        boundPathTableData.rows[0].boundpath = new Object();
        boundPathTableData.rows[0].pathListNum = new Object();
        boundPathTableData.rows[0].optiPortid = new Object();
        
        if ($("levelselect").value == VC12) 
        {
            boundPathTableData.rows[0].optiPortid.value = $("optinterfaceselect").value;
        }
        addRowDataToDinterUni(beSelPathList, 0, true);
    }
    else 
    {
        var hasAdd = false;
        for (var i = 0; i < unilen; ++i) 
        {
        
            if (vctrunck == boundPathTableData.getDataRowParam(i, "vctrunck") &&
            vpDirction == boundPathTableData.getDataRowParam(i, "direction")) 
            {
                if (boundPathTableData.getDataRowParam(i, "optiPortid") != null) 
                {
                    if (optiPortid == boundPathTableData.getDataRowParam(i, "optiPortid")) 
                    {
                        addRowDataToDinterUni(beSelPathList, i);//           
                        hasAdd = true;
                        break;
                    }
                }
                else 
                {
                    addRowDataToDinterUni(beSelPathList, i);//           
                    hasAdd = true;
                    break;
                }
                
            }
        }
        if (!hasAdd) 
        {
            addNewRowDataToDinterUni(beSelPathList);//          
        }
    }
    if (true == document.getElementById("showrowsbox").checked) 
    {
        showRowsUni();//      
    }
    else 
    {
        showRowsSepar();//         			
    }
}

function addNewRowDataToDinterUni(beSelPathList)
{
    var vpVctrunk = getSelectOption(document.getElementById("bindvctrunkselect"));
    var vctrunck = getSelectorText(document.getElementById("bindvctrunkselect"), vpVctrunk);
    var vpDirction = getSelectOption(document.getElementById("dirctionselect"));
    var unilen = boundPathTableData.getDataRowLength();
    var pathListHeadStr = null;
    if ($("levelselect").value == VC12) 
    {
        var unusedresselect = getSelectOption(document.getElementById("unusedresselect"));
        pathListHeadStr = $("optinterfaceselect").options[$("optinterfaceselect").selectedIndex].text + "-VC4-" + unusedresselect + "-";
    }
    else 
    {
        pathListHeadStr = $("availboardselect").options[$("availboardselect").selectedIndex].text + "-";
    }
    boundPathTableData.rows[unilen] = new Object();
    boundPathTableData.rows[unilen].vctrunck = new Object();
    boundPathTableData.rows[unilen].vctrunck.value = vctrunck;
    boundPathTableData.rows[unilen].level = new Object();
    boundPathTableData.rows[unilen].level.value = getSelectOption(document.getElementById("levelselect"));
    boundPathTableData.rows[unilen].direction = new Object();
    boundPathTableData.rows[unilen].direction.value = vpDirction;
    boundPathTableData.rows[unilen].boundpathnum = new Object();
    boundPathTableData.rows[unilen].boundpathnum.value = beSelPathList.length * 2;
    boundPathTableData.rows[unilen].boundpath = new Object();
    boundPathTableData.rows[unilen].boundpath.value = pathListHeadStr + "(" + pathsToUni(beSelPathList) + ")";
    boundPathTableData.rows[unilen].pathListNum = new Object();
    boundPathTableData.rows[unilen].pathListNum.value = beSelPathList.toString();
    boundPathTableData.rows[unilen].optiPortid = new Object();
    if ($("levelselect").value == VC12) 
    {
        boundPathTableData.rows[unilen].optiPortid.value = $("optinterfaceselect").value;
    }
    
}

/**
 * select  dinterUni         
 * @param  ifRefresh           
 * @return  
 */
function addRowDataToDinterUni(beSelPathList, i, ifRefresh)//i      ,ifRefresh            false    
{
    if (!ifRefresh) 
    {
        var pathsList = boundPathTableData.getDataRowParam(i, "pathListNum").split(",");
        pathsList = pathsList.concat(beSelPathList);
        pathsList.sort(sortNumFunc);
    }
    else 
    {
        pathsList = beSelPathList;
    }
    if (pathsList.length == 0)//                
    {
        boundPathTableData.rows.splice(i, 1);
        uinToSepar = false;
        ifchange = true;
        return;
    }
    var pathListHeadStr = null;
    if (i == 0) 
    {
        if ($("levelselect").value == VC12) 
        {
            var unusedresselect = getSelectOption(document.getElementById("unusedresselect"));
            pathListHeadStr = $("optinterfaceselect").options[$("optinterfaceselect").selectedIndex].text + "-VC4-" + unusedresselect + "-";
            boundPathTableData.rows[i].optiPortid.value = $("optinterfaceselect").value;
        }
        else 
        {
            pathListHeadStr = $("availboardselect").options[$("availboardselect").selectedIndex].text + "-";
        }
    }
    else 
    {
        if ($("levelselect").value == VC12) 
        {
            var unusedresselect = getSelectOption(document.getElementById("unusedresselect"));
            pathListHeadStr = $("optinterfaceselect").options[$("optinterfaceselect").selectedIndex].text + "-VC4-" + unusedresselect + "-";
        }
        else 
        {
            pathListHeadStr = boundPathTableData.getDataRowParam(i, "boundpath").split("(")[0];
        }
    }
    boundPathTableData.rows[i].boundpathnum.value = pathsList.length * 2;
    boundPathTableData.rows[i].boundpath.value = pathListHeadStr + "(" + pathsToUni(pathsList) + ")";
    boundPathTableData.rows[i].pathListNum.value = pathsList.toString();
    uinToSepar = false;
    ifchange = true;
}

/**
 * select     options,        
 * @param   
 * @return     options  
 */
function getSelectOption(selectObj)
{
    var selOption = 0;
    if (selectObj.selectedIndex >= 0) 
    {
        selOption = selectObj.options[selectObj.selectedIndex].value;
    }
    return selOption;
}

/**   
 * select              
 * @param   
 * @return  
 */
function pathsToUni(pathsList)
{
    var len = pathsList.length - 1;
    var firstNum = -1;
    var nextNum = -1;
    var conNumStart = -1;
    var conNumEnd = -1;
    var numToStr = "";
    if (pathsList.length == 1)//        
    {
        return pathsList[0];
    }
    for (var i = 0; i < len; i++) 
    {
        firstNum = parseInt(pathsList[i], 10);//      serverNo     
        nextNum = parseInt(pathsList[i + 1], 10);
        if ((firstNum + 1) == nextNum)//             
        {
            if (-1 != conNumStart) 
            {
                conNumEnd = nextNum;
            }
            else 
            {
                conNumStart = firstNum;
                conNumEnd = nextNum;
            }
        }
        else 
        {
            if (-1 == conNumStart) 
            {
                numToStr += "," + firstNum;
                
            }
            else 
            {
                numToStr += "," + conNumStart + "-" + conNumEnd;
                conNumStart = -1;
                conNumEnd = -1;
            }
        }
        if (len == i + 1)//        
        {
            if (-1 == conNumStart) 
            {
                numToStr += "," + nextNum;
            }
            else 
            {
                numToStr += "," + conNumStart + "-" + conNumEnd;
                conNumStart = -1;
                conNumEnd = -1;
            }
        }
        
    }
    return numToStr.substring(1);
}

/**
 *           
 * @param   
 * @return  
 */
function showRowsUni()
{
    boundPathTableData.rows.sort(sortObjFunc);
    
    if (null != boundPathTableData && boundPathTableData.rows.length > 0) 
    {
        imaConfigBindTable.clearTableData(); //       
        createTableBody(imaConfigBindTable, window.tableconf[0], boundPathTableData, RESOURCE);
    }
    else 
    {
        imaConfigBindTable.clearTableData();
    }
    if (!imaConfigBindTable.element.colsArray.selectedId) 
    {
        imaConfigBindTable.element.colsArray.selectedId = "vctrunck";
        imaConfigBindTable.element.colsArray.imgflag = 1;
    }
    var td = imaConfigBindTable.element.headRow.element.cols[imaConfigBindTable.element.colsArray.selectedId].element;
    imaConfigBindTable.sortRows(td, imaConfigBindTable.element.colsArray.imgflag);
}

/**   
 *          
 * @param   
 * @return  
 */
function sortObjFunc(obj1, obj2)
{
    if (obj1.vctrunck.value != obj2.vctrunck.value) 
    {
        return parseInt(obj1.vctrunck.value) - parseInt(obj2.vctrunck.value);
    }
    if (obj1.level.value != obj2.level.value) 
    {
        return parseInt(obj2.level.value) - parseInt(obj1.level.value);
    }
    if (obj1.direction.value != obj2.direction.value) 
    {
        return parseInt(obj1.direction.value) - parseInt(obj2.direction.value);
    }
    return 0;
}

/**
 *         
 * @param   
 * @return  
 */
function showRowsSepar()
{
    boundPathTableData.rows.sort(sortObjFunc);
    var seperateDat = sepearteData();
    imaConfigBindTable.clearTableData(); //       
    createTableBody(imaConfigBindTable, window.tableconf[0], seperateDat, RESOURCE);
    
    if (!imaConfigBindTable.element.colsArray.selectedId) 
    {
        imaConfigBindTable.element.colsArray.selectedId = "vctrunck";
        imaConfigBindTable.element.colsArray.imgflag = 1;
    }
    
    var td = imaConfigBindTable.element.headRow.element.cols[imaConfigBindTable.element.colsArray.selectedId].element;
    imaConfigBindTable.sortRows(td, imaConfigBindTable.element.colsArray.imgflag);
}

/**
 *          
 * @param   
 * @return  
 */
function sepearteData()
{
    var dinterSepar = new DataInterface();
    var tc = window.tableconf[0];
    var tclen = tc.getColsLength();
    
    var len = boundPathTableData.getDataRowLength();
    for (var i = 0; i < len; i++) 
    {
        var separPathList = boundPathTableData.getDataRowParam(i, "pathListNum").split(",");
        var pathHeadName = boundPathTableData.getDataRowParam(i, "boundpath").split("(");
        var pathHeadNameStr
        if ($("levelselect").value == VC12) 
        {
            pathHeadNameStr = pathHeadName[0] + "(" + pathHeadName[1];
        }
        else 
        {
            pathHeadNameStr = pathHeadName[0];
        }
        var separtrunkValue = parseInt(boundPathTableData.getDataRowParam(i, "vctrunck"));
        var separDirction = boundPathTableData.getDataRowParam(i, "direction");
        for (var sj = 0; sj < separPathList.length; sj++) 
        {
            var obj = new Object();
            for (var j = 0; j < tclen; j++) 
            {
                var ptag = new ParamTag();
                var tccolid = tc.getColId(j);
                if ("boundpathnum" == tccolid) 
                {
                    ptag.value = "2";
                }
                else if ("boundpath" == tccolid) 
                {
                    ptag.value = pathHeadNameStr + "(" + parseInt(separPathList[sj]) + ")";
                }
                else if ("pathListNum" == tccolid) 
                {
                    ptag.value = separPathList[sj];
                }
                else 
                {
                    ptag.value = boundPathTableData.getDataRowParam(i, tccolid);
                }
                
                obj[tccolid] = ptag;
            }
            dinterSepar.rows.push(obj);
        }
        
    }
    dinterSepar.rows.sort(sortObjFunc);
    return dinterSepar;
    
}

/**   
 *         ,            
 * @param   
 * @return  
 */
function compareList(list1, list2)
{
    var tmp1 = 0;
    var tmp2 = 0;
    var returnList = new Array();
    while (tmp1 < list1.length && tmp2 < list2.length) 
    {
        if (list1[tmp1] == list2[tmp2]) 
        {
            returnList.push(list1[tmp1]);
            list1.splice(tmp1, 1);
            list2.splice(tmp2, 1);
        }
        else if (parseInt(list1[tmp1]) < parseInt(list2[tmp2]))//    list2 
        {
            tmp1++;
        }
        else //    list2
         {
            tmp2++;
        }
    }
    return returnList;
    
}

/**
 *   selector        text
 */
function getSelectorText(selector, value)
{
    for (var i = 0, len = selector.options.length; i < len; i++) 
    {
        if (selector.options[i].value == value) 
        {
            return selector.options[i].text;
        }
    }
    return null;
}

/**   
 *          
 * @param   
 * @return  
 */
function sortNumFunc(num1, num2)
{
    return parseInt(num1) - parseInt(num2);
}

function refreshBoundTable()
{
    imaConfigBindTable.clearTableData();
    createTableBody(imaConfigBindTable, window.tableconf[0], boundPathTableData, RESOURCE);
}

/**
 * select           
 * @param   
 * @return  
 */
function delVctrunkPaths()
{
    var stSelRowList = imaConfigBindTable.getSelectedRows();
    var stlen = stSelRowList.length;
    var sti = 0;
    var uni = 0;
    var dbdirList = [];//       
    var dbdirList = [];//       
    while (sti < stlen) 
    {
        var rowNum = stSelRowList[sti];
        var pathsList = imaConfigBindTable.getCellCurrentValue(rowNum, "pathListNum", "pathListNum").split(",");
        dbdirList = dbdirList.concat(pathsList);
        boundPathTableData.rows.removeAt(rowNum);
        sti++;
    }
    if (true == document.getElementById("showrowsbox").checked) 
    {
        showRowsUni();//      
    }
    else 
    {
        showRowsSepar();//         			
    }
    
    
    redoSelectRes(dbdirList);
    refreshBoundTable();
    if (stlen > 0) 
    {
        ifchange = true;
    }
    setDefaultSelect();
}

/**
 *                level        
 * @param   
 * @return  
 */
function redoSelectRes(dbdirList)
{

    var slotid = $("availboardselect").value;
    if ($("levelselect").value == VC12) 
    {
        var unusedpathselect = document.getElementById("unusedpathselect");
        for (var i = 0; i < dbdirList.length; i++) 
        {
            var option = new Option("VC12:" + dbdirList[i], dbdirList[i]);
            unusedpathselect.options[unusedpathselect.options.length] = option;
            addVC12PortInfoToCache($("unusedresselect").value, dbdirList[i]);
        }
        sortSelector(unusedpathselect);
    }
    else 
    {
        var unusedresselect = document.getElementById("unusedresselect");
        for (var i = 0; i < dbdirList.length; i++) 
        {
            var option;
            if ($("levelselect").value == FrationalE1) 
            {
                var fe1portid = parseInt(dbdirList[i]);
                if (fe1portid < FranE1Port) 
                {
                    fe1portid = fe1portid + FranE1Port;
                }
                option = new Option(getBoundPortNameFromCache(slotid, fe1portid), fe1portid);
            }
            else 
            {
                option = new Option(getBoundPortNameFromCache(slotid, dbdirList[i]), dbdirList[i]);
            }
            
            unusedresselect.options[unusedresselect.options.length] = option;
        }
        sortSelector(unusedresselect);
    }
}

function addE1PortInfoToCache(portname, portid, isbound)
{
    var slotid = $("availboardselect").value;
    var board = availboardList[slotid];
    var portInfo = new Object();
    portInfo.portName = portname;
    portInfo.portID = portid;
    portInfo.isbound = isbound;
    if (board.portName == null) 
    {
        board.portName = new Array();
    }
    board.portName[board.portName.length] = portInfo;
}

function addVC12PortInfoToCache(highChannelID, timeSlot)
{
    var slotid = $("availboardselect").value;
    var board = availboardList[slotid];
    var opticalid = $("optinterfaceselect").value;
    for (var i = 0; i < board.portName.length; i++) 
    {
        var portInfo = board.portName[i];
        if (portInfo.portID == opticalid) 
        {
            var channelInfo = new Object();
            channelInfo.highChannelId = highChannelID;
            if (portInfo.channelInfoList == null) 
            {
                portInfo.channelInfoList = new Array();
                portInfo.channelInfoList[0] = channelInfo;
                portInfo.channelInfoList[0].timeSlot = new Array();
                portInfo.channelInfoList[0].timeSlot[0] = timeSlot;
                return;
            }
            for (var j = 0; j < portInfo.channelInfoList.length; j++) 
            {
                if (portInfo.channelInfoList[j].highChannelId == highChannelID) 
                {
                    if (portInfo.channelInfoList[j].timeSlot == null) 
                    {
                        portInfo.channelInfoList[j].timeSlot = new Array();
                        portInfo.channelInfoList[j].timeSlot[0] = timeSlot;
                        return;
                    }
                    else if (!isListContainValue(portInfo.channelInfoList[j].timeSlot, timeSlot)) 
                    {
                        portInfo.channelInfoList[j].timeSlot[portInfo.channelInfoList[j].timeSlot.length] = timeSlot;
                        return;
                    }
                    else 
                    {
                        return;
                    }
                    
                }
            }
            portInfo.channelInfoList[portInfo.channelInfoList.length] = channelInfo;
        }
    }
}

function getBoundPortFromCache(slotid)
{
    var board = availboardList[slotid];
    return board.portName;
}

function getBoundPortNameFromCache(slotid, portid)
{
    var board = availboardList[slotid];
    for (var i = 0; i < board.portName.length; i++) 
    {
        var portInfo = board.portName[i];
        if (portInfo.portID == portid) 
        {
            return portInfo.portName;
        }
    }
    return null;
}

function getChannelListFromCache(slotid, optiPortID)
{
    var board = availboardList[slotid];
    for (var i = 0; i < board.portName.length; i++) 
    {
        var portInfo = board.portName[i];
        if (portInfo.portID == optiPortID) 
        {
            return portInfo.channelInfoList;
        }
    }
    return null;
}

function getTimeSlotFromCache(slotid, optiPortID, highChannelID)
{
    var board = availboardList[slotid];
    for (var i = 0; i < board.portName.length; i++) 
    {
        var portInfo = board.portName[i];
        if (portInfo.portID == optiPortID) 
        {
            for (var j = 0; j < portInfo.channelInfoList.length; j++) 
            {
                if (portInfo.channelInfoList[j].highChannelId == highChannelID) 
                {
                    return portInfo.channelInfoList[j].timeSlot;
                }
            }
        }
    }
    return null;
}

function delBindPortFromCache(slotid, bindPortID)
{
    var boundPortList = getBoundPortFromCache(slotid);
    for (var i = 0; i < boundPortList.length; i++) 
    {
        if (boundPortList[i].portID == bindPortID) 
        {
            boundPortList.removeAt(i);
            return;
        }
    }
}

function delTimeSlotFromCache(slotid, optiPortID, highChannelID, timeSlotID)
{
    var timeslotList = getTimeSlotFromCache(slotid, optiPortID, highChannelID);
    timeslotList.remove(timeSlotID);
}

/**
 * select           
 * @param   
 * @return  
 */
function onEnsure(winclose)
{
    if (ifchange) 
    {
        $("okbutton").disabled = true;
        $("cancelbutton").disabled = true;
        $("applybutton").disabled = true;
        processSetBoundTrunck(winclose);
    }
    else 
    {
        if (winclose) 
        {
            if (imaConfigBindTable.getDataRowLength() > 0) 
            {
                if (win.cfgSrcBind == true) 
                {
                    win.ct.getAtom("srcbindpath").setValue(imaConfigBindTable.getCellStoreValue(0, "boundpath", "boundpath"));
                }
                else 
                {
                    win.ct.getAtom("dstbindpath").setValue(imaConfigBindTable.getCellStoreValue(0, "boundpath", "boundpath"));
                }
            }
            else 
            {
                if (win.cfgSrcBind == true) 
                {
                    win.ct.getAtom("srcbindpath").setValue("");
                }
                else 
                {
                    win.ct.getAtom("dstbindpath").setValue("");
                }
            }
            onCancel();
        }
    }
}

/**
 *          
 * @param data: 
 * @return  
 */
function onCancel()
{
    window.opener = null;
    xcloseDialog();
}

var isSetPortTypeSuccess = false;
/*
 *       trunck      
 */
function processSetBoundTrunck(windowclose)
{
    if (doSetPortLevel()) 
    {
        var xml = createSetBoundTrunckXML();
        var URL = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_ATM_CREATE_IMAGRP + "" + "&nmUser=" + win.winurlobj["nmUser"];
		loadXMLdoc(URL, "POST", true, doSetBoundTrunckCallBack, windowclose, "inputdata=" + xml);
    }    
}

function doSetPortLevel()
{
	if($("levelselect").value != VC12)
	{
		var xmlData = createSetPortAttriXml();
		var urlstr = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_ETHPORTATTRIB + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + win.winurlobj["nmUser"];
		loadXMLdoc(urlstr, "POST", false, callbackSetPortAttri, null, "inputdata=" + xmlData);
		return isSetPortTypeSuccess;
	}
	else
	{
		return true;
	}
}

function callbackSetPortAttri(doc)
{
    var data = EncapsulateData(doc);
    var errorCode = data.getSErrorCode();
    
    showErrorDialog(data);
    if (0 == errorCode) 
    {
        isSetPortTypeSuccess = true;
    }
    else 
    {
        isSetPortTypeSuccess = false;
    }
}

/**
 *          XML  
 * @param neid:  ID slotid:  ID tc:        
 * @return String:       XML  
 */
function createSetPortAttriXml()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var slotid = $("availboardselect").value;
    var row;
    var param;
    
    var len = imaConfigBindTable.getDataRowLength();
    for (var i = 0; i < len; i++) 
    {
        var boundpath = imaConfigBindTable.getCellCurrentValue(i, "boundpath", "boundpath");
        var portList = getTagListData((((boundpath.split("("))[1]).split(")"))[0]);
        for (var j = 0; j < portList.length; j++) 
        {
            row = new tagElement("row-params");
            
            param = new tagElement("param");
            param.setAttribute("name", "neid");
            param.setAttribute("value", neid);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "slotid");
            param.setAttribute("value", slotid);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "port");
            param.setAttribute("value", portList[j]);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "SDHPORT_ATTR_MODE");
            param.setAttribute("value", 2);
            row.appendChild(param);
            
            business.appendChild(row);
        }
        
    }
    root.getRoot().appendChild(business);
    return root.toString();
}
function getTagListData(str)
{
    var returnValue = new Array();
    if (str == 0) 
    {
        return returnValue;
    }
    var tempString = str;
    var stringLength = tempString.length;
    if (stringLength == 0) 
    {
        return returnValue;
    }
    
    var str = tempString.split(",");
    for (var i = 0; i < str.length; i++) 
    {
        var b = str[i].indexOf("-") != -1;
        if (b) 
        {
            var range = str[i].split("-");
            var rangeStart = parseInt(range[0]);
            var rangeEnd = parseInt(range[1]);
            if (!(isNaN(rangeStart) || isNaN(rangeEnd))) 
            {
                var start = parseInt(rangeStart);
                var end = parseInt(rangeEnd);
                for (var s1 = start; s1 <= end; s1++) 
                {
					returnValue[returnValue.length]=s1.toString();
                }
            }
        }
        else 
        {
            if (!isNaN(parseInt(str[i]))) 
            {
				returnValue[returnValue.length]=str[i];
            }
        }
    }

    return returnValue;
}
function createSetBoundTrunckXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var slotid = $("availboardselect").value;
    var trunckid = $("bindvctrunkselect").value;
    var len = imaConfigBindTable.getDataRowLength();
    if (len == 0) 
    {
        var row = new tagElement("row-params");
        var param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        row.appendChild(param);
        
        var param = new tagElement("param");
        param.setAttribute("name", "slotid");
        param.setAttribute("value", slotid);
        row.appendChild(param);
        
        var param = new tagElement("param");
        param.setAttribute("name", "trunckid");
        param.setAttribute("value", trunckid);
        row.appendChild(param);
        
        var param = new tagElement("param");
        param.setAttribute("name", "direction");
        param.setAttribute("value", $("dirctionselect").value);
        row.appendChild(param);
        
        var param = new tagElement("param");
        param.setAttribute("name", "level");
        param.setAttribute("value", $("levelselect").value);
        row.appendChild(param);
        
        var param = new tagElement("param");
        param.setAttribute("name", "pathlistStr");
        param.setAttribute("value", "");
        row.appendChild(param);
        bussiness.appendChild(row);
    }
    for (var i = 0; i < len; i++) 
    {
    
        var row = new tagElement("row-params");
        var param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        row.appendChild(param);
        
        var param = new tagElement("param");
        param.setAttribute("name", "slotid");
        param.setAttribute("value", slotid);
        row.appendChild(param);
        
        var param = new tagElement("param");
        param.setAttribute("name", "trunckid");
        param.setAttribute("value", trunckid);
        row.appendChild(param);
        
        var param = new tagElement("param");
        var direction = imaConfigBindTable.getCellCurrentValue(i, "direction", "direction");
        param.setAttribute("name", "direction");
        param.setAttribute("value", direction);
        row.appendChild(param);
        
        var param = new tagElement("param");
        var level = imaConfigBindTable.getCellCurrentValue(i, "level", "level");
        param.setAttribute("name", "level");
        param.setAttribute("value", level);
        row.appendChild(param);
        
        var param = new tagElement("param");
        var boundpath = imaConfigBindTable.getCellCurrentValue(i, "boundpath", "boundpath");
        param.setAttribute("name", "pathlistStr");
        param.setAttribute("value", boundpath);
        row.appendChild(param);
        bussiness.appendChild(row);
        
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doSetBoundTrunckCallBack(doc, windowclose)
{
    $("okbutton").disabled = false;
    $("cancelbutton").disabled = false;
    $("applybutton").disabled = false;
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        win.sendQueryVCTrunkInfo();
    }
    if (data.getSErrorCode() == 0) 
    {
        ifchange = false;
        if (windowclose == true) 
        {
            if (win.cfgSrcBind == true) 
            {
                win.ct.getAtom("srcbindpath").setValue(imaConfigBindTable.getCellStoreValue(0, "boundpath", "boundpath"));
            }
            else 
            {
                win.ct.getAtom("dstbindpath").setValue(imaConfigBindTable.getCellStoreValue(0, "boundpath", "boundpath"));
            }
            onCancel();
        }
    }
    else 
    {
        ifchange = true;
    }
}
