var ct = null;

var act = null;

var tab = null;

var win = getParentWindow();
var neid = win.neid;
var nmUser = win.nmUser;
var neversion = win.winurlobj.neversion;
var connectionType = null;

function init()
{
    connectionType = win.parent.ct.getAtom("connectiontype").getValue();
    initGeneralTable();
    initAdvancedTable();
    initUI();
    initTabs();
}

function initGeneralTable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["attribute"], RESOURCE["value"]);
    $("general").appendChild(ct.getTable());
    
    atom = new Atom("text");
    checkText(atom.element, "1", "4294967295");
    ct.addAttrRow("pwid", RESOURCE["pwid"], atom);
    if (win.pwID != 0) 
    {
        atom.setValue(win.pwID);
    }
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["static"], "1");
    atom.addOption(RESOURCE["dynamic"], "2");
    ct.addAttrRow("pwsignaltype", RESOURCE["pwsignaltype"], atom);
    atom.element.onchange = function()
    {
        changePwSignaltype(this.value);
    }
    
    atom = new Atom("select");
    
    if (connectionType == CONNTYPE_PVC) 
    {
        atom.addOption(RESOURCE["serviceType_9"], "9");
        atom.addOption(RESOURCE["serviceType_12"], "12");
    }
    else 
    {
        atom.addOption(RESOURCE["serviceType_10"], "10");
        atom.addOption(RESOURCE["serviceType_13"], "13");
    }
    ct.addAttrRow("pwtype", RESOURCE["pwtype"], atom);
    atom.element.onchange = function()
    {
        if (this.value == 12 || this.value == 13) 
        {
            act.getAtom("controlword").element.disabled = true;
            act.getAtom("controlword").setValue(3);
        }
        else 
        {
            act.getAtom("controlword").element.disabled = false;
            act.getAtom("controlword").setValue(3);
        }
    }
    
    atom = new Atom("select");
    atom.element.disabled = true;
    atom.addOption(RESOURCE["bidirectional"], "1");
    ct.addAttrRow("direction", RESOURCE["direction"], atom);
    
    atom = new Atom("select");
    atom.element.disabled = true;
    atom.addOption("MPLS", 1);
    ct.addAttrRow("pwencaptype", RESOURCE["pwencaptype"], atom);
    
    atom = new Atom("text");
    checkText(atom.element, "16", "1048575");
    ct.addAttrRow("pwinlabel", RESOURCE["pwinlabel"], atom);
    
    atom = new Atom("text");
    checkText(atom.element, "16", "1048575");
    ct.addAttrRow("pwoutlabel", RESOURCE["pwoutlabel"], atom);
    
    atom = new Atom("select");
    atom.element.disabled = true;
    atom.addOption(RESOURCE["manually"], "0");
    ct.addAttrRow("tunnelmode", RESOURCE["tunnelmode"], atom);
    
    atom = new Atom("select");
    atom.addOption("MPLS", TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL);
    atom.addOption("GRE", TECMDCODE_PTN_GRETUNNEL_QUERY);
    atom.addOption("IP", TECMDCODE_PTN_IPTUNNEL_QUERY);
    ct.addAttrRow("tunneltype", RESOURCE["tunneltype"], atom);
    
    atom = new Atom("span");
    ct.addAttrRow("tunnel", "Tunnel", atom);
    
    var elem = document.createElement("input");
    elem.type = "radio";
    elem.id = "newtunnel";
    elem.onclick = function()
    {
        $("hadtunnel").checked = false;
        this.checked = true;
    }
    atom.element.parentNode.appendChild(elem);
    elem.checked = true;
    
    elem = document.createElement("span");
    elem.innerHTML = RESOURCE["createbtn"];
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "radio";
    elem.id = "hadtunnel";
    elem.onclick = function()
    {
        $("newtunnel").checked = false;
        this.checked = true;
    }
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("span");
    elem.innerHTML = RESOURCE["usehad"];
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "text";
    elem.id = "selectedtunnel";
    elem.disabled = true;
    if (SYSTEMCONF.getLanguage() == "zh") 
    {
        elem.style.width = "58%";
    }
    else 
    {
        elem.style.width = "30%";
    }
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "hidden";
    elem.id = "tunnelindex";
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "button";
    elem.value = "...";
    elem.onclick = doSelectTunnel;
    atom.element.parentNode.appendChild(elem);
    
    atom = new Atom("text");
    validateIp(atom.element);
    ct.addAttrRow("oppsitelsrid", RESOURCE["oppsitelsrid"], atom);
}

function initAdvancedTable()
{
    act = new CTable();
    act.addHead(RESOURCE["attribute"], RESOURCE["value"]);
    
    var atom = new Atom("select");
    atom.addOption(RESOURCE["nouse"], 1);
    atom.addOption(RESOURCE["mustuse"], 3);
    act.addAttrRow("controlword", RESOURCE["controlword"], atom);
    atom.setValue(3);
    
    atom = new Atom("select");
    atom.addOption("None", "0");
    atom.addOption("CW", "1");
    if (compare(neversion, "5.76.01.40") > 0 && compare(neversion, "5.76.01.99") < 0)
    {
        atom.addOption("Alert Label", "2");
    }
    atom.element.options.selectedIndex = 1;
    act.addAttrRow("controlchanneltype", RESOURCE["controlchanneltype"], atom);
    
    atom = new Atom("select");
    atom.addOption("None", "0");
    atom.addOption("Ping", "1");
    atom.element.options.selectedIndex = 1;
    act.addAttrRow("vccvmode", RESOURCE["vccvmode"], atom);
    
    atom = new Atom("text");
    atom.setValue("10");
    textCheckWithStepLen(atom.element, "1", "31", "1");
    act.addAttrRow("count", RESOURCE["count"], atom);
    atom.element.onchange = function()
    {
        if (this.value == 1) 
        {
            act.getAtom("time").setValue("0");
            act.getAtom("time").element.disabled = true;
        }
        else 
        {
            act.getAtom("time").setValue("1000");
            act.getAtom("time").element.disabled = false;
        }
    }
    
    atom = new Atom("text");
    atom.setValue("1000");
    textCheckWithStepLen(atom.element, "100", "50000", "100");
    act.addAttrRow("time", RESOURCE["time"], atom);
    
    atom = new Atom("span");
    atom.setValue("");
    act.addAttrRow("", "", atom);
    
    atom = new Atom("span");
    atom.setValue("");
    act.addAttrRow("", "", atom);
    
    atom = new Atom("span");
    atom.setValue("");
    act.addAttrRow("", "", atom);
    
    atom = new Atom("span");
    atom.setValue("");
    act.addAttrRow("", "", atom);
    
    atom = new Atom("span");
    atom.setValue("");
    act.addAttrRow("", "", atom);
    
    atom = new Atom("span");
    atom.setValue("");
    act.addAttrRow("", "", atom);
    
    atom = new Atom("span");
    atom.setValue("");
    act.addAttrRow("", "", atom);
    
    $("advance").appendChild(act.getTable());
}

function initUI()
{
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
}

function initTabs()
{
    tab = new EmbedTabs();
    tab.addEmbedTab("tab1div", RESOURCE["generalattr"], $("tab1div"));
    tab.addEmbedTab("tab2div", RESOURCE["advancedattr"], $("tab2div"));
    
    setSelectedEmbedTab("tab1div");
    $("embedtab").appendChild(tab.getEmbedTabs());
}

function changePwSignaltype(type)
{
    if (type == 2) 
    {
        ct.getAtom("pwinlabel").element.disabled = true;
        ct.getAtom("pwoutlabel").element.disabled = true;
        ct.getAtom("pwinlabel").setValue("-");
        ct.getAtom("pwoutlabel").setValue("-");
    }
    else 
    {
        ct.getAtom("pwinlabel").element.disabled = false;
        ct.getAtom("pwoutlabel").element.disabled = false;
        ct.getAtom("pwinlabel").setValue("");
        ct.getAtom("pwoutlabel").setValue("");
    }
}

function doSelectTunnel()
{
    var tunnelType = ct.getAtom("tunneltype").getValue();
    if ($("hadtunnel").checked) 
    {
        xshowModalDialog("selecttunnel.html?tunnelType=" + tunnelType, RESOURCE["resourceselected"], 580, 250, "../../../../../../images/");
    }
    else 
    {
        if (tunnelType == TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL) 
        {
            xshowModalDialog("../../ethservice/ethcommon/createmplstunnel.html?tunnelType=" + tunnelType, RESOURCE["resourceselected"], 580, 620, "../../../../../../images/");
        }
        else 
        {
            xshowModalDialog("../../ethservice/ethcommon/createipgretunnel.html?tunnelType=" + tunnelType, RESOURCE["resourceselected"], 580, 450, "../../../../../../images/");
        }
    }
}

/**
 * 
 */
function validate()
{
    var msgArr = new Array();
    
    var pwID = ct.getAtom("pwid").getValue();
    if (typeof(pwID) == "undefined" || pwID == "") 
    {
        msgArr[msgArr.length] = RESOURCE["pwid"] + RESOURCE["rangemsg"] + "1~4294967295";
    }
    var labelRange = "16~1048575";
    var label = ct.getAtom("pwinlabel").getValue();
    if (label != "-" && label == "") 
    {
        msgArr[msgArr.length] = RESOURCE["pwinlabel"] + RESOURCE["rangemsg"] + labelRange;
    }
    label = ct.getAtom("pwoutlabel").getValue();
    if (label != "-" && label == "") 
    {
        msgArr[msgArr.length] = RESOURCE["pwoutlabel"] + RESOURCE["rangemsg"] + labelRange;
    }
    if ($("selectedtunnel").value == "") 
    {
        msgArr[msgArr.length] = RESOURCE["inputtunnel"];
    }
    
    var v = ct.getAtom("oppsitelsrid").getValue();
    var arr = v.split(".");
    var fIp = parseInt(arr[0]);
    var tIp = parseInt(arr[3]);
    if (isNaN(fIp) || isNaN(tIp) || fIp == 0 || fIp == 127 || (fIp >= 224 && fIp <= 255) || tIp == 0 || tIp == 255) 
    {
        msgArr[msgArr.length] = RESOURCE["oppsitelsrid"] + RESOURCE["inputmsg"] + "0.*.*.*,127.*.*.*,*.*.*.0,*.*.*.255,224.0.0.0~255.255.255.255";
    }
    if (msgArr.length > 0) 
    {
        var msg = RESOURCE["errormsg"];
        for (var i = 0, m = msgArr.length; i < m; i++) 
        {
            msg += "\n(" + (i + 1) + ")" + msgArr[i];
        }
        alert(msg);
        return false;
    }
    return true;
}

function doOK()
{
    if (!validate()) 
    {
        return null;
    }
    var di = document.createElement("datainterface");
    var bparams = document.createElement("bussiness-params");
    var rowParams = document.createElement("row-params");
    
    rowParams.appendChild(createParamElement("vnniId", 1));
    rowParams.appendChild(createParamElement("pwID", ct.getAtom("pwid").getValue()));
    rowParams.appendChild(createParamElement("pwIndex", 0));
    rowParams.appendChild(createParamElement("enableState", 1));
    rowParams.appendChild(createParamElement("pwSignalType", ct.getAtom("pwsignaltype").getValue()));
    rowParams.appendChild(createParamElement("serviceType", ct.getAtom("pwtype").getValue()));
    rowParams.appendChild(createParamElement("direction", ct.getAtom("direction").getValue()));
    rowParams.appendChild(createParamElement("pwEncapsType", ct.getAtom("pwencaptype").getValue()));
    rowParams.appendChild(createParamElement("pwIngressLabel", ct.getAtom("pwinlabel").getValue()));
    rowParams.appendChild(createParamElement("pwEgressLabel", ct.getAtom("pwoutlabel").getValue()));
    rowParams.appendChild(createParamElement("oppositeLsrID", convertIPStrToLong(ct.getAtom("oppsitelsrid").getValue())));
    rowParams.appendChild(createParamElement("tunneltype", tunnelTypes[ct.getAtom("tunneltype").getValue()]));
    rowParams.appendChild(createParamElement("tunnelindex", $("tunnelindex").value));
    rowParams.appendChild(createParamElement("tunnelid", $("selectedtunnel").value));
    
    rowParams.appendChild(createParamElement("controlWord", act.getAtom("controlword").getValue()));
    rowParams.appendChild(createParamElement("ctrlChanType", act.getAtom("controlchanneltype").getValue()));
    rowParams.appendChild(createParamElement("vccv", act.getAtom("vccvmode").getValue()));
    rowParams.appendChild(createParamElement("tunnelpolicy", "-"));
    rowParams.appendChild(createParamElement("localWorkingStat", 0));
    rowParams.appendChild(createParamElement("remoteWorkingStat", 0));
    rowParams.appendChild(createParamElement("compWorkingStat", 0));
    rowParams.appendChild(createParamElement("maxcount", act.getAtom("count").getValue()));
    rowParams.appendChild(createParamElement("maxtime", act.getAtom("time").getValue()));
    
    bparams.appendChild(rowParams);
    di.appendChild(bparams);
    
    createTableBody(win.cfgPwst, win.cfgPwtc, EncapsulateData(di), RESOURCE);
    win.addCellListener();
    win.$("cfgqosbtn").disabled = false;
    win.$("delpwbtn").disabled = false;
    win.$("newbtn").disabled = true;
    win.cfgPwst.setRowSelect(0);
    
    if (win.pwID != ct.getAtom("pwid").getValue()) 
    {
        win.parent.refreshPWID(ct.getAtom("pwid").getValue());
    }
    win.addRow(ct.getAtom("pwid").getValue());
    xcloseDialog();
}

function setTunnel(tunnelIndex, tunnel, sinkNode)
{
    $("tunnelindex").value = tunnelIndex;
    $("selectedtunnel").value = tunnel;
    ct.getAtom("oppsitelsrid").setValue(sinkNode);
}
