function init()
{
    initMPLSTunnelTable();
    $("reverse").style.display = "";
    
    initPortAttrTable();
    initText();
	$("label").innerHTML = RESOURCE["newreversetunnel"];
    
    getPortRes();
    refreshSnkBoardData();
}

function initMPLSTunnelTable()
{
    ct = new TunnelTable();
    ct.addHead(RESOURCE["attribute"], RESOURCE["positivevalue"], RESOURCE["negativevalue"]);
    $("tbdiv").appendChild(ct.getTable());
    
    var atom1 = new Atom("text");
    checkText(atom1.element, "1", "65535");
    var atom2 = new Atom("text");
    checkText(atom2.element, "1", "65535");
    ct.addAttrRow("tunnelid", RESOURCE["tunnelid"], atom1, atom2);
    
    atom1 = new Atom("text");
    checkTextData(atom1.element, 64);
    atom2 = new Atom("text");
    checkTextData(atom2.element, 64);
    ct.addAttrRow("tunnelname", RESOURCE["tunnelname"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.element.disabled = true;
    atom1.addOption(RESOURCE["ingress"], 1);
    atom2 = new Atom("select");
    atom2.element.disabled = true;
    atom2.addOption(RESOURCE["egress"], 3);
    ct.addAttrRow("nodetype", RESOURCE["nodetype"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.element.disabled = true;
    atom1.addOption(RESOURCE["unidirectional"], 0);
    atom2 = new Atom("select");
    atom2.element.disabled = true;
    atom2.addOption(RESOURCE["unidirectional"], 0);
    ct.addAttrRow("direction", RESOURCE["direction"], atom1, atom2);
    
    atom1 = new Atom("combobox");
    atom2 = new Atom("combobox");
    ct.addAttrRow("bandwidth", RESOURCE["bandwidth"], atom1, atom2);
    
    atom1.element.parent.initComboBox(getDataArr(), "dm0", 16, true);
    atom1.element.parent.txtview.onkeypress = keypressHandler;
    atom1.element.parent.txtview.onkeyup = keyupHandler;
    atom1.element.parent.txtview.onblur = onblurHandler;
    atom1.element.parent.txtview.style.imeMode = "disabled";
    atom1.element.parent.txtview.onpaste = function()
    {
        return false;
    };
    
    atom2.element.parent.selview.disabled = true;
    atom2.element.parent.txtview.disabled = true;
    atom2.element.parent.initComboBox(getDataArr(), "dm1", 0, true);
    addOptionToSelect(atom2.element.parent.selview, new Option("-", "-"));
    atom2.element.parent.setSelectedIndex(17);
    atom2.element.parent.txtview.onkeypress = keypressHandler;
    atom2.element.parent.txtview.onkeyup = keyupHandler;
    atom2.element.parent.txtview.onblur = onblurHandler;
    atom2.element.parent.txtview.style.imeMode = "disabled";
    atom2.element.parent.txtview.onpaste = function()
    {
        return false;
    };
    
    atom1 = new Atom("select");
    atom1.element.disabled = true;
    atom2 = new Atom("select");
    atom2.element.disabled = true;
    ct.addAttrRow("inboard", RESOURCE["inboard"], atom1, atom2);
    
    atom1 = new Atom("text");
    atom1.element.disabled = true;
    atom1.setValue("-");
    checkText(atom1.element, "16", "1048575");
    atom2 = new Atom("text");
    checkText(atom2.element, "16", "1048575");
    ct.addAttrRow("inlabel", RESOURCE["inlabel"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.element.onchange = changeBoard;
    atom2 = new Atom("select");
    atom2.element.disabled = true;
    ct.addAttrRow("outboard", RESOURCE["outboard"], atom1, atom2);
    
    atom1 = new Atom("text");
    checkText(atom1.element, "16", "1048575");
    atom2 = new Atom("text");
    atom2.element.disabled = true;
    atom2.setValue("-");
    checkText(atom2.element, "16", "1048575");
    ct.addAttrRow("outlabel", RESOURCE["outlabel"], atom1, atom2);
    
    atom1 = new Atom("text");
    validateIp(atom1.element);
    atom2 = new Atom("text");
    atom2.element.disabled = true;
    atom2.setValue("-");
    validateIp(atom2.element);
    ct.addAttrRow("nexthopaddr", RESOURCE["nexthopaddr"], atom1, atom2);
    
    atom1 = new Atom("text");
    atom1.element.disabled = true;
    atom1.setValue("-");
    validateNode(atom1.element, false, "snknode");
    atom2 = new Atom("text");
    atom2.element.disabled = true;
    atom2.setValue("-");
    ct.addAttrRow("srcnode", RESOURCE["srcnode"], atom1, atom2);
    
    atom1 = new Atom("text");
    validateNode(atom1.element, false, "srcnode");
    atom2 = new Atom("text");
    atom2.element.disabled = true;
    atom2.setValue("-");
    ct.addAttrRow("snknode", RESOURCE["snknode"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.addOption(RESOURCE["exp0"], 0);
    atom1.addOption(RESOURCE["exp1"], 1);
    atom1.addOption(RESOURCE["exp2"], 2);
    atom1.addOption(RESOURCE["exp3"], 3);
    atom1.addOption(RESOURCE["exp4"], 4);
    atom1.addOption(RESOURCE["exp5"], 5);
    atom1.addOption(RESOURCE["exp6"], 6);
    atom1.addOption(RESOURCE["exp7"], 7);
    atom1.addOption(RESOURCE["exp255"], 255);
    atom1.element.options.selectedIndex = 8;
    atom2 = new Atom("select");
    atom2.element.disabled = true;
    atom2.addOption(RESOURCE["exp0"], 0);
    atom2.addOption(RESOURCE["exp1"], 1);
    atom2.addOption(RESOURCE["exp2"], 2);
    atom2.addOption(RESOURCE["exp3"], 3);
    atom2.addOption(RESOURCE["exp4"], 4);
    atom2.addOption(RESOURCE["exp5"], 5);
    atom2.addOption(RESOURCE["exp6"], 6);
    atom2.addOption(RESOURCE["exp7"], 7);
    atom2.addOption(RESOURCE["exp255"], 255);
    atom2.addOption("-", 0);
    atom2.element.options.selectedIndex = 9;
    ct.addAttrRow("exp", RESOURCE["exp"] + "(" + RESOURCE["elsp"] + ")", atom1, atom2);
}

function changeBoard()
{
    var atom = ct.getAtom("outboard", 0);
    var option = atom.element.options[atom.element.options.selectedIndex];
    
    atom = ct.getAtom("inboard", 1);
    atom.clearOptions();
    atom.addOption(option.text, option.value);
    
    fillPortAttr(option);
}

function doReverse()
{
    if ($("isreverse").checked) 
    {
        setDisplay("33%", "");
        setComboboxStyle(0);
        setComboboxStyle(1);
    }
    else 
    {
        setDisplay("50%", "none");
        setComboboxStyle(0);
    }
}

function setDisplay(width, display)
{
    ct.element.childNodes[0].childNodes[0].childNodes[0].style.width = width;
    ct.element.childNodes[0].childNodes[0].childNodes[1].style.width = width;
    ct.element.childNodes[0].childNodes[0].childNodes[2].style.display = display;
    
    var childNodes = ct.element.childNodes[1].childNodes;
    for (var i = 0, m = childNodes.length; i < m; i++) 
    {
        childNodes[i].childNodes[0].style.width = width;
        childNodes[i].childNodes[1].style.width = width;
        childNodes[i].childNodes[2].style.display = display;
    }
}

function setComboboxStyle(index)
{
    var elem = ct.getAtom("bandwidth", index).element.parent;
    var wdt = elem.view.parentNode.offsetWidth - 2;
    var clip = "rect(1px," + (wdt - 1) + "px,19px," + (wdt - 18) + "px)";
    
    elem.txtview.style.width = wdt;
    elem.selview.style.width = wdt;
    elem.selview.style.clip = clip;
}

function changeSrcNode()
{
    ct.getAtom("snknode", 1).setValue(ct.getAtom("srcnode", 0).getValue());
}

function changeSnkNode()
{
    ct.getAtom("srcnode", 1).setValue(ct.getAtom("snknode", 0).getValue());
}

function validateTunnel(index)
{
    var atom = ct.getAtom("tunnelid", index);
    var v = atom.getValue().trim();
    if (v == "") 
    {
        alert(RESOURCE["inputtunnelid"]);
        return false;
    }
    atom = ct.getAtom("inlabel", index);
    v = atom.getValue().trim();
    if (!atom.element.disabled && v == "") 
    {
        alert(RESOURCE["inputinlabel"]);
        return false;
    }
    atom = ct.getAtom("outlabel", index);
    v = atom.getValue().trim();
    if (!atom.element.disabled && v == "") 
    {
        alert(RESOURCE["inputoutlabel"]);
        return false;
    }
    
    atom = ct.getAtom("nexthopaddr", index);
    v = atom.getValue().trim();
    if (!atom.element.disabled) 
    {
        if (v == "" || v == "0.0.0.0") 
        {
            alert(RESOURCE["inputhopaddr"]);
            return false;
        }
        else if (v >= "224.0.0.0") 
        {
            alert(RESOURCE["invalidip"]);
            return false;
        }
    }
    
    atom = ct.getAtom("srcnode", index);
    v = atom.getValue().trim();
    if (!atom.element.disabled) 
    {
        if (v == "" || v == "0.0.0.0") 
        {
            alert(RESOURCE["inputsrcnode"]);
            return false;
        }
        else if (v >= "224.0.0.0") 
        {
            alert(RESOURCE["invalidip"]);
            return false;
        }
    }
    
    atom = ct.getAtom("snknode", index);
    v = atom.getValue().trim();
    if (!atom.element.disabled) 
    {
        if (v == "" || v == "0.0.0.0") 
        {
            alert(RESOURCE["inputsnknode"]);
            return false;
        }
        else if (v >= "224.0.0.0") 
        {
            alert(RESOURCE["invalidip"]);
            return false;
        }
    }
    
    return true;
}

function refreshSnkBoardData()
{
    var atom = ct.getAtom("outboard", 0);
    atom.clearOptions();
    for (var i = 0, m = portRes.length; i < m; i++) 
    {
        var portObj = portRes[i];
        var str = portObj.boardName + "-" + portObj.portName;
        if (parseInt(portObj.slotId) != 0xFFFF) 
        {
            str = portObj.slotId + "-" + str;
        }
        atom.addOption(str, portObj.slotId + "-" + portObj.portId);
    }
    
    changeBoard();
}

function validate()
{
	if (!validatePortAttr())
	{
		return false;
	}
	if (!validateTunnel(0)) 
    {
        return false;
    }
    else if ($("isreverse").checked && !validateTunnel(1)) 
    {
        return false;
    }
	return true;
}

function createTunnelXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    bussiness.appendChild(createRowParams(0));
    if ($("isreverse").checked) 
    {
        bussiness.appendChild(createRowParams(1));
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function createRowParams(index)
{
    var rowparams = new tagElement("row-params");
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("auto", 1));
    rowparams.appendChild(createTagElement("autoassign", 2));
    rowparams.appendChild(createTagElement("tunnelindex", 0));
    rowparams.appendChild(createTagElement("tunnelid", ct.getAtom("tunnelid", index).getValue()));
    var tunnelName = ct.getAtom("tunnelname", index).getValue().trim();
    if (tunnelName != "") 
    {
        rowparams.appendChild(createTagElement("name", tunnelName));
    }
    rowparams.appendChild(createTagElement("direction", ct.getAtom("direction", index).getValue()));
    rowparams.appendChild(createTagElement("tunneltype", 0));
    
    var nodeType = parseInt(ct.getAtom("nodetype", index).getValue());
    rowparams.appendChild(createTagElement("nodetype", nodeType));
    
    var board = null;
    var atom = null;
    var bandwidth = ct.getAtom("bandwidth", index).getValue();
    var nextHopAddr = ct.getAtom("nexthopaddr", index).getValue();
    var srcNode = ct.getAtom("srcnode", index).getValue();
    var snkNode = ct.getAtom("snknode", index).getValue();
    var iOptions = ct.getAtom("inboard", index).element.options;
    var oOptions = ct.getAtom("outboard", index).element.options;
    switch (nodeType)
    {
        case NODE_TYPE_INGRESS:
            rowparams.appendChild(createTagElement("bw", bandwidth));
            rowparams.appendChild(createTagElement("bandwidth", isNaN(bandwidth) ? 0 : bandwidth));
            rowparams.appendChild(createTagElement("insubslotid", 0));
            board = oOptions[oOptions.selectedIndex].value.split("-");
            rowparams.appendChild(createTagElement("outslotid", board[0]));
            rowparams.appendChild(createTagElement("outportname", oOptions[oOptions.selectedIndex].text));
            rowparams.appendChild(createTagElement("outport", board[1]));
            rowparams.appendChild(createTagElement("outlabel", ct.getAtom("outlabel", index).getValue()));
            rowparams.appendChild(createTagElement("nexthopaddress", nextHopAddr));
            rowparams.appendChild(createTagElement("nexthopaddr", parseInt("0x" + convertIpaddrToHexcode(nextHopAddr))));
            rowparams.appendChild(createTagElement("sinknode", snkNode));
            rowparams.appendChild(createTagElement("snknode", parseInt("0x" + convertIpaddrToHexcode(snkNode))));
            rowparams.appendChild(createTagElement("exp", ct.getAtom("exp", index).getValue()));
            break;
        case NODE_TYPE_EGRESS:
            board = iOptions[iOptions.selectedIndex].value.split("-");
            rowparams.appendChild(createTagElement("inslotid", board[0]));
            rowparams.appendChild(createTagElement("inportname", iOptions[iOptions.selectedIndex].text));
            rowparams.appendChild(createTagElement("inport", board[1]));
            rowparams.appendChild(createTagElement("inlabel", ct.getAtom("inlabel", index).getValue()));
            rowparams.appendChild(createTagElement("outsubslotid", 0));
            rowparams.appendChild(createTagElement("sourcenode", srcNode));
            rowparams.appendChild(createTagElement("srcnode", parseInt("0x" + convertIpaddrToHexcode(srcNode))));
            break;
        default:
            break;
    }
    return rowparams;
}

function doCreateTunnel()
{
    var xml = createTunnelXML();
    var url = "../../../../../../neExlorerServlet?sfid=" + TE_CMD_MPLSTUNNEL_ADD_P2PTUNNEL + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, createTunnelCallBack, null, "inputdata=" + xml);
}

function createTunnelCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        refreshData(data.getDataRowParam(0, "tunnelindex"));
        xcloseDialog();
    }
}

function refreshData(tunnelIndex)
{
    var tunnelName = ct.getAtom("tunnelname", 0).getValue();
    if (null == tunnelName || "" == tunnelName) 
    {
        tunnelName = RESOURCE["null"];
    }
    win.$("selectedtunnel").value = ct.getAtom("tunnelid", 0).getValue() + "(" + tunnelName + ")";
    win.$("tunnelindex").value = tunnelIndex;
    win.ct.getAtom("oppsitelsrid").setValue(ct.getAtom("nexthopaddr", 0).getValue());
    win.$("hadtunnel").checked = true;
}

function TunnelTable()
{
    this.element = document.createElement("table");
    this.element.appendChild(document.createElement("thead"));
    this.element.appendChild(document.createElement("tbody"));
    this.element.firstChild.appendChild(document.createElement("tr"));
    
    this.attrName = new Object();
    this.attrArray = new Object();
    this.element.className = "attrTable";
    this.addHead = function(head1, head2, head3)
    {
        var th = document.createElement("td");
        span = document.createElement("span");
        span.appendChild(document.createTextNode(head1));
        th.appendChild(span);
        this.element.firstChild.firstChild.appendChild(th);
        th = document.createElement("td");
        span = document.createElement("span");
        span.appendChild(document.createTextNode(head2));
        th.appendChild(span);
        this.element.firstChild.firstChild.appendChild(th);
        th = document.createElement("td");
        span = document.createElement("span");
        span.appendChild(document.createTextNode(head3));
        th.appendChild(span);
        this.element.firstChild.firstChild.appendChild(th);
    }
    
    this.addAttrRow = function(attrid, attrname, atom1, atom2, text)
    {
        tr = document.createElement("tr");
        td = document.createElement("td");
        span = document.createElement("span");
        span.appendChild(document.createTextNode(attrname));
        td.appendChild(span);
        tr.appendChild(td);
        
        td = document.createElement("td");
        td.appendChild(atom1.element);
        if (text != null) 
        {
            span = document.createElement("span");
            span.appendChild(document.createTextNode(text));
            td.appendChild(span);
        }
        tr.appendChild(td);
        
        td = document.createElement("td");
        td.appendChild(atom2.element);
        if (text != null) 
        {
            span = document.createElement("span");
            span.appendChild(document.createTextNode(text));
            td.appendChild(span);
        }
        tr.appendChild(td);
        this.element.childNodes[1].appendChild(tr);
        var atomArr = new Object();
        atomArr[0] = atom1;
        atomArr[1] = atom2;
        this.attrArray[attrid] = atomArr;
        this.attrName[attrid] = attrname;
    }
    
    this.getAttrName = function(attrid)
    {
        return this.attrName[attrid];
    }
    
    this.getAttrValue = function(attrid, index)
    {
        return this.attrArray[attrid][index].getValue();
    }
    
    this.setAttrValue = function(attrid, index, value)
    {
        if (this.attrArray[attrid][index]) 
        {
            this.attrArray[attrid][index].setValue(value);
        }
    }
    
    this.getAtom = function(attrid, index)
    {
        if (this.attrArray[attrid][index]) 
        {
            return this.attrArray[attrid][index];
        }
        
    }
    this.getTable = function()
    {
        return this.element;
    }
}

function validateNode(obj)
{
    var stCall = false;
    var nodeType = "";
    if (arguments.length > 1) 
    {
        stCall = arguments[1];
        nodeType = arguments[2];
    }
    
    var oedit = obj;
    oedit.maxLength = maxbyte;
    oedit.style.imeMode = "disabled"; //     ?
    oedit.onpaste = function()
    {
        return false;
    }
    
    oedit.ondrop = function()
    {
        return false;
    }
    
    oedit.onkeypress = function()
    {
        var event = EventUtil.getEvent();
        var code = (event.keyCode != 0 ? event.keyCode : event.charCode);
        if (code == 8) 
        {
            return true;
        }
        
        var objIp = oedit;
        var existstring = objIp.value;
        var curInput = String.fromCharCode(code);
        if (event.keyCode == 13) 
        {
            objIp.onblur();
        }
        if (((code < 48 || code > 57) && code != splitcharcode) ||
        (code == splitcharcode && existstring.charCodeAt(existstring.length - 1) == splitcharcode) ||
        (code == splitcharcode && existstring.length == 0)) 
        {
            return false;
        }
        
        var tagPosition = digitalTag_getPos(objIp);
        
        var str1 = existstring.substring(0, tagPosition);
        var str2 = existstring.substring(tagPosition, existstring.length);
        existstring = str1 + curInput + str2;
        
        var aryIp = existstring.split(splitchar);
        
        if (aryIp.length > 4) 
        {
            return false;
        }
        
        /* a.b.c.d              ? ?*/
        var dot1 = existstring.indexOf(splitchar);
        var dot2 = existstring.indexOf(splitchar, dot1 + 1);
        var dot3 = existstring.indexOf(splitchar, dot2 + 1);
        var dot4 = existstring.indexOf(splitchar, dot3 + 1);
        
        if (dot1 < 0) 
        {
            if (existstring.length == 3) 
            {
                objIp.value = existstring + splitchar;
                return false;
            }
            else if (existstring.length > 3 && (selectionLen(ojbIp) == 0)) 
            {
                return false;
            }
        }
        else if (dot2 < 0) 
        {
            tagPosition = digitalTag_getPos(objIp);
            if (tagPosition < dot1 && existstring.substring(0, dot1).length > 3 &&
            (selectionLen(objIp) == 0)) 
            {
                return false;
            }
            
            if (existstring.length == dot1 + 4) 
            {
                objIp.value = existstring + splitchar;
                return false;
            }
            else if (existstring.length > dot1 + 4 && (selectionLen(objIp) == 0)) 
            {
                return false;
            }
        }
        else if (dot3 < 0) 
        {
            tagPosition = digitalTag_getPos(objIp);
            if (tagPosition < dot1 && existstring.substring(0, dot1).length > 3 &&
            (selectionLen(objIp) == 0)) 
            {
                return false;
            }
            else if (tagPosition < dot2 && existstring.substring(dot1 + 1, dot2).length > 3 &&
            (selectionLen(objIp) == 0)) 
            {
                return false;
            }
            
            if (existstring.length == dot2 + 4) 
            {
                objIp.value = existstring + splitchar;
                return false;
            }
            else if (existstring.length > dot2 + 4 && (selectionLen(objIp) == 0)) 
            {
                return false;
            }
        }
        else if (dot4 < 0) 
        {
            tagPosition = digitalTag_getPos(objIp);
            if (tagPosition < dot1 && existstring.substring(0, dot1).length > 3 &&
            (selectionLen(objIp) == 0)) 
            {
                return false;
            }
            else if (tagPosition < dot2 && existstring.substring(dot1 + 1, dot2).length > 3 &&
            (selectionLen(objIp) == 0)) 
            {
                return false;
            }
            else if (tagPosition < dot3 && existstring.substring(dot2 + 1, dot3).length > 3 &&
            (selectionLen(objIp) == 0)) 
            {
                return false;
            }
            
            if (existstring.length > maxbyte) 
            {
                if ((selectionLen(objIp) == 0)) 
                {
                    return;
                }
            }
            else if (existstring.length == dot3 + 5) 
            {
                tagPosition = digitalTag_getPos(objIp);
                if (tagPosition > dot3 && (selectionLen(objIp) == 0)) 
                {
                    return;
                }
            }
        }
    }
    
    /**
     *   IP                  255       255
     */
    oedit.onkeyup = function()
    {
        var event = EventUtil.getEvent();
        var objIp = event.srcElement;
        var aryIp = objIp.value.split(splitchar);
        var errFlg = false;
        var i = 0;
        for (i = 0; i < aryIp.length; ++i) 
        {
            if (aryIp[i] != "") 
            {
                aryIp[i] = parseInt(aryIp[i], 10);
            }
            if (aryIp[i] > maxvalue) 
            {
                aryIp[i] = maxvalue;
                errFlg = true;
            }
        }
        if (errFlg) 
        {
            objIp.value = aryIp[0];
            for (i = 1; i < aryIp.length; ++i) 
            {
                objIp.value += (splitchar + aryIp[i]);
            }
        }
    }
    
    oedit.onblur = function()
    {
        var event = EventUtil.getEvent();
        
        var objIp = event.srcElement;
        if (objIp.value == "") 
        {
            alert(RESOURCE["format"]);
            objIp.value = "0.0.0.0";
            if (stCall) 
            {
                cellonblur(objIp);
            }
            ct.getAtom(nodeType, 1).setValue(objIp.value);
            return;
        }
        
        objIp.value = formFullAddr(objIp.value);
        var aryIp = objIp.value.split(splitchar);
        var errFlg = false;
        var i = 0;
        for (i = 0; i < aryIp.length; ++i) 
        {
            if (aryIp[i] > maxvalue) 
            {
                aryIp[i] = maxvalue
                errFlg = true;
            }
        }
        if (errFlg) 
        {
            objIp.value = aryIp[0];
            for (i = 1; i < aryIp.length; ++i) 
            {
                objIp.value += (splitchar + aryIp[i]);
            }
        }
        
        if (stCall) 
        {
            cellonblur(objIp);
        }
        ct.getAtom(nodeType, 1).setValue(objIp.value);
    }
}

function getDataArr()
{
    var opsary = new Array();
    opsary[0] = new Option("1Mbit/s", 1000);
    opsary[1] = new Option("2Mbit/s", 2000);
    opsary[2] = new Option("3Mbit/s", 3000);
    opsary[3] = new Option("4Mbit/s", 4000);
    opsary[4] = new Option("5Mbit/s", 5000);
    opsary[5] = new Option("6Mbit/s", 6000);
    opsary[6] = new Option("7Mbit/s", 7000);
    opsary[7] = new Option("8Mbit/s", 8000);
    opsary[8] = new Option("9Mbit/s", 9000);
    opsary[9] = new Option("10Mbit/s", 10000);
    opsary[10] = new Option("20Mbit/s", 20000);
    opsary[11] = new Option("30Mbit/s", 30000);
    opsary[12] = new Option("40Mbit/s", 40000);
    opsary[13] = new Option("50Mbit/s", 50000);
    opsary[14] = new Option("100Mbit/s", 100000);
    opsary[15] = new Option("1000Mbit/s", 1000000);
    opsary[16] = new Option(RESOURCE["nolimit"], RESOURCE["nolimit"]);
    return opsary;
}

function onblurHandler(event)
{
    if (!event) 
    {
        event = window.event;
    }
    var numobj = event.target ? event.target : event.srcElement;
    if (numobj.value == "") 
    {
        numobj.value = MIN_BANDWIDTH;
        return;
    }
    else if ((isNaN(numobj.value) && numobj.value != RESOURCE["nolimit"]) || numobj.value < MIN_BANDWIDTH) 
    {
        alert(RESOURCE["wrong"]);
        numobj.value = MIN_BANDWIDTH;
        return;
    }
}

function keyupHandler(event)
{
    if (!event) 
    {
        event = window.event;
    }
    var numobj = event.target ? event.target : event.srcElement;
    if (numobj.value > MAX_BANDWIDTH) 
    {
        alert(RESOURCE["wrong"]);
        numobj.value = MAX_BANDWIDTH;
        return;
    }
}

function keypressHandler(event)
{
    var key, keychar;
    if (!event) 
    {
        event = window.event;
        key = window.event.keyCode;
    }
    var numobj = event.target ? event.target : event.srcElement;
    
    var code = (event.keyCode != 0 ? event.keyCode : event.charCode);
    
    if (event.keyCode == 13) 
    {
        if (numobj.value == "") 
        {
            alert(RESOURCE["wrong"]);
            return false;
        }
        event.srcElement.blur();
        return true;
    }
    
    if (code == 8 || code == 46 || code == 37 || code == 39) 
    {
        return true;
    }
    
    if (code < 48 || code > 57) 
    {
        return false;
    }
    window.status = "code:" + code + "; value:" + numobj.value;
    var position = digitalTag_getPos(numobj);
    if (position == 0 && numobj.value.length > 0 && (code == 48 || code == 96)) 
    {
        return false;
    }
    
    if (numobj.value == '0' && position > 0) 
    {
        return false;
    }
    
    keychar = String.fromCharCode(key);
    if (numobj.value + keychar > MAX_BANDWIDTH) 
    {
        alert(RESOURCE["wrong"]);
        numobj.value = MAX_BANDWIDTH;
        return false;
    }
}

ComboBox.prototype.initComboBox = function(ops, str, index, flag)
{
    this.setOptions(ops);
    this.name = str;
    this.id = str;
    this.dispval = flag;
    this.setSelectedIndex(index);
    
    if (this.view.parentNode && this.view.parentNode.offsetWidth > 0) 
    {
        var wdt = this.view.parentNode.offsetWidth - 2;
        var clip = "rect(1px," + (wdt - 1) + "px,19px," + (wdt - 18) + "px)";
        
        this.txtview.style.width = wdt;
        this.selview.style.width = wdt;
        this.txtview.style.top = getPosY(this.view.parentNode);
        this.selview.style.top = getPosY(this.view.parentNode);
        this.selview.style.clip = clip;
    }
}
