var winurlobj = getParentWindow().winurlobj;
var ct;
var Tab;
var connectionst = new SortTable();

var trunkList = new Object();
var portAttriList = null;
var pwID = 0;
var doclose = false;
var INVALID = 4294967295;//    
var TYPE_LINE = 1;//    
var TYPE_EGGR = 2;//    
function PortAttri()
{
    var slotid;
    var trunkid;
    var vpi;
    var vci;
    var uniid;
}

/**
 *      
 * @param  
 * @return  
 */
function initPage()
{
    initServiceTable();
    initConnectionTable();
    initportAttrST();
    initCfgPwTable();
    
    initCfgCos();
    initTabs();
    initButton();
    
}


/**
 *      
 * @param  
 * @return  
 */
function initServiceTable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["attribute"], RESOURCE["getvalue"]);
    
    var atom = new Atom("text");
    checkText(atom.element, "1", "4294967295");
    ct.addAttrRow("serviceid", RESOURCE["serviceid"], atom);
    
    checkboxElem = document.createElement("input");
    checkboxElem.setAttribute("type", "checkbox");
    checkboxElem.className = "checkboxInput";
    checkboxElem.onclick = autoDistribute;
    ct.getAtom("serviceid").element.style.width = "70%";
    ct.getAtom("serviceid").element.parentNode.appendChild(checkboxElem);
    
    var span = document.createElement("span");
    span.innerText = RESOURCE["auto"];
    ct.getAtom("serviceid").element.parentNode.appendChild(span);
    var atom = new Atom("text");
    ct.addAttrRow("servicename", RESOURCE["servicename"], atom);
    
    atom = new Atom("select");
    atom.element.disabled = false;
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["uninni"], UNIsNNI);
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["uniuni"], UNIUNI);
    ct.addAttrRow("servicedirection", RESOURCE["servicedirection"], atom);
    atom.element.onchange = function()
    {
        changeServiceType(this.value);
    }
    
    atom = new Atom("select");
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["pvc"], CONNTYPE_PVC);
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["pvp"], CONNTYPE_PVP);
    ct.addAttrRow("connectiontype", RESOURCE["connectiontype"], atom);
    atom.element.onchange = function()
    {
        changeConnectionType(this.value);
    }
    
    atom = new Atom("text");
    atom.element.disabled = true;
    atom.setValue(RESOURCE["noneprotect"]);
    ct.addAttrRow("protecttype", RESOURCE["protecttype"], atom);
    
    $("servicetablecomponent").appendChild(ct.getTable());
}

function initConnectionTable()
{
    connectionst.head.setAttribute("id", "htmlTablebfdTHead");
    connectionst.body.setAttribute("id", "htmlTablebfdTBody");
    connectionst.setImage("../../../../../../images/");
    createTableHead(connectionst, window.tableconf[0]);
    connectionst.setBodyHeight(getComponetHeight(document.body, 100) * 0.3 + "px");
    $("connectiontablecomponent").appendChild(connectionst.getTable());
}

/**
 *      
 */
function initButton()
{
    $("okbtn").value = RESOURCE["okbutton"];
    $("applybtn").value = RESOURCE["applybutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
    $("addbtn").value = RESOURCE["addbutton"];
    $("delbtn").value = RESOURCE["deletebutton"];
    initportAttrButton();
    initCfgPwButton();
}

/**
 *      Tab 
 */
function initTabs()
{
    Tab = new EmbedTabs();
    Tab.addEmbedTab("tab1div", RESOURCE["cfgportattr"], $("tab1div"));
    
    Tab.addEmbedTab("tab2div", RESOURCE["pw"], $("tab2div"));
    Tab.addEmbedTab("tab3div", RESOURCE["cosmapping"], $("tab3div"));
    setSelectedEmbedTab("tab1div");
    
    $("embedtab").appendChild(Tab.getEmbedTabs());
    
}

function autoDistribute()
{
    var serviceId = ct.getAtom("serviceid").element;
    if (checkboxElem.checked) 
    {
        serviceId.disabled = true;
        serviceId.value = "";
    }
    else 
    {
        serviceId.disabled = false;
        serviceId.value = "1";
    }
}

function changeServiceType(type)
{
    clearData(type);
    setSelectedEmbedTab("tab1div");
    if (type == UNIUNI) 
    {
        tabHeadList["tab2div"].disabled = true;
        tabHeadList["tab3div"].disabled = true;
    }
    else 
    {
        tabHeadList["tab2div"].disabled = false;
        tabHeadList["tab3div"].disabled = false;
    }
}

function changeConnectionType(type)
{
    clearData();
}

function clearData()
{
    connectionst.clearTableData();
    portAttrST.clearTableData();
    doPwDelete();
    cfgCosst.clearTableData();
    trunkList = new Object();
    pwID = 0;
}

function doCancel()
{
    xcloseDialog();
}

function doCreate()
{
    if (checkData() == false) 
    {
        return;
    }
    $("okbtn").disabled = true;
    $("applybtn").disabled = true;
    doclose = true;
    if (ct.getAtom("servicedirection").getValue() != UNIUNI) 
    {
        createPW();
    }
    else 
    {
        doCreateATM();
    }
    
}

function doCreateATM(pwIndex)
{
    if (doCfgPort()) 
    {
        var xmlstr = createCreateATMXML(pwIndex);
        if (null == xmlstr) 
        {
            return;
        }
        loadXMLdoc("../../../../../../neExlorerServlet?sfid=" + "1023", "POST", true, handleBackCreateATM, null, "inputdata=" + xmlstr);
    }
}

function checkData()
{
    if (!checkboxElem.checked && ct.getAtom("serviceid").getValue() == "") 
    {
        alert(RESOURCE["prompt_invalidServiceID"]);
        return false;
    }
    if (connectionst.getDataRowLength() == 0) 
    {
        alert(RESOURCE["prompt_cfgconnect"]);
        return false;
    }
    if (ct.getAtom("servicedirection").getValue() != UNIUNI) 
    {
        if (cfgPwst.getDataRowLength() == 0) 
        {
            alert(RESOURCE["prompt_cfgpw"]);
            return false;
        }
        var sType = cfgPwst.getCellStoreValue(0, "serviceType", "serviceType");
        if (sType == ONETOONEVCC || sType == ONETOONEVPC) 
        {
            if (connectionst.getDataRowLength() > 1) 
            {
                alert(RESOURCE["prompt_moreconn"]);
                return false;
            }
        }
    }
}

function setTrunkLabel()
{
    portAttriList = new Array();
    for (var i = 0, size = connectionst.getDataRowLength(); i < size; i++) 
    {
        var src = connectionst.getCellStoreValue(i, "srcport", "srcport");
        var srcSlotid = src.split("-")[0];
        var srcTrunkid = connectionst.getCellStoreValue(i, "srctrunkid", "srctrunkid");
        var srcVpi = connectionst.getCellStoreValue(i, "invpi", "invpi");
        var srcVci = connectionst.getCellStoreValue(i, "invci", "invci");
        addPort(srcSlotid, srcTrunkid, srcVpi, srcVci);
        
        if (ct.getAtom("servicedirection").getValue() == UNIUNI) 
        {
            var dst = connectionst.getCellStoreValue(i, "sinkport", "sinkport");
            var dstSlotid = dst.split("-")[0];
            var dstTrunkid = connectionst.getCellStoreValue(i, "sinktrunkid", "sinktrunkid");
            var dstVpi = connectionst.getCellStoreValue(i, "outvpi", "outvpi");
            var dstVci = connectionst.getCellStoreValue(i, "outvci", "outvci");
            addPort(dstSlotid, dstTrunkid, dstVpi, dstVci);
        }
    }
}
function getPortByTrunkID(trunkid)
{
	for(var i=0;i<portAttriList.length;i++)
	{
		var port = portAttriList[i];
		if(port.trunkid==trunkid)
		{
			return port;
		}
	}
	return null;
}
function createCreateATMXML(pwIndex)
{
    setTrunkLabel();
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var connType = ct.attrArray.connectiontype.getValue();
    var row = new tagElement("row-params");
    addParam(row, newParam("neid", winurlobj["neid"]));
    addParam(row, newParam("qx", "NSCMD_PTN_ATM_ADD_SRV"));
    addParam(row, newParam("atmindex", 0));
    if (checkboxElem.checked) 
    {
        addParam(row, newParam("useautoid", 0));
    }
    else 
    {
        addParam(row, newParam("useautoid", 1));
    }
    addParam(row, newParam("serviceid", ct.attrArray.serviceid.getValue()));
    addParam(row, newParam("servicename", ct.attrArray.servicename.getValue()));
    var dir = ct.attrArray.servicedirection.getValue();
    var sType = null;
    
    if (dir == UNIUNI) 
    {
        addParam(row, newParam("servicetype", TYPE_LINE));
    }
    else 
    {
        sType = cfgPwst.getCellStoreValue(0, "serviceType", "serviceType");
        if (sType == ONETOONEVCC || sType == ONETOONEVPC) 
        {
            addParam(row, newParam("servicetype", TYPE_LINE));
        }
        else 
        {
            addParam(row, newParam("servicetype", TYPE_EGGR));
        }
    }
    bussiness.appendChild(row);
    for (var i = 0, size = portAttriList.length; i < size; i++) 
    {
        var port = portAttriList[i];
        var row = new tagElement("row-params");
        addParam(row, newParam("qx", "NSCMD_PTN_ATM_ADD_VUNI_EX"));
        addParam(row, newParam("atmindex", 0));
        addParam(row, newParam("vuniid", i + 1));
        port.uniid = i + 1;
        addParam(row, newParam("slotid", port.slotid));
        addParam(row, newParam("atmportid", port.trunkid));
        addParam(row, newParam("count", port.vpi.length));
        var tmp = "";
        for (var j = 0, l = port.vpi.length; j < l; j++) 
        {
            tmp += port.vpi[j];
            tmp += ",";
        }
        addParam(row, newParam("vpi", tmp));
        tmp = "";
        if (connType == CONNTYPE_PVC) 
        {
            for (var j = 0, l = port.vci.length; j < l; j++) 
            {
                tmp += port.vci[j];
                tmp += ",";
            }
            addParam(row, newParam("vci", tmp));
        }
        else 
        {
            tmp = "";
            for (var j = 0, l = port.vpi.length; j < l; j++) 
            {
                tmp += INVALID;
                tmp += ",";
            }
            addParam(row, newParam("vci", tmp));
        }
        if (dir == UNIUNI) 
        {
            addParam(row, newParam("portrole", 255));
        }
        else 
        {
            if (sType == ONETOONEVCC || sType == ONETOONEVPC) 
            {
                addParam(row, newParam("portrole", 255));
            }
            else 
            {
                addParam(row, newParam("portrole", 2));
            }
        }
        bussiness.appendChild(row);
    }
    var pwid = connectionst.getCellStoreValue(0, "pwid", "pwid");
    if (pwid != "-") 
    {
        var row = new tagElement("row-params");
        addParam(row, newParam("qx", "NSCMD_PTN_ATM_ADD_VNNI"));
        addParam(row, newParam("atmindex", 0));
        addParam(row, newParam("vnniid", 1));
        addParam(row, newParam("pwIndex", pwIndex));
        if (dir != UNIUNI && (sType == ONETOONEVCC || sType == ONETOONEVPC)) 
        {
            addParam(row, newParam("portrole", 255));
        }
        else 
        {
            addParam(row, newParam("portrole", 1));
        }
        bussiness.appendChild(row);
    }
    for (var i = 0, size = connectionst.getDataRowLength(); i < size; i++) 
    {
        var row = new tagElement("row-params");
        addParam(row, newParam("qx", "NSCMD_PTN_ATM_ADD_CONN"));
        addParam(row, newParam("atmindex", 0));
        addParam(row, newParam("connectionid", i + 1));
        addParam(row, newParam("inlogicporttype", PORTTYPE_UNI));
		var trunkid=connectionst.getCellStoreValue(i, "srctrunkid", "srctrunkid");
		var port=getPortByTrunkID(trunkid);
		if(port!=null)
		{
			addParam(row, newParam("inlogicportid", port.uniid));
		}
		else
		{
			addParam(row, newParam("inlogicportid", i + 1));
		}
        
        var pwid = connectionst.getCellStoreValue(i, "pwid", "pwid")
        if (pwid == "-") 
        {
            addParam(row, newParam("outlogicporttype", PORTTYPE_UNI));
            addParam(row, newParam("outlogicportid", 2));
        }
        else 
        {
            addParam(row, newParam("outlogicporttype", PORTTYPE_NNI));
            addParam(row, newParam("outlogicportid", 1));
        }
        addParam(row, newParam("invpi", connectionst.getCellStoreValue(i, "invpi", "invpi")));
        if (connType == CONNTYPE_PVC) 
        {
            addParam(row, newParam("invci", connectionst.getCellStoreValue(i, "invci", "invci")));
        }
        else 
        {
            addParam(row, newParam("invci", INVALID));
        }
        addParam(row, newParam("outvpi", connectionst.getCellStoreValue(i, "outvpi", "outvpi")));
        if (connType == CONNTYPE_PVC) 
        {
            addParam(row, newParam("outvci", connectionst.getCellStoreValue(i, "outvci", "outvci")));
        }
        else 
        {
            addParam(row, newParam("outvci", INVALID));
        }
        var upid = connectionst.getCellStoreValue(i, "uplinkpolicy", "uplinkpolicy").split("(")[0];
        var downid = connectionst.getCellStoreValue(i, "downlinkpolicy", "downlinkpolicy").split("(")[0];
        addParam(row, newParam("upid", upid));
        addParam(row, newParam("downid", downid));
        bussiness.appendChild(row);
        
        var row = new tagElement("row-params");
        addParam(row, newParam("qx", "NSCMD_PTN_ATM_SET_CONNECTION_NAME"));
        addParam(row, newParam("atmindex", 0));
        addParam(row, newParam("connectionid", i + 1));
        var name = connectionst.getCellStoreValue(i, "connectionname", "connectionname");
        addParam(row, newParam("connectionname", name));
        bussiness.appendChild(row);
    }
    di.getRoot().appendChild(bussiness);
    
    return di.toString();
}

function handleBackCreateATM(doc)
{
    $("okbtn").disabled = false;
    $("applybtn").disabled = false;
    var dinterface = EncapsulateData(doc);
    showErrorDialog(dinterface);
    if (dinterface.getSErrorCode() == 0) 
    {
        if (doclose == true) 
        {
            xcloseDialog();
        }
        else 
        {
            clearData();
        }
        getParentWindow().doQuery();
    }
}

function doApply()
{
    if (checkData() == false) 
    {
        return;
    }
    doclose = false;
    if (ct.getAtom("servicedirection").getValue() != UNIUNI) 
    {
        createPW();
    }
    else 
    {
        doCreateATM();
    }
}

function doAdd()
{
    var url = "cfgconnection.html?name=" + RESOURCE["createsource"] + "&type=ip";
    xshowModalDialog(url, RESOURCE["createsource"], 500, 350, "../../../../../../images/");
}

function doDel()
{
    var rows = connectionst.getSelectedRows();
    for (var i = 0, size = rows.length; i < size; i++) 
    {
        connectionst.deleteRow(rows[i]);
    }
    connectionst.adjustDataRows();
    
    trunkList = new Object();
    var idList = new Array();
    var trunkName = new Array();
    for (var i = 0, size = connectionst.getDataRowLength(); i < size; i++) 
    {
        var src = connectionst.getCellStoreValue(i, "srcport", "srcport");
        var dst = connectionst.getCellStoreValue(i, "sinkport", "sinkport");
        var srcSlotid = src.split("-")[0];
        var srcTrunkid = connectionst.getCellStoreValue(i, "srctrunkid", "srctrunkid");
        var srcVpi = connectionst.getCellStoreValue(i, "invpi", "invpi");
        var srcVci = connectionst.getCellStoreValue(i, "invci", "invci");
        var dstSlotid = dst.split("-")[0];
        var dstTrunkid = connectionst.getCellStoreValue(i, "sinktrunkid", "sinktrunkid");
        var dstVpi = connectionst.getCellStoreValue(i, "outvpi", "outvpi");
        var dstVci = connectionst.getCellStoreValue(i, "outvci", "outvci");
        
        if (trunkList[srcSlotid] == null) 
        {
            trunkList[srcSlotid] = new Object();
            trunkList[srcSlotid][srcTrunkid] = srcTrunkid;
            idList[idList.length] = srcSlotid + "." + srcTrunkid;
            trunkName[trunkName.length] = src;
        }
        else 
        {
            if (trunkList[srcSlotid][srcTrunkid] == null) 
            {
                trunkList[srcSlotid][srcTrunkid] = srcTrunkid;
                idList[idList.length] = srcSlotid + "." + srcTrunkid;
                trunkName[trunkName.length] = src;
            }
        }
        if (ct.getAtom("servicedirection").getValue() == UNIUNI) 
        {
            if (trunkList[dstSlotid] == null) 
            {
                trunkList[dstSlotid] = new Object();
                trunkList[dstSlotid][dstTrunkid] = dstTrunkid;
                idList[idList.length] = dstSlotid + "." + dstTrunkid;
                trunkName[trunkName.length] = dst;
            }
            else 
            {
                if (trunkList[dstSlotid][dstTrunkid] == null) 
                {
                    trunkList[dstSlotid][dstTrunkid] = dstTrunkid;
                    idList[idList.length] = dstSlotid + "." + dstTrunkid;
                    trunkName[trunkName.length] = dst;
                }
            }
        }
    }
    if (connectionst.getDataRowLength() == 0 &&
    cfgPwst.getDataRowLength() == 0) 
    {
        pwID = 0;
    }
    
    refreshTable(idList, trunkName);
}

function addPort(slotid, trunkid, vpi, vci)
{
    var tmp = null;
    for (var i = 0, size = portAttriList.length; i < size; i++) 
    {
        tmp = portAttriList[i];
        if (tmp.slotid == slotid && tmp.trunkid == trunkid) 
        {
            break;
        }
        tmp = null;
    }
    if (tmp == null) 
    {
        var port = new PortAttri();
        port.slotid = slotid;
        port.trunkid = trunkid
        port.vpi = new Array();
        port.vpi[0] = vpi;
        port.vci = new Array();
        port.vci[0] = vci;
        portAttriList[portAttriList.length] = port;
    }
    else 
    {
        tmp.vpi[tmp.vpi.length] = vpi;
        tmp.vci[tmp.vci.length] = vci;
    }
}

function showErrorDialog(data)
{
    var errArr = [];
    openErrPage("../../../../../../page/", data.getError(), errArr);
}

/**
 *         
 * @param {Object} id  slot.trunkid
 */
function refreshPortTable(id, trunkName, vpi, vci)
{
    if (trunkList[id.split(".")[0]] != null && trunkList[id.split(".")[0]][id.split(".")[1]] != null) 
    {
        return;
    }
    if (trunkList[id.split(".")[0]] != null) //    
    {
        trunkList[id.split(".")[0]][id.split(".")[1]] = id;
    }
    else 
    {
        trunkList[id.split(".")[0]] = new Object();
        trunkList[id.split(".")[0]][id.split(".")[1]] = id;
    }
    queryTrunk(id, trunkName);
}

/**
 *     
 * @param {Object} data      
 */
function addConnection(data)
{
    createTableRow(connectionst, window.tableconf[0], data, RESOURCE);
}

function refreshPWID(id)
{
    pwID = id;
    var l = connectionst.getDataRowLength();
    for (var i = 0; i < l; i++) 
    {
        var cell = connectionst.getCell(i, "pwid");
        connectionst.setCellValue(cell, "pwid", id);
        connectionst.getCellShow(i, "pwid").setValue(id);
    }
}
