var winurlobj = getParentWindow().winurlobj;
var cfgPwst = new SortTable();
var neid = winurlobj.neid;
var nmUser = winurlobj.nmUser;
var pwID = 0;
var expValue = 255;
var cfgPwtc;
var tType = [];
tType["NSCMD_CFG_MPLS_GET_TUNNEL"] = TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL;
tType["NSCMD_CFG_GRE_TNL_GET_TUNNEL"] = TECMDCODE_PTN_GRETUNNEL_QUERY;
tType["NSCMD_CFG_IP_TNL_GET_TUNNEL"] = TECMDCODE_PTN_IPTUNNEL_QUERY;


function initCfgPwTable()
{
    cfgPwst.head.setAttribute("id", "htmlTablebfdTHead");
    cfgPwst.body.setAttribute("id", "htmlTablebfdTBody");
    cfgPwst.setImage("../../../../../../images/");
    cfgPwtc = window.tableconf[2];
    createTableHead(cfgPwst, cfgPwtc);
    cfgPwst.element.oncontextmenu = popupMenuHandler;
    cfgPwst.setOnCellEditHandler(cellEditHandler);
    var height = getTableHeight(document.getElementById("cfgpwattr"), cfgPwst) / 4;
    cfgPwst.setBodyHeight(height + "px");
    $("cfgpwattr").appendChild(cfgPwst.getTable());
}

function doPwCreate()
{
    var serviceType = parent.ct.getAtom("servicedirection").getValue();
    if (serviceType == UNIUNI) 
    {
        alert(RESOURCE["prompt_notsupportpw"]);
        return;
    }
    pwID = parent.pwID;
    if (SYSTEMCONF.getLanguage() == "en") 
    {
        xshowModalDialog("createpw.html", RESOURCE["createpw"], 680, 420, "../../../../../../images/");
        
    }
    else 
    {
        xshowModalDialog("createpw.html", RESOURCE["createpw"], 680, 400, "../../../../../../images/");
    }
}

function createPW()
{
    if (cfgPwst.getDataRowLength() == 0) 
    {
        return;
    }
    var xmlstr = createCreatePWXML();
    if (null == xmlstr) 
    {
        return;
    }
    loadXMLdoc("../../../../../../neExlorerServlet?sfid=" + "1027", "POST", true, handleBackCreatePW, null, "inputdata=" + xmlstr);
}

function addCellListener()
{
    if (cfgPwst.getDataRowLength() == 0) 
    {
        return;
    }
    
    var cell = cfgPwst.getCellEdit(i, "pwID");
    textCheck(cell.element, "1", "4294967295");
    
    cell = cfgPwst.getCellEdit(i, "oppositeLsrID");
    validateIp(cell.element, true);
    
    cfgPwst.getCell(0, "tunnelid").element.ondblclick = function()
    {
        var type = cfgPwst.getCellStoreValue(0, "tunneltype", "tunneltype");
        if (SYSTEMCONF.getLanguage() == "en") 
        {
            xshowModalDialog("selecttunnel.html?tunnelType=" + tType[type], RESOURCE["resourceselected"], 580, 250, "../../../../../../images/");
        }
        else 
        {
            xshowModalDialog("selecttunnel.html?tunnelType=" + tType[type], RESOURCE["resourceselected"], 580, 200, "../../../../../../images/");
        }
    }
}

function cellEditHandler(param)
{
    var rowIndex = param.rowindex;
    var minLabel = 16;
    var maxLabel = 1048575;
    var pwEncapType = parseInt(cfgPwst.getCellStoreValue(rowIndex, "pwEncapsType", "pwEncapsType"));
    if (pwEncapType == 2) 
    {
        minLabel = 49153;
        maxLabel = 50176;
    }
    
    if (param.colid == "pwIngressLabel" && param.stage == TABLE_CONSTANT.BEFOREEDIT) 
    {
        var cell = cfgPwst.getCellEdit(rowIndex, "pwIngressLabel");
        textCheck(cell.element, minLabel, maxLabel);
    }
    
    if (param.colid == "pwEgressLabel" && param.stage == TABLE_CONSTANT.BEFOREEDIT) 
    {
        var cell = cfgPwst.getCellEdit(rowIndex, "pwEgressLabel");
        textCheck(cell.element, minLabel, maxLabel);
    }
    
    if (param.colid == "pwID") 
    {
        var pwID = cfgPwst.getCellStoreValue(0, "pwID", "pwID");
        parent.refreshPWID(pwID);
    }
}

function handleBackCreatePW(doc)
{
    parent.$("okbtn").disabled = false;
    parent.$("applybtn").disabled = false;
    var dinterface = EncapsulateData(doc);
    showErrorDialog(dinterface);
    if (dinterface.getSErrorCode() == 0) 
    {
        var row = dinterface.getDataRow(0);
        var pwIndex = row.pwIndex.value;
        parent.doCreateATM(pwIndex);
    }
}

function createCreatePWXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("vnniID", 1));
    rowparams.appendChild(createTagElement("role", cfgPwst.getCellStoreValue(0, "role", "role")));
    rowparams.appendChild(createTagElement("carrierType", LOAD_TYPE_PW));
    rowparams.appendChild(createTagElement("carrierID1", INVALID_LABEL_VALUE_2));
    rowparams.appendChild(createTagElement("carrierID2", INVALID_LABEL_VALUE_2));
    rowparams.appendChild(createTagElement("carrierID3", INVALID_LABEL_VALUE_2));
    
    rowparams.appendChild(createTagElement("pwSignalType", cfgPwst.getCellStoreValue(0, "pwSignalType", "pwSignalType")));
    rowparams.appendChild(createTagElement("pwType", cfgPwst.getCellStoreValue(0, "serviceType", "serviceType")));
    
    var pwID = cfgPwst.getCellStoreValue(0, "pwID", "pwID");
    rowparams.appendChild(createTagElement("pwID", pwID));
    rowparams.appendChild(createTagElement("direction", cfgPwst.getCellStoreValue(0, "direction", "direction")));
    rowparams.appendChild(createTagElement("pwIngressLabel", cfgPwst.getCellStoreValue(0, "pwIngressLabel", "pwIngressLabel")));
    rowparams.appendChild(createTagElement("pwEgressLabel", cfgPwst.getCellStoreValue(0, "pwEgressLabel", "pwEgressLabel")));
    rowparams.appendChild(createTagElement("oppositeLsrID", cfgPwst.getCellStoreValue(0, "oppositeLsrID", "oppositeLsrID")));
    var tunnelIndexHex = tenToHex(cfgPwst.getCellStoreValue(0, "tunnelindex", "tunnelindex"));
    for (var i = tunnelIndexHex.length; i < 8; i++) 
    {
        tunnelIndexHex = "0" + tunnelIndexHex;
    }
    rowparams.appendChild(createTagElement("tunnelIndexes", tunnelIndexHex));
    rowparams.appendChild(createTagElement("pwEncapsType", cfgPwst.getCellStoreValue(0, "pwEncapsType", "pwEncapsType")));
    rowparams.appendChild(createTagElement("enableState", cfgPwst.getCellStoreValue(0, "enableState", "enableState")));
    rowparams.appendChild(createTagElement("controlWord", cfgPwst.getCellStoreValue(0, "controlWord", "controlWord")));
    rowparams.appendChild(createTagElement("ctrlChanType", cfgPwst.getCellStoreValue(0, "ctrlChanType", "ctrlChanType")));
    rowparams.appendChild(createTagElement("vccv", cfgPwst.getCellStoreValue(0, "vccv", "vccv")));
    
    rowparams.appendChild(createTagElement("idirection", INGRESS));
    rowparams.appendChild(createTagElement("exp", expValue));
    rowparams.appendChild(createTagElement("maxcount", cfgPwst.getCellStoreValue(0, "maxcount", "maxcount")));
    rowparams.appendChild(createTagElement("maxtime", cfgPwst.getCellStoreValue(0, "maxtime", "maxtime")));
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function showErrorDialog(data)
{
    var errArr = [];
    openErrPage("../../../../../../page/", data.getError(), errArr);
}

function doCfgQos()
{
    if (SYSTEMCONF.getLanguage() == "en") 
    {
    
        xshowModalDialog("cfgqos.html", RESOURCE["cfgqos"], 700, 200, "../../../../../../images/");
    }
    else 
    {
    	xshowModalDialog("cfgqos.html", RESOURCE["cfgqos"], 700, 215, "../../../../../../images/");
    }
}

function doPwDelete()
{
    if (cfgPwst.getDataRowLength() == 0) 
    {
        return;
    }
    cfgPwst.clearTableData();
    $("newbtn").disabled = false;
    $("cfgqosbtn").disabled = true;
    $("delpwbtn").disabled = true;
}

function initCfgPwButton()
{
    $("newbtn").value = RESOURCE["newbutton"];
    $("cfgqosbtn").value = RESOURCE["cfgqosbutton"];
    $("delpwbtn").value = RESOURCE["deletebutton"];
    $("cfgqosbtn").disabled = true;
    $("delpwbtn").disabled = true;
}

function setTunnel(tunnelIndex, tunnel, sinkNode)
{
    var cell = cfgPwst.getCell(0, "tunnelindex");
    cfgPwst.setCellValue(cell, "tunnelindex", tunnelIndex);
    
    var cell = cfgPwst.getCell(0, "tunnelid");
    cfgPwst.setCellValue(cell, "tunnelid", tunnel);
    cfgPwst.getCellShow(0, "tunnelid").setValue(tunnel);
    
    var cell = cfgPwst.getCell(0, "oppositeLsrID");
    cfgPwst.setCellValue(cell, "oppositeLsrID", convertIPStrToLong(sinkNode));
    cfgPwst.getCellShow(0, "oppositeLsrID").setValue(sinkNode);
}
