var winurlobj = getParentWindow().winurlobj;
var portAttrST = new SortTable();
var tableCfg;
var isPortAttrModify = false;
function initportAttrST()
{
    portAttrST.head.setAttribute("id", "htmlTablebfdTHead");
    portAttrST.body.setAttribute("id", "htmlTablebfdTBody");
    portAttrST.setImage("../../../../../../images/");
    tableCfg = window.tableconf[1];
    createTableHead(portAttrST, tableCfg);
    portAttrST.element.oncontextmenu = popupMenuHandler;
    var height = getTableHeight(document.getElementById("cfgportattr"), portAttrST) / 4;
    portAttrST.setBodyHeight(height + "px");
    $("cfgportattr").appendChild(portAttrST.getTable());
    portAttrST.setOnCellEditHandler(portCellEditHandler);
}

function initportAttrButton()
{
    $("queryPortAttrbtn").value = RESOURCE["querybutton"];
}

function valueChanged()
{
    isPortAttrModify = true;
}

function doQueryPortAttr()
{
    var idList = new Array();
    var nameList = new Array();
    for (var i = 0, size = portAttrST.getDataRowLength(); i < size; i++) 
    {
        var name = portAttrST.getCellStoreValue(i, "portname", "portname");
        var id = portAttrST.getCellStoreValue(i, "trunckid", "trunckid");
        idList[idList.length] = name.split("-")[0] + "." + id;
        nameList[nameList.length] = name;
    }
    refreshTable(idList, nameList);
}

/**
 *              
 * @param {Object} idList
 */
function refreshTable(idList, nameList)
{
    if (idList.length == 0) 
    {
        portAttrST.clearTableData();
        return;
    }
    var xmlstr = createPortQueryXML(idList);
    loadXMLdoc("../../../../../../neExlorerServlet?sfid=" + "1025", "POST", true, handleBackRefresh, nameList, "inputdata=" + xmlstr);
}

function handleBackRefresh(doc, nameList)
{
    portAttrST.clearTableData();
    handleBackPortQuery(doc, nameList);
}

/**
 *   trunk  
 * @param {Object} id  slotid.trunkid
 */
function queryTrunk(id, trunkName)
{
    var idList = new Array();
    idList[0] = id;
    var nameList = new Array();
    nameList[0] = trunkName;
    var xmlstr = createPortQueryXML(idList);
    if (null == xmlstr) 
    {
        return;
    }
    loadXMLdoc("../../../../../../neExlorerServlet?sfid=" + "1025", "POST", true, handleBackPortQuery, nameList, "inputdata=" + xmlstr);
}

function createPortQueryXML(idList)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    for (var i = 0, size = idList.length; i < size; i++) 
    {
        var row = new tagElement("row-params");
        addParam(row, newParam("neid", winurlobj["neid"]));
        addParam(row, newParam("slotid", idList[i].split(".")[0]));
        addParam(row, newParam("trunckid", idList[i].split(".")[1]));
        bussiness.appendChild(row);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackPortQuery(doc, nameList)
{
    var dinterface = EncapsulateData(doc);
    showErrorDialog(dinterface);
    if (dinterface.getSErrorCode() != 0) 
    {
        return;
    }
    for (var i = 0, len = dinterface.getDataRowLength(); i < len; i++) 
    {
        var datavalue = new Array();
        datavalue[datavalue.length] = dinterface.getDataRow(i).slotid.value;
        datavalue[datavalue.length] = nameList[i];
        datavalue[datavalue.length] = dinterface.getDataRow(i).trunckid.value;
        datavalue[datavalue.length] = "UNI"
        datavalue[datavalue.length] = dinterface.getDataRow(i).maxvpi.value;
        datavalue[datavalue.length] = dinterface.getDataRow(i).maxvci.value;
        datavalue[datavalue.length] = dinterface.getDataRow(i).supportvcc.value;
        createTableRow(portAttrST, tableCfg, datavalue, RESOURCE);
    }
}

function porttype(param)
{
    return "UNI";
}

function doCfgPort()
{
    if (isPortAttrModify) 
    {
        var xmlstr = createCfgXML();
        if (null == xmlstr) 
        {
            return true;
        }
        loadXMLdoc("../../../../../../neExlorerServlet?sfid=" + "1026", "POST", false, handleBackCfg, null, "inputdata=" + xmlstr);
	    return !isPortAttrModify;
    }
	else
	{
		return true;
	}
}

function createCfgXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var len = portAttrST.getDataRowLength();
    for (var i = 0; i < len; i++) 
    {
        if (!portAttrST.getModify(i)) 
        {
            continue;
        }
        var row = new tagElement("row-params");
        addParam(row, newParam("neid", winurlobj["neid"]));
        addParam(row, newParam("slotid", portAttrST.getCellStoreValue(i, "slotid", "slotid")));
        addParam(row, newParam("trunckid", portAttrST.getCellStoreValue(i, "trunckid", "trunckid")));
        addParam(row, newParam("maxvpi", portAttrST.getCellStoreValue(i, "maxvpi", "maxvpi")));
        addParam(row, newParam("maxvci", portAttrST.getCellStoreValue(i, "maxvci", "maxvci")));
        addParam(row, newParam("supportvcc", portAttrST.getCellStoreValue(i, "supportvcc", "supportvcc")));
        bussiness.appendChild(row);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackCfg(doc)
{
    var dinterface = EncapsulateData(doc);
    if (dinterface.getSErrorCode() != 0) 
    {
        isPortAttrModify = true;
        showErrorDialog(dinterface);
        return;
    }
    isPortAttrModify = false;
    refreshTableState(portAttrST, tableCfg, dinterface);
}

function portCellEditHandler(param)
{
    isPortAttrModify = true;
    if (((param.colid == "supportvcc") && (param.stage == TABLE_CONSTANT.BEFOREEDIT))) 
    {
        var degtime = portAttrST.getCellEdit(param.rowindex, param.colid).element;
        
        degtime.style.imeMode = "disabled";
        
        degtime.onpaste = function()
        {
            return false;
        }
        
        degtime.onkeypress = function()
        {
            return digitalCheck(degtime, "0", "4096");
        }
    }
}

function showErrorDialog(data)
{
    var errArr = [];
    openErrPage("../../../../../../page/", data.getError(), errArr);
}
