var st = null;

var win = getParentWindow();
if (!isIE) {
    win = win.frames[1];
}
var neid = win.neid;
var nmUser = win.nmUser;



var type = getNeProperty(self).type;
var tunnelType = parseInt(getNeProperty(self).tunnelType);
loadXMLdoc("../../../../../conf/system.xml", "GET", false, EncapsulateSConf);
if (tunnelType == MPLS_TUNNEL) {
    loadXMLdoc("../../conf/apsmgr_u2kv1r3c00/selecttunneltable_mpls_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable, null);
}
else {
    loadXMLdoc("../../conf/apsmgr/selecttunneltable_ipgre_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable, null);
}


function init(){
    initTable();
    initButton();
    initTunnelData();
}

function initTable(){
    st = new SortTable();
    st.setImage("../../../../../images/");
    st.setSingleChoiceFlg(true);
    createTableHead(st, window.tableconf[0]);
    $("tbdiv").appendChild(st.getTable());
    
    st.setBodyHeight(getTableHeight($("tbdiv"), st) + "px");
}

function initButton(){
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
}

function initTunnelData(){
    var tunnel = null;
    var tunnelRes = win.win.tunnelList;
    var linkTunnel = "";
    var linkTunnelType = 0;
    var nodeType = 0;
    var tunnelList = new Array();

    switch (type) 
    {
        case "workingingresstunnelid":
            linkTunnel = "protectioningresstunnelid";
            linkTunnelType = parseInt(win.ct.getAtom("protectiontunneltype").getValue());
            nodeType = 1;
            for (var i = 0, m = tunnelRes.length; i < m; i++) 
            {
            	 tunnel = tunnelRes[i];
            	 if (tunnel.direction == 1) 
            	 {
            	 	   tunnelList[tunnelList.length] = tunnel;
            	 }
            	 else if (nodeType == parseInt(tunnel.nodeType)) 
            	 {
            	 	   tunnelList[tunnelList.length] = tunnel;
            	 }
            }
            break;
        case "workingegresstunnelid":
            linkTunnel = "protectionegresstunnelid";
            linkTunnelType = parseInt(win.ct.getAtom("protectiontunneltype").getValue());
            nodeType = 3; //egress
            for (var i = 0, m = tunnelRes.length; i < m; i++) 
            {
            	 tunnel = tunnelRes[i];
            	 if (tunnel.direction == 1) 
            	 {
            	 	   tunnelList[tunnelList.length] = tunnel;
            	 }
            	 else if (nodeType == parseInt(tunnel.nodeType)) 
            	 {
            	 	   tunnelList[tunnelList.length] = tunnel;
            	 }
            }
            break;
        case "protectioningresstunnelid":
            linkTunnel = "workingingresstunnelid";
            linkTunnelType = parseInt(win.ct.getAtom("workingtunneltype").getValue());
            nodeType = 1; // ingress
            
            for (var i = 0, m = tunnelRes.length; i < m; i++) 
            {
            	 tunnel = tunnelRes[i];
            	 var workingressatom = win.ct.getAtom("workingingresstunnelid");
            	 var workegressatom = win.ct.getAtom("workingegresstunnelid");
            	 var tunnels = workingressatom.getValue().split("-");
            	 var tunnelIndex = parseInt(tunnels[0]);
            	   
            	 if (tunnel.tunnelIndex == tunnelIndex)
            	 {
            	 	 continue;
            	 }
            	 /*
            	 if (!((tunnel.srcNode == parseInt(tunnels[1]) && tunnel.snkNode == parseInt(tunnels[2]) )
            	 	   || (tunnel.srcNode == parseInt(tunnels[2]) && tunnel.snkNode == parseInt(tunnels[1]))))
            	 {
            	 	   continue;
            	 }
            	 */
            	 if(tunnel.direction == 0 && tunnel.nodeType == 3)
            	 {
            	 		 continue;
            	 }
            	 
            	 tunnelList[tunnelList.length] = tunnel;
            	
            }
            break;
        case "protectionegresstunnelid":
            linkTunnel = "workingegresstunnelid";
            linkTunnelType = parseInt(win.ct.getAtom("workingtunneltype").getValue());
            nodeType = 3; //egress
            for (var i = 0, m = tunnelRes.length; i < m; i++) 
            {
            	 tunnel = tunnelRes[i];
            	 var workingressatom = win.ct.getAtom("workingingresstunnelid");
            	 var workegressatom = win.ct.getAtom("workingegresstunnelid");
            	 var tunnels = workegressatom.getValue().split("-");
            	 var tunnelIndex = parseInt(tunnels[0]);
            	 
            	 if (tunnel.tunnelIndex == tunnelIndex)
            	 {
            	 	 continue;
            	 }
            	 /*
            	 if (!((tunnel.srcNode == parseInt(tunnels[1]) && tunnel.snkNode == parseInt(tunnels[2]) )
            	 	   || (tunnel.srcNode == parseInt(tunnels[2]) && tunnel.snkNode == parseInt(tunnels[1]))))
            	 {
            	 	   continue;
            	 }
            	 */
            	 if(tunnel.direction == 0 && tunnel.nodeType == 1)
            	 {
            	 		 continue;
            	 }
            	 
            	 tunnelList[tunnelList.length] = tunnel;
            	
            	
            }
            break;
        default:
            break;
    }
    
   
    
    if (tunnelList.length > 0) 
    {
        var di = document.createElement("datainterface");
        var bussiness = document.createElement("bussiness-params");
        for (var j = 0, n = tunnelList.length; j < n; j++) 
        {
            var rowparams = document.createElement("row-params");
            var tunnelObj = tunnelList[j];
            
            rowparams.appendChild(createParamElement("tunnelindex", tunnelObj.tunnelIndex));
            rowparams.appendChild(createParamElement("tunnelid", tunnelObj.tunnelId));
            rowparams.appendChild(createParamElement("nodetype", tunnelObj.nodetype));
            rowparams.appendChild(createParamElement("tunnelname", tunnelObj.tunnelName));
            rowparams.appendChild(createParamElement("bandwidth", tunnelObj.bandwidth));
            rowparams.appendChild(createParamElement("srcnode", tunnelObj.srcNode));
            rowparams.appendChild(createParamElement("snknode", tunnelObj.snkNode));
            rowparams.appendChild(createParamElement("tunneldirection", RESOURCE["direction_" + tunnelObj.direction]));
            bussiness.appendChild(rowparams);
        }
        di.appendChild(bussiness);
        
        createTableBody(st, window.tableconf[0], EncapsulateData(di), RESOURCE);
    }
}



function doSelect(){
	
    var tunnelIndex = 0xFFFFFFFF;
    var tunnelName = "";
    var tunnel = "";
    var tunneldirection = "";
    if (st.getSelectedRowCount() == 1) {
        var index = st.getSelectedRows()[0];
        tunnelIndex = st.getCellCurrentValue(index, "tunnelindex", "tunnelindex");
        tunneldirection = st.getCellCurrentValue(index, "tunneldirection", "tunneldirection");
        tunnel += st.getCellCurrentValue(index, "tunnelid", "tunnelid") + "(";
        if (tunnelType == MPLS_TUNNEL) 
        {
            tunnelIndex += "-" + st.getCellCurrentValue(index, "srcnode", "srcnode");
            tunnel += RESOURCE["srcnode"] + ":" + st.getCellShow(index, "srcnode").element.innerHTML + ",";
            if(st.getCellCurrentValue(index, "tunnelname", "tunnelname")!= undefined)
            {
            	tunnelName += st.getCellCurrentValue(index, "tunnelname", "tunnelname");
            }
            
        }
        tunnelIndex += "-" + st.getCellCurrentValue(index, "snknode", "snknode");
        tunnel += RESOURCE["snknode"] + ":" + st.getCellShow(index, "snknode").element.innerHTML + ")";
        win.workingtunneltype = st.getCellCurrentValue(index, "nodetype", "nodetype");
        win.protectiontunneltype = st.getCellCurrentValue(index, "nodetype", "nodetype");
    }
    
    var atom = win.ct.getAtom(type);
    atom.clearOptions();
    atom.addOption(tunnel, tunnelIndex);
    if (tunnelType != MPLS_TUNNEL) {
        var tmpType = type == "workingingresstunnelid" ? "workingegresstunnelid" : "workingingresstunnelid";
        atom = win.ct.getAtom(tmpType);
        atom.clearOptions();
        atom.addOption(tunnel, tunnelIndex);
    }
    else {
        win.ct.getAtom(type.substring(0, type.length - 2) + "name").setValue(tunnelName);
    }
    
    
    if (tunneldirection == RESOURCE["direction_1"]) {
        if (type == "workingingresstunnelid") 
        {
            var atom = win.ct.getAtom("workingegresstunnelid");
            atom.clearOptions();
            atom.addOption(tunnel, tunnelIndex);
            win.ct.getAtom("workingegresstunnelname").setValue(tunnelName);
        }
        else  if (type == "workingegresstunnelid") 
        {
                var atom = win.ct.getAtom("workingingresstunnelid");
                atom.clearOptions();
                atom.addOption(tunnel, tunnelIndex);
                win.ct.getAtom("workingingresstunnelname").setValue(tunnelName);
        }
				else if (type == "protectioningresstunnelid") 
				{
                    var atom = win.ct.getAtom("protectionegresstunnelid");
                    atom.clearOptions();
                    atom.addOption(tunnel, tunnelIndex);
                    win.ct.getAtom("protectionegresstunnelname").setValue(tunnelName);
         }
         else  if (type == "protectionegresstunnelid") 
         {
                        var atom = win.ct.getAtom("protectioningresstunnelid");
                        atom.clearOptions();
                        atom.addOption(tunnel, tunnelIndex);
                        win.ct.getAtom("protectioningresstunnelname").setValue(tunnelName);
          }
    }
    xcloseDialog();
}

window.onresize = function(){
    st.setBodyHeight(getTableHeight($("tbdiv"), st) + "px");
};
