var START_PROTOCOL = 16;
var STOP_PROTOCOL = 16;
var QUERY_SWTICH_STATUS = 16;
var CLEAR  = 16;
var FORCE_SWTICH = 16;
var MANUAL_SWTICH_WORK = 16;
var EXERCISE_SWTICH = 16;
var LOCKOUT_PROTECT = 16;
var CLEAR_SLAVE = 16;

var nmUser = parent.obj.nmUser;

var btnRightArr = new Object();
var countObj = null;
var parisCountObj = null;

getResourse("../../res/apsmgr/apsmgrres_" + SYSTEMCONF.getLanguage() + ".xml");
loadXMLdoc("../../conf/apsmgr_u2kv1r3c00/protectgrouptable_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable, null);
loadXMLdoc("../../conf/apsmgr_u2kv1r3c00/paristable_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable, null);

var proType = [];
proType[0] = RESOURCE["pwprotype0"];
proType[1] = RESOURCE["pwprotype1"];
proType[2] = RESOURCE["pwprotype2"];
proType[3] = RESOURCE["pwprotype3"];
proType[4] = RESOURCE["pwprotype4"];
proType[5] = RESOURCE["pwprotype5"];
proType[6] = RESOURCE["pwprotype6"];

var protectmode = [];
protectmode[0] = RESOURCE["protectmode0"];
protectmode[1] = RESOURCE["protectmode1"];
protectmode[2] = RESOURCE["protectmode2"];

var switchmode = [];
switchmode[0] = RESOURCE["SWTICH_MODE0"];
switchmode[1] = RESOURCE["SWTICH_MODE1"];

var rvtmode = [];
rvtmode[0] = RESOURCE["NO_RECOVERY_MODE"];
rvtmode[1] = RESOURCE["RECOVERY_MODE"];

var enablestatus = [];
enablestatus[0] = RESOURCE["disabled"];
enablestatus[1] = RESOURCE["enabled"];

var validstatus = [];
validstatus[1] = RESOURCE["valid"];
validstatus[0] = RESOURCE["invalidvalue"];

var pwswitchstatus = [];
pwswitchstatus[0] = RESOURCE["protection"];
pwswitchstatus[1] = RESOURCE["working"];
var protectTable;
var pairsTable;

var pwtype = [];//PW  
pwtype[3] = "pwType_3";//ATM  
pwtype[4] = "pwType_4";//  Tag  
pwtype[5] = "pwType_5";//  
pwtype[9] = "pwType_9";//ATM n:1 VCC    
pwtype[10] = "pwType_10";//ATM n:1 VPC    
pwtype[12] = "pwType_12";//ATM 1:1 VCC    
pwtype[13] = "pwType_13";//ATM 1:1 VPC    
pwtype[17] = "pwType_17";//SATop
pwtype[21] = "pwType_21";//CESoPSN
pwtype[25] = "pwType_25";//ABIS

var pwProtocolStatus = [];
pwProtocolStatus[0] = RESOURCE[switchStatus[0]];
pwProtocolStatus[1] = RESOURCE[switchStatus[1]];
pwProtocolStatus[2] = RESOURCE[switchStatus[2]];
pwProtocolStatus[3] = RESOURCE[switchStatus[3]];
pwProtocolStatus[4] = RESOURCE[switchStatus[4]];
pwProtocolStatus[5] = RESOURCE[switchStatus[5]];
pwProtocolStatus[6] = RESOURCE[switchStatus[6]];
pwProtocolStatus[7] = RESOURCE[switchStatus[7]];
pwProtocolStatus[8] = RESOURCE[switchStatus[8]];
pwProtocolStatus[9] = RESOURCE[switchStatus[9]];
pwProtocolStatus[10] = RESOURCE[switchStatus[10]];
pwProtocolStatus[11] = RESOURCE[switchStatus[11]];
pwProtocolStatus[12] = RESOURCE[switchStatus[12]];
pwProtocolStatus[13] = RESOURCE[switchStatus[13]];
pwProtocolStatus[14] = RESOURCE[switchStatus[14]];
pwProtocolStatus[15] = RESOURCE[switchStatus[15]];
pwProtocolStatus[255] = RESOURCE[switchStatus[255]];


function initRight()
{
    btnRightArr.queryBtn = new BtnRightObj("queryBtn", TECMDCODE_IPPTN_QUERY_TUNNEL_PG);
    btnRightArr.applyBtn = new BtnRightObj("applyBtn", TECMDCODE_IPPTN_ADD_TUNNEL_PG);
    /**
     * DTS2011062801408 
     *          
     */
    btnRightArr.deletePWAPSBtn = new BtnRightObj("deletePWAPSBtn", TECMDCODE_IPPTN_DEL_TUNNEL_PG);
    btnRightArr.functionBtn = new BtnRightObj("functionBtn", TECMDCODE_IPPTN_DEL_TUNNEL_PG);
    btnRightArr.deletebtn = new BtnRightObj("deletebtn", TE_F_CMD_MSTPPLUS_PW_DEL_APSPAIR);
    
    getRightInfo(parent.obj, btnRightArr);
}

/**
 *             
 * 
 * @param  
 * @return  
 */
function cellEditHandler(param)
{
	$("applyBtn").disabled = !btnRightArr.applyBtn.right;
	
	var rowid = param.rowindex;
	if( param.colid == "rvtmode" )
	{
		var rvtmodeValue = protectTable.getCellStoreValue(rowid, "rvtmode", "rvtmode");
		var wtrtimeCell = protectTable.getCell(rowid, "wtrtime");
		var wtrtimeCellShow = protectTable.getCellShow(rowid, "wtrtime");
		var wtrtimeValue = protectTable.getCellStoreValue(rowid, "wtrtime", "wtrtime");
		
		if( rvtmodeValue == "1" )
		{
			protectTable.setCellIsEdit(wtrtimeCell, true);
			wtrtimeCellShow.setValue(wtrtimeValue);
		}
		else
		{
			protectTable.setCellIsEdit(wtrtimeCell, false);
			wtrtimeCellShow.setValue("-");
		}		
	}
}

	
		
/**
 *      
 * 
 * @param  
 * @return  
 */
function initBody()
{
	initTable();
	initCountObj();
	initButton();
	initRight();
	$("functionBtn").disabled = true;
	$("applyBtn").disabled = true;
	if (btnRightArr.queryBtn.right) 
	{
		queryPG();
	}
}


/**
 *          
 * 
 * @param  
 * @return  
 */
function initButton()
{
	$("queryBtn").value = RESOURCE["querybutton"];
	$("applyBtn").value = RESOURCE["applybutton"];
	$("functionBtn").value = RESOURCE["functionBtn"];
	$("deletePWAPSBtn").value = RESOURCE["deletebutton"];
	$("queryParisBtn").value = RESOURCE["querybutton"];
	$("deletebtn").value = RESOURCE["deletebutton"];
	
}


/**
 *      
 * 
 * @param  
 * @return  
 */
function queryPG()
{
	$("queryBtn").disabled = true;
	$("applyBtn").disabled = true;
	$("functionBtn").disabled = true;
	$("queryParisBtn").disabled = true;
	$("deletebtn").disabled = true;
	$("deletePWAPSBtn").disabled = true;
	var url = "../../../../../neExlorerServlet?sfid=" + TE_F_CMD_MSTPPLUS_PW_QUERY_APS
			+ "&nmUser=" + parent.obj.nmUser;
			
	loadXMLdoc(url, "POST", true, callbackQueryPG, null, "inputdata="
			+ createQueryPGXMLInfo());
}

/**
 *             
 * 
 * @param doc:          
 * @return  
 */
function callbackQueryPGParis(doc)
{
	var data = EncapsulateData(doc);
 
	if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
  {
		 for (var i = 0, m = data.getDataRowLength(); i < m; i++) 
    {
        var apsId = parseInt(data.getDataRowParam(i, "apsid"));
        if(apsId == 0)
        {
        	 data.removeDataRowAt(i);
        }
    }
		pairsTable.clearTableData();
		createTableBody(pairsTable, window.tableconf[1], data, RESOURCE);
  }
  
   
  $("queryParisBtn").disabled = false;

}



/**
 *             
 * 
 * @param doc:          
 * @return  
 */
function callbackQueryPG(doc)
{
	
	var data = EncapsulateData(doc);
	var errObj = null;
	
	if (0 == data.getSErrorCode() || 1 == data.getSErrorCode())
	{
		protectTable.clearTableData();
		pairsTable.clearTableData();
		fillTableData(data, true);
		
		for (var i = 0, m = protectTable.getDataRowLength(); i < m; i++) 
		{
			var rvtmodeValue = protectTable.getCellStoreValue(i, "rvtmode", "rvtmode");
			var wtrtimeCell = protectTable.getCell(i, "wtrtime");
			var wtrtimeCellShow = protectTable.getCellShow(i, "wtrtime");
			var wtrtimeValue = protectTable.getCellStoreValue(i, "wtrtime", "wtrtime");
			if( rvtmodeValue == "0" )
			{
				protectTable.setCellIsEdit(wtrtimeCell, false);
				wtrtimeCellShow.setValue("-");
			}
		}
	}
	else
	{
		errObj = [];
		errObj.push("nename");
	}

	showOperResult(data, errObj);
	$("queryBtn").disabled = false;
}


/**
 *       
 * 
 * @param data:           
 *            errArr:       
 * @return  
 */
function showOperResult(data, errArr)
{
	if (null == errArr)
	{
		errArr = [];//            
		errArr[0] = "groupid";//            

		for ( var i = 0, len = data.getBErrLength(); i < len; i++)
		{
			temp = data.getError().rowErrors[i].errorObj["groupid"];
			if (null == temp)
			{
				temp = data.getError().rowErrors[i].errorObj["groupID"];
			}
			data.getError().rowErrors[i].errorObj["groupid"] = RESOURCE["PROTECT_GROUP_ID"]
					+ temp;
		}
	}
	openErrPage("../../../../../page/", data.getError(), errArr);
}


/**
 *         
 * 
 * @param data:      
 *            isQuery        
 * @return  
 */
function fillTableData(data, isQuery)
{
	
	createTableBody(protectTable, window.tableconf[0], data, RESOURCE);

	if (protectTable.getDataRowLength() > 0
			&& protectTable.getSelectedRowCount() == 0)
	{
		protectTable.setRowSelect(0);
		rowSelectHandler(protectTable.getSelectedRows());
	}
	addCellEvent();
}

/**
 *             XML  
 * 
 * @param  
 * @return  
 */
function createQueryPGXMLInfo()
{
	var root = new inputxml("datainterface");

	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;

	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", parent.obj.neid);
	row.appendChild(param);

	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	return root.toString();
}

/**
 *             XML  
 * 
 * @param  
 * @return  
 */
function createQueryPGParisXMLInfo(apsid)
{
	var root = new inputxml("datainterface");

	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;

	param = new tagElement("param");
	param.setAttribute("name", "apsid");
	param.setAttribute("value", apsid);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", parent.obj.neid);
	row.appendChild(param);

	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	return root.toString();
}




/**
 *          
 * 
 * @param  
 * @return  
 */
function initTable()
{
	protectTable = new SortTable();

	protectTable.setImage("../../../../../images/");

	protectTable.setOnRowSelectHandler(rowSelectHandler);

	protectTable.setOnCellEditHandler(cellEditHandler);

	createTableHead(protectTable, window.tableconf[0]);

	protectTable.setBodyWidth(window.tableconf[0].width,
			window.tableconf[0].percent, 0);

	var linePGTableArea = document.createElement("div");
	linePGTableArea.setAttribute("id", "protectTable");
	linePGTableArea.className = "adaptTable";
	linePGTableArea.appendChild(protectTable.getTable());
	$("protectGroup").appendChild(linePGTableArea);

	adjustTableLayout(protectTable, window.tableconf[0], 0);

	pairsTable = new SortTable();

	pairsTable.setImage("../../../../../images/");

	pairsTable.setOnRowSelectHandler(pairsTableRowSelectHandler);
	createTableHead(pairsTable, window.tableconf[1]);

	pairsTable.setBodyWidth(window.tableconf[1].width,
			window.tableconf[1].percent, 0);
	var boardMapTableArea = document.createElement("div");
	boardMapTableArea.setAttribute("id", "pairsTable");
	boardMapTableArea.className = "adaptTable";
	boardMapTableArea.appendChild(pairsTable.getTable());
	$("pairscomponent").appendChild(boardMapTableArea);
	$("tablecomponent").oncontextmenu = popupMenuHandler;

	var totalHeight = screen.height;

	protectTable.setBodyHeight(totalHeight * 0.26 + "px");
	pairsTable.setBodyHeight(totalHeight * 0.1 + "px");
}


/**
 *             
 * 
 * @param data: 
 * @return  
 */
function createjsDOMenu()
{
	 removejsDOMmenu();
    
    var isModify = parseInt(protectTable.getCellStoreValue(protectTable.getSelectedRows()[0], "ismodify", "ismodify")) == 0 ? false : true;
    
    var isFunctionEnable = !$("functionBtn").disabled;

    var isenable = protectTable.getCellStoreValue(protectTable.getSelectedRows()[0], "isenable", "isenable");
    
    var cursorMenu = new jsDOMenu(220);
    if (protectTable.getSelectedRows().length > 1)
    {
	    cursorMenu.addMenuItem(new menuItem(RESOURCE["startprotocol"], "", setProtocol, "1", isFunctionEnable));
	    cursorMenu.addMenuItem(new menuItem(RESOURCE["stopprotocol"], "", setProtocol, "0", isFunctionEnable));
    }
    else if (isenable == 0)
    {
    	cursorMenu.addMenuItem(new menuItem(RESOURCE["startprotocol"], "", setProtocol, "1", isFunctionEnable));
    	cursorMenu.addMenuItem(new menuItem(RESOURCE["stopprotocol"], "", setProtocol, "0", !isFunctionEnable));
    }
    else
    {
    	cursorMenu.addMenuItem(new menuItem(RESOURCE["startprotocol"], "", setProtocol, "1", !isFunctionEnable));
    	cursorMenu.addMenuItem(new menuItem(RESOURCE["stopprotocol"], "", setProtocol, "0", isFunctionEnable));
    }
    cursorMenu.addMenuItem(new menuItem("-"));
    cursorMenu.addMenuItem(new menuItem(RESOURCE["queryswitchingstatus"], "", querySwitchingStatus, "", isFunctionEnable));
    cursorMenu.addMenuItem(new menuItem("-"));
    cursorMenu.addMenuItem(new menuItem(RESOURCE["clear"], "", switchAps, "0", isModify && isFunctionEnable));
	cursorMenu.addMenuItem(new menuItem(RESOURCE["lockoutofprotection"], "", switchAps, "1", isModify && isFunctionEnable));
    cursorMenu.addMenuItem(new menuItem(RESOURCE["forceswitching"], "", switchAps, "2", isModify && isFunctionEnable));
    cursorMenu.addMenuItem(new menuItem(RESOURCE["manualswitchingtoworking"], "", switchAps, "3", isModify && isFunctionEnable));
    cursorMenu.addMenuItem(new menuItem(RESOURCE["manualswitchingtoprotection"], "", switchAps, "4", isModify && isFunctionEnable));
    cursorMenu.addMenuItem(new menuItem(RESOURCE["exerciseswitching"], "", switchAps, "5", isModify && isFunctionEnable));

    setPopUpMenu(cursorMenu);
}


/**
 *             
 * 
 * @param rows:      
 * @return  
 */
function rowSelectHandler(rows)
{
	if(rows == null)
	{
		return;
	}
	if (rows.length == 0)
	{
		$("queryBtn").disabled = true;
		$("functionBtn").disabled = true;
		$("deletePWAPSBtn").disabled = true;
		pairsTable.clearTableData();

	}
	else
	{
		$("queryBtn").disabled = false;
		$("functionBtn").disabled = false;
		$("deletePWAPSBtn").disabled = false;
		var apsid = protectTable.getCellStoreValue(rows[0], "apsid", "apsid")

		queryBoardMapInfo(apsid);
		
		var selectedRowCount = protectTable.getSelectedRowCount();
		countObj.setSelectedCount(selectedRowCount);
		countObj.setTotalCount(protectTable.getDataRowLength());
	}
}

function pairsTableRowSelectHandler(rows)
{
	if (rows.length != 0)
	{
		$("deletebtn").disabled = !btnRightArr.deletebtn;
	}
}




/**
 *            
 * 
 * @param groupID    ID
 * @return  
 */
function queryBoardMapInfo(apsid)
{

	$("deletebtn").disabled = true;
	var tmpSelectRow = -1;
	var tmpSlectPGID = -1;
	if (apsid == null)
	{
		tmpSelectRow = protectTable.getSelectedRows()[0];
		apsid = protectTable.getCellStoreValue(tmpSelectRow, "apsid", "apsid");
	}

	pairsTable.clearTableData();
	
	var url = "../../../../../neExlorerServlet?sfid=" + TE_F_CMD_MSTPPLUS_PW_QUERY_APSPAIR
			+ "&nmUser=" + parent.obj.nmUser;
	loadXMLdoc(url, "POST", true, callbackQueryPGParis, null, "inputdata="
			+ createQueryPGParisXMLInfo(apsid));
}



/**
 *         
 * 
 * @param  
 * @return  
 */
function addCellEvent()
{
}


function doQuery()
{
	queryPG();
}

function doApply()
{
    $("queryBtn").disabled = true;
    $("applyBtn").disabled = true;
    $("functionBtn").disabled = true;
    $("queryParisBtn").disabled = true;
    $("deletebtn").disabled = true;
    $("deletePWAPSBtn").disabled = true;
    var xml = createApplyXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TE_F_CMD_MSTPPLUS_PW_SET_APS_ATTRIB + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, applyCallBack, null, "inputdata=" + xml);
}


function createApplyXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, len = protectTable.getDataRowLength(); i < len; i++) 
    {
        if (!protectTable.getModify(i)) 
        {
            continue;
        }
        
        var row = new tagElement("row-params");
        row.appendChild(createTagElement("neid", parent.obj.neid));
        row.appendChild(createTagElement("apsid", protectTable.getCellCurrentValue(i, "apsid", "apsid")));
        row.appendChild(createTagElement("autoassign", 0));
        
        if (protectTable.getCellModify(i, "switchmode")) 
        {
            row.appendChild(createTagElement("switchmode", protectTable.getCellCurrentValue(i, "switchmode", "switchmode")));
        }
		
		     if (protectTable.getCellModify(i, "rvtmode")) 
        {
            row.appendChild(createTagElement("rvtmode", protectTable.getCellCurrentValue(i, "rvtmode", "rvtmode")));
        }
        
        if ( protectTable.getCellModify(i, "wtrtime")) 
        {
            row.appendChild(createTagElement("wtrtime", protectTable.getCellCurrentValue(i, "wtrtime", "wtrtime")));
        }
        
        if (protectTable.getCellModify(i, "delaytime")) 
        {
            row.appendChild(createTagElement("delaytime", protectTable.getCellCurrentValue(i, "delaytime", "delaytime")));
        }
        
         if (protectTable.getCellModify(i, "isenable")) 
        {
            row.appendChild(createTagElement("isenable", protectTable.getCellCurrentValue(i, "isenable", "isenable")));
        }
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}


function createTagElement(name, value)
{
    var elem = new tagElement("param");
    elem.setAttribute("name", name);
    elem.setAttribute("value", value);
    return elem;
}


function applyCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    refreshTableState(protectTable, window.tableconf[0], data);
    
    $("queryBtn").disabled = !btnRightArr.queryBtn.right;
    $("deletePWAPSBtn").disabled = !btnRightArr.deletePWAPSBtn.right;;
    if (protectTable.getSelectedRowCount() > 0) 
    {
        $("functionBtn").disabled = false;
    }
    if (data.getSErrorCode() != 0) 
    {
        $("applyBtn").disabled = !btnRightArr.applyBtn.right;
    }
}


function setProtocol(param)
{
    hideMenu();
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var indexes = protectTable.getSelectedRows();
    for (var i = 0, m = indexes.length; i < m; i++) 
    {
        var rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", parent.obj.neid));
        rowparams.appendChild(createTagElement("autoassign", 0));
        rowparams.appendChild(createTagElement("apsid", protectTable.getCellStoreValue(indexes[i], "apsid", "apsid")));
        rowparams.appendChild(createTagElement("isenable", param));
        bussiness.appendChild(rowparams);
    }
    
    di.getRoot().appendChild(bussiness);
    
    var url = "../../../../../neExlorerServlet?sfid=" + TE_F_CMD_MSTPPLUS_PW_CTR_APS + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, protocolCallBack, param, "inputdata=" + di.toString());
}



function switchAps(param)
{
    hideMenu();
    
    if (!confirm(RESOURCE["switchpwconfirminfo"])) 
    {
        return;
    }
    
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var indexes = protectTable.getSelectedRows();
    for (var i = 0, m = indexes.length; i < m; i++) 
    {
        var rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", parent.obj.neid));
        rowparams.appendChild(createTagElement("autoassign", 0));
        rowparams.appendChild(createTagElement("apsid", protectTable.getCellStoreValue(indexes[i], "apsid", "apsid")));
        rowparams.appendChild(createTagElement("switchcmd", param));
        bussiness.appendChild(rowparams);
    }
    
    di.getRoot().appendChild(bussiness);
    
    var url = "../../../../../neExlorerServlet?sfid=" + TE_F_CMD_MSTPPLUS_PW_SWITCH_APS + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, switchCallBack, null, "inputdata=" + di.toString());
}

function switchCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
}


function querySwitchingStatus()
{
    hideMenu();
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var indexes = protectTable.getSelectedRows();
    for (var i = 0, m = indexes.length; i < m; i++) 
    {
        var rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", parent.obj.neid));
        rowparams.appendChild(createTagElement("autoassign", 0));
        rowparams.appendChild(createTagElement("apsid", protectTable.getCellStoreValue(indexes[i], "apsid", "apsid")));
        bussiness.appendChild(rowparams);
    }
    
    di.getRoot().appendChild(bussiness);
    
    var url = "../../../../../neExlorerServlet?sfid=" + TE_F_CMD_MSTPPLUS_PW_QUERY_APS_STATE + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, qStatusCallBack, null, "inputdata=" + di.toString());
}



function qStatusCallBack(doc)
{
    
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    for (var i = 0, m = data.getDataRowLength(); i < m; i++) 
    {
        var apsId = parseInt(data.getDataRowParam(i, "apsid"));
        for (var j = 0, n = protectTable.getDataRowLength(); j < n; j++) 
        {
            var aps = parseInt(protectTable.getCellStoreValue(j, "apsid", "apsid"));
            if (apsId == aps) 
            {
                var switchState = data.getDataRowParam(i, "switchstatus"); 
                cell = protectTable.getCell(j, "switchstatus");
                protectTable.setCellValue(cell, "switchstatus", switchState);
                protectTable.getCellShow(j, "switchstatus").element.innerHTML = pwswitchstatus[switchState];
                
                var protocolstatus = data.getDataRowParam(i, "protocolstatus");
                cell = protectTable.getCell(j, "protocolstatus");
                protectTable.setCellValue(cell, "protocolstatus", protocolstatus);
                protectTable.getCellShow(j, "protocolstatus").element.innerHTML = pwProtocolStatus[protocolstatus];
                
                
                var workstatus = data.getDataRowParam(i, "workstatus");
                cell = protectTable.getCell(j, "workstatus");
                protectTable.setCellValue(cell, "workstatus", workstatus);
                protectTable.getCellShow(j, "workstatus").element.innerHTML = validstatus[workstatus];
                
                 var protectstatus = data.getDataRowParam(i, "protectstatus");
                cell = protectTable.getCell(j, "protectstatus");
                protectTable.setCellValue(cell, "protectstatus", protectstatus);
                protectTable.getCellShow(j, "protectstatus").element.innerHTML = validstatus[protectstatus];
            }
        }  
      
    }
}

function createDeleteXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var indexes = pairsTable.getSelectedRows();
    for (var i = 0, m = indexes.length; i < m; i++) 
    {
        var rowparams = new tagElement("row-params");
        
        rowparams.appendChild(createTagElement("neid", parent.obj.neid));
        rowparams.appendChild(createTagElement("apsid", pairsTable.getCellCurrentValue(indexes[i], "apsid", "apsid")));
        rowparams.appendChild(createTagElement("workpw", pairsTable.getCellCurrentValue(indexes[i], "workpw", "workpw")));
        rowparams.appendChild(createTagElement("protectpw", pairsTable.getCellCurrentValue(indexes[i], "protectpw", "protectpw")));
        rowparams.appendChild(createTagElement("pwIndex", pairsTable.getCellCurrentValue(indexes[i], "protectpw", "protectpw")));
        rowparams.appendChild(createTagElement("extendargs", "0"));
        bussiness.appendChild(rowparams);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
  
}


function doDelete()
{
    if (!confirm(RESOURCE["deleteconfirminfo"])) 
    {
        return;
    }
    
    $("queryBtn").disabled = true;
    $("applyBtn").disabled = true;
    $("functionBtn").disabled = true;
    $("queryParisBtn").disabled = true;
    $("deletebtn").disabled = true;
    
    
    var xml = createDeleteXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TE_F_CMD_MSTPPLUS_PW_DEL_APSPAIR + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, deleteCallBack, null, "inputdata=" + xml);
}


function deleteCallBack(doc)
{
    $("queryBtn").disabled = !btnRightArr.queryBtn.right;
    
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    var oError = data.getError();
    var indexes = pairsTable.getSelectedRows();
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var apsId = oError.getRowKey(i, "apsid");
        for (var j = indexes.length - 1; j >= 0; j--) 
        {
            var aps = pairsTable.getCellCurrentValue(indexes[j], "apsid", "apsid");
            if (apsId == aps) 
            {
                indexes.splice(j, 1);
                break;
            }
        }
    }
    
    for (var k = indexes.length - 1; k >= 0; k--) 
    {
        pairsTable.deleteRow(indexes[k]);
    }
    pairsTable.adjustDataRows();
    

}

function initCountObj()
{
    var countArea = document.createElement("div");
    $("countdiv").appendChild(countArea);
    countObj = new TableDataCount();
    countArea.appendChild(countObj.getCountArea());
    
    var parisCountArea = document.createElement("div");
    $("parisCountdiv").appendChild(parisCountArea);
    parisCountObj = new TableDataCount();
    parisCountArea.appendChild(parisCountObj.getCountArea());
}

function protocolCallBack(doc, param)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    var oError = data.getError();
    var indexes = protectTable.getSelectedRows();
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var apsId = oError.getRowKey(i, "apsid");
        for (var j = indexes.length - 1; j >= 0; j--) 
        {
            var aps = protectTable.getCellCurrentValue(indexes[j], "apsid", "apsid");
            if (apsId == aps) 
            {
                indexes.splice(j, 1);
                break;
            }
        }
    }
    
    for (var k = indexes.length - 1; k >= 0; k--) 
    {
        var cell = protectTable.getCell(indexes[k], "isenable");
        protectTable.setCellValue(cell, "isenable", param);
        
        protectTable.getCellShow(indexes[k], "isenable").element.innerHTML = enablestatus[param];
    }
}



/*
 * Add table popupmenu handler
 */
function popupMenuHandler(evt)
{  
    if (!evt) 
    {
        evt = window.event;
    }
    
    var elem = (evt.target) ? evt.target : evt.srcElement;
    
    if (elem != null && elem.blur) 
    {
        elem.blur();
    }
    
    while (elem != null) 
    {
        if (elem.tagName == 'TD') 
        {
            break;
        }
        else 
        {
            elem = elem.parentNode;
        }
    }
    
    if (elem == null || elem.tagName != 'TD' || null == elem.parent || elem.editElement == null) 
    {
        createjsDOMenu();
        showMenu(evt);
        return;
    }
    
    var rowid = elem.parentNode.rowIndex;
    var rows = elem.parent.getSelectedRows();
    var colid = elem.colid;
   
    if (rows.contains(rowid)) 
    {
        if (null != elem.editElement && elem.isEdit == 1) 
        {
            createTablePopupMenu(elem, evt);
            return;
        }
        else 
        {
            createjsDOMenu();
            showMenu(evt);
            return;
        }
        
        for (var i = 0; i < rows.length; i++) 
        {
            var tmpElem = elem.parent.getCellElement(rows[i], colid);
            if (null != tmpElem.editElement && tmpElem.isEdit == 1) 
            {
                createTablePopupMenu(tmpElem, evt);
                return;
            }
            else 
            {
                createjsDOMenu();
                showMenu(evt);
                return;
            }
        }
    }
}


function doPWAPSDelete()
{
    if (!confirm(RESOURCE["deletepwpgconfirminfo"])) 
    {
        return;
    }
    
    $("queryBtn").disabled = true;
    $("applyBtn").disabled = true;
    $("functionBtn").disabled = true;
    $("queryParisBtn").disabled = true;
    $("deletebtn").disabled = true;
    
    
    var xml = createDeletePWAPSXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TE_F_CMD_MSTPPLUS_PW_DEL_APS + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, deletePWAPSCallBack, null, "inputdata=" + xml);
}


function deletePWAPSCallBack(doc)
{
    $("queryBtn").disabled = !btnRightArr.queryBtn.right;
    
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    var oError = data.getError();
    var indexes = protectTable.getSelectedRows();
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var apsId = oError.getRowKey(i, "apsid");
        for (var j = indexes.length - 1; j >= 0; j--) 
        {
            var aps = protectTable.getCellCurrentValue(indexes[j], "apsid", "apsid");
            if (apsId == aps) 
            {
                indexes.splice(j, 1);
                break;
            }
        }
    }
    
    for (var k = indexes.length - 1; k >= 0; k--) 
    {
    	protectTable.deleteRow(indexes[k]);
    }
    protectTable.adjustDataRows();
    
	if (protectTable.getDataRowLength() > 0
			&& protectTable.getSelectedRowCount() == 0)
	{
		protectTable.setRowSelect(0);
		rowSelectHandler(protectTable.getSelectedRows());
	}
	else
	{
		$("deletePWAPSBtn").disabled = true;
	}

}
function createDeletePWAPSXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var indexes = protectTable.getSelectedRows();
    for (var i = 0, m = indexes.length; i < m; i++) 
    {
        var rowparams = new tagElement("row-params");
        
        rowparams.appendChild(createTagElement("neid", parent.obj.neid));
        rowparams.appendChild(createTagElement("apsid", protectTable.getCellCurrentValue(indexes[i], "apsid", "apsid")));
        rowparams.appendChild(createTagElement("pwIndex", protectTable.getCellStoreValue(0, "protectpwindex", "protectpwindex")));
        rowparams.appendChild(createTagElement("workpw", protectTable.getCellCurrentValue(indexes[i], "workpw", "workpw")));
        rowparams.appendChild(createTagElement("protectpw", protectTable.getCellCurrentValue(indexes[i], "protectpw", "protectpw")));
        rowparams.appendChild(createTagElement("extendargs", "0"));
        bussiness.appendChild(rowparams);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
  
}
