var ct = null;
var portRes = null;

var win = getParentWindow();
if (!isIE) 
{
    win = win.frames[0];
}
var neid = win.neid;
var nmUser = win.nmUser;

var ONE_PLUS_ONE = 0; //1+1
var ONE_TO_ONE = 1; //1:1
var SINGLE_ENDED = 0; //Single-Ended

function init()
{
    initTable();
    initButton();
}

function initTable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["property"], RESOURCE["value"]);
    
    var atom = new Atom("select");
    atom.addOption(RESOURCE["protype0"], 0);
    atom.addOption(RESOURCE["protype1"], 1);
    atom.element.onchange = changeProType;
    ct.addAttrRow("protype", RESOURCE["protype"], atom);
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["singleended"], 0);
    atom.addOption(RESOURCE["dualended"], 1);
	atom.element.onchange = changeSwitchMode;
    ct.addAttrRow("switchingmode", RESOURCE["switchingmode"], atom);
    
    /**atom = new Atom("select");
    atom.element.disabled = true;
    atom.addOption(RESOURCE["disabled"], 0);
    atom.addOption(RESOURCE["enabled"], 1);
    atom.addOption("-", 255);
    atom.element.options.selectedIndex = 2;
    ct.addAttrRow("bdistatus", RESOURCE["bdistatus"], atom);**/
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["mplstunnel"], 1);
    atom.addOption(RESOURCE["iptunnel"], 3);
    atom.addOption(RESOURCE["gretunnel"], 4);
    atom.element.onchange = changeTunnelType;
    ct.addAttrRow("workingtunneltype", RESOURCE["workingtunneltype"], atom);
    
    atom = new Atom("select");
    atom.element.disabled = true;
    atom.element.style.width = "87%";
    atom.element.style.height = "100%";
    atom.addOption("", 0xFFFFFFFF);
    ct.addAttrRow("workingingresstunnelid", RESOURCE["workingingresstunnelid"], atom);
    atom.element.parentNode.appendChild(createButton("workingingresstunnelid"));
    
    atom = new Atom("span");
    ct.addAttrRow("workingingresstunnelname", RESOURCE["workingingresstunnelname"], atom);
    
    atom = new Atom("select");
    atom.element.disabled = true;
    atom.element.style.width = "87%";
    atom.element.style.height = "100%";
    atom.addOption("", 0xFFFFFFFF);
    ct.addAttrRow("workingegresstunnelid", RESOURCE["workingegresstunnelid"], atom);
    atom.element.parentNode.appendChild(createButton("workingegresstunnelid"));
    
    atom = new Atom("span");
    ct.addAttrRow("workingegresstunnelname", RESOURCE["workingegresstunnelname"], atom);
    atom = new Atom("select");
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["mplstunnel"], 1);
    atom.element.disabled = true;
    ct.addAttrRow("protectiontunneltype", RESOURCE["protectiontunneltype"], atom);
    
    atom = new Atom("select");
    atom.element.disabled = true;
    atom.element.style.width = "87%";
    atom.element.style.height = "100%";
    atom.addOption("", 0xFFFFFFFF);
    ct.addAttrRow("protectioningresstunnelid", RESOURCE["protectioningresstunnelid"], atom);
    atom.element.parentNode.appendChild(createButton("protectioningresstunnelid"));
    
    atom = new Atom("span");
    ct.addAttrRow("protectioningresstunnelname", RESOURCE["protectioningresstunnelname"], atom);
    
    atom = new Atom("select");
    atom.element.disabled = true;
    atom.element.style.width = "87%";
    atom.element.style.height = "100%";
    atom.addOption("", 0xFFFFFFFF);
    ct.addAttrRow("protectionegresstunnelid", RESOURCE["protectionegresstunnelid"], atom);
    atom.element.parentNode.appendChild(createButton("protectionegresstunnelid"));
    
    atom = new Atom("span");
    ct.addAttrRow("protectionegresstunnelname", RESOURCE["protectionegresstunnelname"], atom);
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["nonrevertive"], 0);
    atom.addOption(RESOURCE["revertive"], 1);
    atom.element.onchange = changeRvtMode;
    ct.addAttrRow("revertivemode", RESOURCE["revertivemode"], atom);
    
    atom = new Atom("text");
    atom.element.disabled = true;
    atom.setValue(5);
    checkText(atom.element, "1", "12");
    ct.addAttrRow("wtrtime", RESOURCE["wtrtime"], atom);
    
    atom = new Atom("text");
    atom.setValue(0);
    checkText(atom.element, "0", "100");
    ct.addAttrRow("delaytime", RESOURCE["delaytime"], atom);
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["disabled"], 0);
    atom.addOption(RESOURCE["enabled"], 1);
    ct.addAttrRow("protocolstatus", RESOURCE["protocolstatus"], atom);
    
    $("tbdiv").appendChild(ct.getTable());
}

function initButton()
{
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
    $("applybtn").value = RESOURCE["applybutton"];
}

function createButton(id)
{
    var btn = document.createElement("input");
    btn.setAttribute("type", "button");
    btn.setAttribute("id", id);
    btn.setAttribute("value", "...");
    btn.style.width = "13%";
    btn.style.height = "100%";
    btn.onclick = selectTunnel;
    return btn;
}

function selectTunnel()
{
    var tunnelType = MPLS_TUNNEL; // default mpls tunnel
    if (this.id == "workingingresstunnelid" || this.id == "workingegresstunnelid") 
    {
        tunnelType = ct.getAtom("workingtunneltype").getValue();
    }
    
    var url = "selecttunnel.html?tunnelType=" + tunnelType + "&type=" + this.id;
    xshowModalDialog(url, RESOURCE["selecttunnel"], 480, 400, "../../../../../images/");
}

function changeProType()
{
    ct.getAtom("switchingmode").element.options.selectedIndex = this.value;
    
    /**var atom = ct.getAtom("bdistatus");
    var switchingMode = parseInt(ct.getAtom("switchingmode").getValue());
    if (ONE_TO_ONE == parseInt(this.value) && SINGLE_ENDED == switchingMode) 
    {
        atom.element.options.selectedIndex = 0;
        atom.element.options.length -= 1;
        atom.element.disabled = false;
    }
    else 
    {
        if (!atom.element.disabled) 
        {
            atom.element.disabled = true;
			atom.addOption("-", 255);
            atom.element.options.selectedIndex = 2;
        }
    }**/
}

function changeSwitchMode()
{    
    /**var atom = ct.getAtom("bdistatus");
    var proType = parseInt(ct.getAtom("protype").getValue());
    if (ONE_TO_ONE == proType && SINGLE_ENDED == parseInt(this.value)) 
    {
		if (atom.element.disabled) 
		{
			atom.element.options.selectedIndex = 0;
			atom.element.options.length -= 1;
			atom.element.disabled = false;
		}
    }
    else 
    {
        if (!atom.element.disabled) 
        {
            atom.element.disabled = true;
			atom.addOption("-", 255);
            atom.element.options.selectedIndex = 2;
        }
    }**/
}

function changeTunnelType()
{
    ct.getAtom("workingingresstunnelid").setValue("");
    ct.getAtom("workingingresstunnelname").setValue("");
    ct.getAtom("workingegresstunnelid").setValue("");
    ct.getAtom("workingegresstunnelname").setValue("");
    
    var proTypeAtom = ct.getAtom("protype");
    var modeAtom = ct.getAtom("switchingmode");
    var rvtModeAtom = ct.getAtom("revertivemode");
    var wtrTimeAtom = ct.getAtom("wtrtime");
    var delayTimeAtom = ct.getAtom("delaytime");
    switch (parseInt(this.value))
    {
        case MPLS_TUNNEL:
            proTypeAtom.element.disabled = false;
            modeAtom.element.disabled = false;
            rvtModeAtom.element.disabled = false;
            wtrTimeAtom.element.disabled = false;
            wtrTimeAtom.setValue(5);
            delayTimeAtom.element.disabled = false;
            break;
        case IP_TUNNEL:
        case GRE_TUNNEL:
            proTypeAtom.element.disabled = true;
            proTypeAtom.element.options.selectedIndex = 1;
            modeAtom.element.disabled = true;
            modeAtom.element.options.selectedIndex = 1;
            rvtModeAtom.element.disabled = true;
            rvtModeAtom.element.options.selectedIndex = 1;
            wtrTimeAtom.element.disabled = true;
            wtrTimeAtom.setValue(0);
            delayTimeAtom.element.disabled = true;
            delayTimeAtom.setValue(0);
            break;
        default:
            break;
    }
}

function changeRvtMode()
{
    var atom = ct.getAtom("wtrtime");
    if (parseInt(this.value) == 1) 
    {
        atom.element.disabled = false;
    }
    else 
    {
        atom.element.disabled = true;
    }
}

function validate()
{
    var wInTunnel = parseInt(ct.getAtom("workingingresstunnelid").getValue());
    var wOutTunnel = parseInt(ct.getAtom("workingegresstunnelid").getValue());
    var pInTunnel = parseInt(ct.getAtom("protectioningresstunnelid").getValue());
    var pOutTunnel = parseInt(ct.getAtom("protectionegresstunnelid").getValue());
    
    var proType = parseInt(ct.getAtom("protype").getValue());
    var switchMode = parseInt(ct.getAtom("switchingmode").getValue());
    if (ONE_PLUS_ONE == proType && SINGLE_ENDED == switchMode) 
    {
        if ((wInTunnel != 0xFFFFFFFF && pInTunnel == 0xFFFFFFFF) || (wOutTunnel != 0xFFFFFFFF && pOutTunnel == 0xFFFFFFFF) || (wInTunnel == 0xFFFFFFFF && pInTunnel != 0xFFFFFFFF) || (wOutTunnel == 0xFFFFFFFF && pOutTunnel != 0xFFFFFFFF)) 
        {
            alert(RESOURCE["inputtip"]);
            return false;
        }
    }
    else 
    {
        if (wInTunnel == 0xFFFFFFFF || wOutTunnel == 0xFFFFFFFF || pInTunnel == 0xFFFFFFFF || pOutTunnel == 0xFFFFFFFF) 
        {
            alert(RESOURCE["inputtip"]);
            return false;
        }
    }
    return true;
}

function createAPSXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("autoassign", 1));
    rowparams.appendChild(createTagElement("apsid", 0));
    rowparams.appendChild(createTagElement("tunneltype", 1)); //support only p2p    
    rowparams.appendChild(createTagElement("protype", ct.getAtom("protype").getValue()));
    
    rowparams.appendChild(createTagElement("switchmode", ct.getAtom("switchingmode").getValue()));
    rowparams.appendChild(createTagElement("rvtmode", ct.getAtom("revertivemode").getValue()));
    rowparams.appendChild(createTagElement("wtrtime", ct.getAtom("wtrtime").getValue()));
    rowparams.appendChild(createTagElement("delaytime", ct.getAtom("delaytime").getValue()));
    rowparams.appendChild(createTagElement("groupid", 0xFFFF));
    
    rowparams.appendChild(createTagElement("winauto", 0));
    rowparams.appendChild(createTagElement("wintunnel", ct.getAtom("workingegresstunnelid").getValue().split("-")[0]));
    rowparams.appendChild(createTagElement("woutauto", 0));
    rowparams.appendChild(createTagElement("wouttunnel", ct.getAtom("workingingresstunnelid").getValue().split("-")[0]));
    rowparams.appendChild(createTagElement("pinauto", 0));
    rowparams.appendChild(createTagElement("pintunnel", ct.getAtom("protectionegresstunnelid").getValue().split("-")[0]));
    rowparams.appendChild(createTagElement("poutauto", 0));
    rowparams.appendChild(createTagElement("pouttunnel", ct.getAtom("protectioningresstunnelid").getValue().split("-")[0]));
    
    rowparams.appendChild(createTagElement("autoass", 2));
	/**var atom = ct.getAtom("bdistatus");
	if (!atom.element.disabled)
	{
		rowparams.appendChild(createTagElement("bdistatus", atom.getValue()));
	}**/
    rowparams.appendChild(createTagElement("protocolstatus", ct.getAtom("protocolstatus").getValue()));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doCreate(param)
{
    if (!validate()) 
    {
        return;
    }
    var xml = createAPSXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_ADD_TUNNEL_PG + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, createCallBack, param, "inputdata=" + xml);
}

function createCallBack(doc, param)
{
    var data = EncapsulateData(doc);
    showErrDialog(data)
    
    if (data.getSErrorCode() == 0) 
    {
        win.doQuery();
        if (param) 
        {
            xcloseDialog();
        }
    }
}
