var st0 = null;
var st1 = null;
var countObj = null;
var apsList = null;
var tunnelList = null;

var ONE_TO_ONE = 1; //1:1
var SINGLE_ENDED = 0; //Single-Ended
var btnRightArr = new Object();

var winobj = getNeProperty(top);
var neid = winobj.neid;
var nmUser = winobj.nmUser;

function init()
{
    initTable();
    initCountObj();
    initButton();
    
    initRight();
    
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("newbtn").disabled = !btnRightArr.newbtn.right;
    if (btnRightArr.querybtn.right) 
    {
        doQuery();
    }
}

function initTable()
{
    st0 = new SortTable();
    st0.setImage("../../../../../images/");
    st0.setOnRowSelectHandler(rowSelectHandler);
    st0.setOnCellEditHandler(cellEditHandler);
    createTableHead(st0, window.tableconf[0]);
    $("apsdiv").appendChild(st0.getTable());
    st0.setBodyHeight(getComponetHeight(document.body, 100) * 0.6 + "px");
    
    $("apsdiv").oncontextmenu = popupMenuHandler;
    
    st1 = new SortTable();
    st1.setImage("../../../../../images/");
    createTableHead(st1, window.tableconf[1]);
    $("tunneldiv").appendChild(st1.getTable());
    
    st1.setBodyHeight(getComponetHeight(document.body, 100) * 0.3 + "px");
}

function initCountObj()
{
    var countArea = document.createElement("div");
    $("countdiv").appendChild(countArea);
    countObj = new TableDataCount();
    countArea.appendChild(countObj.getCountArea());
}

function initButton()
{
    $("querybtn").value = RESOURCE["querybutton"];
    $("newbtn").value = RESOURCE["newbutton"];
    $("deletebtn").value = RESOURCE["deletebutton"];
    $("functionbtn").value = RESOURCE["functionbutton"];
    $("applybtn").value = RESOURCE["applybutton"];
}

function initRight()
{
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_IPPTN_QUERY_TUNNEL_PG);
    btnRightArr.newbtn = new BtnRightObj("newbtn", TECMDCODE_IPPTN_ADD_TUNNEL_PG);
    btnRightArr.deletebtn = new BtnRightObj("deletebtn", TECMDCODE_IPPTN_DEL_TUNNEL_PG);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_IPPTN_MODIFY_TUNNEL_PG);
    btnRightArr.ctrbtn = new BtnRightObj("ctrbtn", TECMDCODE_IPPTN_CTR_TUNNEL_PG);
    btnRightArr.statebtn = new BtnRightObj("statebtn", TECMDCODE_IPPTN_GET_TUNNEL_PG_STATE);
    btnRightArr.switchbtn = new BtnRightObj("switchbtn", TECMDCODE_IPPTN_SWITCH_TUNNEL_PG);
    
    getRightInfo(winobj, btnRightArr);
}

function rowSelectHandler()
{
    st1.clearTableData();
    
    var selectedRowCount = st0.getSelectedRowCount();
    countObj.setSelectedCount(selectedRowCount);
    
    if (selectedRowCount > 0) 
    {
        $("deletebtn").disabled = !btnRightArr.deletebtn.right;
        $("functionbtn").disabled = false;
        
        var index = st0.getSelectedRows()[0];
        var apsId = st0.getCellCurrentValue(index, "apsid", "apsid");
        
        createTableBody(st1, window.tableconf[1], EncapsulateData(createTunnelRow(apsId, apsList[apsId])), RESOURCE);
    }
    else 
    {
        $("deletebtn").disabled = true;
        $("functionbtn").disabled = true;
    }
}

function cellEditHandler()
{
    $("applybtn").disabled = !btnRightArr.applybtn.right;
}

function doQuery()
{
    $("querybtn").disabled = true;
    $("newbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("functionbtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createQueryXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_QUERY_TUNNEL_PG + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, queryCallBack, null, "inputdata=" + xml);
}

function queryCallBack(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("newbtn").disabled = !btnRightArr.newbtn.right;
    
    var data = EncapsulateData(doc);
    showErrDialog(data);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        st0.clearTableData();
        getApsTunnel(data);
        createTableBody(st0, window.tableconf[0], data, RESOURCE);
        addCellListener();
        
        countObj.setTotalCount(st0.getDataRowLength());
        
        if (st0.getDataRowLength() > 0) 
        {
            st0.setRowSelect(0);
        }
        rowSelectHandler();
    }
    else 
    {
        if (st0.getSelectedRowCount() > 0) 
        {
            $("deletebtn").disabled = !btnRightArr.deletebtn.right;
            $("functionbtn").disabled = false;
        }
    }
}

function getApsTunnel(data)
{
    var tunnel = null;
    apsList = new Array();
    for (var i = 0, m = data.getDataRowLength(); i < m; i++) 
    {
        var apsId = data.getDataRowParam(i, "apsid");
        
        var tunnelObj = new Object();
        if (INVALID_TUNNEL_INDEX != parseInt(data.getDataRowParam(i, "winindex"))) 
        {
            tunnel = new Object();
            tunnel.tunnelID = data.getDataRowParam(i, "wintunnelid");
            tunnel.tunnelType = data.getDataRowParam(i, "wintunneltype");
            tunnel.tunnelName = data.getDataRowParam(i, "wintunnelname");
            tunnel.ingressID = data.getDataRowParam(i, "winingressid");
            tunnel.egressID = data.getDataRowParam(i, "winegressid");
            tunnelObj.wInTunnel = tunnel;
        }
        
        if (INVALID_TUNNEL_INDEX != parseInt(data.getDataRowParam(i, "woutindex"))) 
        {
            tunnel = new Object();
            tunnel.tunnelID = data.getDataRowParam(i, "wouttunnelid");
            tunnel.tunnelType = data.getDataRowParam(i, "wouttunneltype");
            tunnel.tunnelName = data.getDataRowParam(i, "wouttunnelname");
            tunnel.ingressID = data.getDataRowParam(i, "woutingressid");
            tunnel.egressID = data.getDataRowParam(i, "woutegressid");
            tunnelObj.wOutTunnel = tunnel;
        }
        
        if (INVALID_TUNNEL_INDEX != parseInt(data.getDataRowParam(i, "pinindex"))) 
        {
            tunnel = new Object();
            tunnel.tunnelID = data.getDataRowParam(i, "pintunnelid");
            tunnel.tunnelType = data.getDataRowParam(i, "pintunneltype");
            tunnel.tunnelName = data.getDataRowParam(i, "pintunnelname");
            tunnel.ingressID = data.getDataRowParam(i, "piningressid");
            tunnel.egressID = data.getDataRowParam(i, "pinegressid");
            tunnelObj.pInTunnel = tunnel;
        }
        
        if (INVALID_TUNNEL_INDEX != parseInt(data.getDataRowParam(i, "poutindex"))) 
        {
            tunnel = new Object();
            tunnel.tunnelID = data.getDataRowParam(i, "pouttunnelid");
            tunnel.tunnelType = data.getDataRowParam(i, "pouttunneltype");
            tunnel.tunnelName = data.getDataRowParam(i, "pouttunnelname");
            tunnel.ingressID = data.getDataRowParam(i, "poutingressid");
            tunnel.egressID = data.getDataRowParam(i, "poutegressid");
            tunnelObj.pOutTunnel = tunnel;
        }
        
        apsList[apsId] = tunnelObj;
    }
}

function addCellListener()
{
    var isModify = null;
    var cell = null;
    for (var i = 0, m = st0.getDataRowLength(); i < m; i++) 
    {
        var proType = parseInt(st0.getCellCurrentValue(i, "protype", "protype"));
        var switchMode = parseInt(st0.getCellCurrentValue(i, "switchmode", "switchmode"));
        /**if (ONE_TO_ONE == proType && SINGLE_ENDED == switchMode) 
        {
            st0.setCellIsEdit(st0.getCell(i, "bdistatus"), 1);
        }
        else 
        {
            st0.getCellShow(i, "bdistatus").element.innerHTML = "-";
        }**/
        st0.getCellShow(i, "switchstatus").element.innerHTML = "/";
        var isModify = st0.getCellCurrentValue(i, "ismodify", "ismodify");
        if (isModify == 0) 
        {
            cell = st0.getCell(i, "switchmode");
            st0.setCellIsEdit(cell, 0);
            
            cell = st0.getCell(i, "rvtmode");
            st0.setCellIsEdit(cell, 0);
            
            cell = st0.getCell(i, "wtrtime");
            st0.setCellIsEdit(cell, 0);
            
            cell = st0.getCell(i, "delaytime");
            st0.setCellIsEdit(cell, 0);
        }
        else 
        {
            cell = st0.getCellElement(i, "switchmode");
            /**cell.editElement.element.onchange = function()
            {
                var rowIndex = this.parentNode.parentNode.rowIndex;
                var cell = st0.getCell(rowIndex, "bdistatus");
                var proType = parseInt(st0.getCellCurrentValue(rowIndex, "protype", "protype"));
                if (ONE_TO_ONE == proType && SINGLE_ENDED == parseInt(this.value)) 
                {
                    st0.setCellValue(cell, "bdistatus", 0);
                    st0.getCellShow(rowIndex, "bdistatus").element.innerHTML = RESOURCE["disabled"];
                    st0.setCellIsEdit(cell, 1);
                }
                else 
                {
                    st0.setCellValue(cell, "bdistatus", 255);
                    st0.getCellShow(rowIndex, "bdistatus").element.innerHTML = "-";
                    st0.setCellIsEdit(cell, 0);
                }
            }**/
            
            var rvtMode = parseInt(st0.getCellCurrentValue(i, "rvtmode", "rvtmode"));
            if (rvtMode == 0) 
            {
                cell = st0.getCell(i, "wtrtime");
                st0.setCellIsEdit(cell, 0);
            }
            
            cell = st0.getCellElement(i, "rvtmode");
            cell.editElement.element.onchange = function()
            {
                var rowIndex = this.parentNode.parentNode.rowIndex;
                st0.setCellIsEdit(st0.getCell(rowIndex, "wtrtime"), parseInt(this.value));
            }
            
            cell = st0.getCellElement(i, "wtrtime");
            textCheck(cell.editElement.element, "1", "12");
            
            cell = st0.getCellElement(i, "delaytime");
            textCheck(cell.editElement.element, "0", "100");
        }
    }
}

/*
 * Add table popupmenu handler
 */
function popupMenuHandler(evt)
{
    if (!evt) 
    {
        evt = window.event;
    }
    
    var elem = (evt.target) ? evt.target : evt.srcElement;
    
    if (elem != null && elem.blur) 
    {
        elem.blur();
    }
    
    while (elem != null) 
    {
        if (elem.tagName == 'TD') 
        {
            break;
        }
        else 
        {
            elem = elem.parentNode;
        }
    }
    
    if (elem == null || elem.tagName != 'TD' || null == elem.parent || elem.editElement == null) 
    {
        createjsDOMenu();
        showMenu(evt);
        return;
    }
    
    var rowid = elem.parentNode.rowIndex;
    var rows = elem.parent.getSelectedRows();
    var colid = elem.colid;
    if (rows.contains(rowid)) 
    {
        if (null != elem.editElement && elem.isEdit == 1) 
        {
            createTablePopupMenu(elem, evt);
            return;
        }
        else 
        {
            createjsDOMenu();
            showMenu(evt);
            return;
        }
        
        for (var i = 0; i < rows.length; i++) 
        {
            var tmpElem = elem.parent.getCellElement(rows[i], colid);
            if (null != tmpElem.editElement && tmpElem.isEdit == 1) 
            {
                createTablePopupMenu(tmpElem, evt);
                return;
            }
            else 
            {
                createjsDOMenu();
                showMenu(evt);
                return;
            }
        }
    }
}

function doCreate()
{
    var xml = createQueryXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TE_CMD_MPLSTUNNEL_GET_AVALIABLETUNNEL4APS + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, tunnelResCallBack, null, "inputdata=" + xml);
}

function tunnelResCallBack(doc)
{
    var data = EncapsulateData(doc);
    var rowLength = data.getDataRowLength();
    if (rowLength <= 0) 
    {
        alert(RESOURCE["notunnel"]);
        return;
    }
    
    tunnelList = new Array();
    for (var i = 0; i < rowLength; i++) 
    {
        var tunnelObj = new Object();
        tunnelObj.tunnelType = data.getDataRowParam(i, "tunneltype");
        tunnelObj.nodeType = data.getDataRowParam(i, "nodetype");
        tunnelObj.tunnelIndex = data.getDataRowParam(i, "tunnelindex");
        tunnelObj.tunnelId = data.getDataRowParam(i, "tunnelid");
        tunnelObj.tunnelName = data.getDataRowParam(i, "tunnelname");
        tunnelObj.bandwidth = data.getDataRowParam(i, "bandwidth");
        tunnelObj.srcNode = data.getDataRowParam(i, "srcnode");
        tunnelObj.snkNode = data.getDataRowParam(i, "snknode");
        tunnelList[tunnelList.length] = tunnelObj;
    }
    xshowModalDialog("createaps.html", RESOURCE["newbfd"], 600, 550, "../../../../../images/", "no");
}

function createDeleteXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var indexes = st0.getSelectedRows();
    for (var i = 0, m = indexes.length; i < m; i++) 
    {
        var rowparams = new tagElement("row-params");
        
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("apsid", st0.getCellCurrentValue(indexes[i], "apsid", "apsid")));
        
        bussiness.appendChild(rowparams);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doDelete()
{
    if (!confirm(RESOURCE["deleteconfirminfo"])) 
    {
        return;
    }
    
    $("querybtn").disabled = true;
    $("newbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("deletebtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createDeleteXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_DEL_TUNNEL_PG + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, deleteCallBack, null, "inputdata=" + xml);
}

function deleteCallBack(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("newbtn").disabled = !btnRightArr.newbtn.right;
    
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    var oError = data.getError();
    var indexes = st0.getSelectedRows();
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var apsId = oError.getRowKey(i, "apsid");
        for (var j = indexes.length - 1; j >= 0; j--) 
        {
            var aps = st0.getCellCurrentValue(indexes[j], "apsid", "apsid");
            if (apsId == aps) 
            {
                indexes.splice(j, 1);
                break;
            }
        }
    }
    
    for (var k = indexes.length - 1; k >= 0; k--) 
    {
        st0.deleteRow(indexes[k]);
    }
    st0.adjustDataRows();
    
    countObj.setTotalCount(st0.getDataRowLength());
    if (st0.getDataRowLength() > 0) 
    {
        for (var i = 0, m = data.getBErrLength(); i < m; i++) 
        {
            if (st0.getModify(i)) 
            {
                $("applybtn").disabled = !btnRightArr.applybtn.right;
                break;
            }
        }
        if (st0.getSelectedRowCount() <= 0) 
        {
            st0.setRowSelect(0);
        }
    }
    rowSelectHandler();
}

function createApplyXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, len = st0.getDataRowLength(); i < len; i++) 
    {
        if (!st0.getModify(i)) 
        {
            continue;
        }
        
        var row = new tagElement("row-params");
        row.appendChild(createTagElement("neid", neid));
        row.appendChild(createTagElement("apsid", st0.getCellCurrentValue(i, "apsid", "apsid")));
        
        if (st0.getCellModify(i, "switchmode")) 
        {
            row.appendChild(createTagElement("switchmode", st0.getCellCurrentValue(i, "switchmode", "switchmode")));
        }
		
	/**	if (st0.getCellModify(i, "bdistatus")) 
        {
            row.appendChild(createTagElement("bdistatus", st0.getCellCurrentValue(i, "bdistatus", "bdistatus")));
        }**/
        
        if (st0.getCellModify(i, "rvtmode") || st0.getCellModify(i, "wtrtime")) 
        {
            row.appendChild(createTagElement("rvtmode", st0.getCellCurrentValue(i, "rvtmode", "rvtmode")));
            row.appendChild(createTagElement("wtrtime", st0.getCellCurrentValue(i, "wtrtime", "wtrtime")));
        }
        
        if (st0.getCellModify(i, "delaytime")) 
        {
            row.appendChild(createTagElement("delaytime", st0.getCellCurrentValue(i, "delaytime", "delaytime")));
        }
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doApply()
{
    $("querybtn").disabled = true;
    $("newbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("functionbtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createApplyXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_MODIFY_TUNNEL_PG + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, applyCallBack, null, "inputdata=" + xml);
}

function applyCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    refreshTableState(st0, window.tableconf[0], data);
    
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("newbtn").disabled = !btnRightArr.newbtn.right;
    if (st0.getSelectedRowCount() > 0) 
    {
        $("deletebtn").disabled = !btnRightArr.deletebtn.right;
        $("functionbtn").disabled = false;
    }
    if (data.getSErrorCode() != 0) 
    {
        $("applybtn").disabled = !btnRightArr.applybtn.right;
    }
}

/*
 *        ?
 */
function createjsDOMenu()
{
    removejsDOMmenu();
    
    var isModify = parseInt(st0.getCellStoreValue(st0.getSelectedRows()[0], "ismodify", "ismodify")) == 0 ? false : true;
    
    var cursorMenu = new jsDOMenu(220);
    cursorMenu.addMenuItem(new menuItem(RESOURCE["startprotocol"], "", setProtocol, "1", btnRightArr.ctrbtn.right));
    cursorMenu.addMenuItem(new menuItem(RESOURCE["stopprotocol"], "", setProtocol, "0", btnRightArr.ctrbtn.right));
    cursorMenu.addMenuItem(new menuItem("-"));
    cursorMenu.addMenuItem(new menuItem(RESOURCE["queryswitchingstatus"], "", querySwitchingStatus, "", btnRightArr.statebtn.right));
    cursorMenu.addMenuItem(new menuItem("-"));
    cursorMenu.addMenuItem(new menuItem(RESOURCE["clear"], "", switchAps, "0", isModify && btnRightArr.switchbtn.right));
    cursorMenu.addMenuItem(new menuItem(RESOURCE["lockoutofprotection"], "", switchAps, "5", isModify && btnRightArr.switchbtn.right));
    cursorMenu.addMenuItem(new menuItem(RESOURCE["forceswitching"], "", switchAps, "1", isModify && btnRightArr.switchbtn.right));
    cursorMenu.addMenuItem(new menuItem(RESOURCE["manualswitchingtoworking"], "", switchAps, "2", isModify && btnRightArr.switchbtn.right));
    cursorMenu.addMenuItem(new menuItem(RESOURCE["manualswitchingtoprotection"], "", switchAps, "3", isModify && btnRightArr.switchbtn.right));
    cursorMenu.addMenuItem(new menuItem(RESOURCE["exerciseswitching"], "", switchAps, "4", isModify && btnRightArr.switchbtn.right));

    setPopUpMenu(cursorMenu);
}

function setProtocol(param)
{
    hideMenu();
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var indexes = st0.getSelectedRows();
    for (var i = 0, m = indexes.length; i < m; i++) 
    {
        var rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("apsid", st0.getCellStoreValue(indexes[i], "apsid", "apsid")));
        rowparams.appendChild(createTagElement("protocolstatus", param));
        bussiness.appendChild(rowparams);
    }
    
    di.getRoot().appendChild(bussiness);
    
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_CTR_TUNNEL_PG + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, protocolCallBack, param, "inputdata=" + di.toString());
}

function protocolCallBack(doc, param)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    var oError = data.getError();
    var indexes = st0.getSelectedRows();
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var apsId = oError.getRowKey(i, "apsid");
        for (var j = indexes.length - 1; j >= 0; j--) 
        {
            var aps = st0.getCellCurrentValue(indexes[j], "apsid", "apsid");
            if (apsId == aps) 
            {
                indexes.splice(j, 1);
                break;
            }
        }
    }
    
    for (var k = indexes.length - 1; k >= 0; k--) 
    {
        var cell = st0.getCell(indexes[k], "protocolstatus");
        st0.setCellValue(cell, "protocolstatus", param);
        st0.getCellShow(indexes[k], "protocolstatus").element.innerHTML = RESOURCE[protocolStatus[param]];
    }
}

function querySwitchingStatus()
{
    hideMenu();
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var indexes = st0.getSelectedRows();
    for (var i = 0, m = indexes.length; i < m; i++) 
    {
        var rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("apsid", st0.getCellStoreValue(indexes[i], "apsid", "apsid")));
        bussiness.appendChild(rowparams);
    }
    
    di.getRoot().appendChild(bussiness);
    
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_GET_TUNNEL_PG_STATE + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, qStatusCallBack, null, "inputdata=" + di.toString());
}

function qStatusCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    for (var i = 0, m = data.getDataRowLength(); i < m; i++) 
    {
        var apsId = parseInt(data.getDataRowParam(i, "apsid"));
        for (var j = 0, n = st0.getDataRowLength(); j < n; j++) 
        {
            var aps = parseInt(st0.getCellStoreValue(j, "apsid", "apsid"));
            if (apsId == aps) 
            {
                var switchState = data.getDataRowParam(i, "switchstate");
                var cell = st0.getCell(j, "switchstatus");
                st0.setCellValue(cell, "switchstatus", switchState);
                st0.getCellShow(j, "switchstatus").element.innerHTML = RESOURCE[switchStatus[switchState]];
                break;
            }
        }
        
        var aps = parseInt(st1.getCellStoreValue(0, "apsid", "apsid"));
        if (apsId == aps) 
        {
            var curState = parseInt(data.getDataRowParam(i, "curstate"));
            var unit = parseInt(st1.getCellStoreValue(0, "unit", "unit"));
            if (curState == unit) 
            {
                var cell = st1.getCell(0, "curtunnel");
                st1.setCellValue(cell, "curtunnel", 1);
                st1.getCellShow(0, "curtunnel").element.innerHTML = RESOURCE["active"];
                
                cell = st1.getCell(1, "curtunnel");
                st1.setCellValue(cell, "curtunnel", 0);
                st1.getCellShow(1, "curtunnel").element.innerHTML = RESOURCE["standby"];
            }
            else 
            {
                var cell = st1.getCell(0, "curtunnel");
                st1.setCellValue(cell, "curtunnel", 0);
                st1.getCellShow(0, "curtunnel").element.innerHTML = RESOURCE["standby"];
                
                cell = st1.getCell(1, "curtunnel");
                st1.setCellValue(cell, "curtunnel", 1);
                st1.getCellShow(1, "curtunnel").element.innerHTML = RESOURCE["active"];
                
            }
            
            var wState = data.getDataRowParam(i, "wstate");
            var pState = data.getDataRowParam(i, "pstate");
            var cell = st1.getCell(0, "tunnelstatus");
            st1.setCellValue(cell, "tunnelstatus", wState);
            st1.getCellShow(0, "tunnelstatus").element.innerHTML = RESOURCE[tunnelStatus[wState]];
            
            cell = st1.getCell(1, "tunnelstatus");
            st1.setCellValue(cell, "tunnelstatus", pState);
            st1.getCellShow(1, "tunnelstatus").element.innerHTML = RESOURCE[tunnelStatus[pState]];
        }
    }
}

function switchAps(param)
{
    hideMenu();
    
    if (!confirm(RESOURCE["switchconfirminfo"])) 
    {
        return;
    }
    
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var indexes = st0.getSelectedRows();
    for (var i = 0, m = indexes.length; i < m; i++) 
    {
        var rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("apsid", st0.getCellStoreValue(indexes[i], "apsid", "apsid")));
        rowparams.appendChild(createTagElement("switchcmd", param));
        bussiness.appendChild(rowparams);
    }
    
    di.getRoot().appendChild(bussiness);
    
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_SWITCH_TUNNEL_PG + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, switchCallBack, null, "inputdata=" + di.toString());
}

function switchCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
}
