var MPLS_TUNNEL = 1;
var IP_TUNNEL = 3;
var GRE_TUNNEL = 4;
var INVALID_TUNNEL_INDEX = 0xFFFFFFFF;

var proType = new Array();
proType[0] = "protype0";
proType[1] = "protype1";

var protectmode = new Array();
protectmode[0] = "protectmode0";
protectmode[1] = "protectmode1";
protectmode[2] = "protectmode2";

var switchMode = new Array();
switchMode[0] = "singleended";
switchMode[1] = "dualended";

var bdiStatus = new Array();
bdiStatus[0] = "disabled";
bdiStatus[1] = "enabled";

var rvtMode = new Array();
rvtMode[0] = "nonrevertive";
rvtMode[1] = "revertive";

var protocolStatus = new Array();
protocolStatus[0] = "disabled";
protocolStatus[1] = "enabled";

var switchStatus = new Array();
switchStatus[0] = "state0";
switchStatus[1] = "state1";
switchStatus[2] = "state2";
switchStatus[3] = "state3";
switchStatus[4] = "state4";
switchStatus[5] = "state5";
switchStatus[6] = "state6";
switchStatus[7] = "state7";
switchStatus[8] = "state8";
switchStatus[9] = "state9";
switchStatus[10] = "state10";
switchStatus[11] = "state11";
switchStatus[12] = "state12";
switchStatus[13] = "state13";
switchStatus[14] = "state14";
switchStatus[15] = "state15";
switchStatus[255] = "invalid";

var unit = new Array();
unit[0] = "protection";
unit[1] = "working";

var unitConvert = new Array();
unitConvert[0] = "protection";
unitConvert[1] = "working";

var curTunnel = new Array();
curTunnel[0] = "standby";
curTunnel[1] = "active";
curTunnel[255] = "unknown";

var tunnelStatus = new Array();
tunnelStatus[0] = "unavailable";
tunnelStatus[1] = "available";
tunnelStatus[255] = "unknown";

var tunnelType = new Array();
tunnelType[1] = "mplstunnel";
tunnelType[3] = "iptunnel";
tunnelType[4] = "gretunnel";

var direction = new Array();
direction[0] = "unidirectional";
direction[1] = "bidirectional";

function createQueryXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function createTagElement(name, value)
{
    var elem = new tagElement("param");
    elem.setAttribute("name", name);
    elem.setAttribute("value", value);
    return elem;
}

function createParamElement(name, value)
{
    var elem = document.createElement("param");
    elem.setAttribute("name", name);
    elem.setAttribute("value", value);
    return elem;
}

function createTunnel(tunnel)
{
    var tunnelStr = (tunnel.tunnelName != null && tunnel.tunnelName != "") ? (tunnel.tunnelName + "-") : "";
    tunnelStr += RESOURCE[tunnelType[tunnel.tunnelType]] + "-" + tunnel.tunnelID + "(";    
    if (tunnel.tunnelType == 1) //is a mpls tunnel
    {
        tunnelStr += RESOURCE["srcnode"] + ":" + convertNumToIpaddr(tunnel.ingressID) + ",";
    }
    tunnelStr += RESOURCE["snknode"] + ":" + convertNumToIpaddr(tunnel.egressID) + ")";
    return tunnelStr;
}

function createTunnelRow(apsId, tunnelObj)
{
    var di = document.createElement("datainterface");
    var bparams = document.createElement("bussiness-params");
    
    var tunnelType = 0;
	var tunnelDirection = "-";
    var rowParams = document.createElement("row-params");
	rowParams.appendChild(createParamElement("apsid", apsId));
    rowParams.appendChild(createParamElement("unit", 1));
    rowParams.appendChild(createParamElement("curtunnel", 255));
    rowParams.appendChild(createParamElement("tunnelstatus", 255));
    if (null != tunnelObj.wInTunnel) 
    {
        tunnelType = tunnelObj.wInTunnel.tunnelType;
        rowParams.appendChild(createParamElement("egresstunnel", createTunnel(tunnelObj.wInTunnel)));
    }
    else
    {
    	rowParams.appendChild(createParamElement("egresstunnel", "-"));
    }
    if (null != tunnelObj.wOutTunnel) 
    {
        tunnelType = tunnelObj.wOutTunnel.tunnelType;
		if( null != tunnelObj.wOutTunnel.direction || undefined != tunnelObj.wOutTunnel.direction)
		{
			tunnelDirection = tunnelObj.wOutTunnel.direction;
		}
        rowParams.appendChild(createParamElement("ingresstunnel", createTunnel(tunnelObj.wOutTunnel)));
    }
    else
    {
    	rowParams.appendChild(createParamElement("ingresstunnel", "-"));
    }
    rowParams.appendChild(createParamElement("tunneltype", tunnelType));
    bparams.appendChild(rowParams);

    rowParams.appendChild(createParamElement("direction", tunnelDirection));
    bparams.appendChild(rowParams);
	    
    rowParams = document.createElement("row-params");
	rowParams.appendChild(createParamElement("apsid", apsId));
    rowParams.appendChild(createParamElement("unit", 0));
    rowParams.appendChild(createParamElement("curtunnel", 255));
    rowParams.appendChild(createParamElement("tunnelstatus", 255));
    if (null != tunnelObj.pInTunnel) 
    {
        tunnelType = tunnelObj.pInTunnel.tunnelType;
        rowParams.appendChild(createParamElement("egresstunnel", createTunnel(tunnelObj.pInTunnel)));
    }
    else
    {
    	rowParams.appendChild(createParamElement("egresstunnel", "-"));
    }
    if (null != tunnelObj.pOutTunnel) 
    {
        tunnelType = tunnelObj.pOutTunnel.tunnelType;
		if( null != tunnelObj.pOutTunnel.direction || undefined != tunnelObj.pOutTunnel.direction)
		{
			tunnelDirection = tunnelObj.pOutTunnel.direction;
		}
        rowParams.appendChild(createParamElement("ingresstunnel", createTunnel(tunnelObj.pOutTunnel)));
    }
    else
    {
    	rowParams.appendChild(createParamElement("ingresstunnel", "-"));
    }
    rowParams.appendChild(createParamElement("tunneltype", tunnelType));
    bparams.appendChild(rowParams);
	
	rowParams.appendChild(createParamElement("direction", tunnelDirection));
    bparams.appendChild(rowParams);
	
	di.appendChild(bparams);
    return di;
}

function showErrDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
	errArr[1] = "apsid";    
    openErrPage("../../../../../page/", data.getError(), errArr);
}
