/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.tpid.script;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.script.TEScriptCmd;
import com.huawei.nglct.cbb.script.TEScriptHandler;
import com.huawei.nglct.cbb.script.TEScriptOperationMgr;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ip.ptn.tpid.db.TETPIDDbMgr;
import com.huawei.nglct.po.embeddednemgrmo.mstp.TEMPLSNeAttributeMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.List;
import org.slf4j.Logger;

public class TETPIDScriptHandler
implements TEScriptHandler {
    private static final Logger logger = TELogFactory.getNormalLogger();

    public int doExport(int neID, int item) {
        int result = 0;
        if (!TENEListMgr.getInstance().isAddedNE(neID)) {
            return result;
        }
        return this.writeExportDataToScript(neID, item);
    }

    private int writeExportDataToScript(int neID, int item) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        TEMPLSNeAttributeMOPO tpidMO = TETPIDDbMgr.getTPIDMOFromDB(neID, errRet);
        if (0 != errRet.getResult()) {
            return 1092743443;
        }
        if (null == tpidMO) {
            logger.info("tpidMO is null! neID->" + neID);
            return 0;
        }
        TEScriptCmd cmd = this.constractScriptCmd(tpidMO, item);
        if (null == cmd) {
            return 0;
        }
        return TEScriptOperationMgr.getInstance().writeCommand(neID, item, cmd);
    }

    private TEScriptCmd constractScriptCmd(TEMPLSNeAttributeMOPO tpidMO, int item) {
        TEScriptCmd cmd = new TEScriptCmd();
        cmd.setCmdCode(item);
        String tpidStr = tpidMO.getTPID();
        try {
            int tpid = Integer.parseInt(tpidStr, 16);
            cmd.addPara("netpid", tpid, true, false);
        }
        catch (Exception e) {
            logger.error("parse netpid fail!", (Throwable)e);
        }
        return cmd;
    }

    public int doImport(int neID, int item, List<TEScriptCmd> contents) {
        return 0;
    }
}

