/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.tpid.db;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginLog;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.po.embeddednemgrmo.mstp.TEMPLSNeAttributeMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.List;
import org.slf4j.Logger;

public class TETPIDDbMgr {
    public static final String UNKNOWN = "UNKNOWN";
    private static final Logger logger = TELogFactory.getNormalLogger();

    private TETPIDDbMgr() {
    }

    public static TEMPLSNeAttributeMOPO getTPIDMOFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TETPIDDbMgr.getTPIDMOFromDB";
        TEBeanPluginLog.logFuncBegin((String)"TETPIDDbMgr.getTPIDMOFromDB");
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        TEMPLSNeAttributeMOPO moDevice = null;
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                TETPIDDbMgr.logNullNEError(neID);
                TETPIDDbMgr.setOperFail(neID, errRet, 1090596385);
                TEBeanPluginLog.logFuncEnd((String)"TETPIDDbMgr.getTPIDMOFromDB");
                return moDevice;
            }
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID}, TEMPLSNeAttributeMOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID}, TEMPLSNeAttributeMOPO.class);
        }
        catch (Exception e) {
            TETPIDDbMgr.logExceptionOnGet(neID, e);
            TETPIDDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TETPIDDbMgr.getTPIDMOFromDB");
            return moDevice;
        }
        if (null == dbResult) {
            TETPIDDbMgr.logNullErrorOnGet(neID);
            TETPIDDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TETPIDDbMgr.getTPIDMOFromDB");
            return moDevice;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            List data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                moDevice = (TEMPLSNeAttributeMOPO)data.get(0);
            }
        } else {
            TETPIDDbMgr.logRetCodeErrorOnGet(neID, retCode);
            TETPIDDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TETPIDDbMgr.getTPIDMOFromDB");
        return moDevice;
    }

    public static void updateTPIDMOToDB(int neID, TEMPLSNeAttributeMOPO tpidMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TETPIDDbMgr.updateTPIDMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TETPIDDbMgr.updateTPIDMOToDB");
        if (null == tpidMO) {
            return;
        }
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.update((int[])new int[]{neID}, (Object)tpidMO) : TECommonDaoService.update_NonLock((int[])new int[]{neID}, (Object)tpidMO);
        }
        catch (Exception e) {
            TETPIDDbMgr.logExceptionErrorOnUpdate(neID, e);
            TETPIDDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TETPIDDbMgr.updateTPIDMOToDB");
            return;
        }
        if (null == dbResult) {
            TETPIDDbMgr.logNullErrorOnUpdate(neID);
            TETPIDDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TETPIDDbMgr.updateTPIDMOToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TETPIDDbMgr.logRetCodeErrorOnUpdate(neID, retCode);
            TETPIDDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TETPIDDbMgr.updateTPIDMOToDB");
    }

    public static void createTPIDMOToDB(int neID, TEMPLSNeAttributeMOPO tpidMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TETPIDDbMgr.createTPIDMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TETPIDDbMgr.createTPIDMOToDB");
        if (null == tpidMO) {
            return;
        }
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.create((int[])new int[]{neID}, (Object)tpidMO) : TECommonDaoService.create_NonLock((int[])new int[]{neID}, (Object)tpidMO);
        }
        catch (Exception e) {
            TETPIDDbMgr.logExceptionErrorOnCreate(neID, e);
            TETPIDDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TETPIDDbMgr.createTPIDMOToDB");
            return;
        }
        if (null == dbResult) {
            TETPIDDbMgr.logNullErrorOnCreate(neID);
            TETPIDDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TETPIDDbMgr.createTPIDMOToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TETPIDDbMgr.logRetCodeErrorOnCreate(neID, retCode);
            TETPIDDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TETPIDDbMgr.createTPIDMOToDB");
    }

    public static void delTPIDMOToDB(int neID, TEMPLSNeAttributeMOPO tpidMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TETPIDDbMgr.delTPIDMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TETPIDDbMgr.delTPIDMOToDB");
        if (null == tpidMO) {
            return;
        }
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.delete((int[])new int[]{neID}, (Object)tpidMO) : TECommonDaoService.delete_NonLock((int[])new int[]{neID}, (Object)tpidMO);
        }
        catch (Exception e) {
            TETPIDDbMgr.logExceptionErrorOnDel(neID, e);
            TETPIDDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TETPIDDbMgr.delTPIDMOToDB");
            return;
        }
        if (null == dbResult) {
            TETPIDDbMgr.logNullErrorOnDel(neID);
            TETPIDDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TETPIDDbMgr.delTPIDMOToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TETPIDDbMgr.logRetCodeErrorOnDel(neID, retCode);
            TETPIDDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TETPIDDbMgr.delTPIDMOToDB");
    }

    private static void setOperFail(int neID, TEErrInfoReturn rspErrRet, int retCode) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = ne.getNEName();
        rspErrRet.setResult(1090605056);
        rspErrRet.addErrInfo(TETPIDDbMgr.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, retCode).getErrList());
    }

    public static TEErrInfoReturn constructErrInfoReturn(int neID, int errorCode) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = UNKNOWN;
        if (null != ne) {
            neName = ne.getNEName();
        }
        return TETPIDDbMgr.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, errorCode);
    }

    public static TEErrInfoReturn constructErrInfoReturn(int[] objID, String[] objName, int retCode) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        errRet.setResult(2);
        TEErrInfo errInfo = new TEErrInfo();
        errInfo.setObjID(objID);
        errInfo.setObjName(TETPIDDbMgr.getObjName(objName));
        errInfo.setErrorCode(retCode);
        errRet.addErrInfo(errInfo);
        return errRet;
    }

    public static String getObjName(String[] objName) {
        StringBuffer objNameBuffer = new StringBuffer();
        int len = objName.length;
        for (int i = 0; i < len; ++i) {
            if (0 != i) {
                objNameBuffer.append('-');
            }
            objNameBuffer.append(objName[i]);
        }
        return objNameBuffer.toString();
    }

    private static void logNullNEError(int neID) {
        logger.error("ne is null! neID->" + neID);
    }

    private static void logRetCodeErrorOnGet(int neID, int retCode) {
        String tipStr = String.format("get mo from db device fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }

    private static void logNullErrorOnGet(int neID) {
        logger.error("get mo from db fail! dbResult is null! neID->" + neID);
    }

    private static void logExceptionOnGet(int neID, Exception e) {
        logger.error("get mo from db fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeErrorOnUpdate(int neID, int retCode) {
        String tipStr = String.format("update mo to db device fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }

    private static void logNullErrorOnUpdate(int neID) {
        logger.error("update mo to db device fail! dbResult is null! neID->" + neID);
    }

    private static void logExceptionErrorOnUpdate(int neID, Exception e) {
        logger.error("update mo to db device fail! neID->" + neID, (Throwable)e);
    }

    private static void logNullErrorOnCreate(int neID) {
        logger.error("create mo to db device fail! neID->" + neID);
    }

    private static void logExceptionErrorOnCreate(int neID, Exception e) {
        logger.error("create mo to db device fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeErrorOnCreate(int neID, int retCode) {
        String tipStr = String.format("create mo to db device fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }

    private static void logNullErrorOnDel(int neID) {
        logger.error("delete mo to db device fail! neID->" + neID);
    }

    private static void logExceptionErrorOnDel(int neID, Exception e) {
        logger.error("delete mo to db device fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeErrorOnDel(int neID, int retCode) {
        String tipStr = String.format("delete mo to db device fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }
}

