/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.tpid.beanplugin;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.beanplugin.TEBeanPlugin;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginUtil;
import com.huawei.nglct.nemgr.ip.ptn.tpid.db.TETPIDDbMgr;
import com.huawei.nglct.po.embeddednemgrmo.mstp.TEMPLSNeAttributeMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.List;
import org.slf4j.Logger;

public class TEQueryTPIDBeanPlugin
extends TEBeanPlugin {
    private static final Logger logger = TELogFactory.getNormalLogger();

    public TEErrInfoReturn doAfterSendMessage(int neid, SubFunc subFunc, List<Operation> operationList) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        String operName = null;
        for (Operation oper : operationList) {
            operName = oper.getName();
            if (!"NSCMD_PTN_MPLS_PW_GET_ETH_NETPID".equals(operName) && !"NSCMD_PTNETH_GET_NEQINQTPID".equals(operName)) continue;
            TEErrInfoReturn tempErrRet = new TEErrInfoReturn();
            this.handleNSCMD_PTN_GET_ETH_NETPID(neid, oper, tempErrRet);
            if (0 == tempErrRet.getResult()) continue;
            errRet.setResult(2);
            errRet.addErrInfo(tempErrRet.getErrList());
        }
        return errRet;
    }

    private void handleNSCMD_PTN_GET_ETH_NETPID(int neID, Operation oper, TEErrInfoReturn errRet) {
        String tpID = TEBeanPluginUtil.getOutputPartValueStr((Operation)oper, (String)"tpID", (String)"");
        if (null == tpID || tpID.isEmpty()) {
            return;
        }
        TEMPLSNeAttributeMOPO tpidMO = TETPIDDbMgr.getTPIDMOFromDB(neID, errRet);
        if (0 == errRet.getResult()) {
            if (null == tpidMO) {
                logger.info("tpidMO is null! will create!");
                tpidMO = new TEMPLSNeAttributeMOPO();
                if (this.setTPMO(tpidMO, oper, tpID)) {
                    TETPIDDbMgr.createTPIDMOToDB(neID, tpidMO, errRet);
                }
            } else if (this.setTPMO(tpidMO, oper, tpID)) {
                TETPIDDbMgr.updateTPIDMOToDB(neID, tpidMO, errRet);
            }
        }
        TEBeanPluginUtil.fillErrorToOperation((Operation)oper, (TEErrInfoReturn)errRet);
    }

    private boolean setTPMO(TEMPLSNeAttributeMOPO tpMO, Operation oper, String tpID) {
        String operName = oper.getName();
        if ("NSCMD_PTN_MPLS_PW_GET_ETH_NETPID".equals(operName)) {
            tpMO.setTPID(tpID);
        } else if ("NSCMD_PTNETH_GET_NEQINQTPID".equals(operName)) {
            tpMO.setNEPortTPID(tpID);
        } else {
            logger.error("cmd Name is error! exit!");
            return false;
        }
        return true;
    }
}

