/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.snooping;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

public class TESnoopingQueryRouteBean
extends TENEExplorerBean {
    private static final String ELAN = "2";
    private HashMap uniPortNameMap = new HashMap();
    private HashMap nniPortNameMap = new HashMap();
    private static final int INVALID_SUBSLOTID = 255;
    private static final int PW = 1;
    private static final int QINQ = 4;
    private static final int PORT = 3;
    private static final int UNI = 1;
    private boolean queryUNI = false;
    private boolean queryNNI = false;
    private TimeZoneDateBean TimeProccessor = null;

    public void handleMessage(int neid, ArrayList operList, SubFunc subfunc) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operList);
        this.TimeProccessor = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid);
        if (2 == Integer.parseInt(this.outputData.getErrorMessage().getErrorcode())) {
            return;
        }
        BussinessParams bp = this.outputData.getBussinessParams();
        ArrayList<RowParams> tmpRowParamList = new ArrayList<RowParams>();
        RowParams[] rowsArr = bp.getRowParams();
        RowParams row = null;
        RowParams tmpRow = null;
        Param index = null;
        Param vlan = null;
        String portData = null;
        int portNum = -1;
        StringBuffer buf = new StringBuffer();
        for (int iIndex = 0; iIndex < rowsArr.length; ++iIndex) {
            row = rowsArr[iIndex];
            index = row.getParam("indexID");
            vlan = row.getParam("vlanID");
            portNum = Integer.parseInt(row.getParam("portNum").getValue());
            portData = row.getParam("portData").getValue();
            byte[] portDataArray = portData.getBytes();
            int arrayIndex = 0;
            for (int jIndex = 0; jIndex < portNum; ++jIndex) {
                buf.delete(0, buf.length());
                tmpRow = new RowParams();
                tmpRow.addParam(index);
                tmpRow.addParam(vlan);
                int portType = IOStreamConvertor.readPositiveShort((byte[])portDataArray, (int)arrayIndex);
                tmpRow.addParam("portType", String.valueOf(portType));
                int portID = IOStreamConvertor.readPositiveInt((byte[])portDataArray, (int)(arrayIndex += 2));
                arrayIndex += 4;
                if (1 == portType) {
                    if (!this.queryUNI) {
                        this.queryUNI = true;
                        this.getUniPortName(index.getValue());
                    }
                    tmpRow.addParam("portID", (String)this.uniPortNameMap.get(String.valueOf(portID)));
                    tmpRow.addParam("interfaceIndex", portID + "");
                } else {
                    if (!this.queryNNI) {
                        this.queryNNI = true;
                        this.getNniPortName(index.getValue());
                    }
                    tmpRow.addParam("portID", (String)this.nniPortNameMap.get(String.valueOf(portID)));
                    tmpRow.addParam("interfaceIndex", portID + "");
                }
                int portState = IOStreamConvertor.readPositiveShort((byte[])portDataArray, (int)arrayIndex);
                tmpRow.addParam("portState", String.valueOf(portState));
                int year = IOStreamConvertor.readPositiveShort((byte[])portDataArray, (int)(arrayIndex += 2)) + 1990;
                int month = IOStreamConvertor.readPositiveShort((byte[])portDataArray, (int)(arrayIndex += 2));
                int day = IOStreamConvertor.readPositiveShort((byte[])portDataArray, (int)(arrayIndex += 2));
                int hour = IOStreamConvertor.readPositiveShort((byte[])portDataArray, (int)(arrayIndex += 2));
                int minute = IOStreamConvertor.readPositiveShort((byte[])portDataArray, (int)(arrayIndex += 2));
                int second = IOStreamConvertor.readPositiveShort((byte[])portDataArray, (int)(arrayIndex += 2));
                int centiSec = IOStreamConvertor.readPositiveShort((byte[])portDataArray, (int)(arrayIndex += 2));
                arrayIndex += 2;
                buf.append(year).append('-').append(month).append('-').append(day).append(" ");
                buf.append(hour).append(':').append(minute).append(':').append(second).append(':').append(centiSec);
                Calendar time = TEDateUtils.strToCalendar((String)buf.toString());
                tmpRow.addParam("createTime", this.TimeProccessor.calendarToTime(time));
                int rtTime = IOStreamConvertor.readPositiveShort((byte[])portDataArray, (int)arrayIndex);
                arrayIndex += 2;
                tmpRow.addParam("remainRTAgeTime", String.valueOf(rtTime));
                tmpRowParamList.add(tmpRow);
            }
        }
        bp.clearRowParams();
        int size = tmpRowParamList.size();
        for (int i = 0; i < size; ++i) {
            bp.addRowParams((RowParams)tmpRowParamList.get(i));
        }
    }

    private void getUniPortName(String serviceIndex) {
        TEConfigurationDataMgr configurationData = TEConfigurationDataMgr.getInstance();
        ArrayList<Object> uniPortList = new ArrayList<Object>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_SERVICE_GET_ETHVUNI");
        Input input = oper.getInput();
        input.setPartValue("servType", ELAN);
        input.setPartValue("servIndex", serviceIndex + "");
        input.setPartValue("vuniId", "0");
        uniPortList.add(oper.clone());
        TENECommMgr.getInstance().sendCommand(this.neid, uniPortList, this.getTimeOut());
        Operation tmpOper = (Operation)uniPortList.get(0);
        uniPortList.clear();
        for (Output output : tmpOper.getOutput()) {
            int slotid = Integer.parseInt(output.getPartValue("slotid"));
            int boardType = configurationData.getBoardType(this.neid, slotid);
            String boardName = configurationData.getBoardTypeName(this.neid, boardType);
            StringBuffer portAllName = new StringBuffer();
            portAllName.append(slotid).append("-").append(boardName).append("-");
            int subslotid = Integer.parseInt(output.getPartValue("subslotid"));
            if (255 != subslotid) {
                int subboardType = configurationData.getSubboardType(this.neid, slotid, subslotid);
                String subboardName = configurationData.getBoardTypeName(this.neid, subboardType);
                portAllName.append(subslotid).append("-").append(subboardName).append("-");
            }
            int port = Integer.parseInt(output.getPartValue("port"));
            String portName = configurationData.getPortNameForPTN(this.neid, slotid, boardType, port);
            portAllName.append(portName);
            String vuniId = output.getPartValue("vuniId");
            this.uniPortNameMap.put(vuniId, portAllName.toString());
        }
    }

    private void getNniPortName(String serviceIndex) {
        TEConfigurationDataMgr configurationData = TEConfigurationDataMgr.getInstance();
        ArrayList<Object> uniPortList = new ArrayList<Object>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_SERVICE_GET_EVNNI");
        Input input = oper.getInput();
        input.setPartValue("servType", ELAN);
        input.setPartValue("servIndex", serviceIndex + "");
        input.setPartValue("vnniId", "0");
        uniPortList.add(oper.clone());
        TENECommMgr.getInstance().sendCommand(this.neid, uniPortList, this.getTimeOut());
        Operation tmpOper = (Operation)uniPortList.get(0);
        uniPortList.clear();
        for (Output output : tmpOper.getOutput()) {
            StringBuffer portAllName = new StringBuffer();
            String vnniId = output.getPartValue("vnniId");
            int carrierType = Integer.parseInt(output.getPartValue("carrierType"));
            if (1 == carrierType) {
                long pwIndex = Long.parseLong(output.getPartValue("port"));
                String pwID = this.getPWID(pwIndex);
                portAllName.append("PW-").append(pwID);
            }
            if (4 == carrierType) {
                long QINQIndex = Long.parseLong(output.getPartValue("port"));
                portAllName.append("QinQ-").append(QINQIndex);
            }
            if (3 == carrierType) {
                int slotid = Integer.parseInt(output.getPartValue("slotid"));
                int boardType = configurationData.getBoardType(this.neid, slotid);
                String boardName = configurationData.getBoardTypeName(this.neid, boardType);
                portAllName.append(slotid).append("-").append(boardName).append("-");
                int subslotid = Integer.parseInt(output.getPartValue("subslotid"));
                if (255 != subslotid) {
                    int subboardType = configurationData.getSubboardType(this.neid, slotid, subslotid);
                    String subboardName = configurationData.getBoardTypeName(this.neid, subboardType);
                    portAllName.append(subslotid).append("-").append(subboardName).append("-");
                }
                int port = Integer.parseInt(output.getPartValue("port"));
                String portName = configurationData.getPortNameForPTN(this.neid, slotid, boardType, port);
                portAllName.append(portName);
            }
            this.nniPortNameMap.put(vnniId, portAllName.toString());
        }
    }

    private String getPWID(long pwIndex) {
        String pwID = "";
        ArrayList<Object> pwIDList = new ArrayList<Object>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_MPLS_PW_GET_PW");
        Input input = oper.getInput();
        input.setPartValue("pwIndex", pwIndex + "");
        pwIDList.add(oper.clone());
        TENECommMgr.getInstance().sendCommand(this.neid, pwIDList, this.getTimeOut());
        Operation tmpOper = (Operation)pwIDList.get(0);
        pwIDList.clear();
        for (Output output : tmpOper.getOutput()) {
            pwID = output.getPartValue("pwId");
            if (pwID != null) continue;
            pwID = output.getPartValue("pwID");
        }
        return pwID;
    }
}

