/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.snooping;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ptn.snooping.TEIGMPUtils;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class TESnoopingQueryMemInfMgrInfoBean
extends TENEExplorerBean {
    private static final String ELAN = "2";
    private HashMap uniPortNameMap = new HashMap();
    private HashMap nniPortNameMap = new HashMap();
    private static final int INVALID_SUBSLOTID = 255;
    private static final int INVALID_REMAINAGETIME = 255;
    private static final int PW = 1;
    private static final int PORT = 3;
    private static final int QINQ = 4;
    private static final int UNI = 1;
    private boolean queryUNI = false;
    private boolean queryNNI = false;
    private static final String DEFAULT = "0";
    private static final String PB_NNI = "1";
    String sAwarePorttype = "0";
    private static final String C_AWARED = "1";
    private static final String S_AWARED = "2";
    private static final String IVL = "2";

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
        int errorCode = Integer.parseInt(this.outputData.getErrorMessage().getErrorcode());
        if (0 != errorCode && 1 != errorCode) {
            return;
        }
        BussinessParams bParas = this.outputData.getBussinessParams();
        ArrayList<RowParams> tmpRowParamList = new ArrayList<RowParams>();
        ArrayList rowList = bParas.getRowParamList();
        RowParams rowParas = null;
        RowParams tempRow = null;
        Param index = ((RowParams)rowList.get(0)).getParam("indexID");
        Param vlan = ((RowParams)rowList.get(0)).getParam("vlanID");
        String portData = null;
        int portNum = -1;
        Iterator iter = rowList.iterator();
        while (iter.hasNext()) {
            rowParas = (RowParams)iter.next();
            BigInteger indexIDLong = new BigInteger(index.getValue());
            if (0L > indexIDLong.longValue()) {
                iter.remove();
                continue;
            }
            Param macAddParam = rowParas.getParam("macAdd");
            String macAdd = macAddParam.getValue();
            StringBuffer buf = new StringBuffer();
            if (macAdd.length() == 12) {
                int macL = macAdd.length();
                for (int j = 0; j < macL; j += 2) {
                    buf.append(macAdd.charAt(j)).append(macAdd.charAt(j + 1)).append("-");
                }
                buf.deleteCharAt(buf.length() - 1);
                macAddParam.setValue(buf.toString().trim());
            }
            buf.delete(0, buf.length());
            int offset = 14;
            portData = rowParas.getParam("portData").getValue();
            StringBuffer portDataStrbuf = new StringBuffer(portData);
            portDataStrbuf.delete(0, offset);
            portNum = Integer.parseInt(portDataStrbuf.substring(0, 4), 16);
            offset = 4;
            portDataStrbuf.delete(0, offset);
            offset = 0;
            for (int i = 0; i < portNum; ++i) {
                tempRow = new RowParams();
                tempRow.addParam(index);
                tempRow.addParam(vlan);
                tempRow.addParam(macAddParam);
                int portType = Integer.parseInt(portDataStrbuf.substring(offset, offset + 2), 16);
                int portID = Integer.parseInt(portDataStrbuf.substring(offset += 2, offset + 4), 16);
                int remainRTAgeTime = Integer.parseInt(portDataStrbuf.substring(offset += 4, offset + 2), 16);
                offset += 2;
                tempRow.addParam("portType", String.valueOf(portType));
                if (1 == portType) {
                    if (!this.queryUNI) {
                        this.queryUNI = true;
                        this.getUniPortName(index.getValue());
                    }
                    if (this.uniPortNameMap.get(String.valueOf(portID)) != null) {
                        tempRow.addParam("portID", (String)this.uniPortNameMap.get(String.valueOf(portID)));
                        tempRow.getParam("portType").setValue("1");
                    }
                    if ((TEIGMPUtils.isSupport1adForS_I(neid) || this.sAwarePorttype.equals("1")) && this.nniPortNameMap.get(String.valueOf(portID)) != null) {
                        tempRow.addParam("portID", (String)this.nniPortNameMap.get(String.valueOf(portID)));
                        tempRow.getParam("portType").setValue("2");
                    }
                    tempRow.addParam("interfaceIndex", portID + "");
                } else {
                    if (!this.queryNNI) {
                        this.queryNNI = true;
                        this.getNniPortName(index.getValue());
                    }
                    tempRow.addParam("portID", (String)this.nniPortNameMap.get(String.valueOf(portID)));
                    tempRow.addParam("interfaceIndex", portID + "");
                }
                if (remainRTAgeTime == 255) {
                    tempRow.addParam("remainRTAgeTime", "-");
                } else {
                    tempRow.addParam("remainRTAgeTime", String.valueOf(remainRTAgeTime));
                }
                tmpRowParamList.add(tempRow);
            }
        }
        bParas.clearRowParams();
        int size = tmpRowParamList.size();
        for (int i = 0; i < size; ++i) {
            bParas.addRowParams((RowParams)tmpRowParamList.get(i));
        }
    }

    private void getUniPortName(String serviceIndex) {
        Input input;
        boolean isSupportPBUNi = false;
        TEConfigurationDataMgr configurationData = TEConfigurationDataMgr.getInstance();
        ArrayList<Object> uniPortList = new ArrayList<Object>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_SERVICE_GET_SAWAREPORT_ROLE");
        if (oper != null) {
            isSupportPBUNi = true;
            input = oper.getInput();
            input.setPartValue("serviceIndex", serviceIndex);
            uniPortList.add(oper.clone());
        } else {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_SERVICE_GET_ELANINFO");
            if (oper != null) {
                input = oper.getInput();
                input.setPartValue("indexID", serviceIndex);
                uniPortList.add(oper.clone());
            }
        }
        oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_SERVICE_GET_ETHVUNI");
        if (oper != null) {
            input = oper.getInput();
            input.setPartValue("servType", "2");
            input.setPartValue("servIndex", serviceIndex + "");
            input.setPartValue("vuniId", DEFAULT);
            uniPortList.add(oper.clone());
        }
        if ((oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_SERVICE_GET_ETHPBVUNI_EX")) != null) {
            oper.getInput().setPartValue("servType", "2");
            oper.getInput().setPartValue("servIndex", serviceIndex + "");
            oper.getInput().setPartValue("vuniId", DEFAULT);
            uniPortList.add(oper.clone());
        }
        String ethBridage = "1";
        String macMode = "2";
        TENECommMgr.getInstance().sendCommand(this.neid, uniPortList, this.getTimeOut());
        int jlen = uniPortList.size();
        for (int j = 0; j < jlen; ++j) {
            Operation tmpOperat = (Operation)uniPortList.get(j);
            for (Output opt : tmpOperat.getOutput()) {
                if (Integer.valueOf(opt.getFault(0).getCode()) != 0) continue;
                if (j == 0) {
                    if (isSupportPBUNi) {
                        this.sAwarePorttype = opt.getPartValue("sawareporttype");
                        continue;
                    }
                    ethBridage = opt.getPartValue("tagFlag");
                    macMode = opt.getPartValue("macMode");
                    continue;
                }
                int slotid = Integer.parseInt(opt.getPartValue("slotid"));
                int boardType = configurationData.getBoardType(this.neid, slotid);
                String boardName = configurationData.getBoardTypeName(this.neid, boardType);
                String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotid);
                StringBuffer portAllNames = new StringBuffer();
                if (!subrackName.isEmpty()) {
                    portAllNames.append(subrackName).append("-");
                }
                portAllNames.append(slotid).append("-").append(boardName).append("-");
                int subSlotid = Integer.parseInt(opt.getPartValue("subslotid"));
                if (255 != subSlotid) {
                    int subboardType = configurationData.getSubboardType(this.neid, slotid, subSlotid);
                    String subboardName = configurationData.getBoardTypeName(this.neid, subboardType);
                    portAllNames.append(subSlotid).append("-").append(subboardName).append("-");
                }
                int port = Integer.parseInt(opt.getPartValue("port"));
                String portName = configurationData.getPortNameForPTN(this.neid, slotid, boardType, port);
                portAllNames.append(portName);
                int tagNum = Integer.parseInt(opt.getPartValue("tagNum"));
                if (0 != tagNum) {
                    String tagIds = opt.getPartValue("svlan");
                    if (tagIds != null) {
                        portAllNames.append("[" + tagIds + "]");
                    } else {
                        tagIds = opt.getPartValue("tagIds");
                        int tagidLen = 8;
                        StringBuffer buf = new StringBuffer();
                        int vlanLen = tagIds.length();
                        for (int z = 0; z < vlanLen; z += tagidLen) {
                            int tagID = Integer.parseInt(tagIds.substring(z, z + tagidLen), 16);
                            buf.append(tagID).append(',');
                        }
                        String tagidStr = buf.delete(buf.length() - 1, buf.length()).toString();
                        tagidStr = "[" + TEIGMPUtils.parseEncapsValueList(tagidStr) + "]";
                        portAllNames.append(tagidStr);
                    }
                }
                String vID = "";
                if (this.sAwarePorttype.equals("1") || ethBridage.equals("2") && macMode.equals("2") && TEIGMPUtils.isSupport1adForS_I(this.neid)) {
                    if (j == 1) {
                        vID = opt.getPartValue("vuniId");
                        this.nniPortNameMap.put(vID, portAllNames.toString());
                    }
                    if (j != 2) continue;
                    vID = opt.getPartValue("vuniId");
                    this.uniPortNameMap.put(vID, portAllNames.toString());
                    continue;
                }
                vID = opt.getPartValue("vuniId");
                this.uniPortNameMap.put(vID, portAllNames.toString());
                vID = opt.getPartValue("vnniId");
                this.uniPortNameMap.put(vID, portAllNames.toString());
            }
        }
        uniPortList.clear();
    }

    private void getNniPortName(String serviceIndex) {
        TEConfigurationDataMgr configData = TEConfigurationDataMgr.getInstance();
        ArrayList<Object> uniPortList = new ArrayList<Object>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_SERVICE_GET_EVNNI");
        Input ipt = oper.getInput();
        ipt.setPartValue("servType", "2");
        ipt.setPartValue("servIndex", serviceIndex + "");
        ipt.setPartValue("vnniId", DEFAULT);
        uniPortList.add(oper.clone());
        TENECommMgr.getInstance().sendCommand(this.neid, uniPortList, this.getTimeOut());
        Operation tmpOper = (Operation)uniPortList.get(0);
        uniPortList.clear();
        for (Output output : tmpOper.getOutput()) {
            StringBuffer portAllNames = new StringBuffer();
            String vnniId = output.getPartValue("vnniId");
            int carrierType = Integer.parseInt(output.getPartValue("carrierType"));
            if (1 == carrierType) {
                long pwIndex = Long.parseLong(output.getPartValue("port"));
                String pwID = this.getPWID(pwIndex);
                portAllNames.append("PW-").append(pwID);
            }
            if (4 == carrierType) {
                long QINQIndex = Long.parseLong(output.getPartValue("port"));
                portAllNames.append("QinQ-").append(QINQIndex);
            }
            if (3 == carrierType) {
                int slotid = Integer.parseInt(output.getPartValue("slotid"));
                int boardType = configData.getBoardType(this.neid, slotid);
                String boardName = configData.getBoardTypeName(this.neid, boardType);
                portAllNames.append(slotid).append("-").append(boardName).append("-");
                int subslotid = Integer.parseInt(output.getPartValue("subslotid"));
                if (255 != subslotid) {
                    int subboardType = configData.getSubboardType(this.neid, slotid, subslotid);
                    String subboardName = configData.getBoardTypeName(this.neid, subboardType);
                    portAllNames.append(subslotid).append("-").append(subboardName).append("-");
                }
                int port = Integer.parseInt(output.getPartValue("port"));
                String portName = configData.getPortNameForPTN(this.neid, slotid, boardType, port);
                portAllNames.append(portName);
            }
            this.nniPortNameMap.put(vnniId, portAllNames.toString());
        }
    }

    private String getPWID(long pwIndex) {
        String pwId = "";
        ArrayList<Object> pwIDList = new ArrayList<Object>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_MPLS_PW_GET_PW");
        Input ipt = oper.getInput();
        ipt.setPartValue("pwIndex", pwIndex + "");
        pwIDList.add(oper.clone());
        TENECommMgr.getInstance().sendCommand(this.neid, pwIDList, this.getTimeOut());
        Operation tmpOper = (Operation)pwIDList.get(0);
        pwIDList.clear();
        for (Output output : tmpOper.getOutput()) {
            pwId = output.getPartValue("pwId");
            if (pwId != null) continue;
            pwId = output.getPartValue("pwID");
        }
        return pwId;
    }
}

