/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.snooping;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.ip.ptn.snooping.TEIGMPUtils;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TEQueryQuickLeaveBean
extends TENEExplorerBean {
    private static final String ELAN = "2";
    private HashMap uniPortNameMap = new HashMap();
    private HashMap nniPortNameMap = new HashMap();
    private static final int INVALID_SUBSLOTID = 255;
    private static final int PW = 1;
    private static final int QINQ = 4;
    private static final int PORT = 3;
    private static final String UNI = "1";
    private boolean queryUNI = false;
    private boolean queryNNI = false;
    private static final String DEFAULT = "0";
    private static final String PB_NNI = "1";
    String sAwarePorttype = "0";
    private static final String C_AWARED = "1";
    private static final String S_AWARED = "2";
    protected static final String PBTYPE_PBNNI = "1";
    protected static final String PBTYPE_VUNI = "2";
    protected static final String PBTYPE_DEFAULT = "0";
    private static final String IVL = "2";
    protected String pbType = "1";

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        int i;
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
        BussinessParams bParams = this.outputData.getBussinessParams();
        ArrayList<RowParams> tmpRowParamList = new ArrayList<RowParams>();
        RowParams[] rows = bParams.getRowParams();
        RowParams rowParams = null;
        RowParams tmpRowParams = null;
        Param index = null;
        Param vlan = null;
        Param portType = null;
        Param portID = null;
        Param quickLeaveEnableState = null;
        for (i = 0; i < rows.length; ++i) {
            rowParams = rows[i];
            index = rowParams.getParam("indexID");
            if (null == index) {
                return;
            }
            vlan = rowParams.getParam("vlanID");
            portType = rowParams.getParam("portType");
            portID = rowParams.getParam("portID");
            quickLeaveEnableState = rowParams.getParam("quickLeaveEnableState");
            tmpRowParams = new RowParams();
            tmpRowParams.addParam(index);
            tmpRowParams.addParam(vlan);
            tmpRowParams.addParam(portType);
            tmpRowParams.addParam(quickLeaveEnableState);
            if ("1".equals(portType.getValue())) {
                if (!this.queryUNI) {
                    this.queryUNI = true;
                    this.getUniPortName(index.getValue());
                }
                tmpRowParams.addParam("port", portID.getValue());
                if (this.uniPortNameMap.get(portID.getValue()) != null) {
                    tmpRowParams.addParam("portID", (String)this.uniPortNameMap.get(portID.getValue()));
                    tmpRowParams.getParam("portType").setValue("1");
                }
                if ((TEIGMPUtils.isSupport1adForS_I(neid) || this.sAwarePorttype.equals("1")) && this.nniPortNameMap.get(portID.getValue()) != null) {
                    tmpRowParams.addParam("portID", (String)this.nniPortNameMap.get(portID.getValue()));
                    tmpRowParams.getParam("portType").setValue("2");
                }
            } else {
                if (!this.queryNNI) {
                    this.queryNNI = true;
                    this.getNniPortName(index.getValue());
                }
                tmpRowParams.addParam("port", portID.getValue());
                tmpRowParams.addParam("portID", (String)this.nniPortNameMap.get(portID.getValue()));
            }
            tmpRowParamList.add(tmpRowParams);
        }
        bParams.clearRowParams();
        int size = tmpRowParamList.size();
        for (i = 0; i < size; ++i) {
            bParams.addRowParams((RowParams)tmpRowParamList.get(i));
        }
    }

    private void getUniPortName(String serviceIndex) {
        Input input;
        boolean isSupportPBUNi = false;
        TEConfigurationDataMgr configurationData = TEConfigurationDataMgr.getInstance();
        ArrayList<Object> uniPortList = new ArrayList<Object>();
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_SERVICE_GET_SAWAREPORT_ROLE");
        if (operation != null) {
            isSupportPBUNi = true;
            input = operation.getInput();
            input.setPartValue("serviceIndex", serviceIndex);
            uniPortList.add(operation.clone());
        } else {
            operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_SERVICE_GET_ELANINFO");
            if (operation != null) {
                input = operation.getInput();
                input.setPartValue("indexID", serviceIndex);
                uniPortList.add(operation.clone());
            }
        }
        operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_SERVICE_GET_ETHVUNI");
        if (operation != null) {
            input = operation.getInput();
            input.setPartValue("servType", "2");
            input.setPartValue("servIndex", serviceIndex + "");
            input.setPartValue("vuniId", "0");
            uniPortList.add(operation.clone());
        }
        if ((operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_SERVICE_GET_ETHPBVUNI_EX")) != null) {
            operation.getInput().setPartValue("servType", "2");
            operation.getInput().setPartValue("servIndex", serviceIndex + "");
            operation.getInput().setPartValue("vuniId", "0");
            uniPortList.add(operation.clone());
        }
        if ((operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_SERVICE_GET_SAWAREPORT_ROLE_FOR_IGMP")) != null) {
            operation.getInput().setPartValue("servIndex", serviceIndex + "");
            uniPortList.add(operation.clone());
        }
        String ethBridage = "1";
        String macMode = "2";
        TENECommMgr.getInstance().sendCommand(this.neid, uniPortList, this.getTimeOut());
        int jlen = uniPortList.size();
        for (int j = 0; j < jlen; ++j) {
            Operation tmpOperation = (Operation)uniPortList.get(j);
            for (Output output : tmpOperation.getOutput()) {
                if (Integer.valueOf(output.getFault(0).getCode()) != 0) continue;
                if (j == 0 || j == 3) {
                    if (isSupportPBUNi) {
                        this.sAwarePorttype = output.getPartValue("sawareporttype");
                        continue;
                    }
                    ethBridage = output.getPartValue("tagFlag");
                    macMode = output.getPartValue("macMode");
                    continue;
                }
                int slotid = Integer.parseInt(output.getPartValue("slotid"));
                int boardType = configurationData.getBoardType(this.neid, slotid);
                String boardName = configurationData.getBoardTypeName(this.neid, boardType);
                StringBuffer portAllNames = new StringBuffer();
                String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotid);
                if (!subrackName.isEmpty()) {
                    portAllNames.append(subrackName).append("-");
                }
                portAllNames.append(slotid).append("-").append(boardName).append("-");
                int subslotid = Integer.parseInt(output.getPartValue("subslotid"));
                if (255 != subslotid) {
                    int subboardType = configurationData.getSubboardType(this.neid, slotid, subslotid);
                    String subboardName = configurationData.getBoardTypeName(this.neid, subboardType);
                    portAllNames.append(subslotid).append("-").append(subboardName).append("-");
                }
                int port = Integer.parseInt(output.getPartValue("port"));
                String portName = configurationData.getPortNameForPTN(this.neid, slotid, boardType, port);
                portAllNames.append(portName);
                int tagNum = Integer.parseInt(output.getPartValue("tagNum"));
                if (0 != tagNum) {
                    String tagIds = output.getPartValue("svlan");
                    if (tagIds != null) {
                        portAllNames.append("[" + tagIds + "]");
                    } else {
                        tagIds = output.getPartValue("tagIds");
                        int tagidLen = 8;
                        StringBuffer buff = new StringBuffer();
                        int vlanLen = tagIds.length();
                        for (int z = 0; z < vlanLen; z += tagidLen) {
                            int tagID = Integer.parseInt(tagIds.substring(z, z + tagidLen), 16);
                            buff.append(tagID).append(',');
                        }
                        String tagidStr = buff.delete(buff.length() - 1, buff.length()).toString();
                        tagidStr = "[" + TEIGMPUtils.parseEncapsValueList(tagidStr) + "]";
                        portAllNames.append(tagidStr);
                    }
                }
                String vIdStr = "";
                if (this.sAwarePorttype.equals("1") || ethBridage.equals("2") && macMode.equals("2") && TEIGMPUtils.isSupport1adForS_I(this.neid)) {
                    if (j == 1) {
                        vIdStr = output.getPartValue("vuniId");
                        this.nniPortNameMap.put(vIdStr, portAllNames.toString());
                    }
                    if (j != 2) continue;
                    vIdStr = output.getPartValue("vuniId");
                    this.uniPortNameMap.put(vIdStr, portAllNames.toString());
                    continue;
                }
                vIdStr = output.getPartValue("vuniId");
                this.uniPortNameMap.put(vIdStr, portAllNames.toString());
                vIdStr = output.getPartValue("vnniId");
                this.uniPortNameMap.put(vIdStr, portAllNames.toString());
            }
        }
        uniPortList.clear();
    }

    private void getNniPortName(String serviceIndex) {
        TEConfigurationDataMgr configurationData = TEConfigurationDataMgr.getInstance();
        ArrayList<Object> uniPortList = new ArrayList<Object>();
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_SERVICE_GET_EVNNI");
        Input input = operation.getInput();
        input.setPartValue("servType", "2");
        input.setPartValue("servIndex", serviceIndex + "");
        input.setPartValue("vnniId", "0");
        uniPortList.add(operation.clone());
        TENECommMgr.getInstance().sendCommand(this.neid, uniPortList, this.getTimeOut());
        Operation tmpOperation = (Operation)uniPortList.get(0);
        uniPortList.clear();
        for (Output output : tmpOperation.getOutput()) {
            StringBuffer portAllNames = new StringBuffer();
            String vnniId = output.getPartValue("vnniId");
            int carrierType = Integer.parseInt(output.getPartValue("carrierType"));
            if (1 == carrierType) {
                long pwIndex = Long.parseLong(output.getPartValue("port"));
                String pwID = this.getPWID(pwIndex);
                portAllNames.append("PW-").append(pwID);
            }
            if (4 == carrierType) {
                long QINQIndex = Long.parseLong(output.getPartValue("port"));
                portAllNames.append("QinQ-").append(QINQIndex);
            }
            if (3 == carrierType) {
                int slotid = Integer.parseInt(output.getPartValue("slotid"));
                int boardType = configurationData.getBoardType(this.neid, slotid);
                String boardName = configurationData.getBoardTypeName(this.neid, boardType);
                portAllNames.append(slotid).append("-").append(boardName).append("-");
                int subslotid = Integer.parseInt(output.getPartValue("subslotid"));
                if (255 != subslotid) {
                    int subboardType = configurationData.getSubboardType(this.neid, slotid, subslotid);
                    String subboardName = configurationData.getBoardTypeName(this.neid, subboardType);
                    portAllNames.append(subslotid).append("-").append(subboardName).append("-");
                }
                int port = Integer.parseInt(output.getPartValue("port"));
                String portName = configurationData.getPortNameForPTN(this.neid, slotid, boardType, port);
                portAllNames.append(portName);
            }
            this.nniPortNameMap.put(vnniId, portAllNames.toString());
        }
    }

    private String getPWID(long pwIndex) {
        String pwID = "";
        ArrayList<Object> pwIDList = new ArrayList<Object>();
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_MPLS_PW_GET_PW");
        Input input = operation.getInput();
        input.setPartValue("pwIndex", pwIndex + "");
        pwIDList.add(operation.clone());
        TENECommMgr.getInstance().sendCommand(this.neid, pwIDList, this.getTimeOut());
        Operation tmpOperation = (Operation)pwIDList.get(0);
        pwIDList.clear();
        for (Output output : tmpOperation.getOutput()) {
            pwID = output.getPartValue("pwId");
            if (pwID != null) continue;
            pwID = output.getPartValue("pwID");
        }
        return pwID;
    }

    protected void resetPBType(List<Operation> opers) {
        int pbTypeOperIndex = -1;
        int len = opers.size();
        for (int i = 0; i < len; ++i) {
            Output output;
            Operation oper = opers.get(i);
            if (!"NSCMD_SERVICE_GET_SAWAREPORT_ROLE_FOR_IGMP".equals(oper.getName()) || !(output = oper.getOutput(0)).getFault(0).getCode().equals(String.valueOf(0))) continue;
            this.pbType = output.getPartValue("sawareporttype");
            if ("0".equals(this.pbType) && TESpecialAttrMgr.getInstance().isNESupport(this.neid, "TE_FUNC_MSTP_CFG_ETHER_ELAN", "ELAN_ATTR_SUPPORT_VPLS")) {
                this.pbType = "2";
            }
            pbTypeOperIndex = i;
            break;
        }
        if (pbTypeOperIndex != -1) {
            opers.remove(pbTypeOperIndex);
        }
    }
}

