/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.snooping;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.datamgr.TENEConfigurationDataMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class TEIGMPUtils {
    public static final String ELAN = "2";
    private static final String C_AWARED = "1";
    private static final String S_AWARED = "2";
    public static final String NNI_TYPE = "2";
    private static final String UNI_PROFIX = "UNI_";
    private static final String NNI_PROFIX = "NNI_";
    private static final int PW_CARRY = 1;
    private static final int QINQ_CARRY = 4;
    private static final int PORT_CARRY = 3;
    private static final String DEFAULT = "0";
    private static final String PB_NNI = "1";
    private static String sAwarePorttype = "0";
    private static boolean isSupportPBUNi = false;
    private static final String IVL = "2";

    private TEIGMPUtils() {
    }

    private static List<Operation> getQueryServiceOperationList(int neid, String serviceIndex) {
        Input input;
        ArrayList<Operation> uniPortList = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_SERVICE_GET_SAWAREPORT_ROLE");
        if (oper != null) {
            isSupportPBUNi = true;
            input = oper.getInput();
            input.setPartValue("serviceIndex", serviceIndex);
            uniPortList.add(oper);
        } else {
            oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_SERVICE_GET_ELANINFO");
            if (oper != null) {
                input = oper.getInput();
                input.setPartValue("indexID", serviceIndex);
                uniPortList.add(oper);
            }
        }
        oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_SERVICE_GET_ETHVUNI");
        if (oper != null && oper.getInput().getPart("vuniId") != null) {
            input = oper.getInput();
            input.setPartValue("servType", "2");
            input.setPartValue("servIndex", serviceIndex);
            input.setPartValue("vuniId", DEFAULT);
            uniPortList.add(oper);
        }
        if ((oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_SERVICE_GET_ETHPBVUNI_EX")) != null && oper.getInput().getPart("vuniId") != null) {
            oper.getInput().setPartValue("servType", "2");
            oper.getInput().setPartValue("servIndex", serviceIndex);
            oper.getInput().setPartValue("vuniId", DEFAULT);
            uniPortList.add(oper);
        }
        if ((oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_SERVICE_GET_EVNNI")) != null && oper.getInput().getPart("vnniId") != null) {
            input = oper.getInput();
            input.setPartValue("servType", "2");
            input.setPartValue("servIndex", serviceIndex + "");
            input.setPartValue("vnniId", DEFAULT);
            uniPortList.add(oper);
        }
        if ((oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_SERVICE_GET_EVNNI_1")) != null && oper.getInput().getPart("vnniId") != null) {
            input = oper.getInput();
            input.setPartValue("servType", "2");
            input.setPartValue("servIndex", serviceIndex + "");
            input.setPartValue("vnniId", DEFAULT);
            uniPortList.add(oper);
        }
        return uniPortList;
    }

    private static Map<String, String> parseOperationList(int neid, List<Operation> operList) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (operList.isEmpty()) {
            return result;
        }
        Operation elanOper = operList.get(0);
        String ethBridage = "1";
        String macMode = "2";
        if (elanOper.getOutput(0).getFault(0).getCode().equals(String.valueOf(0))) {
            if (isSupportPBUNi) {
                sAwarePorttype = elanOper.getOutput(0).getPartValue("sawareporttype");
            } else {
                ethBridage = elanOper.getOutput(0).getPartValue("tagFlag");
                macMode = elanOper.getOutput(0).getPartValue("macMode");
            }
        }
        int jlen = operList.size();
        for (int j = 1; j < jlen; ++j) {
            Operation tmpOper = operList.get(j);
            for (Output output : tmpOper.getOutput()) {
                String vId;
                if (!output.getFault(0).getCode().equals(String.valueOf(0))) continue;
                StringBuffer portAllName = new StringBuffer();
                if (tmpOper.getName().equals("NSCMD_SERVICE_GET_ETHVUNI")) {
                    portAllName.append(TEIGMPUtils.getPortName(neid, output));
                    vId = output.getPartValue("vuniId");
                    if (sAwarePorttype.equals("1") || ethBridage.equals("2") && macMode.equals("2") && TEIGMPUtils.isSupport1adForS_I(neid)) {
                        result.put(NNI_PROFIX + vId, portAllName.toString());
                        continue;
                    }
                    result.put(UNI_PROFIX + vId, portAllName.toString());
                    continue;
                }
                if (tmpOper.getName().equals("NSCMD_SERVICE_GET_ETHPBVUNI_EX")) {
                    portAllName.append(TEIGMPUtils.getPortName(neid, output));
                    vId = output.getPartValue("vuniId");
                    result.put(UNI_PROFIX + vId, portAllName.toString());
                    continue;
                }
                if (!tmpOper.getName().equals("NSCMD_SERVICE_GET_EVNNI")) continue;
                String vnniId = output.getPartValue("vnniId");
                int carrierType = Integer.parseInt(output.getPartValue("carrierType"));
                if (1 == carrierType) {
                    long pwIndex = Long.parseLong(output.getPartValue("port"));
                    String pwID = TEIGMPUtils.getPWID(neid, pwIndex);
                    portAllName.append("PW-").append(pwID);
                }
                if (4 == carrierType) {
                    long QINQIndex = Long.parseLong(output.getPartValue("port"));
                    portAllName.append("QinQ-").append(QINQIndex);
                }
                if (3 == carrierType) {
                    portAllName.append(TEIGMPUtils.getPortName(neid, output));
                }
                result.put(NNI_PROFIX + vnniId, portAllName.toString());
            }
        }
        return result;
    }

    private static String getPortName(int neid, Output output) {
        TEConfigurationDataMgr configurationData = TEConfigurationDataMgr.getInstance();
        StringBuffer portAllName = new StringBuffer();
        int slotid = Integer.parseInt(output.getPartValue("slotid"));
        int boardType = configurationData.getBoardType(neid, slotid);
        portAllName.append(TEBoardUtil.getShelfBoardName((int)neid, (int)slotid)).append('-');
        int port = Integer.parseInt(output.getPartValue("port"));
        String portName = configurationData.getPortNameForPTN(neid, slotid, boardType, port);
        portAllName.append(portName);
        int tagNum = Integer.parseInt(output.getPartValue("tagNum"));
        if (0 != tagNum) {
            String tagIds = output.getPartValue("svlan");
            if (tagIds != null) {
                portAllName.append("[" + tagIds + "]");
            } else {
                tagIds = output.getPartValue("tagIds");
                int tagidLen = 8;
                StringBuffer buf = new StringBuffer();
                int vlanLen = tagIds.length();
                for (int z = 0; z < vlanLen; z += tagidLen) {
                    int tagID = Integer.parseInt(tagIds.substring(z, z + tagidLen), 16);
                    buf.append(tagID).append(',');
                }
                String tagidStr = buf.delete(buf.length() - 1, buf.length()).toString();
                tagidStr = "[" + TEIGMPUtils.parseEncapsValueList(tagidStr) + "]";
                portAllName.append(tagidStr);
            }
        }
        return portAllName.toString();
    }

    public static String getNNIPortName(String portID, Map<String, String> portNameMap) {
        return portNameMap.get(NNI_PROFIX + portID);
    }

    public static String getUNIPortName(String portID, Map<String, String> portNameMap) {
        return portNameMap.get(UNI_PROFIX + portID);
    }

    public static Map<String, String> queryServicePortName(int neid, String serviceIndex) {
        List<Operation> operList = TEIGMPUtils.getQueryServiceOperationList(neid, serviceIndex);
        OperationResult result = TENECommMgr.getInstance().sendCommand(neid, operList, 20);
        Map<String, String> resultMap = new HashMap<String, String>();
        if (result.retCode == 0) {
            resultMap = TEIGMPUtils.parseOperationList(neid, operList);
        }
        return resultMap;
    }

    private static String getPWID(int neid, long pwIndex) {
        String pwID = "";
        ArrayList<Object> pwIDList = new ArrayList<Object>();
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_GET_PW");
        Input input = oper.getInput();
        input.setPartValue("pwIndex", pwIndex + "");
        pwIDList.add(oper.clone());
        TENECommMgr.getInstance().sendCommand(neid, pwIDList, 20);
        Operation tmpOper = (Operation)pwIDList.get(0);
        pwIDList.clear();
        Output[] outputArr = tmpOper.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            Output output = outputArr[i];
            if (!output.getFault(i).getCode().equals(String.valueOf(0)) || (pwID = output.getPartValue("pwId")) != null) continue;
            pwID = output.getPartValue("pwID");
        }
        return pwID;
    }

    public static String parseEncapsValueList(String str) {
        String[] stringArray = str.split(",");
        int[] intArray = new int[stringArray.length];
        int len = stringArray.length;
        for (int j = 0; j < len; ++j) {
            intArray[j] = Integer.parseInt(stringArray[j]);
        }
        Arrays.sort(intArray);
        ArrayList<String> encapsValue = new ArrayList<String>();
        int len2 = stringArray.length;
        for (int j = 0; j < len2; ++j) {
            encapsValue.add(intArray[j] + "");
        }
        String result = "";
        if (encapsValue.size() >= 2) {
            Iterator it = encapsValue.iterator();
            int curNum = Integer.parseInt((String)it.next());
            int offset = 0;
            StringBuffer temp = new StringBuffer(String.valueOf(curNum));
            int tmpNum = -1;
            while (it.hasNext()) {
                int nextNum = Integer.parseInt((String)it.next());
                if (nextNum != curNum + offset + 1) {
                    if (offset != 0) {
                        tmpNum = curNum + offset;
                        temp.append("-").append(tmpNum);
                        temp.append(",").append(nextNum);
                    } else {
                        temp.append(",").append(nextNum);
                    }
                    offset = 0;
                    curNum = nextNum;
                    continue;
                }
                ++offset;
            }
            if (offset > 0) {
                tmpNum = curNum + offset;
                temp.append("-").append(tmpNum);
            }
            result = temp.toString();
        } else if (encapsValue.size() == 1) {
            result = encapsValue.get(0).toString();
        }
        return result;
    }

    public static boolean isSupport1adForS_I(int neid) {
        int neType;
        TENEConfigurationDataMgr mgr = TENEConfigurationDataMgr.getInstance();
        return mgr.isOSN5X0NEByType(neType = mgr.getNE(neid).getNEType()) || neType == 67 || neType == 136 || mgr.isRTN900DomainNEByType(neType) && neType != 114 && neType != 77;
    }
}

