/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.shaping;

import com.huawei.nglct.cbb.datamanage.integration.handler.TECIUpLoadHandler;
import com.huawei.nglct.cbb.datamanage.integration.handler.TECfgItem;
import com.huawei.nglct.cbb.datamanage.integration.model.TEDataCfgNEInfo;
import com.huawei.nglct.cbb.datamanage.integration.model.TEDataCfgUploadPara;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ip.ptn.shaping.TEShapingDBMgr;
import com.huawei.nglct.po.embeddednemgrmo.policy.TEPortShapingMOPO;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import org.slf4j.Logger;

public class TEShapingUploadHandler
implements TECIUpLoadHandler {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();
    private static final String TENEEXPLORERBEAN_CLASSNAME = "com.huawei.nglct.explorer.TENEExplorerBean";
    TEDataCfgNEInfo neInfo = null;

    public TECfgItem getOperIF(int OperType) {
        return null;
    }

    public String getItemName() {
        return null;
    }

    public int getItemID() {
        return 0;
    }

    public int upLoad(TEDataCfgUploadPara pPara) {
        this.neInfo = pPara.getTmpNEInfo();
        int neID = this.neInfo.getNeID();
        if (!this.isNEExist(neID)) {
            e2eLogger.info("temp ne is not exist");
            neID = pPara.getOldNEID();
            if (!this.isNEExist(neID)) {
                e2eLogger.info("old ne is not exist");
                return 0;
            }
        }
        return this.uploadImpl(neID);
    }

    private boolean isNEExist(int neID) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        return null != ne;
    }

    public int uploadImpl(int neID) {
        String FUNC_NAME = "TEArpUploadHandler.uploadImpl";
        e2eLogger.info("TEArpUploadHandler.uploadImpl: begin.");
        int retCode = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter2(neID);
        if (0 != retCode) {
            TEShapingUploadHandler.logConnectNEFail(neID, retCode);
            e2eLogger.info("TEArpUploadHandler.uploadImpl: end.");
            return retCode;
        }
        Datainterface output = this.getDataFromNe(neID);
        if (output.getErrorMessage().getErrorcode().equals("0")) {
            RowParams[] rows;
            TEErrInfoReturn errRet = new TEErrInfoReturn();
            TEShapingDBMgr.delAllShapingsFromDB(neID, errRet);
            for (RowParams row : rows = output.getBussinessParams().getRowParams()) {
                String slotid = row.getParam("slotid").getValue();
                String port = row.getParam("port").getValue();
                String cir = row.getParam("cir").getValue();
                String cbs = row.getParam("cbs").getValue();
                String pir = row.getParam("pir").getValue();
                String pbs = row.getParam("pbs").getValue();
                TEPortShapingMOPO shapingMO = new TEPortShapingMOPO();
                shapingMO.setSlotID(Integer.parseInt(slotid));
                shapingMO.setPortID(Integer.parseInt(port));
                shapingMO.setCir(Long.parseLong(cir));
                shapingMO.setCbs(Long.parseLong(cbs));
                shapingMO.setPir(Long.parseLong(pir));
                shapingMO.setPbs(Long.parseLong(pbs));
                TEShapingDBMgr.createShapingToDB(neID, shapingMO, errRet);
            }
        }
        e2eLogger.info("TEArpUploadHandler.uploadImpl: end.");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Datainterface getDataFromNe(int neIDshaping) {
        Datainterface din = new Datainterface();
        BussinessParams bus = new BussinessParams();
        din.setBussinessParams(bus);
        RowParams rp = new RowParams();
        bus.addRowParams(rp);
        Param p = new Param("neid", String.valueOf(neIDshaping));
        rp.addParam(p);
        int sfid = 2167969;
        SubFunc subFunc = null;
        int neType = this.neInfo.getNeType();
        String neVersion = this.neInfo.getNeVersion();
        try {
            subFunc = TECreateObjectFactory.getSubFuncByVer((int)neIDshaping, (int)sfid, (int)neType, (String)neVersion);
        }
        catch (Exception e1) {
            TELogFactory.getNormalLogger().error(e1.getMessage());
        }
        if (null == subFunc) {
            TELogFactory.getNormalLogger().info("Not Find Query Lmsp subFunc!");
            return null;
        }
        Datainterface allData = null;
        String classMapping = subFunc.getClassMapping();
        TENEMgrInterface neMgrBean = null;
        try {
            neMgrBean = classMapping == null ? (TENEMgrInterface)Class.forName(TENEEXPLORERBEAN_CLASSNAME).newInstance() : (TENEMgrInterface)Class.forName(classMapping).newInstance();
        }
        catch (Exception e) {
            e2eLogger.error("The Upload ARP from weblct exception " + neIDshaping, (Throwable)e);
        }
        finally {
            if (null != neMgrBean) {
                allData = neMgrBean.performBussinessProcess(neIDshaping, subFunc, din, null, null, null);
            }
        }
        return allData;
    }

    private static void logConnectNEFail(int neID, int retCode) {
        String tipStr = "upload arp fail! ";
        tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
        e2eLogger.error(tipStr);
    }
}

