/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.shaping;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.po.embeddednemgrmo.policy.TEPortShapingMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public final class TEShapingDBMgr {
    private static final Logger normalLogger = TELogFactory.getNormalLogger();
    public static final String DB_COL_SLOT = "SlotID";
    public static final String DB_COL_PORT = "PortID";
    public static final String DB_COL_SUBCARD = "SubCardID";

    private TEShapingDBMgr() {
    }

    public static List<TEPortShapingMOPO> getShapingFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEShapingDBMgr.getShapingFromDB";
        normalLogger.info("TEShapingDBMgr.getShapingFromDB: begin.");
        ArrayList<TEPortShapingMOPO> shapingList = new ArrayList<TEPortShapingMOPO>();
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                TEShapingDBMgr.logNullNEError(neID);
                errRet.setResult(1090596385);
                TEShapingDBMgr.logFuncEnd("TEShapingDBMgr.getShapingFromDB");
                return shapingList;
            }
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID}, TEPortShapingMOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID}, TEPortShapingMOPO.class);
        }
        catch (Exception e) {
            normalLogger.error("get shaping from db fail! neID->" + neID, (Throwable)e);
            errRet.setResult(1092743443);
            TEShapingDBMgr.logFuncEnd("TEShapingDBMgr.getShapingFromDB");
            return shapingList;
        }
        if (null == dbResult) {
            normalLogger.error("get clock device from db fail! dbResult is null! neID->" + neID);
            errRet.setResult(1092743443);
            TEShapingDBMgr.logFuncEnd("TEShapingDBMgr.getShapingFromDB");
            return shapingList;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            List data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                for (Object obj : data) {
                    shapingList.add((TEPortShapingMOPO)obj);
                }
            }
        } else {
            TEShapingDBMgr.logRetCodeErrorOnGet(neID, retCode);
            errRet.setResult(retCode);
        }
        TEShapingDBMgr.logFuncEnd("TEShapingDBMgr.getShapingFromDB");
        return shapingList;
    }

    public static void delShapingFromDB(int neID, TEPortShapingMOPO shapingMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEShapingDBMgr.delShapingFromDB";
        normalLogger.info("TEShapingDBMgr.delShapingFromDB: begin.");
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.delete((int[])new int[]{neID}, (Object)shapingMO) : TECommonDaoService.delete_NonLock((int[])new int[]{neID}, (Object)shapingMO);
        }
        catch (Exception e) {
            normalLogger.error("delete shaping from db fail! neID->" + neID, (Throwable)e);
            errRet.setResult(1092743443);
            TEShapingDBMgr.logFuncEnd("TEShapingDBMgr.delShapingFromDB");
            return;
        }
        if (null == dbResult) {
            TEShapingDBMgr.logNullError(neID);
            errRet.setResult(1092743443);
            TEShapingDBMgr.logFuncEnd("TEShapingDBMgr.delShapingFromDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEShapingDBMgr.logRetCodeError(neID, retCode);
            errRet.setResult(retCode);
        }
        TEShapingDBMgr.logFuncEnd("TEShapingDBMgr.delShapingFromDB");
    }

    public static void delAllShapingsFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEShapingDBMgr.delAllShapingsFromDB";
        normalLogger.info("TEShapingDBMgr.delAllShapingsFromDB: begin.");
        List<TEPortShapingMOPO> shapingList = TEShapingDBMgr.getShapingFromDB(neID, errRet);
        int retCode = errRet.getResult();
        if (0 != retCode) {
            TEShapingDBMgr.logRetCodeError(neID, retCode);
            errRet.setResult(retCode);
        }
        for (TEPortShapingMOPO shaping : shapingList) {
            TEShapingDBMgr.delShapingFromDB(neID, shaping, errRet);
        }
        TEShapingDBMgr.logFuncEnd("TEShapingDBMgr.delAllShapingsFromDB");
    }

    public static void createShapingToDB(int neID, TEPortShapingMOPO shapingMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEShapingDBMgr.createShapingToDB";
        normalLogger.info("TEShapingDBMgr.createShapingToDB: begin.");
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.create((int[])new int[]{neID}, (Object)shapingMO) : TECommonDaoService.create_NonLock((int[])new int[]{neID}, (Object)shapingMO);
        }
        catch (Exception e) {
            TEShapingDBMgr.logExceptionErrorOnCreate(neID, e);
            errRet.setResult(1092743443);
            TEShapingDBMgr.logFuncEnd("TEShapingDBMgr.createShapingToDB");
            return;
        }
        if (null == dbResult) {
            TEShapingDBMgr.logNullError(neID);
            errRet.setResult(1092743443);
            TEShapingDBMgr.logFuncEnd("TEShapingDBMgr.createShapingToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEShapingDBMgr.logRetCodeError(neID, retCode);
            errRet.setResult(retCode);
        }
        TEShapingDBMgr.logFuncEnd("TEShapingDBMgr.createShapingToDB");
    }

    public static TEPortShapingMOPO getShapingFromDB(int neID, int slotid, int subslotid, int port) {
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair aPair = new TEDaoNameValuePair(DB_COL_SLOT, String.valueOf(slotid));
        criteria.add(aPair);
        aPair = new TEDaoNameValuePair(DB_COL_SUBCARD, String.valueOf(subslotid));
        criteria.add(aPair);
        aPair = new TEDaoNameValuePair(DB_COL_PORT, String.valueOf(port));
        criteria.add(aPair);
        TEPortShapingMOPO mopo = null;
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findByID((int[])new int[]{neID}, TEPortShapingMOPO.class, criteria) : TECommonDaoService.findByID_NonLock((int[])new int[]{neID}, TEPortShapingMOPO.class, criteria);
            if (null == dbResult) {
                String tipStr = "Get TEP2PLPTMOPO fail! The dbResult is null!! ";
                tipStr = tipStr + String.format("[neID:%d]", neID);
                normalLogger.error(tipStr);
                return mopo;
            }
        }
        catch (Exception e) {
            String tipStr = "Get TEPTNPTPLPTMOPO fail! DB oper error! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            normalLogger.error(tipStr, (Throwable)e);
            return mopo;
        }
        if (0 == dbResult.getResult() && dbResult.getData().size() > 0) {
            mopo = (TEPortShapingMOPO)dbResult.getData().get(0);
        }
        return mopo;
    }

    public static void updateShapingToDB(int neID, TEPortShapingMOPO lptMo, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEP2PLPTDBMgr.updateP2PLptToDB";
        normalLogger.info("TEP2PLPTDBMgr.updateP2PLptToDB: begin.");
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.update((int[])new int[]{neID}, (Object)lptMo) : TECommonDaoService.update_NonLock((int[])new int[]{neID}, (Object)lptMo);
        }
        catch (Exception e) {
            errRet.setResult(1092743443);
            TEShapingDBMgr.logFuncEnd("TEP2PLPTDBMgr.updateP2PLptToDB");
            return;
        }
        if (null == dbResult) {
            TEShapingDBMgr.logNullError(neID);
            errRet.setResult(1092743443);
            TEShapingDBMgr.logFuncEnd("TEP2PLPTDBMgr.updateP2PLptToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEShapingDBMgr.logRetCodeError(neID, retCode);
            errRet.setResult(retCode);
        }
        TEShapingDBMgr.logFuncEnd("TEP2PLPTDBMgr.updateP2PLptToDB");
    }

    private static void logNullNEError(int neID) {
        normalLogger.error("ne is null! neID->" + neID);
    }

    private static void logRetCodeErrorOnGet(int neID, int retCode) {
        String tipStr = String.format("get clock to db device fail! neID:%d, retCode:%d", neID, retCode);
        normalLogger.error(tipStr);
    }

    private static void logNullError(int neID) {
        normalLogger.error("delete clock to db device fail! neID->" + neID);
    }

    private static void logFuncEnd(String funcName) {
        normalLogger.info(funcName + ": end.");
    }

    private static void logRetCodeError(int neID, int retCode) {
        String tipStr = String.format("delete  fail! neID:%d, retCode:%d", neID, retCode);
        normalLogger.error(tipStr);
    }

    private static void logExceptionErrorOnCreate(int neID, Exception e) {
        normalLogger.error("create  fail! neID->" + neID, (Throwable)e);
    }
}

