/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.shaping;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ptn.shaping.TEGetShapingBoardsBean;
import java.util.ArrayList;
import java.util.Vector;

public class TEQueryShapingBean
extends TECommonWriteLogBean {
    private static final String INVALID_VALUE = "4294967295";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        Datainterface theInputData = new Datainterface();
        theInputData.setBussinessParams(new BussinessParams());
        Vector logBoardList = TENEListMgr.getInstance().getNE(neid).getBoardList();
        int len = logBoardList.size();
        for (int i = 0; i < len; ++i) {
            TEBoard board = (TEBoard)logBoardList.get(i);
            if (!TEGetShapingBoardsBean.isPortPolicySuppBoard(neid, board.getSlotID(), board.getBoardType())) continue;
            RowParams row = new RowParams();
            row.addParam("slotid", board.getSlotID() + "");
            if (TEConfigurationDataMgr.getInstance().isSupportSubCard(board.getBoardType())) {
                row.addParam("subcard", "0");
            }
            theInputData.getBussinessParams().addRowParams(row);
        }
        return super.performBussinessProcess(neid, subFunc, theInputData, memeryData, user, ipAddress);
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        RowParams[] rows = this.outputData.getBussinessParams().getRowParams();
        for (int i = rows.length - 1; i >= 0; --i) {
            int subslotid;
            if (rows[i].getParam("pbs") != null) {
                String cir = rows[i].getParam("cir").getValue();
                String dcbs = rows[i].getParam("cbs").getValue();
                String pbs = rows[i].getParam("pbs").getValue();
                String pir = rows[i].getParam("pir").getValue();
                if (pbs.equals(INVALID_VALUE) && pir.equals(INVALID_VALUE) && cir.equals(INVALID_VALUE) && dcbs.equals(INVALID_VALUE)) {
                    this.outputData.getBussinessParams().removeRowParams(i);
                }
            }
            if (rows[i].getParam("portname") == null) continue;
            int slotid = Integer.valueOf(rows[i].getParam("slotid").getValue());
            int boardtype = Integer.valueOf(rows[i].getParam("boardtype").getValue());
            int port = Integer.valueOf(rows[i].getParam("port").getValue());
            if (rows[i].getParam("subcard") != null && (subslotid = Integer.parseInt(rows[i].getParam("subcard").getValue())) != 255 && subslotid != 0) {
                boardtype = TEConfigurationDataMgr.getInstance().getSubboardType(neid, slotid, subslotid);
                rows[i].addParam("subcardname", TEConfigurationDataMgr.getInstance().getSubBoardName(neid, slotid, subslotid));
            }
            String portname = TEConfigurationDataMgr.getInstance().getPortNameForPTN(neid, slotid, boardtype, port, 16);
            rows[i].getParam("portname").setValue(portname);
        }
    }
}

