/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.shaping;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.gencfg.TEGenCfgCommon;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.datamgr.TENEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.datamgr.TEPortModelConfigurationDataMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.device.port.TEVirtualPortUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class TEGetShapingBoardsBean
extends TENEExplorerBean {
    private static final String IPPTN_ATTR_PORTSHAPING = "IPPTN_ATTR_PORTSHAPING";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            Vector logBoardList = neObj.getBoardList();
            Collections.sort(logBoardList);
            this.outputData = new Datainterface();
            BussinessParams bussiness = new BussinessParams();
            int len = logBoardList.size();
            for (int i = 0; i < len; ++i) {
                TEPortModelConfigurationDataMgr cfgMgr;
                List portList;
                TEBoard board = (TEBoard)logBoardList.get(i);
                int boardType = board.getBoardType();
                int boardSlot = board.getSlotID();
                String boardName = cfgDataMgr.getBoardTypeName(neid, boardType);
                if (!TEGetShapingBoardsBean.isPortPolicySuppBoard(neid, boardSlot, boardType) || TEVirtualPortUtil.isMSOTNBoard((int)neid, (int)boardSlot) && ((portList = (cfgMgr = TEPortModelConfigurationDataMgr.getInstance()).getLogicPortList(neid, boardSlot, 63213)) == null || portList.isEmpty())) continue;
                RowParams row = new RowParams();
                int subrackId = TEBoardUtil.getSubrackIDFromSlot((int)neid, (int)boardSlot);
                if (subrackId >= 0) {
                    String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)boardSlot);
                    row.addParam("board", subrackName + "-" + TEBoardUtil.getSlotIDFromSlot((int)neid, (int)boardSlot) + "-" + boardName);
                } else {
                    row.addParam("board", boardSlot + "-" + boardName);
                }
                row.addParam("slotid", String.valueOf(boardSlot));
                bussiness.addRowParams(row);
            }
            this.outputData.setBussinessParams(bussiness);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public static boolean isPortPolicySuppBoard(int neid, int slotid, int boardType) {
        TEPortModelConfigurationDataMgr cfgMgr = TEPortModelConfigurationDataMgr.getInstance();
        if (TENEConfigurationDataMgr.getInstance().isOTNDomainNE(neid)) {
            boolean hasLogicPort = !cfgMgr.getLogicPortList(neid, slotid).isEmpty();
            return TEGenCfgCommon.isSupportAttr((int)boardType, (String)IPPTN_ATTR_PORTSHAPING) && hasLogicPort;
        }
        boolean ret = false;
        ArrayList portList = new ArrayList();
        portList.addAll(cfgMgr.getLogicPortList(neid, slotid, 1799));
        portList.addAll(cfgMgr.getLogicPortList(neid, slotid, 1802));
        if (portList.size() > 0) {
            ret = true;
        }
        return ret;
    }
}

