/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.serialinterface;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.string.TEConvertUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;

public class TEQuerySerialInterface
extends TECommonWriteLogBean {
    public static final long INVALID_IP = 0xFFFFFFFFL;
    public static final long INVALID_BOARD = 65535L;
    public static final int IPTYPE_UNSET = 255;
    public static final int IPTYPE_USERSET = 1;
    private static final String FILTER_LAYER2_PORT_DATA = "1";
    private static final String LAYER2_PORT_MODE = "2";
    TEConfigurationDataMgr cfgMgr = TEConfigurationDataMgr.getInstance();

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.parseFilterErrorCodeList();
        super.handleMessage(neid, operationList, subfunc, filterErrorCodeList);
        int slotId = 0;
        int port = 0;
        int bdType = 0;
        int phyportid = 0;
        long ip = 0L;
        long ipMask = 0L;
        int ipType = 0;
        String vc4id = FILTER_LAYER2_PORT_DATA;
        String portId = "";
        String portName = "";
        String boardName = "";
        int borrowedslotId = 0;
        int borrowedPort = 0;
        int borrowedboardType = 0;
        String borrowedboardName = "";
        String borrowedportName = "";
        Param param = null;
        RowParams rowParams = null;
        Param flagParam = this.inputData.getBussinessParams().getRowParams(0).getParam("isFilterLayer2");
        String isFilterLayer2 = null;
        if (flagParam != null) {
            isFilterLayer2 = flagParam.getValue();
        }
        RowParams[] rowParamses = this.outputData.getBussinessParams().getRowParams();
        for (int j = rowParamses.length - 1; j >= 0; --j) {
            rowParams = rowParamses[j];
            if (null == rowParams || 0 == rowParams.getParamCount()) {
                this.outputData.getBussinessParams().removeRowParams(j);
                if (rowParams == null || rowParams.getRowErrorsCount() == 0) continue;
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
                continue;
            }
            if (null != rowParams.getParam("port") && ((port = Integer.valueOf(portId = rowParams.getParam("port").getValue()).intValue()) < 6144 || port > 8192)) {
                this.outputData.getBussinessParams().removeRowParams(j);
                continue;
            }
            if (FILTER_LAYER2_PORT_DATA.equals(isFilterLayer2) && null != rowParams.getParam("PTNIF_PORT_ATTR_MODE") && LAYER2_PORT_MODE.equals(rowParams.getParam("PTNIF_PORT_ATTR_MODE").getValue())) {
                this.outputData.getBussinessParams().removeRowParams(j);
                continue;
            }
            param = rowParams.getParam("slotid");
            if (null != param) {
                slotId = Integer.valueOf(param.getValue());
                bdType = this.cfgMgr.getBoardType(neid, slotId);
            }
            if (null != rowParams.getParam("PTNIF_PORT_ATTR_PORTNAME")) {
                portName = rowParams.getParam("PTNIF_PORT_ATTR_PORTNAME").getValue();
            }
            if (!"".equals(portName)) {
                rowParams.getParam("portname").setValue(port - 6144 + "(" + "Serial-" + portName + ")");
            } else {
                rowParams.getParam("portname").setValue(port - 6144 + "(" + "Serial-" + (port - 6144) + ")");
            }
            param = rowParams.getParam("boardname");
            if (null != param) {
                boardName = param.getValue();
            }
            if (null != (param = rowParams.getParam("phyportid")) && !"".equals(param.getValue())) {
                phyportid = Integer.valueOf(param.getValue());
                rowParams.getParam("phyportid").setValue(slotId + "-" + boardName + "-" + this.cfgMgr.getPortNameForPTN(neid, slotId, bdType, phyportid));
                boardName = "";
            }
            if (null != (param = rowParams.getParam("highchannel"))) {
                if (!"".equals(param.getValue())) {
                    vc4id = param.getValue();
                    param.setValue("VC4-" + vc4id);
                } else {
                    Param tmp = rowParams.getParam("level");
                    if ("0".equals(tmp.getValue())) {
                        vc4id = FILTER_LAYER2_PORT_DATA;
                        param.setValue("VC4-" + vc4id);
                    } else {
                        param.setValue("-");
                    }
                }
            }
            if (null != (param = rowParams.getParam("phypathlist"))) {
                if ("".equals(param.getValue())) {
                    param.setValue("-");
                } else {
                    param.setValue(this.parsePathNum(param.getValue()));
                }
            }
            if (null != (param = rowParams.getParam("ktimeslot"))) {
                param.setValue(this.parsePathNum(param.getValue()));
            }
            if (null != (param = rowParams.getParam("ATTR_ETHOVERPTN_MAC_IPADDRESS")) && !"/".equals(param.getValue()) && !"".equals(param.getValue())) {
                ipType = Integer.valueOf(rowParams.getParam("ATTR_ETHOVERPTN_MAC_SPECIFYIPADDRESS").getValue());
                ipMask = Long.valueOf(rowParams.getParam("ATTR_ETHOVERPTN_MAC_IPMARSK").getValue());
                ip = Long.valueOf(param.getValue());
                if (1 == ipType && 0xFFFFFFFFL == ip && 0xFFFFFFFFL == ipMask) {
                    rowParams.getParam("ATTR_ETHOVERPTN_MAC_SPECIFYIPADDRESS").setValue(String.valueOf(255));
                }
                param.setValue(TEConvertUtil.ipToString((long)Long.valueOf(param.getValue())));
                param = rowParams.getParam("ATTR_ETHOVERPTN_MAC_IPMARSK");
                param.setValue(TEConvertUtil.ipToString((long)Long.valueOf(param.getValue())));
            } else {
                rowParams.getParam("ATTR_ETHOVERPTN_MAC_SPECIFYIPADDRESS").setValue(String.valueOf(255));
            }
            param = rowParams.getParam("ATTR_ETHOVERPTN_MAC_BORROWEDBOARDIPADDR");
            if (null != param && !"/".equals(param.getValue()) && !"".equals(param.getValue())) {
                borrowedslotId = Integer.valueOf(param.getValue());
                borrowedboardType = this.cfgMgr.getBoardType(neid, borrowedslotId);
                borrowedboardName = this.cfgMgr.getBoardTypeName(neid, borrowedboardType);
                rowParams.getParam("ATTR_ETHOVERPTN_MAC_BORROWEDBOARDIPADDR").setValue(borrowedslotId + "-" + borrowedboardName);
            }
            if (null == (param = rowParams.getParam("ATTR_ETHOVERPTN_MAC_BORROWEDPORTIPADDR")) || "/".equals(param.getValue()) || "".equals(param.getValue())) continue;
            borrowedPort = Integer.valueOf(param.getValue());
            borrowedportName = this.cfgMgr.getPortNameForPTN(neid, borrowedslotId, borrowedboardType, borrowedPort);
            rowParams.getParam("ATTR_ETHOVERPTN_MAC_BORROWEDPORTIPADDR").setValue(borrowedslotId + "-" + borrowedboardName + "-" + borrowedportName + "#" + borrowedPort);
        }
    }

    private String parsePathNum(String pathStr) {
        if (pathStr == null || pathStr.length() == 0) {
            return "";
        }
        ArrayList<Integer> strList = new ArrayList<Integer>();
        int size = pathStr.length();
        for (int i = 0; i < size; ++i) {
            int tmp = Integer.parseInt(pathStr.substring(i, i + 2), 16);
            if (tmp != 0) {
                strList.add(tmp);
            }
            ++i;
        }
        ArrayList allList = new ArrayList();
        ArrayList<Integer> seriateList = new ArrayList<Integer>();
        int size2 = strList.size();
        for (int i = 0; i < size2; ++i) {
            int pathNum = (Integer)strList.get(i);
            if (seriateList.isEmpty() || (Integer)seriateList.get(seriateList.size() - 1) + 1 == pathNum) {
                seriateList.add(pathNum);
            } else {
                allList.add(seriateList);
                seriateList = new ArrayList<Integer>();
                seriateList.add(pathNum);
            }
            if (i != size2 - 1) continue;
            allList.add(seriateList);
        }
        StringBuilder strBuilder = new StringBuilder();
        int size3 = allList.size();
        for (int i = 0; i < size3; ++i) {
            seriateList = (ArrayList<Integer>)allList.get(i);
            if (seriateList.size() == 1) {
                strBuilder.append(",");
                strBuilder.append(seriateList.get(0));
                continue;
            }
            strBuilder.append(",");
            strBuilder.append(seriateList.get(0));
            strBuilder.append("-");
            strBuilder.append(seriateList.get(seriateList.size() - 1));
        }
        return strBuilder.toString().substring(1, strBuilder.toString().length());
    }

    private void parseFilterErrorCodeList() {
        Operation operation = null;
        int len = this.operationList.size();
        for (int i = 0; i < len; ++i) {
            Output[] outputs;
            operation = (Operation)this.operationList.get(i);
            if (operation.getName().equals("NSCMD_ETHN_PORT_GET_SERIALPORT")) {
                outputs = operation.getOutput();
                if (outputs == null || outputs.length == 0) continue;
                for (Output output : outputs) {
                    Part level;
                    Part[] newParts;
                    Part[] parts;
                    String slotId = output.getPart("slotid").getValue();
                    String portId = output.getPart("phyportid").getValue();
                    if (slotId == null) continue;
                    int bdType = this.cfgMgr.getBoardType(this.neid, Integer.parseInt(slotId));
                    int portType = TEConfigurationDataMgr.getInstance().getPortType(this.neid, bdType, Integer.parseInt(portId));
                    if (portType == 1798) {
                        parts = output.getPart();
                        newParts = new Part[parts.length + 1];
                        System.arraycopy(parts, 0, newParts, 0, parts.length);
                        output.setPart(newParts);
                        level = new Part();
                        level.setName("level");
                        level.setValue("0");
                        level.setType("int");
                        output.setPart(newParts.length - 1, level);
                        continue;
                    }
                    output.getPart("phypathnum").setName("ktimeslotnum");
                    output.getPart("phypathlist").setName("ktimeslot");
                    parts = output.getPart();
                    newParts = new Part[parts.length + 1];
                    System.arraycopy(parts, 0, newParts, 0, parts.length);
                    output.setPart(newParts);
                    level = new Part();
                    level.setName("level");
                    level.setValue(FILTER_LAYER2_PORT_DATA);
                    level.setType("int");
                    output.setPart(newParts.length - 1, level);
                }
                continue;
            }
            if (!operation.getName().equals("NSCMD_ETHN_PORT_GET_SERIALPORT_VC12") || (outputs = operation.getOutput()) == null || outputs.length == 0) continue;
            for (Output output : outputs) {
                Part[] parts = output.getPart();
                Part[] newParts = new Part[parts.length + 1];
                System.arraycopy(parts, 0, newParts, 0, parts.length);
                output.setPart(newParts);
                Part level = new Part();
                level.setName("level");
                level.setValue(FILTER_LAYER2_PORT_DATA);
                level.setType("int");
                output.setPart(newParts.length - 1, level);
            }
        }
    }
}

