/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.serialinterface;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TEPortProperty;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgAttribute;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.nemgr.ip.ptn.serialinterface.SortComparator;
import com.huawei.nglct.util.string.TEConvertUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class TEGetSerialInterfaceRes
extends TENEExplorerBean {
    Map<TEBoard, ArrayList> availablePorts = new TreeMap<TEBoard, ArrayList>();
    private TEConfigurationDataMgr cfgMgr = TEConfigurationDataMgr.getInstance();
    private List<String> usedPorts = new ArrayList<String>();
    private List<String> unusedPorts = new ArrayList<String>();
    private List<Integer> usedChannels = new ArrayList<Integer>();
    private List<String> unusedChannels = new ArrayList<String>();
    private Map<Integer, List<Integer>> usedChannelTimeslots = new TreeMap<Integer, List<Integer>>();
    private List<String> unusedChannelTimeslots = new ArrayList<String>();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.outputData = new Datainterface();
        BussinessParams bussinessParams = new BussinessParams();
        this.outputData.setBussinessParams(bussinessParams);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        RowParams rowParams = inputData.getBussinessParams().getRowParams(0);
        int reType = Integer.valueOf(rowParams.getParam("restype").getValue());
        switch (reType) {
            case 0: {
                this.getPortResForSerial();
                break;
            }
            case 1: {
                this.getPortResForCreateSerial();
                break;
            }
            case 2: {
                this.getPortChannelResForCreateSerial(rowParams);
                break;
            }
            case 5: {
                this.getAllTimeSlotResForCreateCes(rowParams);
                break;
            }
            case 3: 
            case 4: {
                this.getIPPortList();
                break;
            }
        }
        return this.outputData;
    }

    protected void getPortResForSerial() {
        this.availablePorts.putAll(this.getPortsByPortType(this.neid, "SERIALPORT_ATTR_SERIALATTRIBUTES"));
        this.filterAvailablePortsForSerial();
        this.availablePorts.clear();
        this.availablePorts = null;
    }

    private void filterAvailablePortsForSerial() {
        TEBoard board = null;
        int slotId = 0;
        int boardType = 0;
        int portId = 0;
        int pathId = 0;
        RowParams rowParams = null;
        ArrayList portList = null;
        Map.Entry<TEBoard, ArrayList> entry2 = null;
        Iterator<Map.Entry<TEBoard, ArrayList>> iter = null;
        for (Map.Entry<TEBoard, ArrayList> entry2 : this.availablePorts.entrySet()) {
            board = entry2.getKey();
            portList = entry2.getValue();
            int m = portList.size();
            for (int i = 0; i < m; ++i) {
                slotId = board.getSlotID();
                boardType = this.cfgMgr.getBoardType(this.neid, slotId);
                portId = ((TEGenCfgPortAttribute)portList.get(i)).getPort();
                pathId = ((TEGenCfgPortAttribute)portList.get(i)).getPath();
                rowParams = new RowParams();
                rowParams.addParam("slotid", String.valueOf(slotId));
                rowParams.addParam("boardname", this.cfgMgr.getBoardTypeName(this.neid, boardType));
                rowParams.addParam("port", String.valueOf(portId));
                rowParams.addParam("portname", this.cfgMgr.getPortName(this.neid, slotId, boardType, portId));
                rowParams.addParam("path", String.valueOf(pathId));
                this.outputData.getBussinessParams().addRowParams(rowParams);
            }
        }
    }

    protected void getPortResForCreateSerial() {
        this.getSDHPorts();
        this.getPDHPorts();
        Collections.sort(this.unusedPorts, new SortComparator());
        if (!this.unusedPorts.isEmpty()) {
            RowParams rowParams = new RowParams();
            Param param = new Param("memberinterfaces", "");
            int m = this.unusedPorts.size();
            for (int i = 0; i < m; ++i) {
                param.addOption(new Option(this.unusedPorts.get(i)));
            }
            rowParams.addParam(param);
            this.outputData.getBussinessParams().addRowParams(rowParams);
        }
        this.usedPorts.clear();
        this.unusedPorts.clear();
    }

    private void getSDHPorts() {
        int slotId = 0;
        int boardType = 0;
        int portId = 0;
        TEBoard board = null;
        TIntArrayList portList = null;
        Map.Entry<TEBoard, TIntArrayList> entry2 = null;
        Iterator<Map.Entry<TEBoard, TIntArrayList>> iter = null;
        for (Map.Entry<TEBoard, TIntArrayList> entry2 : this.getPortsByPortType(this.neid, 1798).entrySet()) {
            board = entry2.getKey();
            portList = entry2.getValue();
            int m = portList.size();
            for (int i = 0; i < m; ++i) {
                slotId = board.getSlotID();
                boardType = this.cfgMgr.getBoardType(this.neid, slotId);
                portId = portList.get(i);
                if (this.usedPorts.contains(slotId + "-" + portId)) continue;
                this.usedPorts.add(slotId + "-" + portId);
                this.unusedPorts.add(slotId + "-" + this.cfgMgr.getBoardTypeName(this.neid, boardType) + "-" + this.cfgMgr.getPortNameForPTN(this.neid, slotId, boardType, portId) + "#" + portId + "#" + 1798);
            }
        }
    }

    private void getPDHPorts() {
        TEBoard board = null;
        TIntArrayList portList = null;
        Map.Entry<TEBoard, TIntArrayList> entry2 = null;
        Iterator<Map.Entry<TEBoard, TIntArrayList>> iter = null;
        this.operationList = new ArrayList();
        Operation oper1 = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTNETY_GET_LEVELMODE");
        Input input1 = oper1.getInput();
        for (Map.Entry<TEBoard, TIntArrayList> entry2 : this.getPortsByPortType(this.neid, 1797).entrySet()) {
            board = entry2.getKey();
            portList = entry2.getValue();
            int m = portList.size();
            for (int i = 0; i < m; ++i) {
                input1.setPartValue("slotid", String.valueOf(board.getSlotID()));
                input1.setPartValue("port", String.valueOf(portList.get(i)));
                this.operationList.add(oper1.clone());
            }
        }
        if (this.operationList.size() > 0) {
            int slotId = 0;
            int boardType = 0;
            int portId = 0;
            Operation oper = null;
            Output output = null;
            int result = this.sendMessage(this.neid);
            if (0 == result) {
                int n = this.operationList.size();
                for (int j = 0; j < n; ++j) {
                    oper = (Operation)this.operationList.get(j);
                    output = oper.getOutput(0);
                    if (0 != Integer.valueOf(output.getFault(0).getCode()) || 1 != Integer.valueOf(output.getPartValue("PTNIF_PORT_ATTR_MODE"))) continue;
                    slotId = Integer.valueOf(output.getPartValue("slotid"));
                    boardType = this.cfgMgr.getBoardType(this.neid, slotId);
                    portId = Integer.valueOf(output.getPartValue("port"));
                    if (this.usedPorts.contains(slotId + "-" + portId)) continue;
                    this.usedPorts.add(slotId + "-" + portId);
                    this.unusedPorts.add(slotId + "-" + this.cfgMgr.getBoardTypeName(this.neid, boardType) + "-" + this.cfgMgr.getPortNameForPTN(this.neid, slotId, boardType, portId) + "#" + portId + "#" + 1797);
                }
            }
        }
    }

    protected void getPortChannelResForCreateSerial(RowParams inputRowParams) {
        int slotid = Integer.valueOf(inputRowParams.getParam("slotid").getValue());
        int portid = Integer.valueOf(inputRowParams.getParam("port").getValue());
        int lowpath = Integer.valueOf(inputRowParams.getParam("lowpath").getValue());
        int boardType = this.cfgMgr.getBoardType(this.neid, slotid);
        if (-1 == lowpath) {
            this.getSerialPorts(slotid, portid);
            Collections.sort(this.unusedChannels, new SortComparator());
            String lowchannel = slotid + "-" + this.cfgMgr.getBoardTypeName(this.neid, boardType) + "-" + this.cfgMgr.getPortNameForPTN(this.neid, slotid, boardType, portid);
            RowParams rowParams = new RowParams();
            Param param = new Param("memberinterfaces", lowchannel);
            if (!this.unusedChannels.isEmpty()) {
                int m = this.unusedChannels.size();
                for (int i = 0; i < m; ++i) {
                    param.addOption(new Option(this.unusedChannels.get(i)));
                }
            }
            rowParams.addParam(param);
            this.outputData.getBussinessParams().addRowParams(rowParams);
            this.usedChannels.clear();
            this.unusedChannels.clear();
        } else {
            this.getSerialvc12Ports(slotid, portid);
            if (!this.unusedChannelTimeslots.isEmpty()) {
                RowParams rowParams = new RowParams();
                Param param = new Param("memberinterfaces", "");
                int m = this.unusedChannelTimeslots.size();
                for (int i = 0; i < m; ++i) {
                    param.addOption(new Option(this.unusedChannelTimeslots.get(i)));
                }
                rowParams.addParam(param);
                this.outputData.getBussinessParams().addRowParams(rowParams);
            }
            this.usedChannelTimeslots.clear();
            this.unusedChannelTimeslots.clear();
        }
    }

    protected void getAllTimeSlotResForCreateCes(RowParams inputRowParams) {
        int slotid = Integer.valueOf(inputRowParams.getParam("slotid").getValue());
        int portid = Integer.valueOf(inputRowParams.getParam("port").getValue());
        int lowpath = Integer.valueOf(inputRowParams.getParam("lowpath").getValue());
        int boardType = this.cfgMgr.getBoardType(this.neid, slotid);
        if (-1 == lowpath) {
            this.getAllPortTimeSlots(slotid, portid);
            Collections.sort(this.unusedChannels, new SortComparator());
            String lowchannel = slotid + "-" + this.cfgMgr.getBoardTypeName(this.neid, boardType) + "-" + this.cfgMgr.getPortNameForPTN(this.neid, slotid, boardType, portid);
            RowParams rowParams = new RowParams();
            Param param = new Param("memberinterfaces", lowchannel);
            if (!this.unusedChannels.isEmpty()) {
                int m = this.unusedChannels.size();
                for (int i = 0; i < m; ++i) {
                    param.addOption(new Option(this.unusedChannels.get(i)));
                }
            }
            rowParams.addParam(param);
            this.outputData.getBussinessParams().addRowParams(rowParams);
            this.usedChannels.clear();
            this.unusedChannels.clear();
        } else {
            this.getAllvc12Ports(slotid, portid);
            if (!this.unusedChannelTimeslots.isEmpty()) {
                RowParams rowParams = new RowParams();
                Param param = new Param("memberinterfaces", "");
                int m = this.unusedChannelTimeslots.size();
                for (int i = 0; i < m; ++i) {
                    param.addOption(new Option(this.unusedChannelTimeslots.get(i)));
                }
                rowParams.addParam(param);
                this.outputData.getBussinessParams().addRowParams(rowParams);
            }
            this.usedChannelTimeslots.clear();
            this.unusedChannelTimeslots.clear();
        }
    }

    private void getSerialPorts(int slotid, int portid) {
        block8: {
            int slotId = -1;
            int portId = -1;
            int boardType = this.cfgMgr.getBoardType(this.neid, slotid);
            List<Integer> pathList = null;
            this.operationList = new ArrayList();
            Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_ETHN_PORT_GET_SERIALPORT");
            Input input = oper.getInput();
            input.setPartValue("slotid", String.valueOf(slotid));
            this.operationList.add(oper.clone());
            if (this.operationList.size() <= 0) break block8;
            int result = this.sendMessage(this.neid);
            if (0 == result) {
                int n = this.operationList.size();
                block0: for (int j = 0; j < n; j += 2) {
                    oper = (Operation)this.operationList.get(j);
                    for (Output output : oper.getOutput()) {
                        if (0 != Integer.valueOf(output.getFault(0).getCode())) continue;
                        slotId = Integer.valueOf(output.getPartValue("slotid"));
                        portId = Integer.valueOf(output.getPartValue("phyportid"));
                        if (slotid != slotId || portid != portId && portid != -1) continue block0;
                        pathList = this.usedChannels(output.getPartValue("phypathlist"));
                        this.usedChannels.addAll(pathList);
                    }
                }
            }
            int portnum = 1;
            if (portid == -1) {
                portnum = TEGetSerialInterfaceRes.getSerialPortsBySlot(this.neid, slotid).size();
                for (int pid = 1; pid <= portnum; ++pid) {
                    for (int channelid = 1; channelid <= 31; ++channelid) {
                        if (this.usedChannels.contains(channelid)) continue;
                        this.unusedChannels.add(slotid + "-" + this.cfgMgr.getBoardTypeName(this.neid, boardType) + "-" + this.cfgMgr.getPortNameForPTN(this.neid, slotid, boardType, pid) + "#" + pid + "#" + channelid);
                    }
                }
            } else {
                for (int channelid = 1; channelid <= 31; ++channelid) {
                    if (this.usedChannels.contains(channelid)) continue;
                    this.unusedChannels.add(slotid + "-" + this.cfgMgr.getBoardTypeName(this.neid, boardType) + "-" + this.cfgMgr.getPortNameForPTN(this.neid, slotid, boardType, portid) + "#" + portid + "#" + channelid);
                }
            }
        }
    }

    private void getAllPortTimeSlots(int slotid, int portid) {
        int boardType = this.cfgMgr.getBoardType(this.neid, slotid);
        int portnum = 1;
        if (portid == -1) {
            portnum = TEGetSerialInterfaceRes.getSerialPortsBySlot(this.neid, slotid).size();
            for (int pid = 1; pid <= portnum; ++pid) {
                for (int channelid = 1; channelid <= 31; ++channelid) {
                    this.unusedChannels.add(slotid + "-" + this.cfgMgr.getBoardTypeName(this.neid, boardType) + "-" + this.cfgMgr.getPortNameForPTN(this.neid, slotid, boardType, pid) + "#" + pid + "#" + channelid);
                }
            }
        } else {
            for (int channelid = 1; channelid <= 31; ++channelid) {
                this.unusedChannels.add(slotid + "-" + this.cfgMgr.getBoardTypeName(this.neid, boardType) + "-" + this.cfgMgr.getPortNameForPTN(this.neid, slotid, boardType, portid) + "#" + portid + "#" + channelid);
            }
        }
    }

    private void getAllvc12Ports(int slotid, int portid) {
        int boardType = this.cfgMgr.getBoardType(this.neid, slotid);
        for (int channelid = 1; channelid <= 63; ++channelid) {
            for (int timeslotid = 1; timeslotid <= 31; ++timeslotid) {
                this.unusedChannelTimeslots.add(slotid + "-" + this.cfgMgr.getBoardTypeName(this.neid, boardType) + "-" + this.cfgMgr.getPortNameForPTN(this.neid, slotid, boardType, portid) + "-" + "VC4:1" + "-" + "VC12:" + channelid + "#" + channelid + "#" + timeslotid);
            }
        }
    }

    private void getSerialvc12Ports(int slotid, int portid) {
        int slotId = -1;
        int portId = -1;
        int lowChannel = -1;
        int boardType = this.cfgMgr.getBoardType(this.neid, slotid);
        List<Integer> pathList = null;
        List<Integer> lowchannelidList = null;
        this.operationList = new ArrayList();
        Output output2 = null;
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_ETHN_PORT_GET_SERIALPORT_VC12");
        Input input = oper.getInput();
        input.setPartValue("slotid", String.valueOf(slotid));
        this.operationList.add(oper.clone());
        if (this.operationList.size() > 0) {
            int result = this.sendMessage(this.neid);
            if (0 == result) {
                int n = this.operationList.size();
                for (int j = 0; j < n; j += 2) {
                    oper = (Operation)this.operationList.get(j);
                    for (Output output2 : oper.getOutput()) {
                        if (0 != Integer.valueOf(output2.getFault(0).getCode())) continue;
                        slotId = Integer.valueOf(output2.getPartValue("slotid"));
                        portId = Integer.valueOf(output2.getPartValue("phyportid"));
                        lowChannel = Integer.valueOf(output2.getPartValue("phypathlist"), 16);
                        if (slotid != slotId || portid != portId) continue;
                        pathList = this.usedChannels(output2.getPartValue("ktimeslot"));
                        this.usedChannelTimeslots.put(lowChannel, pathList);
                    }
                }
            }
            for (int channelid = 1; channelid <= 63; ++channelid) {
                lowchannelidList = this.usedChannelTimeslots.get(channelid);
                for (int timeslotid = 1; timeslotid <= 31; ++timeslotid) {
                    if (null != lowchannelidList && lowchannelidList.contains(timeslotid)) continue;
                    this.unusedChannelTimeslots.add(slotid + "-" + this.cfgMgr.getBoardTypeName(this.neid, boardType) + "-" + this.cfgMgr.getPortNameForPTN(this.neid, slotid, boardType, portid) + "-" + "VC4:1" + "-" + "VC12:" + channelid + "#" + channelid + "#" + timeslotid);
                }
            }
        }
    }

    protected Map<TEBoard, ArrayList<TEGenCfgPortAttribute>> getPortsByPortType(int neid, String serialattri) {
        return TEGenCfgModel.getAllSupportPortListInNE((int)neid, (String)serialattri);
    }

    protected static ArrayList getSerialPortsBySlot(int neid, int slotid) {
        TEGenCfgAttribute cfgAttribute;
        int boardType = TEConfigurationDataMgr.getInstance().getBoard(neid, slotid).getBoardType();
        TEGenCfgModel genCfgModel = TEGenCfgDataMgr.getGenCfgMode((int)boardType);
        if (null != genCfgModel && null != (cfgAttribute = genCfgModel.getAttrFromId("SERIALPORT_ATTR_SERIALATTRIBUTES"))) {
            return cfgAttribute.getPortList();
        }
        return null;
    }

    private Map<TEBoard, TIntArrayList> getPortsByPortType(int neid, int portType) {
        HashMap<TEBoard, TIntArrayList> ports = new HashMap<TEBoard, TIntArrayList>();
        int portId = 0;
        TIntArrayList portList1 = null;
        TEBoard board = null;
        TEPortProperty portProperty = null;
        ArrayList portPropertyList = null;
        Vector boardVec = this.cfgMgr.getNE(neid).getClonedBoardList();
        int m = boardVec.size();
        for (int i = 0; i < m; ++i) {
            portList1 = new TIntArrayList();
            board = (TEBoard)boardVec.get(i);
            portPropertyList = this.cfgMgr.getBoardPortPropertyList(neid, board.getBoardType());
            int n = portPropertyList.size();
            for (int j = 0; j < n; ++j) {
                portProperty = (TEPortProperty)portPropertyList.get(j);
                portId = portProperty.getPortNo();
                if (portProperty.getPortType() != portType || portList1.contains(portId)) continue;
                portList1.add(portId);
            }
            if (portList1.size() <= 0) continue;
            ports.put((TEBoard)board.clone(), portList1);
        }
        return ports;
    }

    private void getIPPortList() {
        TEBoard board = null;
        this.operationList = new ArrayList();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_PORT_L3_GET_IPPARA_EX");
        Input input = oper.getInput();
        Operation operName = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_PORT_GET_NAME");
        Input inputName = oper.getInput();
        Vector bdVec = this.cfgMgr.getNE(this.neid).getClonedBoardList();
        int m = bdVec.size();
        for (int i = 0; i < m; ++i) {
            board = (TEBoard)bdVec.get(i);
            input.setPartValue("slotid", String.valueOf(board.getSlotID()));
            input.setPartValue("port", "0");
            this.operationList.add(oper.clone());
            inputName.setPartValue("slotid", String.valueOf(board.getSlotID()));
            inputName.setPartValue("port", "0");
            this.operationList.add(operName.clone());
        }
        input.setPartValue("slotid", String.valueOf(65535));
        input.setPartValue("port", "0");
        this.operationList.add(oper.clone());
        inputName.setPartValue("slotid", String.valueOf(board.getSlotID()));
        inputName.setPartValue("port", "0");
        this.operationList.add(operName.clone());
        int result = this.sendMessage(this.neid);
        if (0 == result) {
            RowParams rowParams = new RowParams();
            Param param = new Param("borrowedports", "");
            rowParams.addParam(param);
            this.handleIPPortAttr(param);
            if (param.getOptionCount() > 0) {
                this.outputData.getBussinessParams().addRowParams(rowParams);
            }
        }
    }

    private void handleIPPortAttr(Param param) {
        int errCode = 0;
        int slotId = 0;
        int portId = 0;
        int boardType = 0;
        String resName = null;
        String portName = null;
        Operation oper = null;
        Output output = null;
        int n = this.operationList.size();
        for (int j = 0; j < n; ++j) {
            oper = (Operation)this.operationList.get(j);
            errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode());
            if (0 != errCode) continue;
            int mn = oper.getOutputCount();
            for (int k = 0; k < mn; ++k) {
                output = oper.getOutput(k);
                slotId = Integer.valueOf(output.getPartValue("slotid"));
                portId = Integer.valueOf(output.getPartValue("port"));
                if (1 != Integer.valueOf(output.getPartValue("ATTR_ETHOVERPTN_MAC_SPECIFYIPADDRESS")) || 0xFFFFFFFFL == Long.valueOf(output.getPartValue("ATTR_ETHOVERPTN_MAC_IPADDRESS")) || 0xFFFFFFFFL == Long.valueOf(output.getPartValue("ATTR_ETHOVERPTN_MAC_IPMARSK"))) continue;
                boardType = this.cfgMgr.getBoardType(this.neid, slotId);
                portName = this.cfgMgr.getPortNameForPTN(this.neid, slotId, boardType, portId);
                resName = slotId + "-" + this.cfgMgr.getBoardTypeName(this.neid, boardType) + "-" + portName;
                param.addOption(new Option(resName + "#" + portId));
            }
        }
    }

    private List<Integer> usedChannels(String protoChannels) {
        ArrayList<Integer> channelid = new ArrayList<Integer>(0);
        if (null == protoChannels || "".equals(protoChannels)) {
            return channelid;
        }
        String convertStr = TEConvertUtil.strToMAC((String)protoChannels);
        String[] pathlist = convertStr.split("-");
        int num = pathlist.length;
        for (int i = 0; i < num; ++i) {
            channelid.add(Integer.valueOf(pathlist[i], 16));
        }
        return channelid;
    }
}

