/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.portmirror_ptn;

import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.ip.ptn.portmirror.TEDeletePortMirror;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;

public class TEDeletePortMirror_ptn
extends TEDeletePortMirror {
    protected String resFile = "ip" + File.separator + "ptn" + File.separator + "res" + File.separator + "portmirror_ptn" + File.separator + "portmirrorres_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
    protected TEResourceUtil res;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.res = TEGetFilePath.getResource((int)neid, (String)this.resFile);
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    @Override
    protected void logSuccess(String user, String ipAddress, String operateObject, String operateName, int errorCode) {
        int userIDPtn = 0;
        if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
            try {
                userIDPtn = Integer.parseInt(user);
            }
            catch (Exception e) {
                userIDPtn = 0;
            }
        }
        RowParams rowParams = null;
        TELogInfo loginfo = new TELogInfo();
        loginfo.setCmdID(this.subfunc.getCode());
        loginfo.setLocation(ipAddress);
        loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
        loginfo.setUserID(userIDPtn);
        loginfo.setOperateObject(operateObject);
        loginfo.setOperateName(operateName);
        StringBuilder operDesc = new StringBuilder();
        int size = this.inputData.getBussinessParams().getRowParams().length;
        for (int i = 0; i < size; ++i) {
            rowParams = this.inputData.getBussinessParams().getRowParams(i);
            String mirrorport = rowParams.getParam("mirrorport").getValue();
            String obsmirrorport = rowParams.getParam("obsmirrorport").getValue();
            Param mirrorIndexParam = rowParams.getParam("mirrorServiceIndex");
            if (null != mirrorIndexParam) {
                operDesc.append(this.res.getString("mirrorServiceIndex")).append(':').append(mirrorIndexParam.getValue()).append(", ");
            }
            operDesc.append(this.res.getString("mirrorport")).append(":").append(mirrorport).append(", ").append(this.res.getString("obsmirrorport")).append(obsmirrorport);
            if (i == size - 1) continue;
            operDesc.append(", ");
        }
        loginfo.setOperateDesc(operDesc.toString());
        loginfo.setResult(0);
        loginfo.setErrCode(0);
        loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
        this.logInfoList.add(loginfo);
    }

    @Override
    protected void logFail(String user, String ipAddress, String operateObject, String operateName) {
        int len = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowErrors[] rowErrors = this.outputData.getBussinessParams().getRowParams(i).getRowErrors();
            int size = rowErrors.length;
            for (int j = 0; j < size; ++j) {
                String mirrorport = rowErrors[j].getParam("mirrorport").getValue();
                String obsmirrorport = rowErrors[j].getParam("obsmirrorport").getValue();
                StringBuilder operDesc = new StringBuilder();
                operDesc.append(this.res.getString("mirrorport")).append(":").append(mirrorport).append(", ").append(this.res.getString("obsmirrorport")).append(obsmirrorport);
                for (int k = this.logInfoList.size() - 1; k >= 0; --k) {
                    TELogInfo loginfo = (TELogInfo)this.logInfoList.get(k);
                    if (!loginfo.getOperateDesc().equalsIgnoreCase(operDesc.toString())) continue;
                    this.logInfoList.remove(k);
                }
                TELogInfo loginfo = new TELogInfo();
                loginfo.setCmdID(this.subfunc.getCode());
                loginfo.setLocation(ipAddress);
                loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
                loginfo.setOperateObject(operateObject);
                loginfo.setOperateName(operateName);
                loginfo.setOperateDesc(operDesc.toString());
                loginfo.setResult(2);
                loginfo.setErrCode(Integer.parseInt(rowErrors[j].getErrorMessage().getErrorcode()));
                loginfo.setErrInfo(rowErrors[i].getErrorMessage().getErrorinfo());
                this.logInfoList.add(loginfo);
            }
        }
    }
}

