/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.policy_v2r8c01.classifier;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.ip.ptn.policy.classifier.TEClassifierData;
import com.huawei.nglct.nemgr.ip.ptn.policy.classifier.TEClassifierMgr;
import com.huawei.nglct.nemgr.ip.ptn.policy.classifier.TERuleData;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TEQueryClassifierBean
extends TENEExplorerBean {
    private int policyType;
    private BussinessParams bussiness = new BussinessParams();
    private TEClassifierMgr classifierMgr = TEClassifierMgr.getInstance();

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        RowParams rowParas;
        TEClassifierData datas;
        int classifierId;
        String errorCode;
        int i;
        boolean allFailFlag = true;
        boolean allSuccFlag = true;
        this.outputData = new Datainterface();
        Operation operat = (Operation)operationList.get(0);
        this.policyType = Integer.parseInt(operat.getInput().getPartValue("policyType"));
        int policyId = Integer.parseInt(operat.getInput().getPartValue("policyId"));
        this.classifierMgr.clearClassifierList();
        int size = operat.getOutputCount();
        for (i = 0; i < size; ++i) {
            Output output = operat.getOutput(i);
            errorCode = output.getFault()[0].getCode();
            if (errorCode.equals("0")) {
                allFailFlag = false;
                classifierId = Integer.parseInt(output.getPartValue("classifierId"));
                datas = this.classifierMgr.getClassifierData(this.policyType, policyId, classifierId);
                if (datas == null) {
                    datas = new TEClassifierData(this.policyType, policyId, classifierId);
                }
                int order = Integer.parseInt(output.getPartValue("classifierOrder"));
                int relation = Integer.parseInt(output.getPartValue("relation"));
                int ruleId = Integer.parseInt(output.getPartValue("ruleId"));
                String rule = this.filterString(output.getPartValue("classifierRule"));
                datas.setClassifierOrder(order);
                datas.setRelation(relation);
                TERuleData ruleData = new TERuleData(neid, ruleId, rule);
                ruleData.setRuleStr(rule);
                datas.addRule(ruleData);
                this.classifierMgr.addClassifier(datas);
                continue;
            }
            if (Integer.valueOf(errorCode) == 38662) continue;
            allSuccFlag = false;
            rowParas = new RowParams();
            rowParas.addRowErrors(this.constructErrorObj(errorCode));
            this.bussiness.addRowParams(rowParas);
        }
        Collections.sort(this.classifierMgr.getClassifierList());
        operat = (Operation)operationList.get(1);
        int len = operat.getOutputCount();
        for (i = 0; i < len; ++i) {
            Output opt = operat.getOutput(i);
            errorCode = opt.getFault()[0].getCode();
            if (errorCode.equals("0")) {
                allFailFlag = false;
                classifierId = Integer.parseInt(opt.getPartValue("classifierId"));
                datas = this.classifierMgr.getClassifierData(this.policyType, policyId, classifierId);
                int acl = Integer.parseInt(opt.getPartValue("classifierAcl"));
                datas.setAcl(acl);
                if (this.policyType != 2 && this.policyType != 1) continue;
                String cos = opt.getPartValue("cos");
                datas.setCosType(cos);
                String cir = opt.getPartValue("cir");
                String cbs = opt.getPartValue("cbs");
                String pir = opt.getPartValue("pir");
                String pbs = opt.getPartValue("pbs");
                datas.setCosBandwidth(cir, cbs, pir, pbs);
                int colorMode = Integer.parseInt(opt.getPartValue("colorMode"));
                datas.setColorMode(colorMode);
                int handle = Integer.parseInt(opt.getPartValue("greenHandleMethod"));
                String rmkCos = opt.getPartValue("greenRemarkCos");
                String rmkColor = opt.getPartValue("greenRemarkColor");
                datas.setGreenInfo(handle, rmkCos, rmkColor);
                handle = Integer.parseInt(opt.getPartValue("yellowHandleMethod"));
                rmkCos = opt.getPartValue("yellowRemarkCos");
                rmkColor = opt.getPartValue("yellowRemarkColor");
                datas.setYellowInfo(handle, rmkCos, rmkColor);
                handle = Integer.parseInt(opt.getPartValue("redHandleMethod"));
                rmkCos = opt.getPartValue("redRemarkCos");
                rmkColor = opt.getPartValue("redRemarkColor");
                datas.setRedInfo(handle, rmkCos, rmkColor);
                continue;
            }
            if (Integer.valueOf(errorCode) == 38662 || Integer.valueOf(errorCode) == 37124) continue;
            allSuccFlag = false;
            rowParas = new RowParams();
            rowParas.addRowErrors(this.constructErrorObj(errorCode));
            this.bussiness.addRowParams(rowParas);
        }
        List classifierList = this.classifierMgr.getClassifierList();
        this.constructBussinessParams(classifierList);
        this.constructErrorMessage(allSuccFlag, allFailFlag);
        this.outputData.setBussinessParams(this.bussiness);
    }

    private RowErrors constructErrorObj(String errorCode) {
        RowErrors errors = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        errorMessage.setErrorcode(errorCode);
        errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)Integer.parseInt(errorCode)));
        errors.setErrorMessage(errorMessage);
        return errors;
    }

    private String filterString(String rules) {
        String retStr = rules;
        int len = rules.length();
        for (int k = 0; k < len; ++k) {
            if (rules.charAt(k) != '\u0000') continue;
            retStr = rules.substring(0, k);
            break;
        }
        return retStr;
    }

    private void constructBussinessParams(List classifierList) {
        TENE ne = TEConfigurationDataMgr.getInstance().getNE(this.neid);
        int len = classifierList.size();
        for (int i = 0; i < len; ++i) {
            TEClassifierData datas = (TEClassifierData)classifierList.get(i);
            if (datas.getPolicyType() != this.policyType) continue;
            RowParams rowParas = new RowParams();
            int acl = datas.getAcl();
            List ruleList = datas.getRuleList();
            String classifierRule = this.classifierMgr.convertRule2nm(ruleList, datas.getRelation(), false);
            String classifierRuleVal = this.classifierMgr.convertRule2nm(ruleList, datas.getRelation(), true);
            rowParas.addParam("index", String.valueOf(i));
            rowParas.addParam("classifierOrder", String.valueOf(datas.getClassifierOrder()));
            rowParas.addParam("classifierId", String.valueOf(datas.getClassifierId()));
            rowParas.addParam("classifierRule", classifierRule);
            rowParas.addParam("classifierRuleVal", classifierRuleVal);
            rowParas.addParam("classifierAcl", String.valueOf(acl));
            rowParas.addParam("relation", String.valueOf(datas.getRelation()));
            if (this.policyType == 2 || this.policyType == 1) {
                rowParas.addParam("queueType", datas.getCosType());
                boolean isSuppCarLimit = TESpecialAttrMgr.getInstance().isNESupport(this.neid, "TE_FUNC_QOS_MANAGEMENT", "TE_ATTR_QOS_SUPPORT_CARLIMIT");
                if (ne.getNEType() == 115 && !this.isPortTraffic(classifierRuleVal) && !isSuppCarLimit) {
                    rowParas.addParam("bwEnable", String.valueOf(0));
                    rowParas.addParam("cir", "-");
                    rowParas.addParam("cbs", "-");
                    rowParas.addParam("pir", "-");
                    rowParas.addParam("pbs", "-");
                    rowParas.addParam("greenHandleMethod", "255");
                    rowParas.addParam("greenRemarkColor", "255");
                    rowParas.addParam("greenRemarkCos", "255");
                    rowParas.addParam("yellowHandleMethod", "255");
                    rowParas.addParam("yellowRemarkColor", "255");
                    rowParas.addParam("yellowRemarkCos", "255");
                    rowParas.addParam("redHandleMethod", "255");
                    rowParas.addParam("redRemarkColor", "255");
                    rowParas.addParam("redRemarkCos", "255");
                } else {
                    if (datas.getCosCir().equals("4294967295")) {
                        rowParas.addParam("bwEnable", String.valueOf(2));
                    } else {
                        rowParas.addParam("bwEnable", String.valueOf(1));
                    }
                    rowParas.addParam("cir", datas.getCosCir().equals("4294967295") ? "" : datas.getCosCir());
                    rowParas.addParam("cbs", datas.getCosCbs());
                    rowParas.addParam("pir", datas.getCosPir().equals("4294967295") ? "" : datas.getCosPir());
                    rowParas.addParam("pbs", datas.getCosPbs());
                    rowParas.addParam("colorMode", String.valueOf(datas.getColorMode()));
                    rowParas.addParam("greenHandleMethod", String.valueOf(datas.getGreenHandleMethod()));
                    rowParas.addParam("greenRemarkColor", String.valueOf(datas.getGreenRemarkColor()));
                    rowParas.addParam("greenRemarkCos", String.valueOf(datas.getGreenRemarkCos()));
                    rowParas.addParam("yellowHandleMethod", String.valueOf(datas.getYellowHandleMethod()));
                    rowParas.addParam("yellowRemarkColor", String.valueOf(datas.getYellowRemarkColor()));
                    rowParas.addParam("yellowRemarkCos", String.valueOf(datas.getYellowRemarkCos()));
                    rowParas.addParam("redHandleMethod", String.valueOf(datas.getRedHandleMethod()));
                    rowParas.addParam("redRemarkColor", String.valueOf(datas.getRedRemarkColor()));
                    rowParas.addParam("redRemarkCos", String.valueOf(datas.getRedRemarkCos()));
                }
            }
            this.bussiness.addRowParams(rowParas);
        }
    }

    private boolean isPortTraffic(String classifierRule) {
        String[] ruleList = classifierRule.substring(1, classifierRule.length() - 1).split(":");
        return (ruleList[0].equals("cvlanid") || ruleList[0].equals("svlanid")) && ruleList[1].equals("0");
    }

    private void constructErrorMessage(boolean allSuccFlag, boolean allFailFlag) {
        if (allSuccFlag) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        } else if (allFailFlag) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
        }
    }
}

