/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.policy_u2kv1r2c00.classifier;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.ip.ptn.policy.classifier.TEClassifierData;
import com.huawei.nglct.nemgr.ip.ptn.policy.classifier.TEClassifierMgr;
import com.huawei.nglct.nemgr.ip.ptn.policy.classifier.TERuleData;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TEQueryClassifierBean
extends TENEExplorerBean {
    private int policyType;
    private BussinessParams bussiness = new BussinessParams();
    private TEClassifierMgr classifierMgr = TEClassifierMgr.getInstance();

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        RowParams row;
        TEClassifierData data;
        int classifierId;
        String errorCode;
        Output output;
        int i;
        boolean allFail = true;
        boolean allSucc = true;
        this.outputData = new Datainterface();
        Operation oper = (Operation)operationList.get(0);
        this.policyType = Integer.parseInt(oper.getInput().getPartValue("policyType"));
        int policyId = Integer.parseInt(oper.getInput().getPartValue("policyId"));
        this.classifierMgr.clearClassifierList();
        int size = oper.getOutputCount();
        for (i = 0; i < size; ++i) {
            output = oper.getOutput(i);
            errorCode = output.getFault()[0].getCode();
            if (errorCode.equals("0")) {
                allFail = false;
                classifierId = Integer.parseInt(output.getPartValue("classifierId"));
                data = this.classifierMgr.getClassifierData(this.policyType, policyId, classifierId);
                if (data == null) {
                    data = new TEClassifierData(this.policyType, policyId, classifierId);
                }
                int order = Integer.parseInt(output.getPartValue("classifierOrder"));
                int relation = Integer.parseInt(output.getPartValue("relation"));
                int ruleId = Integer.parseInt(output.getPartValue("ruleId"));
                String rule = this.filterString(output.getPartValue("classifierRule"));
                data.setClassifierOrder(order);
                data.setRelation(relation);
                TERuleData ruleData = new TERuleData(neid, ruleId, rule);
                ruleData.setRuleStr(rule);
                data.addRule(ruleData);
                this.classifierMgr.addClassifier(data);
                continue;
            }
            if (Integer.parseInt(errorCode) == 38662) continue;
            allSucc = false;
            row = new RowParams();
            row.addRowErrors(this.constructErrorObj(errorCode));
            this.bussiness.addRowParams(row);
        }
        Collections.sort(this.classifierMgr.getClassifierList());
        oper = (Operation)operationList.get(1);
        int len = oper.getOutputCount();
        for (i = 0; i < len; ++i) {
            output = oper.getOutput(i);
            errorCode = output.getFault()[0].getCode();
            if (errorCode.equals("0")) {
                allFail = false;
                classifierId = Integer.parseInt(output.getPartValue("classifierId"));
                TEClassifierData dataTemp = this.classifierMgr.getClassifierData(this.policyType, policyId, classifierId);
                int acl = Integer.parseInt(output.getPartValue("classifierAcl"));
                dataTemp.setAcl(acl);
                if (this.policyType != 1) continue;
                String cosStr = output.getPartValue("cos");
                dataTemp.setCosType(cosStr);
                String cirStr = output.getPartValue("cir");
                String cbs = output.getPartValue("cbs");
                String pir = output.getPartValue("pir");
                String pbs = output.getPartValue("pbs");
                dataTemp.setCosBandwidth(cirStr, cbs, pir, pbs);
                int colorMode = Integer.parseInt(output.getPartValue("colorMode"));
                dataTemp.setColorMode(colorMode);
                int handle = Integer.parseInt(output.getPartValue("greenHandleMethod"));
                String rmkCos = output.getPartValue("greenRemarkCos");
                String rmkColor = output.getPartValue("greenRemarkColor");
                dataTemp.setGreenInfo(handle, rmkCos, rmkColor);
                handle = Integer.parseInt(output.getPartValue("yellowHandleMethod"));
                rmkCos = output.getPartValue("yellowRemarkCos");
                rmkColor = output.getPartValue("yellowRemarkColor");
                dataTemp.setYellowInfo(handle, rmkCos, rmkColor);
                handle = Integer.parseInt(output.getPartValue("redHandleMethod"));
                rmkCos = output.getPartValue("redRemarkCos");
                rmkColor = output.getPartValue("redRemarkColor");
                dataTemp.setRedInfo(handle, rmkCos, rmkColor);
                continue;
            }
            if (Integer.parseInt(errorCode) == 38662 || Integer.parseInt(errorCode) == 37124) continue;
            allSucc = false;
            row = new RowParams();
            row.addRowErrors(this.constructErrorObj(errorCode));
            this.bussiness.addRowParams(row);
        }
        oper = (Operation)operationList.get(2);
        len = oper.getOutputCount();
        for (i = 0; i < len; ++i) {
            output = oper.getOutput(i);
            errorCode = output.getFault()[0].getCode();
            if (errorCode.equals("0")) {
                allFail = false;
                classifierId = Integer.parseInt(output.getPartValue("classifierId"));
                data = this.classifierMgr.getClassifierData(this.policyType, policyId, classifierId);
                if (this.policyType != 1) continue;
                String cir = output.getPartValue("cir_sp");
                String cbs = output.getPartValue("cbs_sp");
                String pir = output.getPartValue("pir_sp");
                String pbs = output.getPartValue("pbs_sp");
                data.setShapingAttr(cir, cbs, pir, pbs);
                continue;
            }
            if (Integer.parseInt(errorCode) == 38662 || Integer.parseInt(errorCode) == 37124) continue;
            allSucc = false;
            row = new RowParams();
            row.addRowErrors(this.constructErrorObj(errorCode));
            this.bussiness.addRowParams(row);
        }
        List classifierList = this.classifierMgr.getClassifierList();
        this.constructBussinessParams(classifierList);
        this.constructErrorMessage(allSucc, allFail);
        this.outputData.setBussinessParams(this.bussiness);
    }

    private RowErrors constructErrorObj(String errorCode) {
        RowErrors error = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        errorMessage.setErrorcode(errorCode);
        errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)Integer.parseInt(errorCode)));
        error.setErrorMessage(errorMessage);
        return error;
    }

    private String filterString(String rule) {
        String retStr = rule;
        int len = rule.length();
        for (int k = 0; k < len; ++k) {
            if (rule.charAt(k) != '\u0000') continue;
            retStr = rule.substring(0, k);
            break;
        }
        return retStr;
    }

    private void constructBussinessParams(List classifierList) {
        int len = classifierList.size();
        for (int i = 0; i < len; ++i) {
            TEClassifierData data = (TEClassifierData)classifierList.get(i);
            if (data.getPolicyType() != this.policyType) continue;
            RowParams row = new RowParams();
            int acl = data.getAcl();
            List ruleList = data.getRuleList();
            String classifierRule = this.classifierMgr.convertRule2nm(ruleList, data.getRelation(), false);
            String classifierRuleVal = this.classifierMgr.convertRule2nm(ruleList, data.getRelation(), true);
            row.addParam("index", String.valueOf(i));
            row.addParam("classifierOrder", String.valueOf(data.getClassifierOrder()));
            row.addParam("classifierId", String.valueOf(data.getClassifierId()));
            row.addParam("classifierRule", classifierRule);
            row.addParam("classifierRuleVal", classifierRuleVal);
            row.addParam("classifierAcl", String.valueOf(acl));
            row.addParam("relation", String.valueOf(data.getRelation()));
            if (this.policyType == 1) {
                row.addParam("queueType", data.getCosType());
                if (data.getCosCir().equals("4294967295")) {
                    row.addParam("bwEnable", String.valueOf(2));
                } else {
                    row.addParam("bwEnable", String.valueOf(1));
                }
                row.addParam("cir", data.getCosCir().equals("4294967295") ? "" : data.getCosCir());
                row.addParam("cbs", String.valueOf(data.getCosCbs()));
                row.addParam("pir", data.getCosPir().equals("4294967295") ? "" : data.getCosPir());
                row.addParam("pbs", String.valueOf(data.getCosPbs()));
                row.addParam("colorMode", String.valueOf(data.getColorMode()));
                row.addParam("greenHandleMethod", String.valueOf(data.getGreenHandleMethod()));
                row.addParam("greenRemarkColor", String.valueOf(data.getGreenRemarkColor()));
                row.addParam("greenRemarkCos", String.valueOf(data.getGreenRemarkCos()));
                row.addParam("yellowHandleMethod", String.valueOf(data.getYellowHandleMethod()));
                row.addParam("yellowRemarkColor", String.valueOf(data.getYellowRemarkColor()));
                row.addParam("yellowRemarkCos", String.valueOf(data.getYellowRemarkCos()));
                row.addParam("redHandleMethod", String.valueOf(data.getRedHandleMethod()));
                row.addParam("redRemarkColor", String.valueOf(data.getRedRemarkColor()));
                row.addParam("redRemarkCos", String.valueOf(data.getRedRemarkCos()));
                if (data.getCosCir_sp().equals("4294967295")) {
                    row.addParam("bwEnable_sp", String.valueOf(2));
                } else {
                    row.addParam("bwEnable_sp", String.valueOf(1));
                }
                row.addParam("cir_sp", data.getCosCir_sp().equals("4294967295") ? "" : data.getCosCir_sp());
                row.addParam("cbs_sp", String.valueOf(data.getCosCbs_sp()));
                row.addParam("pir_sp", data.getCosPir_sp().equals("4294967295") ? "" : data.getCosPir_sp());
                row.addParam("pbs_sp", String.valueOf(data.getCosPbs_sp()));
            }
            this.bussiness.addRowParams(row);
        }
    }

    private void constructErrorMessage(boolean allSucc, boolean allFail) {
        if (allSucc) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        } else if (allFail) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
        }
    }
}

