/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.policy_u2kv1r2c00;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.List;

public class TEQueryPolicyCosBean
extends TENEExplorerBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
            int result = this.sendMessage(neid);
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        RowParams rParam;
        Operation modeOper = (Operation)((Operation)operationList.get(2)).clone();
        ArrayList<Integer> filterErrorCodeList = new ArrayList<Integer>();
        filterErrorCodeList.add(42336);
        filterErrorCodeList.add(42082);
        super.handleMessage(neid, operationList, subfunc, filterErrorCodeList);
        BussinessParams bussiness = this.outputData.getBussinessParams();
        int tmpQueueId = 1;
        int queueLen = 8;
        List paramsList = (List)bussiness.getRowParamList().clone();
        int rows = paramsList.size();
        for (int i = 0; i < rows && (rParam = (RowParams)paramsList.get(i)).getParamCount() != 0; ++i) {
            if ("".equals(rParam.getParam("queueType").getValue())) {
                bussiness.removeRowParams(rParam);
                this.addDisabledQueue(tmpQueueId, bussiness);
                ++tmpQueueId;
                continue;
            }
            int queueType = Integer.parseInt(rParam.getParam("queueType").getValue());
            while (tmpQueueId < queueType) {
                this.addDisabledQueue(tmpQueueId, bussiness);
                ++tmpQueueId;
            }
            if (queueType != tmpQueueId) continue;
            Param param = rParam.getParam("bwEnable");
            param.setValue("1");
            String dropTail = rParam.getParam("dropTail").getValue();
            if (dropTail.equals("65535")) {
                param = rParam.getParam("dropTail");
                param.setValue("");
            }
            rParam.addParam("policy", "1");
            rParam.addParam("policyRate", "");
            ++tmpQueueId;
        }
        while (tmpQueueId <= queueLen) {
            this.addDisabledQueue(tmpQueueId, bussiness);
            ++tmpQueueId;
        }
        this.addMode(modeOper);
    }

    private void addDisabledQueue(int queueId, BussinessParams bussiness) {
        RowParams tmpRow = new RowParams();
        tmpRow.addParam("policy", "1");
        tmpRow.addParam("policyRate", "");
        tmpRow.addParam("queueType", String.valueOf(queueId));
        tmpRow.addParam("bwEnable", "2");
        tmpRow.addParam("cir", "");
        tmpRow.addParam("pir", "");
        tmpRow.addParam("cbs", "");
        tmpRow.addParam("pbs", "");
        tmpRow.addParam("dropTail", "");
        bussiness.addRowParams(queueId - 1, tmpRow);
    }

    private void reProcess(String wrrId) {
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_PTN_QOS_GET_WRRSCHEDULE");
        oper.getInput().setPartValue("policyId", wrrId);
        this.operationList.clear();
        this.operationList.add(oper);
        int result = this.sendMessage(this.neid);
        if (result == 0) {
            this.reHandleMsg();
        } else {
            TELogFactory.getNormalLogger().error("get WRR cos fail!");
        }
    }

    private void reHandleMsg() {
        Operation oper = (Operation)this.operationList.get(0);
        Output output = oper.getOutput(0);
        RowParams row = null;
        for (int j = 0; j < 8; ++j) {
            String policyRate = output.getPart(j + 1).getValue();
            row = this.outputData.getBussinessParams().getRowParams(j);
            Param param = new Param();
            param.setName("wrrId");
            param.setValue(output.getPartValue("policyId"));
            row.addParam(param);
            if (row.getParam("policy").getValue().equals("1")) continue;
            if ("0".equals(policyRate) || policyRate == null) {
                row.getParam("policy").setValue("1");
                continue;
            }
            row.getParam("policyRate").setValue(policyRate);
            row.getParam("policy").setValue("2");
        }
    }

    private void addMode(Operation oper) {
        Output output = oper.getOutput(0);
        RowParams row = null;
        for (int j = 0; j < 8; ++j) {
            String mode = output.getPart(j + 2).getValue();
            row = this.outputData.getBussinessParams().getRowParams(j);
            row.getParam("policy").setValue(mode);
        }
    }
}

