/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.policy.wredpolicy;

import com.huawei.nglct.nemgr.ip.ptn.policy.wredpolicy.TEWredPolicyData;
import java.util.Vector;

public class TEWredPolicyListMgr {
    private Vector portWredPolicyList = new Vector();
    private Vector serviceWredPolicyList = new Vector();
    private static TEWredPolicyListMgr instance;

    private TEWredPolicyListMgr() {
    }

    public static synchronized TEWredPolicyListMgr getInstance() {
        if (instance == null) {
            instance = new TEWredPolicyListMgr();
        }
        return instance;
    }

    public Vector getWredPolicyList(int policyType) {
        if (policyType == 1) {
            return this.getPortWredPolicyList();
        }
        return this.getServiceWredPolicyList();
    }

    public TEWredPolicyData getWredPolicy(int policyId, int policyType) {
        Vector operationList = this.getOperationList(policyType);
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            TEWredPolicyData data = (TEWredPolicyData)operationList.get(i);
            if (data.getPolicyId() != policyId) continue;
            return data;
        }
        return null;
    }

    public void addWredPolicy(TEWredPolicyData data) {
        Vector operationList = this.getOperationList(data);
        boolean isAdd = true;
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            TEWredPolicyData policy = (TEWredPolicyData)operationList.get(i);
            if (data.getPolicyId() != policy.getPolicyId()) continue;
            isAdd = false;
        }
        if (isAdd) {
            operationList.add(data);
        }
    }

    public void deleteWredPolicy(TEWredPolicyData data) {
        Vector operationList = this.getOperationList(data);
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            TEWredPolicyData policy = (TEWredPolicyData)operationList.get(i);
            if (data.getPolicyId() != policy.getPolicyId()) continue;
            operationList.remove(i);
            return;
        }
    }

    public void deleteWredPolicy(int policyId, int policyType) {
        Vector operationList = this.getOperationList(policyType);
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            TEWredPolicyData policy = (TEWredPolicyData)operationList.get(i);
            if (policyId != policy.getPolicyId()) continue;
            operationList.remove(i);
            return;
        }
    }

    public void clearPolicyList(int policyType) {
        Vector policyList = this.getOperationList(policyType);
        policyList.clear();
    }

    private Vector getOperationList(TEWredPolicyData data) {
        int policyType = data.getPolicyType();
        if (policyType == 1) {
            return this.portWredPolicyList;
        }
        return this.serviceWredPolicyList;
    }

    private Vector getOperationList(int policyType) {
        if (policyType == 1) {
            return this.portWredPolicyList;
        }
        return this.serviceWredPolicyList;
    }

    public Vector getPortWredPolicyList() {
        return this.portWredPolicyList;
    }

    public void setPortWredPolicyList(Vector portWredPolicyList) {
        this.portWredPolicyList = portWredPolicyList;
    }

    public Vector getServiceWredPolicyList() {
        return this.serviceWredPolicyList;
    }

    public void setServiceWredPolicyList(Vector serviceWredPolicyList) {
        this.serviceWredPolicyList = serviceWredPolicyList;
    }
}

