/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.policy.vunipolicy;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class TEQueryVuniActpointBean
extends TENEExplorerBean {
    private static int INGRESS = 1;
    private static int EGRESS = 2;
    private static final int UNI_INFO = 33929;
    private TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.subfunc = subFunc;
        this.neid = neid;
        this.inputData = inputData;
        this.outputData = new Datainterface();
        this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
        StringBuffer uniInfo = null;
        String policyType = inputData.getBussinessParams().getRowParams()[0].getParam("policyType").getValue();
        int resultCode = 0;
        OperationResult resultObj = TENECommMgr.getInstance().sendCommand(neid, (List)this.operationList, this.TIME_OUT);
        if (null != resultObj) {
            resultCode = resultObj.retCode;
        }
        ArrayList<Object> queryServIDOPList = new ArrayList<Object>();
        if (0 == resultCode) {
            Operation operTmp = (Operation)this.operationList.get(0);
            int count = operTmp.getOutputCount();
            for (int i = count - 1; i >= 0; --i) {
                Output output = operTmp.getOutput(i);
                if (!output.getFault()[0].getCode().equals("0")) continue;
                String dir = output.getPartValue("actpoint4");
                if (!this.typeMatch(policyType, dir)) {
                    operTmp.removeOutput(i);
                    continue;
                }
                String indexID = output.getPartValue("actpoint1");
                Operation elineInfoOp = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_SERVICE_GET_ELINEINFO");
                Input elineInfoInput = elineInfoOp.getInput();
                elineInfoInput.setPartValue("serviceIndex", indexID);
                queryServIDOPList.add(elineInfoOp.clone());
                Operation operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_SERVICE_GET_EAGGRINFO");
                Input eAgressInfoInput = operation.getInput();
                eAgressInfoInput.setPartValue("serviceIndex", indexID);
                queryServIDOPList.add(operation.clone());
                Operation vuniInfoOp = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_SERVICE_GET_ETHVUNI");
                Input vuniInfoOpInput = vuniInfoOp.getInput();
                vuniInfoOpInput.setPartValue("servType", "0");
                vuniInfoOpInput.setPartValue("servIndex", indexID);
                vuniInfoOpInput.setPartValue("vuniId", output.getPartValue("actpoint2"));
                queryServIDOPList.add(vuniInfoOp.clone());
            }
            if (queryServIDOPList.size() > 0) {
                resultCode = 0;
                resultObj = TENECommMgr.getInstance().sendCommand(neid, queryServIDOPList, this.TIME_OUT);
                if (null != resultObj) {
                    resultCode = resultObj.retCode;
                }
                if (resultCode == 0) {
                    Operation operIndex = (Operation)this.operationList.get(0);
                    int indexCount = operIndex.getOutputCount();
                    for (int opIndex = 0; opIndex < indexCount; ++opIndex) {
                        Output indexOuput = operIndex.getOutput(opIndex);
                        if (!indexOuput.getFault()[0].getCode().equals("0")) continue;
                        String servIndexStr = indexOuput.getPartValue("actpoint1");
                        String VUNIID = indexOuput.getPartValue("actpoint2");
                        Object var20_25 = null;
                        for (Operation operation : queryServIDOPList) {
                            Output outputTmp = operation.getOutput(0);
                            resultCode = Integer.valueOf(outputTmp.getFault(0).getCode());
                            if (38737 == resultCode || 42366 == resultCode) continue;
                            Input inputTmp = operation.getInput();
                            if (33929 == operation.getCmdid()) {
                                int slotid = Integer.valueOf(outputTmp.getPartValue("slotid"));
                                int boardType = this.cfgDataMgr.getBoardType(neid, slotid);
                                String boardName = this.cfgDataMgr.getBoardTypeName(neid, boardType);
                                int subslotid = Integer.valueOf(outputTmp.getPartValue("subslotid"));
                                String subboardName = "";
                                String portName = "";
                                uniInfo = new StringBuffer();
                                int port = Integer.valueOf(outputTmp.getPartValue("port"));
                                if (255 != subslotid) {
                                    int subboardType = this.cfgDataMgr.getSubboardType(neid, slotid, subslotid);
                                    subboardName = this.cfgDataMgr.getBoardTypeName(neid, subboardType);
                                    portName = this.cfgDataMgr.getPortNameForPTN(neid, slotid, subboardType, port);
                                    uniInfo.append(slotid).append("-").append(boardName).append("-").append(subslotid).append("-").append(subboardName).append("-").append(portName).append("[");
                                } else {
                                    portName = this.cfgDataMgr.getPortNameForPTN(neid, slotid, boardType, port);
                                    uniInfo.append(slotid).append("-").append(boardName).append("-").append(portName).append("[");
                                }
                                String vlanArray = outputTmp.getPartValue("tagIds");
                                StringBuffer vlanBuf = new StringBuffer();
                                int vlanNumber = Integer.valueOf(outputTmp.getPartValue("tagNum"));
                                if (0 < vlanNumber) {
                                    vlanBuf.append(Integer.valueOf(vlanArray.substring(0, 8), 16));
                                }
                                for (int i = 1; i < vlanNumber; ++i) {
                                    vlanBuf.append(",").append(Integer.valueOf(vlanArray.substring(i * 8, (i + 1) * 8), 16));
                                }
                                String vlans = this.parseEncapsValueList(vlanBuf.toString());
                                uniInfo.append(vlans);
                                uniInfo.append("]");
                                if (!inputTmp.getPart("servIndex").getValue().equals(servIndexStr) || !inputTmp.getPart("vuniId").getValue().equals(VUNIID) || !outputTmp.getFault(0).getCode().equals("0")) continue;
                                indexOuput.setPartValue("actpoint2", uniInfo.toString());
                                continue;
                            }
                            if (!inputTmp.getPart("serviceIndex").getValue().equals(servIndexStr)) continue;
                            if (outputTmp.getFault(0).getCode().equals("0")) {
                                String servID = outputTmp.getPartValue("serviceID");
                                indexOuput.setPartValue("actpoint1", servID);
                                continue;
                            }
                            indexOuput.addFault(0, outputTmp.getFault(0));
                        }
                    }
                }
            }
            this.handleMessage(neid, this.operationList, subFunc, this.getFilterErrorCodeList());
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)resultCode));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private boolean typeMatch(String policyType, String direction) {
        boolean ret = false;
        int poliType = Integer.valueOf(policyType);
        int dir = Integer.valueOf(direction);
        if (poliType == 2 && dir == INGRESS) {
            ret = true;
        } else if (poliType == 3 && dir == EGRESS) {
            ret = true;
        }
        return ret;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorList = new ArrayList<Integer>();
        errorList.add(42322);
        errorList.add(42336);
        errorList.add(42366);
        errorList.add(42079);
        return errorList;
    }

    private String parseEncapsValueList(String str) {
        if ("".equals(str)) {
            return str;
        }
        String[] stringArray = str.split(",");
        int[] intArray = new int[stringArray.length];
        int len = stringArray.length;
        for (int j = 0; j < len; ++j) {
            intArray[j] = Integer.valueOf(stringArray[j]);
        }
        Arrays.sort(intArray);
        ArrayList<String> encapsValue = new ArrayList<String>();
        int len2 = stringArray.length;
        for (int j = 0; j < len2; ++j) {
            encapsValue.add(intArray[j] + "");
        }
        String result = "";
        if (encapsValue.size() >= 2) {
            Iterator it = encapsValue.iterator();
            int curNum = Integer.valueOf((String)it.next());
            int offset = 0;
            StringBuffer temp = new StringBuffer(curNum);
            int tmpNum = -1;
            while (it.hasNext()) {
                int nextNum = Integer.valueOf((String)it.next());
                if (nextNum != curNum + offset + 1) {
                    if (offset != 0) {
                        tmpNum = curNum + offset;
                        temp.append("-").append(tmpNum);
                        temp.append(",").append(nextNum);
                    } else {
                        temp.append(",").append(nextNum);
                    }
                    offset = 0;
                    curNum = nextNum;
                    continue;
                }
                ++offset;
            }
            if (offset > 0) {
                tmpNum = curNum + offset;
                temp.append("-").append(tmpNum);
            }
            result = temp.toString();
        } else if (encapsValue.size() == 1) {
            result = encapsValue.get(0).toString();
        }
        return result;
    }
}

