/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.policy.classifier;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.ip.ptn.policy.classifier.TEClassifierData;
import com.huawei.nglct.nemgr.ip.ptn.policy.classifier.TEClassifierMgr;
import com.huawei.nglct.nemgr.ip.ptn.policy.classifier.TERuleData;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TEQueryClassifierBean
extends TENEExplorerBean {
    private static long INVALID_VALUE = 0xFFFFFFFFL;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        RowParams row;
        TEClassifierData data;
        int classifierId;
        String errorCode;
        Output output;
        int i;
        boolean allFail = true;
        boolean allSucc = true;
        this.outputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        Operation oper = (Operation)operationList.get(0);
        int policyType = Integer.parseInt(oper.getInput().getPartValue("policyType"));
        int policyId = Integer.parseInt(oper.getInput().getPartValue("policyId"));
        TEClassifierMgr classifierMgr = TEClassifierMgr.getInstance();
        classifierMgr.clearClassifierList();
        int size = oper.getOutputCount();
        for (i = 0; i < size; ++i) {
            output = oper.getOutput(i);
            errorCode = output.getFault()[0].getCode();
            if (errorCode.equals("0")) {
                allFail = false;
                classifierId = Integer.parseInt(output.getPartValue("classifierId"));
                data = classifierMgr.getClassifierData(policyType, policyId, classifierId);
                if (data == null) {
                    data = new TEClassifierData(policyType, policyId, classifierId);
                }
                int order = Integer.parseInt(output.getPartValue("classifierOrder"));
                int relation = Integer.parseInt(output.getPartValue("relation"));
                int ruleId = Integer.parseInt(output.getPartValue("ruleId"));
                String rule = output.getPartValue("classifierRule");
                int len = rule.length();
                for (int k = 0; k < len; ++k) {
                    if (rule.charAt(k) != '\u0000') continue;
                    rule = rule.substring(0, k);
                    break;
                }
                data.setClassifierOrder(order);
                data.setRelation(relation);
                TERuleData ruleData = new TERuleData(neid, ruleId, rule);
                ruleData.setRuleStr(rule);
                data.addRule(ruleData);
                classifierMgr.addClassifier(data);
                continue;
            }
            if (Integer.valueOf(errorCode) == 38662) continue;
            allSucc = false;
            row = new RowParams();
            row.addRowErrors(this.constructErrorObj(errorCode));
            bussiness.addRowParams(row);
        }
        Collections.sort(classifierMgr.getClassifierList());
        oper = (Operation)operationList.get(1);
        int len = oper.getOutputCount();
        for (i = 0; i < len; ++i) {
            output = oper.getOutput(i);
            errorCode = output.getFault()[0].getCode();
            if (errorCode.equals("0")) {
                allFail = false;
                classifierId = Integer.parseInt(output.getPartValue("classifierId"));
                data = classifierMgr.getClassifierData(policyType, policyId, classifierId);
                int acl = Integer.parseInt(output.getPartValue("classifierAcl"));
                data.setAcl(acl);
                if (policyType == 2) {
                    String cos = output.getPartValue("cos");
                    data.setCosType(cos);
                }
                long car = Long.parseLong(output.getPartValue("car"));
                data.setCar(car);
                continue;
            }
            if (Integer.valueOf(errorCode) == 38662) continue;
            allSucc = false;
            row = new RowParams();
            row.addRowErrors(this.constructErrorObj(errorCode));
            bussiness.addRowParams(row);
        }
        List classifierList = classifierMgr.getClassifierList();
        int len2 = classifierList.size();
        for (int i2 = 0; i2 < len2; ++i2) {
            TEClassifierData data2 = (TEClassifierData)classifierList.get(i2);
            if (data2.getPolicyType() != policyType) continue;
            row = new RowParams();
            int acl = data2.getAcl();
            List ruleList = data2.getRuleList();
            String classifierRule = classifierMgr.convertRule2nm(ruleList, data2.getRelation(), false);
            int rulelen = classifierRule.length();
            if (classifierRule.endsWith("&") || classifierRule.endsWith("|")) {
                classifierRule = classifierRule.substring(0, rulelen - 1);
            }
            String classifierRuleVal = classifierMgr.convertRule2nm(ruleList, data2.getRelation(), true);
            row.addParam("index", String.valueOf(i2));
            row.addParam("classifierOrder", String.valueOf(data2.getClassifierOrder()));
            row.addParam("classifierId", String.valueOf(data2.getClassifierId()));
            row.addParam("classifierRule", classifierRule);
            row.addParam("classifierRuleVal", classifierRuleVal);
            row.addParam("classifierAcl", String.valueOf(acl));
            row.addParam("relation", String.valueOf(data2.getRelation()));
            long car = data2.getCar();
            if (car == INVALID_VALUE) {
                row.addParam("car", "-");
                row.addParam("carName", "");
            } else {
                row.addParam("car", String.valueOf(data2.getCar()));
                row.addParam("carName", this.queryCarPolicyName(String.valueOf(data2.getCar())));
            }
            if (policyType == 2) {
                row.addParam("queueType", data2.getCosType());
            }
            bussiness.addRowParams(row);
        }
        if (allSucc) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        } else if (allFail) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
        }
        this.outputData.setBussinessParams(bussiness);
    }

    private RowErrors constructErrorObj(String errorCode) {
        RowErrors error = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        errorMessage.setErrorcode(errorCode);
        errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)Integer.parseInt(errorCode)));
        error.setErrorMessage(errorMessage);
        return error;
    }

    private String queryCarPolicyName(String car) {
        this.operationList.clear();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_QOS_GET_CARINFO");
        Input input = oper.getInput();
        input.setPartValue("policyId", car);
        this.operationList.add(oper);
        int result = this.sendMessage(this.neid);
        if (result != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            return "";
        }
        Operation tmpOper = (Operation)this.operationList.get(0);
        Output output = tmpOper.getOutput()[0];
        for (Fault fault : output.getFault()) {
            int code = Integer.parseInt(fault.getCode());
            if (code == 0) continue;
            ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage((int)1);
            this.outputData.setErrorMessage(bigErr);
            return "";
        }
        String policyName = output.getPartValue("policyName");
        int len = policyName.length();
        for (int k = 0; k < len; ++k) {
            if (policyName.charAt(k) != '\u0000') continue;
            policyName = policyName.substring(0, k);
            break;
        }
        return policyName;
    }
}

