/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.policy;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.ip.ptn.policy.wredpolicy.TEWredPolicyData;
import com.huawei.nglct.nemgr.ip.ptn.policy.wredpolicy.TEWredPolicyListMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.List;

public class TEQueryPolicyCosBean
extends TENEExplorerBean {
    private int policyType;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
            RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
            this.policyType = Integer.parseInt(rowParams[0].getParam("policyType").getValue());
            int result = this.sendMessage(neid);
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        RowParams rParam;
        ArrayList<Integer> filterErrorCodeList = new ArrayList<Integer>();
        filterErrorCodeList.add(42336);
        filterErrorCodeList.add(42082);
        super.handleMessage(neid, operationList, subfunc, filterErrorCodeList);
        BussinessParams bussiness = this.outputData.getBussinessParams();
        int tmpQueueId = 1;
        int queueLen = 8;
        List paramsList = (List)bussiness.getRowParamList().clone();
        int rows = paramsList.size();
        for (int i = 0; i < rows && (rParam = (RowParams)paramsList.get(i)).getParamCount() != 0; ++i) {
            int queueType = Integer.parseInt(rParam.getParam("queueType").getValue());
            while (tmpQueueId < queueType) {
                this.addDisabledQueue(tmpQueueId, bussiness);
                ++tmpQueueId;
            }
            if (queueType != tmpQueueId) continue;
            Param param = rParam.getParam("bwEnable");
            param.setValue("1");
            String dropWred = rParam.getParam("dropWred").getValue();
            if (!dropWred.equals("4294967295")) {
                TEWredPolicyListMgr policyListMgr = TEWredPolicyListMgr.getInstance();
                String name = dropWred;
                int dropWrodID = -1;
                try {
                    dropWrodID = Integer.parseInt(dropWred);
                    TEWredPolicyData data = policyListMgr.getWredPolicy(dropWrodID, this.policyType);
                    if (data != null) {
                        name = data.getPolicyName();
                    }
                }
                catch (Exception e) {
                    TELogFactory.getNormalLogger().error("TEQueryPolicyCosBean.handleMessage() fail!", (Throwable)e);
                }
                param = new Param();
                param.setName("wredName");
                param.setValue(name);
                rParam.addParam(param);
            } else {
                param = rParam.getParam("dropWred");
                param.setValue("");
            }
            String dropTail = rParam.getParam("dropTail").getValue();
            if (dropTail.equals("65535")) {
                param = rParam.getParam("dropTail");
                param.setValue("");
            }
            ++tmpQueueId;
        }
        while (tmpQueueId <= queueLen) {
            this.addDisabledQueue(tmpQueueId, bussiness);
            ++tmpQueueId;
        }
    }

    private void addDisabledQueue(int queueId, BussinessParams bussiness) {
        RowParams tmpRow = new RowParams();
        tmpRow.addParam("queueType", String.valueOf(queueId));
        tmpRow.addParam("bwEnable", "2");
        tmpRow.addParam("cir", "");
        tmpRow.addParam("pir", "");
        tmpRow.addParam("cbs", "");
        tmpRow.addParam("pbs", "");
        tmpRow.addParam("dropTail", "");
        tmpRow.addParam("dropWred", "");
        bussiness.addRowParams(queueId - 1, tmpRow);
    }
}

