/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.policy;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.ip.ptn.policy.wfqpolicy.TEWfqPolicyData;
import com.huawei.nglct.nemgr.ip.ptn.policy.wfqpolicy.TEWfqPolicyListMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEQueryPolicyBean
extends TENEExplorerBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.outputData = new Datainterface();
        this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
        if (null == this.operationList || this.operationList.isEmpty()) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        int result = this.sendMessage(neid);
        if (result == 0) {
            Output output;
            Operation oper = (Operation)this.operationList.get(0);
            int size = oper.getOutputCount();
            for (int i = 0; i < size && (output = oper.getOutput(i)).getFault()[0].getCode().equals(String.valueOf(0)); ++i) {
                String name = output.getPartValue("policyName");
                int len = name.length();
                for (int k = 0; k < len; ++k) {
                    if (name.charAt(k) != '\u0000') continue;
                    name = name.substring(0, k);
                    break;
                }
                output.setPartValue("policyName", name);
            }
            ArrayList<Integer> filterErrorCodeList = new ArrayList<Integer>();
            filterErrorCodeList.add(38662);
            this.handleMessage(neid, this.operationList, subFunc, filterErrorCodeList);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        Param isLogFlagParam = inputData.getBussinessParams().getRowParams(0).getParam("isLogFlag");
        if (isLogFlagParam != null && isLogFlagParam.getValue().equals("0")) {
            this.isLogFlag = false;
        }
        if (this.isLogFlag && this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        super.handleMessage(neid, operationList, subfunc, filterErrorCodeList);
        if (2 == Integer.parseInt(this.outputData.getErrorMessage().getErrorcode())) {
            return;
        }
        BussinessParams bussiness = this.outputData.getBussinessParams();
        ArrayList rows = bussiness.getRowParamList();
        int len = rows.size();
        for (int i = 0; i < len; ++i) {
            String wfqId;
            RowParams rParams = (RowParams)rows.get(i);
            Param wfqParam = rParams.getParam("wfqPolicy");
            if (wfqParam == null || (wfqId = rParams.getParam("wfqPolicy").getValue()).equals("4294967295")) continue;
            TEWfqPolicyData data = TEWfqPolicyListMgr.getInstance().getWfqPolicy(Integer.parseInt(wfqId));
            String wfqPolicyName = "";
            wfqPolicyName = null == data ? this.queryWfqPolicyName(wfqId) : data.getPolicyName();
            rParams.addParam("wfqName", wfqPolicyName);
        }
    }

    private String queryWfqPolicyName(String wfqId) {
        this.operationList.clear();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_QOS_GET_WFQSCHEDULE");
        Input input = oper.getInput();
        input.setPartValue("policyId", wfqId);
        this.operationList.add(oper);
        int result = this.sendMessage(this.neid);
        if (result != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            return "";
        }
        Operation tmpOper = (Operation)this.operationList.get(0);
        Output output = tmpOper.getOutput()[0];
        for (Fault fault : output.getFault()) {
            int code = Integer.parseInt(fault.getCode());
            if (code == 0) continue;
            ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage((int)1);
            this.outputData.setErrorMessage(bigErr);
            return "";
        }
        String policyName = output.getPartValue("policyName");
        int len = policyName.length();
        for (int k = 0; k < len; ++k) {
            if (policyName.charAt(k) != '\u0000') continue;
            policyName = policyName.substring(0, k);
            break;
        }
        int policyId = Integer.parseInt(output.getPartValue("policyId"));
        int af1 = Integer.parseInt(output.getPartValue("af1"));
        int af2 = Integer.parseInt(output.getPartValue("af2"));
        int af3 = Integer.parseInt(output.getPartValue("af3"));
        int af4 = Integer.parseInt(output.getPartValue("af4"));
        TEWfqPolicyData data = new TEWfqPolicyData(policyId, policyName, af1, af2, af3, af4);
        TEWfqPolicyListMgr.getInstance().addWfqPolicy(data);
        return policyName;
    }
}

