/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.pdhinterface;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TEGenCfgQueryBean;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Vector;

public class TEPDHInterfaceQueryBean
extends TEGenCfgQueryBean {
    private TEConfigurationDataMgr cfgMgr = TEConfigurationDataMgr.getInstance();

    public ArrayList getQueryAttrList(RowParams rowparams) {
        ArrayList<String> attrList = new ArrayList<String>();
        String paramName = "";
        for (int i = rowparams.getParamCount() - 1; i >= 0; --i) {
            paramName = rowparams.getParam(i).getName();
            if (!"attrId".equalsIgnoreCase(paramName)) continue;
            attrList.add(rowparams.getParam(i).getValue());
        }
        return attrList;
    }

    public boolean isNeedExpandOperObj(String attrId) {
        return true;
    }

    public void handleMessage(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        super.handleMessage(neid, subfunc, operationList, filterErrorCodeList);
        RowParams[] rParamArr = this.outputData.getBussinessParams().getRowParams();
        boolean isNeedQueryBorrowBD = false;
        for (int i = 0; i < rParamArr.length; ++i) {
            Param ipTypeParam;
            Param portParam;
            RowParams rowParams = rParamArr[i];
            Param portNameParam = rowParams.getParam("PTNIF_PORT_ATTR_PORTNAME_PDH");
            if (portNameParam == null && (portParam = rowParams.getParam("port")) != null) {
                int slotId = Integer.parseInt(rowParams.getParam("slotid").getValue());
                int bdType = this.cfgMgr.getBoardType(neid, slotId);
                int portId = Integer.parseInt(portParam.getValue());
                String portName = this.cfgMgr.getPortNameForPTN(neid, slotId, bdType, portId);
                portNameParam = new Param("PTNIF_PORT_ATTR_PORTNAME_PDH", portName.substring(portName.indexOf(40) + 1, portName.lastIndexOf(41)));
                rowParams.addParam(portNameParam);
            }
            Param retimeParam = rowParams.getParam("PDHPATH_ATTR_RETIMEMODE");
            Param retimeEx2Param = rowParams.getParam("PDHPATH_ATTR_RETIMEMODE_EX2");
            if (null != retimeParam && null == retimeEx2Param) {
                rowParams.addParam(new Param("PDHPATH_ATTR_RETIMEMODE_EX2", retimeParam.getValue()));
            }
            if ((ipTypeParam = rParamArr[i].getParam("PTNIF_PORT_ATTR_IPPARATYPE")) == null) continue;
            isNeedQueryBorrowBD = true;
            if (!ipTypeParam.getValue().equals("3")) continue;
            int borrowedSlotId = Integer.parseInt(rowParams.getParam("PTNIF_PORT_ATTR_IPPARABORD").getValue());
            int borrowedPortId = Integer.parseInt(rowParams.getParam("PTNIF_PORT_ATTR_IPPARAPORT").getValue());
            int boardType = this.cfgMgr.getBoardType(neid, borrowedSlotId);
            String boardName = this.cfgMgr.getBoardTypeName(neid, boardType);
            String portName = this.cfgMgr.getPortNameForPTN(neid, borrowedSlotId, boardType, borrowedPortId);
            rowParams.addParam("borrowedBDName", borrowedSlotId + "-" + boardName);
            rowParams.addParam("borrowedPortName", borrowedSlotId + "-" + boardName + "-" + portName);
        }
        this.handlePortName(rParamArr);
        if (isNeedQueryBorrowBD) {
            this.queryBorrowBDInfo();
        }
    }

    private void queryBorrowBDInfo() {
        int portId = -1;
        TEBoard board = null;
        this.operationList.clear();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_PORT_GET_NAME");
        Input input = oper.getInput();
        input.setPartValue("slotid", String.valueOf(65535));
        input.setPartValue("port", "0");
        this.operationList.add(oper.clone());
        oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_PORT_L3_GET_IPPARA");
        input = oper.getInput();
        Vector bdVec = this.cfgMgr.getNE(this.neid).getClonedBoardList();
        int m = bdVec.size();
        for (int i = 0; i < m; ++i) {
            board = (TEBoard)bdVec.get(i);
            input.setPartValue("slotid", String.valueOf(board.getSlotID()));
            input.setPartValue("port", "0");
            this.operationList.add(oper.clone());
        }
        input.setPartValue("slotid", String.valueOf(65535));
        input.setPartValue("port", "0");
        this.operationList.add(oper.clone());
        int result = this.sendMessage(this.neid);
        if (0 == result) {
            String portName = null;
            Output output = null;
            TIntObjectHashMap mpPortNameMap = new TIntObjectHashMap();
            RowParams rowParams = new RowParams();
            Param param = new Param("borrowedports", "");
            rowParams.addParam(param);
            int errCode = 0;
            oper = (Operation)this.operationList.get(0);
            errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode());
            if (0 == errCode) {
                int mn = oper.getOutputCount();
                for (int k = 0; k < mn; ++k) {
                    output = oper.getOutput(k);
                    portId = Integer.valueOf(output.getPartValue("port"));
                    portName = IOStreamConvertor.replaceSpecialStr((String)output.getPartValue("PTNIF_PORT_ATTR_PORTNAME"));
                    if ("".equalsIgnoreCase(portName) || !this.filterPort(portId)) continue;
                    mpPortNameMap.put(portId, (Object)portName);
                }
            }
            this.handleIPPortAttr((TIntObjectHashMap<String>)mpPortNameMap, param);
            if (param.getOptionCount() > 0) {
                this.outputData.getBussinessParams().addRowParams(rowParams);
            }
        }
    }

    private void handleIPPortAttr(TIntObjectHashMap<String> mpPortNameMap, Param param) {
        int errCode = 0;
        int slotId = 0;
        int portId = 0;
        int boardType = 0;
        String resName = null;
        String portName = null;
        Operation oper = null;
        Output output = null;
        int n = this.operationList.size();
        for (int j = 1; j < n; ++j) {
            oper = (Operation)this.operationList.get(j);
            errCode = Integer.parseInt(oper.getOutput(0).getFault(0).getCode());
            if (0 != errCode) continue;
            int mn = oper.getOutputCount();
            for (int k = 0; k < mn; ++k) {
                output = oper.getOutput(k);
                slotId = Integer.parseInt(output.getPartValue("slotid"));
                portId = Integer.parseInt(output.getPartValue("port"));
                if (!this.filterPort(portId) || 1 != Integer.parseInt(output.getPartValue("PTNIF_PORT_ATTR_IPPARATYPE")) || 0xFFFFFFFFL == Long.valueOf(output.getPartValue("PTNIF_PORT_ATTR_IPPARA")) || 0xFFFFFFFFL == Long.valueOf(output.getPartValue("PTNIF_PORT_ATTR_IPPARAT"))) continue;
                boardType = this.cfgMgr.getBoardType(this.neid, slotId);
                portName = this.cfgMgr.getPortNameForPTN(this.neid, slotId, boardType, portId);
                if (mpPortNameMap.contains(portId)) {
                    portName = portName.substring(0, portName.indexOf("-") + 1) + (String)mpPortNameMap.get(portId) + ")";
                }
                resName = slotId + "-" + this.cfgMgr.getBoardTypeName(this.neid, boardType) + "-" + portName;
                param.addOption(new Option(resName + "#" + portId));
            }
        }
    }

    private boolean filterPort(int portId) {
        return true;
    }

    private void handlePortName(RowParams[] rowParamses) {
        for (RowParams rowParams : rowParamses) {
            int portId;
            int slotId;
            int errCount = rowParams.getRowErrorsCount();
            if (errCount > 0) {
                for (int j = 0; j < errCount; ++j) {
                    RowErrors rowErrors = rowParams.getRowErrors(j);
                    slotId = Integer.valueOf(rowErrors.getParam("slotid").getValue());
                    portId = Integer.valueOf(rowErrors.getParam("port").getValue());
                    rowErrors.getParam("portname").setValue(this.cfgMgr.getPortNameForPTN(this.neid, slotId, this.cfgMgr.getBoardType(this.neid, slotId), portId));
                }
                continue;
            }
            slotId = Integer.valueOf(rowParams.getParam("slotid").getValue());
            portId = Integer.valueOf(rowParams.getParam("port").getValue());
            rowParams.getParam("portname").setValue(this.cfgMgr.getPortNameForPTN(this.neid, slotId, this.cfgMgr.getBoardType(this.neid, slotId), portId));
        }
    }

    private int sendMessage(int neid) {
        int retCode = 0;
        OperationResult result = TECommuNEMgr.getInstance().sendCommand(neid, this.operationList, this.getTimeOut(), this.subFunc);
        if (null != result) {
            retCode = result.retCode;
        }
        return retCode;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        errorCodeList.add(42692);
        errorCodeList.add(42693);
        errorCodeList.add(38737);
        errorCodeList.add(42171);
        errorCodeList.add(43100);
        errorCodeList.add(38662);
        errorCodeList.add(42165);
        errorCodeList.add(42163);
        errorCodeList.add(38671);
        errorCodeList.add(38777);
        errorCodeList.add(38664);
        return errorCodeList;
    }
}

