/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.mpls_u2kv1r7c00;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TEQueryStaticUnicastTunnel
extends com.huawei.nglct.nemgr.ip.ptn.mpls.TEQueryStaticUnicastTunnel {
    List<String> mplsOAMTunnelList = new ArrayList<String>();
    List<String> mplsTPOAMTunnelList = new ArrayList<String>();

    @Override
    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.fillOAMList(operationList);
        super.handleMessage(neid, operationList, subfunc);
        this.addOAMType();
    }

    private void fillOAMList(List<Operation> opers) {
        Iterator<Operation> iter = opers.iterator();
        while (iter.hasNext()) {
            Output output;
            int i;
            int len;
            Operation oper = iter.next();
            if ("NSCMD_GET_ETHN_TUNNEL_OAMCFGINFO".equals(oper.getName())) {
                len = oper.getOutputCount();
                for (i = 0; i < len; ++i) {
                    output = oper.getOutput(i);
                    if (!output.getFault(0).getCode().equals(String.valueOf(0))) continue;
                    this.mplsOAMTunnelList.add(output.getPartValue("tunnelindex"));
                }
                iter.remove();
                continue;
            }
            if (!"NSCMD_MPLSTP_OAM_GET_MEG_TUNEL".equals(oper.getName())) continue;
            len = oper.getOutputCount();
            for (i = 0; i < len; ++i) {
                output = oper.getOutput(i);
                if (!output.getFault(0).getCode().equals(String.valueOf(0))) continue;
                this.mplsTPOAMTunnelList.add(output.getPartValue("megindex"));
            }
            iter.remove();
        }
    }

    private void addOAMType() {
        BussinessParams bus = this.outputData.getBussinessParams();
        int len = bus.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowParams row = bus.getRowParams(i);
            Param tennelIndexParam = row.getParam("tunnelindex");
            if (tennelIndexParam == null || "".equals(tennelIndexParam.getValue())) continue;
            Param tempParam = new Param();
            tempParam.setName("oamType");
            if (this.mplsOAMTunnelList.contains(tennelIndexParam.getValue())) {
                tempParam.setValue("MPLS OAM(Y.1711)");
            } else if (this.mplsTPOAMTunnelList.contains(tennelIndexParam.getValue())) {
                tempParam.setValue("MPLS-TP OAM(Y.1731)");
            } else {
                tempParam.setValue("-");
            }
            row.addParam(tempParam);
        }
    }
}

