/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.mpls_u2kv1r7c00;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TENEQueryPWBean
extends com.huawei.nglct.nemgr.ip.ptn.mpls_u2kv1r3c00.TENEQueryPWBean {
    List<String> mplsOAMPWList = new ArrayList<String>();
    List<String> mplsTPOAMPWList = new ArrayList<String>();

    @Override
    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.fillOAMPWList(operationList);
        super.handleMessage(neid, operationList, subfunc);
        this.addOAMTypeToPW();
    }

    private void fillOAMPWList(List<Operation> opers) {
        Iterator<Operation> iter = opers.iterator();
        while (iter.hasNext()) {
            Output output;
            int i;
            int len;
            Operation oper = iter.next();
            if ("NSCMD_ETHN_PWOAM_GET_OAMATTR".equals(oper.getName())) {
                len = oper.getOutputCount();
                for (i = 0; i < len; ++i) {
                    output = oper.getOutput(i);
                    if (!output.getFault(0).getCode().equals(String.valueOf(0))) continue;
                    this.mplsOAMPWList.add(output.getPartValue("pwIndex"));
                }
                iter.remove();
                continue;
            }
            if (!"NSCMD_MPLSTP_OAM_GET_MEG_PW".equals(oper.getName())) continue;
            len = oper.getOutputCount();
            for (i = 0; i < len; ++i) {
                output = oper.getOutput(i);
                if (!output.getFault(0).getCode().equals(String.valueOf(0))) continue;
                this.mplsTPOAMPWList.add(output.getPartValue("megindex"));
            }
            iter.remove();
        }
    }

    private void addOAMTypeToPW() {
        BussinessParams bus = this.outputData.getBussinessParams();
        int len = bus.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowParams row = bus.getRowParams(i);
            Param tennelIndexParam = row.getParam("pwIndex");
            if (tennelIndexParam == null || "".equals(tennelIndexParam.getValue())) continue;
            Param tempParam = new Param();
            tempParam.setName("oamType");
            if (this.mplsOAMPWList.contains(tennelIndexParam.getValue())) {
                tempParam.setValue("MPLS OAM(Y.1711)");
            } else if (this.mplsTPOAMPWList.contains(tennelIndexParam.getValue())) {
                tempParam.setValue("MPLS-TP OAM(Y.1731)");
            } else {
                tempParam.setValue("-");
            }
            row.addParam(tempParam);
        }
    }
}

