/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.mpls.rsvptunnel.notice;

import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nemgr.f_interface.rsvp.AsnPtnDnyTunnelIndexChangemeReq;
import com.huawei.nglct.nemgr.f_interface.rsvp.AsnPtnDynTunnelInfo;
import com.huawei.nglct.po.embeddednemgrmo.rtn.rsvp.TEDynTunnelObjMOPO;
import com.huawei.nglct.po.embeddednemgrmo.rtn.rsvp.TEDynamicTunnelMoContainer;
import com.huawei.nglct.util.convertor.IPAddressUtil;
import com.huawei.nglct.util.string.TEStringUtils;
import java.util.ArrayList;
import java.util.List;
import net.commustru.fstru.FStruct;

public class TERsvpTunnelNoticeUtil {
    public static FStruct getRsvpDeleteReqEvent(int neid, Datainterface inputData, List<String> applySuccessIndexs) {
        AsnPtnDnyTunnelIndexChangemeReq rsvpTunnelChangeAsn = new AsnPtnDnyTunnelIndexChangemeReq();
        rsvpTunnelChangeAsn.neID = neid;
        int size = inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < size; ++i) {
            Param tunnelindexParam = inputData.getBussinessParams().getRowParams(i).getParam("tunnelindex");
            if (TEStringUtils.isParamEmpty((Param)tunnelindexParam) || !applySuccessIndexs.contains(tunnelindexParam.getValue())) continue;
            AsnPtnDynTunnelInfo dnyTunnelInfo = new AsnPtnDynTunnelInfo();
            TERsvpTunnelNoticeUtil.processTunnelInfoData(dnyTunnelInfo, inputData.getBussinessParams().getRowParams(i));
            rsvpTunnelChangeAsn.delTnlKeyList.add((Object)dnyTunnelInfo);
        }
        if (rsvpTunnelChangeAsn.addTnlKeyList.isEmpty() && rsvpTunnelChangeAsn.delTnlKeyList.isEmpty()) {
            return null;
        }
        return rsvpTunnelChangeAsn;
    }

    public static FStruct getRsvpEventReqFromDB(int neID, List<TEDynamicTunnelMoContainer> containerList, List<TEDynTunnelObjMOPO> mopoList) {
        AsnPtnDnyTunnelIndexChangemeReq rsvpTunnelChangeAsn = new AsnPtnDnyTunnelIndexChangemeReq();
        rsvpTunnelChangeAsn.neID = neID;
        ArrayList<TEDynTunnelObjMOPO> dynTunnelFromDB = new ArrayList<TEDynTunnelObjMOPO>();
        for (TEDynamicTunnelMoContainer teDynTunnelContainer : containerList) {
            for (TEDynTunnelObjMOPO teDynMopo : teDynTunnelContainer.getDynamicTunnelList()) {
                dynTunnelFromDB.add(teDynMopo);
            }
        }
        for (TEDynTunnelObjMOPO teDynTunnelMopo : dynTunnelFromDB) {
            if (mopoList.contains(teDynTunnelMopo)) continue;
            rsvpTunnelChangeAsn.delTnlKeyList.add((Object)TERsvpTunnelNoticeUtil.convertMopoToAsn(teDynTunnelMopo));
        }
        for (TEDynTunnelObjMOPO teDynTunnelMopo : mopoList) {
            rsvpTunnelChangeAsn.addTnlKeyList.add((Object)TERsvpTunnelNoticeUtil.convertMopoToAsn(teDynTunnelMopo));
        }
        if (rsvpTunnelChangeAsn.addTnlKeyList.isEmpty() && rsvpTunnelChangeAsn.delTnlKeyList.isEmpty()) {
            return null;
        }
        return rsvpTunnelChangeAsn;
    }

    public static FStruct convertMopoToAsn(TEDynTunnelObjMOPO teDynMopo) {
        AsnPtnDynTunnelInfo dnyTunnelInfo = new AsnPtnDynTunnelInfo();
        dnyTunnelInfo.dynTunnelIndex = teDynMopo.getTunnelIndex();
        dnyTunnelInfo.dynTunnelName = teDynMopo.getTunnelName() == null ? "".getBytes() : teDynMopo.getTunnelName().getBytes();
        dnyTunnelInfo.dynTunnelKey.tunnelID = teDynMopo.getTunnelID();
        dnyTunnelInfo.dynTunnelKey.ingressID = teDynMopo.getIngressNode();
        dnyTunnelInfo.dynTunnelKey.egressID = teDynMopo.getEgressNode();
        dnyTunnelInfo.dynTunnelKey.tunnelPos = teDynMopo.getPosition();
        return dnyTunnelInfo;
    }

    private static void processTunnelInfoData(AsnPtnDynTunnelInfo tunnelInfo, RowParams rowParams) {
        int size = rowParams.getParamCount();
        for (int i = 0; i < size; ++i) {
            Param param = rowParams.getParam(i);
            if (TEStringUtils.isParamEmpty((Param)param)) continue;
            String paramName = param.getName();
            String paramValue = param.getValue();
            if (paramName.equals("tunnelindex")) {
                tunnelInfo.dynTunnelIndex = Long.parseLong(paramValue);
            }
            if (paramName.equals("tunnelname")) {
                tunnelInfo.dynTunnelName = paramValue.getBytes();
            }
            if (paramName.equals("tunnelid")) {
                tunnelInfo.dynTunnelKey.tunnelID = Integer.parseInt(paramValue);
            }
            if (paramName.equals("srcnode")) {
                tunnelInfo.dynTunnelKey.ingressID = IPAddressUtil.convertIPStrToLong((String)paramValue);
            }
            if (paramName.equals("snknode")) {
                tunnelInfo.dynTunnelKey.egressID = IPAddressUtil.convertIPStrToLong((String)paramValue);
            }
            if (!paramName.equals("nodetype")) continue;
            tunnelInfo.dynTunnelKey.tunnelPos = Integer.parseInt(paramValue);
        }
    }
}

