/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.mpls.rsvptunnel.mooperation;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.po.embeddednemgrmo.rtn.rsvp.TEDynRouteResObjMOPO;
import com.huawei.nglct.po.embeddednemgrmo.rtn.rsvp.TEDynTunnelObjMOPO;
import com.huawei.nglct.po.embeddednemgrmo.rtn.rsvp.TEDynamicTunnelMoContainer;
import com.huawei.nglct.util.string.TEStringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

public class TERsvpTunnelDBMgr {
    private static final Logger logger = TELogFactory.getNormalLogger();
    public static final short LSPTYPE_MAIN = 0;
    public static final short LSPTYPE_BACKUP = 1;

    private TERsvpTunnelDBMgr() {
    }

    public static void setDynTunnelObj(TEDynTunnelObjMOPO dynTunnelObjMO, RowParams row, boolean isContainKey) {
        if (!isContainKey) {
            TERsvpTunnelDBMgr.setDynTunnelKeyParam(dynTunnelObjMO, row);
        }
        TERsvpTunnelDBMgr.setDynTunnelParaOne(dynTunnelObjMO, row);
        TERsvpTunnelDBMgr.setDynTunnelParaTwo(dynTunnelObjMO, row);
    }

    private static void setDynTunnelParaTwo(TEDynTunnelObjMOPO dynTunnelObjMO, RowParams row) {
        Param tunnelBackupType;
        Param tunnelTypeParam;
        Param tunnelNameParam;
        Param runStateParam;
        Param rREnableParam;
        Param fRREnableParam;
        Param expParam;
        Param enabelStateParam = row.getParam("enablestatus");
        if (!TEStringUtils.isParamEmpty((Param)enabelStateParam)) {
            short enabelState = Short.parseShort(enabelStateParam.getValue());
            dynTunnelObjMO.setEnabelState(enabelState);
        }
        if (null != (expParam = row.getParam("cos")) && null != expParam.getValue()) {
            short cosEx = Short.parseShort(expParam.getValue());
            dynTunnelObjMO.setCosEx(cosEx);
        }
        if (!TEStringUtils.isParamEmpty((Param)(fRREnableParam = row.getParam("fastrerouteenable")))) {
            short fRREnable = Short.parseShort(fRREnableParam.getValue());
            dynTunnelObjMO.setFRREnable(fRREnable);
        }
        if (!TEStringUtils.isParamEmpty((Param)(rREnableParam = row.getParam("rerouteenable")))) {
            short rREnable = Short.parseShort(rREnableParam.getValue());
            dynTunnelObjMO.setRREnable(rREnable);
        }
        if (!TEStringUtils.isParamEmpty((Param)(runStateParam = row.getParam("runstat")))) {
            short runState = Short.parseShort(runStateParam.getValue());
            dynTunnelObjMO.setRunState(runState);
        }
        if (null != (tunnelNameParam = row.getParam("tunnelname")) && null != tunnelNameParam.getValue()) {
            String tunnelName = tunnelNameParam.getValue();
            dynTunnelObjMO.setTunnelName(tunnelName);
        }
        if (!TEStringUtils.isParamEmpty((Param)(tunnelTypeParam = row.getParam("tunneltype")))) {
            short tunnelType = Short.parseShort(tunnelTypeParam.getValue());
            dynTunnelObjMO.setTunnelType(tunnelType);
        }
        if (!TEStringUtils.isParamEmpty((Param)(tunnelBackupType = row.getParam("protype")))) {
            short backupType = Short.parseShort(tunnelBackupType.getValue());
            dynTunnelObjMO.setBackupType(backupType);
        }
    }

    private static void setDynTunnelParaOne(TEDynTunnelObjMOPO dynTunnelObjMO, RowParams row) {
        Param rsvforbindingParam;
        Param autooptperiodParam;
        Param autooptenParam;
        Param dSTypeParam;
        Param directionParam;
        Param expParam;
        Param cosParam;
        Param containPrioParam;
        Param buildPrioParam;
        Param bandwidthParam;
        Param affinityMaskParam;
        Param affinityParam = row.getParam("affinityattr");
        if (!TEStringUtils.isParamEmpty((Param)affinityParam)) {
            long affinity = Long.parseLong(affinityParam.getValue());
            dynTunnelObjMO.setAffinity(affinity);
        }
        if (!TEStringUtils.isParamEmpty((Param)(affinityMaskParam = row.getParam("affinityattrmask")))) {
            long affinityMask = Long.parseLong(affinityMaskParam.getValue());
            dynTunnelObjMO.setAffinityMask(affinityMask);
        }
        if (!TEStringUtils.isParamEmpty((Param)(bandwidthParam = row.getParam("bandwidth")))) {
            long bandwidth = Long.parseLong(bandwidthParam.getValue());
            dynTunnelObjMO.setBandwidth(bandwidth);
        }
        if (!TEStringUtils.isParamEmpty((Param)(buildPrioParam = row.getParam("createpri")))) {
            short buildPrio = Short.parseShort(buildPrioParam.getValue());
            dynTunnelObjMO.setBuildPrio(buildPrio);
        }
        if (!TEStringUtils.isParamEmpty((Param)(containPrioParam = row.getParam("keeppri")))) {
            short containPrio = Short.parseShort(containPrioParam.getValue());
            dynTunnelObjMO.setContainPrio(containPrio);
        }
        if (!TEStringUtils.isParamEmpty((Param)(cosParam = row.getParam("exp")))) {
            short cos = Short.parseShort(cosParam.getValue());
            dynTunnelObjMO.setCos(cos);
        }
        if (!TEStringUtils.isParamEmpty((Param)(expParam = row.getParam("cos")))) {
            short exp = Short.parseShort(expParam.getValue());
            dynTunnelObjMO.setCosEx(exp);
        }
        if (!TEStringUtils.isParamEmpty((Param)(directionParam = row.getParam("direction")))) {
            short direction = Short.parseShort(directionParam.getValue());
            dynTunnelObjMO.setDirection(direction);
        }
        if (!TEStringUtils.isParamEmpty((Param)(dSTypeParam = row.getParam("schedutype")))) {
            short dSType = Short.parseShort(dSTypeParam.getValue());
            dynTunnelObjMO.setDSType(dSType);
        }
        if (!TEStringUtils.isParamEmpty((Param)(autooptenParam = row.getParam("autoopten")))) {
            short autoopten = Short.parseShort(autooptenParam.getValue());
            dynTunnelObjMO.setAutoOptEnable(autoopten);
        }
        if (!TEStringUtils.isParamEmpty((Param)(autooptperiodParam = row.getParam("autooptperiod")))) {
            long autooptperiod = Long.parseLong(autooptperiodParam.getValue());
            dynTunnelObjMO.setAutoOptPeriod(autooptperiod);
        }
        if (!TEStringUtils.isParamEmpty((Param)(rsvforbindingParam = row.getParam("rsvforbinding")))) {
            short rsvforbinding = Short.parseShort(rsvforbindingParam.getValue());
            dynTunnelObjMO.setBindingResvType(rsvforbinding);
        }
    }

    private static void setDynTunnelKeyParam(TEDynTunnelObjMOPO dynTunnelObjMO, RowParams row) {
        Param positionParam;
        Param egressNodeParam;
        Param ingressNodeParam;
        Param tunnelIDParam;
        Param tunnelindexParam = row.getParam("tunnelindex");
        if (!TEStringUtils.isParamEmpty((Param)tunnelindexParam)) {
            long tunnelIndex = Long.parseLong(tunnelindexParam.getValue());
            dynTunnelObjMO.setTunnelIndex(tunnelIndex);
        }
        if (!TEStringUtils.isParamEmpty((Param)(tunnelIDParam = row.getParam("tunnelid")))) {
            int tunnelID = Integer.parseInt(tunnelIDParam.getValue());
            dynTunnelObjMO.setTunnelID(tunnelID);
        }
        if (!TEStringUtils.isParamEmpty((Param)(ingressNodeParam = row.getParam("srcnode")))) {
            long ingressNode = Long.parseLong(ingressNodeParam.getValue());
            dynTunnelObjMO.setIngressNode(ingressNode);
        }
        if (!TEStringUtils.isParamEmpty((Param)(egressNodeParam = row.getParam("snknode")))) {
            long egressNode = Long.parseLong(egressNodeParam.getValue());
            dynTunnelObjMO.setEgressNode(egressNode);
        }
        if (!TEStringUtils.isParamEmpty((Param)(positionParam = row.getParam("nodetype")))) {
            short position = Short.parseShort(positionParam.getValue());
            dynTunnelObjMO.setPosition(position);
        }
    }

    public static List<String> getOpeDynTnlSuccessID(String idName, Datainterface inputData, Datainterface outputData) {
        ArrayList<String> errorIDList = new ArrayList<String>();
        ArrayList<String> operateIDList = new ArrayList<String>();
        int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (errorCode == 2) {
            logger.error("operate ID:" + idName + "fail and not save data to DB");
            return operateIDList;
        }
        if (errorCode == 1) {
            BussinessParams outBusinessparams = outputData.getBussinessParams();
            int errorRowLen = outBusinessparams.getRowParamsCount();
            for (int errorRow = 0; errorRow < errorRowLen; ++errorRow) {
                RowErrors[] rowErrors;
                for (RowErrors rowError : rowErrors = outputData.getBussinessParams().getRowParams(errorRow).getRowErrors()) {
                    if (rowError.getParam(idName) == null) continue;
                    errorIDList.add(rowError.getParam(idName).getValue());
                }
            }
        }
        BussinessParams businessparams = inputData.getBussinessParams();
        String id = "";
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            RowParams rowparams = businessparams.getRowParams(row);
            id = rowparams.getParam(idName).getValue();
            if (errorIDList.contains(id)) continue;
            operateIDList.add(id);
        }
        return operateIDList;
    }

    public static TEDynamicTunnelMoContainer getContainer(int neID) {
        TEDynamicTunnelMoContainer container = null;
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll((int)neID, (int[])new int[]{neID}, TEDynamicTunnelMoContainer.class);
            if (null == dbResult) {
                String tipStr = "Get DynamicTunnel container fail! The dbResult is null!! ";
                tipStr = tipStr + String.format("[neID:%d]", neID);
                logger.error(tipStr);
                return container;
            }
        }
        catch (Exception e) {
            String tipStr = "Get DynamicTunnel container fail! DB oper error! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            logger.error(tipStr, (Throwable)e);
            return container;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            List data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                container = (TEDynamicTunnelMoContainer)data.get(0);
            }
        } else {
            String tipStr = "Get DynamicTunnel container fail! ";
            tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
            logger.error(tipStr);
        }
        logger.error("get DynamicTunnel container from db end.");
        return container;
    }

    public static TEDynTunnelObjMOPO getDynTunnelObj(TEDynamicTunnelMoContainer dynamicTunnelMoContainer, long tunnelindex) {
        Set dynTunnelObjList = dynamicTunnelMoContainer.getDynamicTunnelList();
        Iterator dynTunnelObjIterator = dynTunnelObjList.iterator();
        TEDynTunnelObjMOPO dynTunnelObjMOPO = null;
        TEDynTunnelObjMOPO dynTunnelObjMOPOTmp = null;
        while (dynTunnelObjIterator.hasNext()) {
            dynTunnelObjMOPOTmp = (TEDynTunnelObjMOPO)dynTunnelObjIterator.next();
            if (dynTunnelObjMOPOTmp.getTunnelIndex() != tunnelindex) continue;
            dynTunnelObjMOPO = dynTunnelObjMOPOTmp;
            break;
        }
        return dynTunnelObjMOPO;
    }

    public static void createContainerToDB(int neID, TEDynamicTunnelMoContainer container) {
        if (null == container) {
            String tipStr = "The DynamicTunnelMoContainer is null! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            logger.info(tipStr);
            return;
        }
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.create((int)neID, (int[])new int[]{neID}, (Object)container);
            if (null == dbResult) {
                String tipStr = "Save DynamicTunnelMoContainer result fail! The dbResult is null! ";
                tipStr = tipStr + String.format("[neID:%d", neID);
                logger.error(tipStr);
                return;
            }
        }
        catch (Exception e) {
            logger.error("Save DynamicTunnelMoContainer result fail!", (Throwable)e);
            return;
        }
        int retCode = dbResult.getResult();
        String tipStr = "Save DynamicTunnelMoContainer result. ";
        tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
        logger.info(tipStr);
        logger.info("save DynamicTunnelMoContainer to db end.");
    }

    public static List<TEDynamicTunnelMoContainer> getContainerFromDB(int neID) {
        ArrayList<TEDynamicTunnelMoContainer> dynamicTnlContainerList = new ArrayList<TEDynamicTunnelMoContainer>();
        TEDynamicTunnelMoContainer container = null;
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll((int)neID, (int[])new int[]{neID}, TEDynamicTunnelMoContainer.class);
            if (null == dbResult) {
                String tipStr = "Get DynamicTunnel container fail! The dbResult is null!! ";
                tipStr = tipStr + String.format("[neID:%d]", neID);
                logger.error(tipStr);
                return null;
            }
        }
        catch (Exception e) {
            String tipStr = "Get DynamicTunnel container fail! DB oper error! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            logger.error(tipStr, (Throwable)e);
            return null;
        }
        List data = dbResult.getData();
        for (Object object : data) {
            container = (TEDynamicTunnelMoContainer)object;
            Set dynTunnelMoPoSet = container.getDynamicTunnelList();
            Iterator iterator = dynTunnelMoPoSet.iterator();
            while (iterator.hasNext()) {
                TEDynTunnelObjMOPO teDynTunnelObjMOPO = (TEDynTunnelObjMOPO)iterator.next();
                if (teDynTunnelObjMOPO.isDeployment()) continue;
                iterator.remove();
            }
            dynamicTnlContainerList.add(container);
        }
        return dynamicTnlContainerList;
    }

    public static TEDynamicTunnelMoContainer deleteContainerToDB(List<TEDynamicTunnelMoContainer> data, int neID) {
        if (null != data && !data.isEmpty()) {
            TEDaoOperationResult delDbResult = null;
            for (TEDynamicTunnelMoContainer container : data) {
                try {
                    delDbResult = TECommonDaoService.delete((int)neID, (int[])new int[]{neID}, (Object)container);
                    if (null != delDbResult) continue;
                    logger.error("delDynamicTunnel container: Del DynamicTunnel container fail! The dbResult is null!");
                }
                catch (Exception e) {
                    String tipStr = "Get DynamicTunnel container fail! DB oper error! ";
                    tipStr = tipStr + String.format("[neID:%d]", neID);
                    logger.error(tipStr, (Throwable)e);
                    return null;
                }
            }
        }
        return new TEDynamicTunnelMoContainer();
    }

    public static void updateContainerToDB(int neID, TEDynamicTunnelMoContainer container) {
        if (null == container) {
            String tipStr = "The DynamicTunnelMoContainer is null! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            logger.info(tipStr);
            return;
        }
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.update((int)neID, (int[])new int[]{neID}, (Object)container);
            if (null == dbResult) {
                String tipStr = "Save DynamicTunnelMoContainer result fail! The dbResult is null! ";
                tipStr = tipStr + String.format("[neID:%d", neID);
                logger.error(tipStr);
                return;
            }
        }
        catch (Exception e) {
            logger.error("Save DynamicTunnelMoContainer result fail!", (Throwable)e);
            return;
        }
        int retCode = dbResult.getResult();
        String tipStr = "Save DynamicTunnelMoContainer result. ";
        tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
        logger.error(tipStr);
        logger.info("save DynamicTunnelMoContainer to db end.");
    }

    public static void setDynTunnelHopObj(TEDynRouteResObjMOPO dynTunnelHopObjMOPO, RowParams row) {
        Param RestrictTypeParam;
        Param RestrictIpAdderssParam = row.getParam("restrictip");
        if (!TEStringUtils.isParamEmpty((Param)RestrictIpAdderssParam)) {
            long RestrictIpAdderss = Long.parseLong(RestrictIpAdderssParam.getValue());
            dynTunnelHopObjMOPO.setRestrictIpAdderss(RestrictIpAdderss);
        }
        if (!TEStringUtils.isParamEmpty((Param)(RestrictTypeParam = row.getParam("restricttype")))) {
            short RestrictType = Short.parseShort(RestrictTypeParam.getValue());
            dynTunnelHopObjMOPO.setRestrictType(RestrictType);
        }
    }
}

