/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.mpls.rsvptunnel.mooperation;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.explorer.TEWNEMgrBusinessInterface;
import com.huawei.nglct.nemgr.ip.ptn.mpls.rsvptunnel.mooperation.TERsvpTunnelDBMgr;
import com.huawei.nglct.po.embeddednemgrmo.rtn.rsvp.TEDynRouteResObjMOPO;
import com.huawei.nglct.po.embeddednemgrmo.rtn.rsvp.TEDynTunnelObjMOPO;
import com.huawei.nglct.po.embeddednemgrmo.rtn.rsvp.TEDynamicTunnelMoContainer;
import com.huawei.nglct.util.string.TEStringUtils;
import java.util.Iterator;
import java.util.Set;

public class TECancleTunnelHopMoOperation
implements TEWNEMgrBusinessInterface {
    public void perfomWNEMgrBussinessProcess(int neID, Datainterface inputData, Datainterface outputData) {
        if (this.isInalidOutput(outputData)) {
            return;
        }
        BussinessParams businessparams = inputData.getBussinessParams();
        RowParams rowparams = businessparams.getRowParams(0);
        Param tunnelindexParam = rowparams.getParam("tunnelindex");
        long tunnelindex = 0L;
        if (!TEStringUtils.isParamEmpty((Param)tunnelindexParam)) {
            tunnelindex = Long.parseLong(tunnelindexParam.getValue());
        }
        try {
            TEDynamicTunnelMoContainer dynamicTunnelMoContainer = TERsvpTunnelDBMgr.getContainer(neID);
            if (null == dynamicTunnelMoContainer) {
                return;
            }
            Set dynTunnelObjList = dynamicTunnelMoContainer.getDynamicTunnelList();
            Set dynTunnelHopObjList = dynamicTunnelMoContainer.getRouteRestrictList();
            this.modifyExistMo(tunnelindex, dynTunnelObjList);
            this.deleteExistBackupRouteMo(tunnelindex, dynTunnelHopObjList);
            TERsvpTunnelDBMgr.updateContainerToDB(neID, dynamicTunnelMoContainer);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("operate rsvp Tunnel DB: apply Tunnel route failed!");
        }
    }

    private void deleteExistBackupRouteMo(long tunnelindex, Set<TEDynRouteResObjMOPO> dynTunnelHopObjList) {
        Iterator<TEDynRouteResObjMOPO> iter = dynTunnelHopObjList.iterator();
        while (iter.hasNext()) {
            TEDynRouteResObjMOPO tmpMo = iter.next();
            if (tmpMo.getTunnelIndex() != tunnelindex || tmpMo.getLspType() != 1) continue;
            iter.remove();
        }
    }

    private void modifyExistMo(long tunnelindex, Set<TEDynTunnelObjMOPO> dynTunnelObjList) {
        for (TEDynTunnelObjMOPO tmpMo : dynTunnelObjList) {
            if (tmpMo.getTunnelIndex() != tunnelindex) continue;
            tmpMo.setBackupType((short)255);
            tmpMo.setHoldTime(255L);
            tmpMo.setRevertiveMode((short)255);
        }
    }

    private boolean isInalidOutput(Datainterface outputData) {
        if (outputData == null || outputData.getBussinessParams() == null || outputData.getBussinessParams().getRowParams() == null) {
            return true;
        }
        int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        return errorCode == 2;
    }
}

